/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TDescribeOutputStyle;
import org.apache.impala.thrift.TDescribeResult;
import org.apache.impala.thrift.TResultRow;

public class DescribeResultFactory {
    private static final int NUM_DESC_FORMATTED_RESULT_COLS = 3;
    private static final TColumnValue EMPTY = new TColumnValue().setString_val("");

    public static TDescribeResult buildDescribeDbResult(FeDb db, TDescribeOutputStyle outputFormat) {
        switch (outputFormat) {
            case MINIMAL: {
                return DescribeResultFactory.describeDbMinimal(db);
            }
            case FORMATTED: 
            case EXTENDED: {
                return DescribeResultFactory.describeDbExtended(db);
            }
        }
        throw new UnsupportedOperationException("Unknown TDescribeOutputStyle value for describe database: " + (Object)((Object)outputFormat));
    }

    private static TDescribeResult describeDbMinimal(FeDb db) {
        TDescribeResult descResult = new TDescribeResult();
        Database msDb = db.getMetaStoreDb();
        descResult.results = Lists.newArrayList();
        String location = null;
        String managedLocation = null;
        String comment = null;
        if (msDb != null) {
            location = msDb.getLocationUri();
            managedLocation = MetastoreShim.getManagedLocationUri(msDb);
            comment = msDb.getDescription();
        }
        TColumnValue dbNameCol = new TColumnValue();
        dbNameCol.setString_val(db.getName());
        TColumnValue dbLocationCol = new TColumnValue();
        dbLocationCol.setString_val(Objects.toString(location, ""));
        TColumnValue commentCol = new TColumnValue();
        commentCol.setString_val(Objects.toString(comment, ""));
        descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{dbNameCol, dbLocationCol, commentCol})));
        if (managedLocation != null) {
            TColumnValue keyCol = new TColumnValue();
            keyCol.setString_val("managedlocation:");
            TColumnValue dbManagedLocationCol = new TColumnValue();
            dbManagedLocationCol.setString_val(Objects.toString(managedLocation, ""));
            descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{keyCol, dbManagedLocationCol, EMPTY})));
        }
        return descResult;
    }

    private static void buildPrivilegeResult(TDescribeResult descResult, Map<String, List<PrivilegeGrantInfo>> privilegeMap) {
        if (privilegeMap == null) {
            return;
        }
        for (Map.Entry<String, List<PrivilegeGrantInfo>> privilegeEntry : privilegeMap.entrySet()) {
            TColumnValue title = new TColumnValue();
            title.setString_val("Privileges for " + privilegeEntry.getKey() + ": ");
            descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{title, EMPTY, EMPTY})));
            for (PrivilegeGrantInfo privilegeInfo : privilegeEntry.getValue()) {
                TColumnValue privilege = new TColumnValue();
                privilege.setString_val(privilegeInfo.getPrivilege() + " " + privilegeInfo.isGrantOption());
                TColumnValue grantor = new TColumnValue();
                grantor.setString_val(privilegeInfo.getGrantor() + " " + privilegeInfo.getGrantorType());
                TColumnValue grantTime = new TColumnValue();
                grantTime.setString_val(privilegeInfo.getCreateTime() + "");
                descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{privilege, grantor, grantTime})));
            }
        }
    }

    private static TDescribeResult describeDbExtended(FeDb db) {
        TDescribeResult descResult = DescribeResultFactory.describeDbMinimal(db);
        Database msDb = db.getMetaStoreDb();
        String ownerName = null;
        PrincipalType ownerType = null;
        Map params = null;
        PrincipalPrivilegeSet privileges = null;
        if (msDb != null) {
            ownerName = msDb.getOwnerName();
            ownerType = msDb.getOwnerType();
            params = msDb.getParameters();
            privileges = msDb.getPrivileges();
        }
        if (ownerName != null && ownerType != null) {
            TColumnValue owner = new TColumnValue();
            owner.setString_val("Owner: ");
            TResultRow ownerRow = new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{owner, EMPTY, EMPTY}));
            descResult.results.add(ownerRow);
            TColumnValue ownerNameCol = new TColumnValue();
            ownerNameCol.setString_val(Objects.toString(ownerName, ""));
            TColumnValue ownerTypeCol = new TColumnValue();
            ownerTypeCol.setString_val(Objects.toString(ownerType, ""));
            descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{EMPTY, ownerNameCol, ownerTypeCol})));
        }
        if (params != null && params.size() > 0) {
            TColumnValue parameter = new TColumnValue();
            parameter.setString_val("Parameter: ");
            TResultRow parameterRow = new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{parameter, EMPTY, EMPTY}));
            descResult.results.add(parameterRow);
            for (Map.Entry param : params.entrySet()) {
                TColumnValue key = new TColumnValue();
                key.setString_val(Objects.toString(param.getKey(), ""));
                TColumnValue val = new TColumnValue();
                val.setString_val(Objects.toString(param.getValue(), ""));
                descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{EMPTY, key, val})));
            }
        }
        if (privileges != null) {
            DescribeResultFactory.buildPrivilegeResult(descResult, privileges.getUserPrivileges());
            DescribeResultFactory.buildPrivilegeResult(descResult, privileges.getGroupPrivileges());
            DescribeResultFactory.buildPrivilegeResult(descResult, privileges.getRolePrivileges());
        }
        return descResult;
    }

    public static TDescribeResult buildDescribeFormattedResult(FeTable table, List<Column> filteredColumns) throws ImpalaRuntimeException {
        TDescribeResult result = new TDescribeResult();
        result.results = Lists.newArrayList();
        Table msTable = table.getMetaStoreTable().deepCopy();
        ArrayList<Column> nonClustered = new ArrayList<Column>();
        ArrayList<Column> clustered = new ArrayList<Column>();
        for (Column col : filteredColumns) {
            if (table.isClusteringColumn(col)) {
                clustered.add(col);
                continue;
            }
            nonClustered.add(col);
        }
        msTable.getSd().setCols(Column.toFieldSchemas(nonClustered));
        msTable.setPartitionKeys(Column.toFieldSchemas(clustered));
        PrimaryKeyInfo pki = new PrimaryKeyInfo(table.getSqlConstraints().getPrimaryKeys(), table.getName(), table.getDb().getName());
        ForeignKeyInfo fki = new ForeignKeyInfo(table.getSqlConstraints().getForeignKeys(), table.getName(), table.getDb().getName());
        StringBuilder sb = new StringBuilder();
        sb.append(MetastoreShim.getAllColumnsInformation(msTable.getSd().getCols(), msTable.getPartitionKeys(), true, false, true));
        if (table instanceof FeIcebergTable) {
            sb.append(MetastoreShim.getPartitionTransformInformation(FeIcebergTable.Utils.getPartitionTransformKeys((FeIcebergTable)table)));
        }
        sb.append(MetastoreShim.getTableInformation(msTable));
        sb.append(MetastoreShim.getConstraintsInformation(pki, fki));
        for (String line : sb.toString().split("\n")) {
            String[] columns = line.split("\t");
            TResultRow resultRow = new TResultRow();
            for (int i = 0; i < 3; ++i) {
                TColumnValue colVal = new TColumnValue();
                colVal.setString_val(null);
                if (columns.length > i) {
                    colVal.setString_val(columns[i]);
                }
                resultRow.addToColVals(colVal);
            }
            result.results.add(resultRow);
        }
        return result;
    }

    public static TDescribeResult buildDescribeMinimalResult(StructType type) {
        TDescribeResult descResult = new TDescribeResult();
        descResult.results = Lists.newArrayList();
        for (StructField field : type.getFields()) {
            TColumnValue colNameCol = new TColumnValue();
            colNameCol.setString_val(field.getName());
            TColumnValue dataTypeCol = new TColumnValue();
            dataTypeCol.setString_val(field.getType().prettyPrint().toLowerCase());
            TColumnValue commentCol = new TColumnValue();
            commentCol.setString_val(Strings.nullToEmpty((String)field.getComment()));
            descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{colNameCol, dataTypeCol, commentCol})));
        }
        return descResult;
    }

    public static TDescribeResult buildKuduDescribeMinimalResult(List<Column> columns) {
        TDescribeResult descResult = new TDescribeResult();
        descResult.results = Lists.newArrayList();
        for (Column c : columns) {
            Preconditions.checkState((boolean)(c instanceof KuduColumn));
            KuduColumn kuduColumn = (KuduColumn)c;
            TColumnValue colNameCol = new TColumnValue();
            colNameCol.setString_val(kuduColumn.getName());
            TColumnValue dataTypeCol = new TColumnValue();
            dataTypeCol.setString_val(kuduColumn.getType().prettyPrint().toLowerCase());
            TColumnValue commentCol = new TColumnValue();
            commentCol.setString_val(Strings.nullToEmpty((String)kuduColumn.getComment()));
            TColumnValue pkCol = new TColumnValue();
            pkCol.setString_val(Boolean.toString(kuduColumn.isKey()));
            TColumnValue pkUniqueCol = new TColumnValue();
            if (kuduColumn.isKey()) {
                pkUniqueCol.setString_val(Boolean.toString(kuduColumn.isPrimaryKeyUnique()));
            } else {
                pkUniqueCol.setString_val("");
            }
            TColumnValue nullableCol = new TColumnValue();
            nullableCol.setString_val(Boolean.toString(kuduColumn.isNullable()));
            TColumnValue defaultValCol = new TColumnValue();
            if (kuduColumn.hasDefaultValue()) {
                defaultValCol.setString_val(kuduColumn.getDefaultValueString());
            } else {
                defaultValCol.setString_val("");
            }
            TColumnValue encodingCol = new TColumnValue();
            encodingCol.setString_val(kuduColumn.getEncoding().toString());
            TColumnValue compressionCol = new TColumnValue();
            compressionCol.setString_val(kuduColumn.getCompression().toString());
            TColumnValue blockSizeCol = new TColumnValue();
            blockSizeCol.setString_val(Integer.toString(kuduColumn.getBlockSize()));
            descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{colNameCol, dataTypeCol, commentCol, pkCol, pkUniqueCol, nullableCol, defaultValCol, encodingCol, compressionCol, blockSizeCol})));
        }
        return descResult;
    }

    public static TDescribeResult buildIcebergDescribeMinimalResult(List<Column> columns) {
        TDescribeResult descResult = new TDescribeResult();
        descResult.results = Lists.newArrayList();
        for (Column c : columns) {
            Preconditions.checkState((boolean)(c instanceof IcebergColumn));
            IcebergColumn icebergColumn = (IcebergColumn)c;
            TColumnValue colNameCol = new TColumnValue();
            colNameCol.setString_val(icebergColumn.getName());
            TColumnValue dataTypeCol = new TColumnValue();
            dataTypeCol.setString_val(icebergColumn.getType().prettyPrint().toLowerCase());
            TColumnValue commentCol = new TColumnValue();
            commentCol.setString_val(Strings.nullToEmpty((String)icebergColumn.getComment()));
            TColumnValue nullableCol = new TColumnValue();
            nullableCol.setString_val(Boolean.toString(icebergColumn.isNullable()));
            descResult.results.add(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{colNameCol, dataTypeCol, commentCol, nullableCol})));
        }
        return descResult;
    }

    public static TDescribeResult buildIcebergMetadataDescribeMinimalResult(FeIcebergTable table, String vTableName) throws ImpalaRuntimeException {
        IcebergMetadataTable metadataTable = new IcebergMetadataTable(table, vTableName);
        return DescribeResultFactory.buildIcebergDescribeMinimalResult(metadataTable.getColumns());
    }
}

