/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.rewrite.ExprRewriteRule;

public class SimplifyDistinctFromRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new SimplifyDistinctFromRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        if (!expr.isAnalyzed()) {
            return expr;
        }
        if (expr instanceof BinaryPredicate) {
            BinaryPredicate pred = (BinaryPredicate)expr;
            if (pred.getOp() == BinaryPredicate.Operator.NOT_DISTINCT && ((Expr)pred.getChild(0)).equals(pred.getChild(1))) {
                return new BoolLiteral(true);
            }
            if (pred.getOp() == BinaryPredicate.Operator.DISTINCT_FROM && ((Expr)pred.getChild(0)).equals(pred.getChild(1))) {
                return new BoolLiteral(false);
            }
        }
        return expr;
    }
}

