/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;

public class SimplifyCastStringToTimestamp
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new SimplifyCastStringToTimestamp();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        if (expr instanceof CastExpr && !((CastExpr)expr).isImplicit() && expr.getChild(0) instanceof FunctionCallExpr) {
            if (!expr.isAnalyzed()) {
                expr.analyze(analyzer);
            }
            FunctionCallExpr fce = (FunctionCallExpr)expr.getChild(0);
            if (!expr.getType().isTimestamp() || !fce.getFnName().getFunction().equalsIgnoreCase("unix_timestamp")) {
                return expr;
            }
            Expr simplifiedExpr = null;
            if (fce.getChildren().size() == 1 && ((Expr)fce.getChild(0)).getType().isStringType()) {
                simplifiedExpr = new CastExpr(new TypeDef(expr.getType()), (Expr)fce.getChild(0));
            } else if (fce.getChildren().size() == 2 && ((Expr)fce.getChild(0)).getType().isStringType() && ((Expr)fce.getChild(1)).getType().isStringType()) {
                simplifiedExpr = new FunctionCallExpr(new FunctionName("to_timestamp"), (List<Expr>)Lists.newArrayList(fce.getChildren()));
            }
            if (simplifiedExpr != null) {
                simplifiedExpr.analyze(analyzer);
                return simplifiedExpr;
            }
        }
        return expr;
    }
}

