/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.catalog.Type;
import org.apache.impala.rewrite.ExprRewriteRule;

public class SimplifyCastExprRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new SimplifyCastExprRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        if (!(expr instanceof CastExpr)) {
            return expr;
        }
        Preconditions.checkState((expr.getChildren().size() == 1 ? 1 : 0) != 0);
        CastExpr castExpr = (CastExpr)expr;
        Expr child = (Expr)castExpr.getChild(0);
        if (child instanceof NullLiteral) {
            return castExpr;
        }
        if (!castExpr.isAnalyzed()) {
            castExpr.analyzeNoThrow(analyzer);
        }
        if (!child.isAnalyzed()) {
            child.analyzeNoThrow(analyzer);
        }
        Preconditions.checkState((castExpr.getType() != Type.INVALID && child.getType() != Type.INVALID ? 1 : 0) != 0, (Object)"'castExpr' must be analyzed before rewrite");
        return castExpr.getType().matchesType(child.getType()) ? child : castExpr;
    }
}

