/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.rewrite.ExprRewriteRule;

public class NormalizeCountStarRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new NormalizeCountStarRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        if (!(expr instanceof FunctionCallExpr)) {
            return expr;
        }
        FunctionCallExpr origExpr = (FunctionCallExpr)expr;
        if (!origExpr.getFnName().getFunction().equalsIgnoreCase("count")) {
            return expr;
        }
        if (origExpr.getParams().isStar()) {
            return expr;
        }
        if (origExpr.getParams().isDistinct()) {
            return expr;
        }
        if (origExpr.getParams().exprs().size() != 1) {
            return expr;
        }
        Expr child = (Expr)origExpr.getChild(0);
        if (!Expr.IS_LITERAL.apply((Object)child)) {
            return expr;
        }
        if (Expr.IS_NULL_VALUE.apply((Object)child)) {
            return expr;
        }
        FunctionCallExpr result = new FunctionCallExpr(new FunctionName("count"), FunctionParams.createStarParam());
        return result;
    }

    private NormalizeCountStarRule() {
    }
}

