/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.rewrite.ExprRewriteRule;

public class NormalizeBinaryPredicatesRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new NormalizeBinaryPredicatesRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        if (!(expr instanceof BinaryPredicate)) {
            return expr;
        }
        if (this.isExprOpSlotRef(expr) || this.isConstantOpExpr(expr)) {
            BinaryPredicate.Operator op = ((BinaryPredicate)expr).getOp();
            return new BinaryPredicate(op.converse(), (Expr)expr.getChild(1), (Expr)expr.getChild(0));
        }
        return expr;
    }

    boolean isConstantOpExpr(Expr expr) {
        return ((Expr)expr.getChild(0)).isConstant() && !((Expr)expr.getChild(1)).isConstant();
    }

    boolean isExprOpSlotRef(Expr expr) {
        return ((Expr)expr.getChild(0)).unwrapSlotRef(false) == null && ((Expr)expr.getChild(1)).unwrapSlotRef(false) != null;
    }
}

