/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;

public class FoldConstantsRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new FoldConstantsRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        CastExpr castExpr;
        for (Expr child : expr.getChildren()) {
            if (Expr.IS_LITERAL.apply((Object)child)) continue;
            return expr;
        }
        if (Expr.IS_LITERAL.apply((Object)expr) || !expr.isConstant()) {
            return expr;
        }
        if (expr instanceof CastExpr && Expr.IS_NULL_LITERAL.apply((castExpr = (CastExpr)expr).getChild(0))) {
            return expr;
        }
        if (!expr.isAnalyzed()) {
            expr.analyze(analyzer);
            if (!expr.isConstant()) {
                return expr;
            }
        }
        boolean isExplicitCast = expr instanceof CastExpr && !expr.isImplicitCast();
        LiteralExpr result = LiteralExpr.createBounded(expr, analyzer.getQueryCtx(), 65536, isExplicitCast);
        if (result != null) {
            return result.castTo(expr.getType());
        }
        return expr;
    }

    private FoldConstantsRule() {
    }
}

