/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;

public enum CountStarToConstRule implements ExprRewriteRule
{
    INSTANCE;


    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        if (expr.isRewritten()) {
            return expr;
        }
        if (!FunctionCallExpr.isCountStarFunctionCallExpr(expr)) {
            return expr;
        }
        if (analyzer.canRewriteCountStarForV1()) {
            return LiteralExpr.createFromUnescapedStr(String.valueOf(analyzer.getTotalRecordsNumV1()), Type.BIGINT);
        }
        if (analyzer.canRewriteCountStartForV2()) {
            expr.setRewritten(true);
            return new ArithmeticExpr(ArithmeticExpr.Operator.ADD, expr, NumericLiteral.create(analyzer.getTotalRecordsNumV2()));
        }
        return expr;
    }
}

