/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BetweenPredicate;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetweenToCompoundRule
implements ExprRewriteRule {
    private static final Logger LOG = LoggerFactory.getLogger(BetweenToCompoundRule.class);
    public static final ExprRewriteRule INSTANCE = new BetweenToCompoundRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        CompoundPredicate pred;
        CompoundPredicate.Operator compoundOperator;
        BinaryPredicate.Operator upperOperator;
        BinaryPredicate.Operator lowerOperator;
        if (!(expr instanceof BetweenPredicate)) {
            return expr;
        }
        BetweenPredicate bp = (BetweenPredicate)expr;
        Expr value = (Expr)bp.getChild(0);
        Expr clonedValue = value.clone();
        Expr lowerBound = (Expr)bp.getChild(1);
        Expr upperBound = (Expr)bp.getChild(2);
        if (bp.isNotBetween()) {
            lowerOperator = BinaryPredicate.Operator.LT;
            upperOperator = BinaryPredicate.Operator.GT;
            compoundOperator = CompoundPredicate.Operator.OR;
        } else {
            lowerOperator = BinaryPredicate.Operator.GE;
            upperOperator = BinaryPredicate.Operator.LE;
            compoundOperator = CompoundPredicate.Operator.AND;
        }
        BinaryPredicate lower = new BinaryPredicate(lowerOperator, value, lowerBound);
        BinaryPredicate upper = new BinaryPredicate(upperOperator, clonedValue, upperBound);
        double sel = BetweenToCompoundRule.computeBetweenSelectivity(analyzer, compoundOperator, lower, upper);
        if (sel > 0.0) {
            lower.setBetweenSelectivity(bp.getId(), sel);
            upper.setBetweenSelectivity(bp.getId(), sel);
            pred = CompoundPredicate.createFromBetweenPredicate(compoundOperator, lower, upper, sel);
        } else {
            pred = new CompoundPredicate(compoundOperator, lower, upper);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Transformed " + bp.debugString() + " to " + pred.debugString());
        }
        return pred;
    }

    private static double computeBetweenSelectivity(Analyzer analyzer, CompoundPredicate.Operator compoundOperator, BinaryPredicate lowerBound, BinaryPredicate upperBound) {
        SlotRef slotRef = lowerBound.getBoundSlot();
        if (slotRef == null || !slotRef.hasDesc()) {
            return -1.0;
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        FeTable table = slotDesc.getParent().getTable();
        if (table == null || table.getNumRows() < 0L) {
            return -1.0;
        }
        if (!slotDesc.getType().isIntegerOrDateType()) {
            return -1.0;
        }
        ColumnStats stats = slotDesc.getStats();
        if (!stats.hasNumDistinctValues()) {
            return -1.0;
        }
        long numNotNulls = table.getNumRows() - Math.max(0L, stats.getNumNulls());
        if ((double)stats.getNumDistinctValues() / (double)numNotNulls < 0.9) {
            return -1.0;
        }
        try {
            long upperVal = ((Expr)upperBound.getChild(1)).evalToInteger(analyzer, "BETWEEN_up", true);
            long lowerVal = ((Expr)lowerBound.getChild(1)).evalToInteger(analyzer, "BETWEEN_low", true);
            if (stats.getHighValue() != null) {
                upperVal = Math.min(upperVal, Expr.evalToInteger(stats.getHighValue(), true));
            }
            if (stats.getLowValue() != null) {
                lowerVal = Math.max(lowerVal, Expr.evalToInteger(stats.getLowValue(), true));
            }
            if (upperVal < lowerVal) {
                return -1.0;
            }
            long diff = upperVal - lowerVal + 1L;
            double sel = Math.max(0.0, (double)diff / (double)table.getNumRows());
            if (compoundOperator == CompoundPredicate.Operator.OR) {
                sel = 1.0 - sel;
            }
            if (sel <= 0.1) {
                return sel;
            }
        }
        catch (AnalysisException e) {
            LOG.error("Error evaluating bounding value of BetweenPredicate", (Throwable)e);
        }
        return -1.0;
    }

    private BetweenToCompoundRule() {
    }
}

