/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.FeSupport;

public class ValueRange {
    private Expr lowerBound_;
    private boolean lowerBoundInclusive_;
    private Expr upperBound_;
    private boolean upperBoundInclusive_;

    Expr getLowerBound() {
        return this.lowerBound_;
    }

    void setLowerBound(Expr e) {
        this.lowerBound_ = e;
    }

    boolean getLowerBoundInclusive() {
        return this.lowerBoundInclusive_;
    }

    void setLowerBoundInclusive(boolean b) {
        this.lowerBoundInclusive_ = b;
    }

    Expr getUpperBound() {
        return this.upperBound_;
    }

    void setUpperBound(Expr e) {
        this.upperBound_ = e;
    }

    boolean getUpperBoundInclusive() {
        return this.upperBoundInclusive_;
    }

    void setUpperBoundInclusive(boolean b) {
        this.upperBoundInclusive_ = b;
    }

    public static ValueRange createEqRange(Expr valueExpr) {
        ValueRange result = new ValueRange();
        result.lowerBound_ = valueExpr;
        result.lowerBoundInclusive_ = true;
        result.upperBound_ = valueExpr;
        result.upperBoundInclusive_ = true;
        return result;
    }

    public boolean isEqRange() {
        return this.lowerBound_ == this.upperBound_ && this.lowerBoundInclusive_ && this.upperBoundInclusive_;
    }

    public boolean isInRange(Analyzer analyzer, Expr valueExpr) throws InternalException {
        Preconditions.checkState((boolean)valueExpr.isConstant());
        Preconditions.checkState((this.lowerBound_ != null || this.upperBound_ != null ? 1 : 0) != 0);
        Expr p = null;
        if (this.lowerBound_ != null && this.upperBound_ != null && this.lowerBoundInclusive_ && this.upperBoundInclusive_ && this.lowerBound_ == this.upperBound_) {
            p = new BinaryPredicate(BinaryPredicate.Operator.EQ, valueExpr, this.lowerBound_);
        } else {
            if (this.lowerBound_ != null) {
                p = new BinaryPredicate(this.lowerBoundInclusive_ ? BinaryPredicate.Operator.GE : BinaryPredicate.Operator.GT, valueExpr, this.lowerBound_);
            }
            if (this.upperBound_ != null) {
                BinaryPredicate p2 = new BinaryPredicate(this.upperBoundInclusive_ ? BinaryPredicate.Operator.GE : BinaryPredicate.Operator.GT, this.upperBound_, valueExpr);
                p = p != null ? new CompoundPredicate(CompoundPredicate.Operator.AND, p, p2) : p2;
            }
        }
        Preconditions.checkState((boolean)p.isConstant());
        try {
            p.analyze(analyzer);
        }
        catch (AnalysisException e) {
            throw new InternalException("couldn't analyze predicate " + p.toSql() + "\n" + e.toString());
        }
        return FeSupport.EvalPredicate(p, analyzer.getQueryCtx());
    }
}

