/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TUnnestNode;

public class UnnestNode
extends PlanNode {
    private final SubplanNode containingSubplanNode_;
    private final List<CollectionTableRef> tblRefs_;
    private final List<Expr> collectionExprs_;

    public UnnestNode(PlanNodeId id, SubplanNode containingSubplanNode, CollectionTableRef tblRef) {
        this(id, containingSubplanNode, Lists.newArrayList((Object[])new CollectionTableRef[]{tblRef}));
    }

    public UnnestNode(PlanNodeId id, SubplanNode containingSubplanNode, List<CollectionTableRef> tblRefs) {
        super(id, "UNNEST");
        this.containingSubplanNode_ = containingSubplanNode;
        this.tblRefs_ = tblRefs;
        Preconditions.checkState((tblRefs.size() > 0 ? 1 : 0) != 0);
        this.collectionExprs_ = Lists.newArrayList();
        for (CollectionTableRef ref : tblRefs) {
            SlotRef collectionSlotRef = (SlotRef)ref.getCollectionExpr();
            this.collectionExprs_.add(collectionSlotRef);
            this.tupleIds_.add(collectionSlotRef.getDesc().getItemTupleDesc().getId());
            this.tblRefIds_.add(collectionSlotRef.getDesc().getItemTupleDesc().getId());
        }
        for (Expr collectionExpr : this.collectionExprs_) {
            Preconditions.checkState((boolean)collectionExpr.isBoundByTupleIds(((PlanNode)containingSubplanNode.getChild((int)0)).tupleIds_));
        }
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        this.conjuncts_ = UnnestNode.orderConjunctsByCost(this.conjuncts_);
        analyzer.materializeSlots(this.conjuncts_);
        this.computeMemLayout(analyzer);
        this.checkUnnestFromUnionWithPredicate(analyzer);
    }

    private void checkUnnestFromUnionWithPredicate(Analyzer analyzer) throws AnalysisException {
        PlanNode subplanInputNode = (PlanNode)this.containingSubplanNode_.getChild(0);
        if (!(subplanInputNode instanceof UnionNode)) {
            return;
        }
        UnionNode union = (UnionNode)subplanInputNode;
        ArrayList<TupleDescriptor> unionDescs = new ArrayList<TupleDescriptor>();
        for (TupleId tid : union.getTupleIds()) {
            TupleDescriptor tuple = analyzer.getDescTbl().getTupleDesc(tid);
            this.getCollTupleDescs(tuple, unionDescs);
        }
        for (CollectionTableRef collTblRef : this.tblRefs_) {
            TupleDescriptor collItemTupleDesc = collTblRef.getDesc();
            if (!unionDescs.contains(collItemTupleDesc)) continue;
            List<Expr> predicates = analyzer.getConjuncts();
            for (Expr pred : predicates) {
                if (pred.isAuxExpr()) continue;
                ArrayList matching = new ArrayList();
                pred.collect(expr -> expr instanceof SlotRef && ((SlotRef)expr).getDesc().getParent().equals(collItemTupleDesc), matching);
                if (matching.isEmpty()) continue;
                throw new AnalysisException("Filtering an unnested collection that comes from a UNION [ALL] is not supported yet.");
            }
        }
    }

    private void getCollTupleDescs(TupleDescriptor tuple, List<TupleDescriptor> tupleList) {
        tupleList.add(tuple);
        for (SlotDescriptor slot : tuple.getSlots()) {
            if (!slot.getType().isCollectionType()) continue;
            TupleDescriptor itemTuple = slot.getItemTupleDesc();
            Preconditions.checkNotNull((Object)itemTuple);
            tupleList.add(itemTuple);
        }
    }

    @Override
    protected boolean shouldPickUpZippingUnnestConjuncts() {
        return true;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = 10L;
        this.numNodes_ = ((PlanNode)this.containingSubplanNode_.getChild(0)).getNumNodes();
        this.numInstances_ = ((PlanNode)this.containingSubplanNode_.getChild(0)).getNumInstances();
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), ((PlanNode)this.containingSubplanNode_.getChild(0)).getCardinality(), 0.0f);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s [%s]\n", prefix, this.getDisplayLabel(), this.getDisplayLabelDetail()));
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(String.format("%sparent-subplan=%s\n", detailPrefix, this.containingSubplanNode_.getId()));
        }
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal() && !this.conjuncts_.isEmpty()) {
            output.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
        }
        return output.toString();
    }

    @Override
    protected String getDisplayLabelDetail() {
        StringBuilder strBuilder = new StringBuilder();
        boolean first = true;
        this.tblRefs_.sort((t1, t2) -> {
            String path1 = ToSqlUtils.getPathSql(t1.getPath());
            String path2 = ToSqlUtils.getPathSql(t2.getPath());
            return path1.compareTo(path2);
        });
        for (CollectionTableRef tblRef : this.tblRefs_) {
            if (!first) {
                strBuilder.append(", ");
            }
            strBuilder.append(Joiner.on((String)".").join(tblRef.getPath()));
            if (tblRef.hasExplicitAlias()) {
                strBuilder.append(" " + tblRef.getExplicitAlias());
            }
            first = false;
        }
        return strBuilder.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.UNNEST_NODE;
        TUnnestNode unnestNode = new TUnnestNode();
        for (Expr expr : this.collectionExprs_) {
            unnestNode.addToCollection_exprs(expr.treeToThrift());
        }
        msg.setUnnest_node(unnestNode);
    }
}

