/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.TupleCacheNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleCachePlanner {
    private static final Logger LOG = LoggerFactory.getLogger(TupleCachePlanner.class);
    private final PlannerContext ctx_;

    public TupleCachePlanner(PlannerContext ctx) {
        this.ctx_ = ctx;
    }

    public List<PlanFragment> createPlans(List<PlanFragment> plan) throws ImpalaException {
        PlanNode root = plan.get(0).getPlanRoot();
        root.computeTupleCacheInfo(this.ctx_.getRootAnalyzer().getDescTbl());
        PlanNode newRoot = this.buildCachingPlan(root);
        Preconditions.checkState((plan.get(0).getPlanRoot() == newRoot ? 1 : 0) != 0);
        return plan;
    }

    private PlanNode buildCachingPlan(PlanNode node) throws ImpalaException {
        for (int i = 0; i < node.getChildCount(); ++i) {
            node.setChild(i, this.buildCachingPlan((PlanNode)node.getChild(i)));
        }
        if (!node.getTupleCacheInfo().isEligible()) {
            return node;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding TupleCacheNode above node " + node.getId().toString());
        }
        TupleCacheNode tupleCacheNode = new TupleCacheNode(this.ctx_.getNextNodeId(), node);
        tupleCacheNode.init(this.ctx_.getRootAnalyzer());
        PlanFragment curFragment = node.getFragment();
        if (node == curFragment.getPlanRoot()) {
            curFragment.addPlanRoot(tupleCacheNode);
            return tupleCacheNode;
        }
        tupleCacheNode.setFragment(curFragment);
        return tupleCacheNode;
    }
}

