/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TTupleCacheNode;

public class TupleCacheNode
extends PlanNode {
    protected String subtreeHash_;
    protected String hashTrace_;

    public TupleCacheNode(PlanNodeId id, PlanNode child) {
        super(id, "TUPLE CACHE");
        this.addChild(child);
        this.cardinality_ = child.getCardinality();
        this.limit_ = child.limit_;
        TupleCacheInfo childCacheInfo = child.getTupleCacheInfo();
        Preconditions.checkState((boolean)childCacheInfo.isEligible());
        this.subtreeHash_ = childCacheInfo.getHashString();
        this.hashTrace_ = childCacheInfo.getHashTrace();
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        this.computeTupleIds();
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tblRefIds_.addAll(((PlanNode)this.getChild(0)).getTblRefIds());
        this.tupleIds_.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.nullableTupleIds_.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.TUPLE_CACHE_NODE;
        Preconditions.checkState((!this.hasLimit() ? 1 : 0) != 0, (Object)"TupleCacheNode does not enforce limits itself and cannot have a limit set.");
        TTupleCacheNode tupleCacheNode = new TTupleCacheNode();
        tupleCacheNode.setSubtree_hash(this.subtreeHash_);
        msg.setTuple_cache_node(tupleCacheNode);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        Preconditions.checkNotNull((Object)this.fragment_, (Object)"PlanNode must be placed into a fragment before calling this method.");
        long perInstanceMemEstimate = 0L;
        long bufferSize = TupleCacheNode.computeMaxSpillableBufferSize(queryOptions.getDefault_spillable_buffer_size(), queryOptions.getMax_row_size());
        long perInstanceMinMemReservation = 2L * bufferSize;
        this.nodeResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(perInstanceMemEstimate).setMinMemReservationBytes(perInstanceMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(bufferSize).build();
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s:%s\n", prefix, this.id_.toString(), this.displayName_));
        output.append(detailPrefix + "cache key: " + this.subtreeHash_ + "\n");
        int keyFormatWidth = 100;
        for (int idx = 0; idx < this.hashTrace_.length(); idx += 100) {
            int stop_idx = Math.min(this.hashTrace_.length(), idx + 100);
            output.append(detailPrefix + "[" + this.hashTrace_.substring(idx, stop_idx) + "]\n");
        }
        return output.toString();
    }

    public String getSubtreeHash() {
        return this.subtreeHash_;
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), this.getCardinality(), 0.0f);
    }
}

