/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.thrift.TSlotDescriptor;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTupleDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class TupleCacheInfo {
    private EnumSet<IneligibilityReason> ineligibilityReasons_;
    private DescriptorTable descriptorTable_;
    private final Map<TupleId, TupleId> tupleTranslationMap_ = new TreeMap<TupleId, TupleId>();
    private final Map<SlotId, SlotId> slotTranslationMap_ = new HashMap<SlotId, SlotId>();
    private final IdGenerator<TupleId> translatedTupleIdGenerator_ = TupleId.createGenerator();
    private final IdGenerator<SlotId> translatedSlotIdGenerator_ = SlotId.createGenerator();
    private Hasher hasher_ = Hashing.murmur3_128().newHasher();
    private StringBuilder hashTraceBuilder_ = new StringBuilder();
    private boolean finalized_ = false;
    private String finalizedHashTrace_ = null;
    private String finalizedHashString_ = null;

    public TupleCacheInfo(DescriptorTable descTbl) {
        this.ineligibilityReasons_ = EnumSet.noneOf(IneligibilityReason.class);
        this.descriptorTable_ = descTbl;
    }

    public void setIneligible(IneligibilityReason reason) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        this.ineligibilityReasons_.add(reason);
    }

    public boolean isEligible() {
        return this.ineligibilityReasons_.isEmpty();
    }

    public String getHashString() {
        Preconditions.checkState((boolean)this.isEligible(), (Object)"TupleCacheInfo only has a hash if it is cache eligible");
        Preconditions.checkState((boolean)this.finalized_, (Object)"TupleCacheInfo not finalized");
        return this.finalizedHashString_;
    }

    public String getHashTrace() {
        Preconditions.checkState((boolean)this.isEligible(), (Object)"TupleCacheInfo only has a hash trace if it is cache eligible");
        Preconditions.checkState((boolean)this.finalized_, (Object)"TupleCacheInfo not finalized");
        return this.finalizedHashTrace_;
    }

    public void finalizeHash() {
        this.finalizedHashString_ = this.hasher_.hash().toString();
        this.hasher_ = null;
        this.finalizedHashTrace_ = this.hashTraceBuilder_.toString();
        this.hashTraceBuilder_ = null;
        this.finalized_ = true;
    }

    public void mergeChild(TupleCacheInfo child) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        if (!child.isEligible()) {
            this.ineligibilityReasons_.add(IneligibilityReason.CHILDREN_INELIGIBLE);
        } else {
            this.hasher_.putBytes(child.getHashString().getBytes());
            this.hashTraceBuilder_.append(child.getHashTrace());
            for (TupleId id : child.tupleTranslationMap_.keySet()) {
                this.registerTupleHelper(id, false);
            }
        }
    }

    public void hashThrift(TBase<?, ?> thriftObj) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            this.hasher_.putBytes(serializer.serialize(thriftObj));
        }
        catch (TException e) {
            Preconditions.checkState((boolean)false, (Object)("Unexpected Thrift exception: " + e.toString()));
        }
        String thriftString = thriftObj.toString();
        Preconditions.checkState((thriftString != null ? 1 : 0) != 0);
        this.hashTraceBuilder_.append(thriftString);
    }

    public void registerTuple(TupleId id) {
        this.registerTupleHelper(id, true);
    }

    private void registerTupleHelper(TupleId id, boolean incorporateIntoHash) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        ThriftSerializationCtx serialCtx = new ThriftSerializationCtx(this);
        if (!this.tupleTranslationMap_.containsKey(id)) {
            this.tupleTranslationMap_.put(id, this.translatedTupleIdGenerator_.getNextId());
            TupleDescriptor tupleDesc = this.descriptorTable_.getTupleDesc(id);
            if (incorporateIntoHash) {
                boolean needs_table_id = tupleDesc.getTable() != null && !(tupleDesc.getTable() instanceof FeView);
                TTupleDescriptor thriftTupleDesc = tupleDesc.toThrift(needs_table_id ? new Integer(1) : null, serialCtx);
                this.hashThrift(thriftTupleDesc);
            }
            for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
                TupleDescriptor nestedTupleDesc;
                this.slotTranslationMap_.put(slotDesc.getId(), this.translatedSlotIdGenerator_.getNextId());
                if (incorporateIntoHash) {
                    TSlotDescriptor thriftSlotDesc = slotDesc.toThrift(serialCtx);
                    this.hashThrift(thriftSlotDesc);
                }
                if ((nestedTupleDesc = slotDesc.getItemTupleDesc()) == null) continue;
                this.registerTupleHelper(nestedTupleDesc.getId(), incorporateIntoHash);
            }
        }
    }

    public void registerTable(FeTable tbl) {
        Preconditions.checkState((!(tbl instanceof FeView) ? 1 : 0) != 0, (Object)"registerTable() only applies to base tables");
        Preconditions.checkState((tbl != null ? 1 : 0) != 0, (Object)"Invalid null argument to registerTable()");
        TTableName tblName = tbl.getTableName().toThrift();
        this.hashThrift(tblName);
    }

    public TupleId getLocalTupleId(TupleId globalId) {
        Preconditions.checkState((boolean)this.tupleTranslationMap_.containsKey(globalId));
        return this.tupleTranslationMap_.get(globalId);
    }

    public SlotId getLocalSlotId(SlotId globalId) {
        Preconditions.checkState((boolean)this.slotTranslationMap_.containsKey(globalId));
        return this.slotTranslationMap_.get(globalId);
    }

    public static enum IneligibilityReason {
        NOT_IMPLEMENTED,
        CHILDREN_INELIGIBLE;

    }
}

