/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.planner.EmptySetNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanRootSink;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrivialQueryChecker {
    private static final Logger LOG = LoggerFactory.getLogger(TrivialQueryChecker.class);

    private static boolean PassedMustHave(PlanFragment rootFragment) {
        List allFragments = rootFragment.getNodesPostOrder();
        if (allFragments.size() != 1) {
            return false;
        }
        if (!(rootFragment.getSink() instanceof PlanRootSink)) {
            return false;
        }
        PlanNode planRoot = rootFragment.getPlanRoot();
        if (planRoot.numNodes() != 1) {
            return false;
        }
        return !(planRoot instanceof UnionNode ? ((UnionNode)planRoot).constExprLists_.size() > 1 || ((UnionNode)planRoot).resultExprLists_.size() > 0 : !(rootFragment.getPlanRoot() instanceof EmptySetNode));
    }

    private static boolean HasFunctionSleep(List<Expr> exprList) {
        if (exprList == null) {
            return false;
        }
        ArrayList sleepFuncList = new ArrayList();
        for (Expr expr : exprList) {
            if (expr == null) continue;
            expr.collectAll(Expr.IS_FN_SLEEP, sleepFuncList);
            if (sleepFuncList.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean PassedSpecialCheck(PlanFragment rootFragment) {
        PlanNode planRoot = rootFragment.getPlanRoot();
        Preconditions.checkArgument((planRoot.numNodes() == 1 ? 1 : 0) != 0);
        if (planRoot instanceof UnionNode) {
            UnionNode unionNode = (UnionNode)planRoot;
            Preconditions.checkArgument((unionNode.resultExprLists_.size() == 0 ? 1 : 0) != 0);
            for (List<Expr> constList : unionNode.constExprLists_) {
                if (!TrivialQueryChecker.HasFunctionSleep(constList)) continue;
                return false;
            }
        } else {
            Preconditions.checkArgument((boolean)(rootFragment.getPlanRoot() instanceof EmptySetNode));
        }
        return true;
    }

    public static boolean IsTrivial(PlanFragment rootFragment, TQueryOptions queryOptions, boolean isQueryStmt) {
        if (!queryOptions.isEnable_trivial_query_for_admission() || !isQueryStmt) {
            return false;
        }
        if (!TrivialQueryChecker.PassedMustHave(rootFragment)) {
            return false;
        }
        return TrivialQueryChecker.PassedSpecialCheck(rootFragment);
    }
}

