/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.HBaseTableSink;
import org.apache.impala.planner.HdfsTableSink;
import org.apache.impala.planner.KuduTableSink;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.thrift.TSinkAction;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.ExprUtil;

public abstract class TableSink
extends DataSink {
    protected final FeTable targetTable_;
    protected final Op sinkOp_;
    protected final List<Expr> outputExprs_;

    public TableSink(FeTable targetTable, Op sinkAction, List<Expr> outputExprs) {
        Preconditions.checkState((outputExprs != null ? 1 : 0) != 0);
        this.targetTable_ = targetTable;
        this.sinkOp_ = sinkAction;
        this.outputExprs_ = outputExprs;
    }

    public static TableSink create(FeTable table, Op sinkAction, List<Expr> partitionKeyExprs, List<Expr> outputExprs, List<Integer> referencedColumns, boolean overwrite, boolean inputIsClustered, Pair<List<Integer>, TSortingOrder> sortProperties) {
        return TableSink.create(table, sinkAction, partitionKeyExprs, outputExprs, referencedColumns, overwrite, inputIsClustered, sortProperties, -1L, null, 0, false);
    }

    public static TableSink create(FeTable table, Op sinkAction, List<Expr> partitionKeyExprs, List<Expr> outputExprs, List<Integer> referencedColumns, boolean overwrite, boolean inputIsClustered, Pair<List<Integer>, TSortingOrder> sortProperties, long writeId, ByteBuffer kuduTxnToken, int maxTableSinks) {
        return TableSink.create(table, sinkAction, partitionKeyExprs, outputExprs, referencedColumns, overwrite, inputIsClustered, sortProperties, writeId, kuduTxnToken, maxTableSinks, false);
    }

    public static TableSink create(FeTable table, Op sinkAction, List<Expr> partitionKeyExprs, List<Expr> outputExprs, List<Integer> referencedColumns, boolean overwrite, boolean inputIsClustered, Pair<List<Integer>, TSortingOrder> sortProperties, long writeId, ByteBuffer kuduTxnToken, int maxTableSinks, boolean isResultSink) {
        Preconditions.checkNotNull(partitionKeyExprs);
        Preconditions.checkNotNull(referencedColumns);
        Preconditions.checkNotNull(sortProperties.first);
        if (table instanceof FeIcebergTable) {
            if (sinkAction == Op.INSERT) {
                return new HdfsTableSink(table, partitionKeyExprs, outputExprs, overwrite, inputIsClustered, sortProperties, writeId, maxTableSinks, isResultSink);
            }
            Preconditions.checkState((boolean)false);
        }
        if (table instanceof FeFsTable) {
            Preconditions.checkState((sinkAction == Op.INSERT ? 1 : 0) != 0);
            Preconditions.checkState((boolean)referencedColumns.isEmpty());
            return new HdfsTableSink(table, partitionKeyExprs, outputExprs, overwrite, inputIsClustered, sortProperties, writeId, maxTableSinks, isResultSink);
        }
        if (table instanceof FeHBaseTable) {
            Preconditions.checkState((sinkAction == Op.INSERT ? 1 : 0) != 0);
            Preconditions.checkState((boolean)partitionKeyExprs.isEmpty());
            Preconditions.checkState((!overwrite ? 1 : 0) != 0);
            Preconditions.checkState((boolean)referencedColumns.isEmpty());
            Preconditions.checkState((boolean)((List)sortProperties.first).isEmpty());
            return new HBaseTableSink(table, outputExprs);
        }
        if (table instanceof FeKuduTable) {
            Preconditions.checkState((!overwrite ? 1 : 0) != 0);
            Preconditions.checkState((boolean)((List)sortProperties.first).isEmpty());
            return new KuduTableSink(table, sinkAction, referencedColumns, outputExprs, kuduTxnToken);
        }
        throw new UnsupportedOperationException("Cannot create data sink into table of type: " + table.getClass().getName());
    }

    protected ProcessingCost computeDefaultProcessingCost() {
        return ProcessingCost.basicCost(this.getLabel(), this.fragment_.getPlanRoot().getCardinality(), ExprUtil.computeExprsTotalCost(this.outputExprs_));
    }

    public static enum Op {
        INSERT{

            @Override
            public String toExplainString() {
                return "INSERT INTO";
            }

            @Override
            public TSinkAction toThrift() {
                return TSinkAction.INSERT;
            }
        }
        ,
        UPDATE{

            @Override
            public String toExplainString() {
                return "UPDATE";
            }

            @Override
            public TSinkAction toThrift() {
                return TSinkAction.UPDATE;
            }
        }
        ,
        UPSERT{

            @Override
            public String toExplainString() {
                return "UPSERT INTO";
            }

            @Override
            public TSinkAction toThrift() {
                return TSinkAction.UPSERT;
            }
        }
        ,
        DELETE{

            @Override
            public String toExplainString() {
                return "DELETE FROM";
            }

            @Override
            public TSinkAction toThrift() {
                return TSinkAction.DELETE;
            }
        };


        public abstract String toExplainString();

        public abstract TSinkAction toThrift();
    }
}

