/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.FeSystemTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TAddressesList;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TScanRange;
import org.apache.impala.thrift.TScanRangeLocation;
import org.apache.impala.thrift.TScanRangeLocationList;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.thrift.TSystemTableScanNode;

public class SystemTableScanNode
extends ScanNode {
    private final FeSystemTable table_;

    public SystemTableScanNode(PlanNodeId id, TupleDescriptor desc) {
        super(id, desc, "SCAN SYSTEM_TABLE");
        this.table_ = (FeSystemTable)this.desc_.getTable();
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        this.assignConjuncts(analyzer);
        analyzer.createEquivConjuncts((TupleId)this.tupleIds_.get(0), this.conjuncts_);
        this.conjuncts_ = SystemTableScanNode.orderConjunctsByCost(this.conjuncts_);
        analyzer.materializeSlots(this.conjuncts_);
        this.computeMemLayout(analyzer);
        this.computeScanRangeLocations(analyzer);
        this.computeStats(analyzer);
    }

    private void computeScanRangeLocations(Analyzer analyzer) throws InternalException {
        TAddressesList coordinators_container = FeSupport.GetCoordinators();
        List<TNetworkAddress> coordinators = coordinators_container.getAddresses();
        this.scanRangeSpecs_ = new TScanRangeSpec();
        for (TNetworkAddress networkAddress : coordinators) {
            int globalHostIdx = analyzer.getHostIndex().getOrAddIndex(networkAddress);
            TScanRange range = new TScanRange();
            range.setIs_system_scan(true);
            this.scanRangeSpecs_.addToConcrete_ranges(new TScanRangeLocationList(range, Lists.newArrayList((Object[])new TScanRangeLocation[]{new TScanRangeLocation(globalHostIdx)})));
        }
        analyzer.setIncludeAllCoordinatorsInScheduling(true);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.zero();
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = this.inputCardinality_ = FeSupport.NumLiveQueries();
        this.cardinality_ = this.applyConjunctsSelectivity(this.cardinality_);
        this.cardinality_ = Math.max(1L, this.cardinality_);
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        this.numInstances_ = this.numNodes_ = this.scanRangeSpecs_.getConcrete_rangesSize();
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("tid", this.desc_.getId().asInt()).add("TblName", (Object)this.desc_.getTable().getFullName()).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.SYSTEM_TABLE_SCAN_NODE;
        msg.system_table_scan_node = new TSystemTableScanNode(this.desc_.getId().asInt(), this.table_.getSystemTableName());
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0x100000L);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        String aliasStr = "";
        if (!this.table_.getFullName().equalsIgnoreCase(this.desc_.getAlias()) && !this.table_.getName().equalsIgnoreCase(this.desc_.getAlias())) {
            aliasStr = " " + this.desc_.getAlias();
        }
        output.append(String.format("%s%s:%s [%s%s]\n", prefix, this.id_.toString(), this.displayName_, this.table_.getFullName(), aliasStr));
        if (!this.conjuncts_.isEmpty()) {
            output.append(prefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
        }
        if (detailLevel == TExplainLevel.VERBOSE) {
            output.append(this.getStatsExplainString(prefix));
            output.append("\n");
        }
        return output.toString();
    }
}

