/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.util.MathUtil;

public class SumProcessingCost
extends ProcessingCost {
    private final ProcessingCost cost1_;
    private final ProcessingCost cost2_;

    protected SumProcessingCost(ProcessingCost cost1, ProcessingCost cost2) {
        Preconditions.checkArgument((boolean)cost1.isValid(), (String)"SumProcessingCost: cost1 is invalid! %s", (Object)cost1);
        Preconditions.checkArgument((boolean)cost2.isValid(), (String)"SumProcessingCost: cost2 is invalid! %s", (Object)cost2);
        this.cost1_ = cost1;
        this.cost2_ = cost2;
    }

    @Override
    public long getTotalCost() {
        return MathUtil.saturatingAdd(this.cost1_.getTotalCost(), this.cost2_.getTotalCost());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ProcessingCost clone() {
        return new SumProcessingCost(this.cost1_, this.cost2_);
    }

    @Override
    public String getExplainString(String detailPrefix, boolean fullExplain) {
        StringBuilder output = new StringBuilder();
        output.append(detailPrefix).append("SumCost: ").append(this.getDetails());
        if (fullExplain) {
            String nextPrefix = detailPrefix + "  ";
            output.append("\n").append(this.cost1_.getExplainString(nextPrefix, true));
            output.append("\n").append(this.cost2_.getExplainString(nextPrefix, true));
        }
        return output.toString();
    }
}

