/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.common.InternalException;
import org.apache.impala.planner.PipelineMembership;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TExecNodePhase;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;

public class SubplanNode
extends PlanNode {
    private PlanNode subplan_;

    public SubplanNode(PlanNode input) {
        super("SUBPLAN");
        this.children_.add(input);
    }

    public void setSubplan(PlanNode subplan) {
        Preconditions.checkState((this.children_.size() == 1 ? 1 : 0) != 0);
        this.subplan_ = subplan;
        this.children_.add(subplan);
        this.computeTupleIds();
    }

    @Override
    public void computeTupleIds() {
        Preconditions.checkNotNull((Object)this.subplan_);
        this.clearTupleIds();
        this.tblRefIds_.addAll(this.subplan_.getTblRefIds());
        this.tupleIds_.addAll(this.subplan_.getTupleIds());
        this.nullableTupleIds_.addAll(this.subplan_.getNullableTupleIds());
    }

    @Override
    public void init(Analyzer analyzer) throws InternalException {
        Preconditions.checkState((this.children_.size() == 2 ? 1 : 0) != 0);
        this.assignConjuncts(analyzer);
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
        this.computeStats(analyzer);
        this.outputSmap_ = ((PlanNode)this.getChild(1)).getOutputSmap();
        this.assignedConjuncts_ = analyzer.getAssignedConjuncts();
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = ((PlanNode)this.getChild((int)0)).cardinality_ != -1L && ((PlanNode)this.getChild((int)1)).cardinality_ != -1L ? SubplanNode.checkedMultiply(((PlanNode)this.getChild((int)0)).cardinality_, ((PlanNode)this.getChild((int)1)).cardinality_) : -1L;
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), this.getCardinality(), 0.0f);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    public PlanNode.ExecPhaseResourceProfiles computeTreeResourceProfiles(TQueryOptions queryOptions) {
        ResourceProfile subplanProfile = SubplanNode.subplanComputePeakResources(this);
        return new PlanNode.ExecPhaseResourceProfiles(subplanProfile, subplanProfile);
    }

    private static ResourceProfile subplanComputePeakResources(PlanNode node) {
        ResourceProfile result = node.nodeResourceProfile_;
        for (PlanNode child : node.getChildren()) {
            result = result.sum(SubplanNode.subplanComputePeakResources(child));
        }
        return result;
    }

    @Override
    public void computePipelineMembership() {
        ((PlanNode)this.children_.get(0)).computePipelineMembership();
        this.pipelines_ = new ArrayList();
        for (PipelineMembership leftPipeline : ((PlanNode)this.children_.get(0)).getPipelines()) {
            if (leftPipeline.getPhase() != TExecNodePhase.GETNEXT) continue;
            this.pipelines_.add(new PipelineMembership(leftPipeline.getId(), leftPipeline.getHeight() + 1, TExecNodePhase.GETNEXT));
        }
        ((PlanNode)this.children_.get(1)).setPipelinesRecursive(this.pipelines_);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s\n", prefix, this.getDisplayLabel()));
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal() && !this.conjuncts_.isEmpty()) {
            output.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
        }
        return output.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.SUBPLAN_NODE;
    }
}

