/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.InternalException;
import org.apache.impala.planner.AnalyticEvalNode;
import org.apache.impala.planner.DataPartition;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSortInfo;
import org.apache.impala.thrift.TSortNode;
import org.apache.impala.thrift.TSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(SortNode.class);
    private static final double COST_COEFFICIENT_SORT_TOTAL_SMALL_ROW = 0.0301;
    private static final double COST_COEFFICIENT_SORT_TOTAL_ROWS = 0.4071;
    private static final double COST_COEFFICIENT_SORT_TOTAL_BYTES = 0.0435;
    private static final double COST_COEFFICIENT_SORT_TOPN = 0.5638;
    private final long PARTIAL_SORT_MEM_LIMIT = 0x8000000L;
    private final SortInfo info_;
    private DataPartition inputPartition_;
    private boolean isAnalyticSort_;
    private AnalyticEvalNode analyticEvalNode_;
    private List<Expr> resolvedTupleExprs_;
    protected long offset_;
    protected int numPartitionExprs_;
    protected long perPartitionLimit_;
    protected boolean includeTies_;
    protected long limitWithTies_;
    protected Expr limitSrcPred_;
    private TSortType type_;
    private long estimatedFullInputSize_ = -1L;

    public static SortNode createPartialSortNode(PlanNodeId id, PlanNode input, SortInfo info) {
        return new SortNode(id, input, info, 0L, -1L, -1, -1L, false, TSortType.PARTIAL);
    }

    public static SortNode createTopNSortNode(TQueryOptions queryOptions, PlanNodeId id, PlanNode input, SortInfo info, long offset, long limit, boolean includeTies) {
        SortNode result;
        long topNBytesLimit = queryOptions.topn_bytes_limit;
        long topNCardinality = SortNode.capCardinalityAtLimit(input.cardinality_, limit);
        long estimatedTopNMaterializedSize = info.estimateTopNMaterializedSize(topNCardinality, offset);
        if (topNBytesLimit <= 0L || estimatedTopNMaterializedSize < topNBytesLimit || includeTies) {
            result = new SortNode(id, input, info, offset, limit, -1, -1L, includeTies, TSortType.TOPN);
        } else {
            result = SortNode.createTotalSortNode(id, input, info, offset);
            result.setLimit(limit);
        }
        return result;
    }

    public static SortNode createPartitionedTopNSortNode(PlanNodeId id, PlanNode input, SortInfo info, int numPartitionExprs, long perPartitionLimit, boolean includeTies) {
        return new SortNode(id, input, info, 0L, -1L, numPartitionExprs, perPartitionLimit, includeTies, TSortType.PARTITIONED_TOPN);
    }

    public static SortNode createTotalSortNode(PlanNodeId id, PlanNode input, SortInfo info, long offset) {
        return new SortNode(id, input, info, offset, -1L, -1, -1L, false, TSortType.TOTAL);
    }

    protected SortNode(PlanNodeId id, PlanNode input, SortInfo info, long offset, long limit, int numPartitionExprs, long perPartitionLimit, boolean includeTies, TSortType type) {
        super(id, info.getSortTupleDescriptor().getId().asList(), SortNode.getDisplayName(type));
        Preconditions.checkState((offset >= 0L ? 1 : 0) != 0);
        if (type == TSortType.PARTITIONED_TOPN) {
            Preconditions.checkState((includeTies || numPartitionExprs > 0 ? 1 : 0) != 0);
            Preconditions.checkState((perPartitionLimit > 0L ? 1 : 0) != 0);
        } else if (type == TSortType.TOPN) {
            Preconditions.checkArgument((type != TSortType.TOPN || limit >= 0L ? 1 : 0) != 0);
        }
        this.info_ = info;
        this.children_.add(input);
        this.offset_ = offset;
        this.numPartitionExprs_ = numPartitionExprs;
        this.perPartitionLimit_ = perPartitionLimit;
        this.includeTies_ = includeTies;
        this.limitWithTies_ = type == TSortType.TOPN && includeTies ? limit : -1L;
        this.type_ = type;
        if (!includeTies) {
            this.setLimit(limit);
        }
    }

    public long getOffset() {
        return this.offset_;
    }

    public void setOffset(long offset) {
        this.offset_ = offset;
    }

    public boolean hasOffset() {
        return this.offset_ > 0L;
    }

    public boolean isTotalSort() {
        return this.type_ == TSortType.TOTAL;
    }

    public boolean isTypeTopN() {
        return this.type_ == TSortType.TOPN;
    }

    public boolean isPartitionedTopN() {
        return this.type_ == TSortType.PARTITIONED_TOPN;
    }

    public int getNumPartitionExprs() {
        return this.numPartitionExprs_;
    }

    public long getPerPartitionLimit() {
        return this.perPartitionLimit_;
    }

    public boolean isIncludeTies() {
        return this.includeTies_;
    }

    public long getSortLimit() {
        return this.includeTies_ ? this.limitWithTies_ : this.limit_;
    }

    public SortInfo getSortInfo() {
        return this.info_;
    }

    public void setInputPartition(DataPartition inputPartition) {
        this.inputPartition_ = inputPartition;
    }

    public DataPartition getInputPartition() {
        return this.inputPartition_;
    }

    public boolean isAnalyticSort() {
        return this.isAnalyticSort_;
    }

    public void setIsAnalyticSort(boolean v) {
        this.isAnalyticSort_ = v;
    }

    public void setAnalyticEvalNode(AnalyticEvalNode n) {
        this.analyticEvalNode_ = n;
    }

    public AnalyticEvalNode getAnalyticEvalNode() {
        return this.analyticEvalNode_;
    }

    public void tryConvertToTopN(long limit, Analyzer analyzer, boolean includeTies) {
        Preconditions.checkArgument((this.type_ == TSortType.TOTAL || this.type_ == TSortType.PARTITIONED_TOPN ? 1 : 0) != 0);
        Preconditions.checkState((!this.hasLimit() ? 1 : 0) != 0);
        Preconditions.checkState((!this.hasOffset() ? 1 : 0) != 0);
        long topNBytesLimit = analyzer.getQueryOptions().topn_bytes_limit;
        long topNCardinality = SortNode.capCardinalityAtLimit(((PlanNode)this.getChild((int)0)).cardinality_, limit);
        long estimatedTopNMaterializedSize = this.info_.estimateTopNMaterializedSize(topNCardinality, this.offset_);
        if (topNBytesLimit > 0L && estimatedTopNMaterializedSize >= topNBytesLimit) {
            return;
        }
        this.type_ = TSortType.TOPN;
        this.displayName_ = SortNode.getDisplayName(this.type_);
        this.numPartitionExprs_ = -1;
        this.perPartitionLimit_ = -1L;
        this.includeTies_ = includeTies;
        if (includeTies) {
            this.unsetLimit();
            this.limitWithTies_ = limit;
        } else {
            this.setLimit(limit);
        }
        this.computeStats(analyzer);
    }

    @Override
    public boolean allowPartitioned() {
        if (this.isAnalyticSort_ && this.hasLimit()) {
            return true;
        }
        return super.allowPartitioned();
    }

    public void setLimitSrcPred(Expr v) {
        this.limitSrcPred_ = v;
    }

    @Override
    public boolean isBlockingNode() {
        return this.type_ != TSortType.PARTIAL;
    }

    @Override
    public void init(Analyzer analyzer) throws InternalException {
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
        this.computeMemLayout(analyzer);
        this.computeStats(analyzer);
        List<SlotDescriptor> sortTupleSlots = this.info_.getSortTupleDescriptor().getSlots();
        Preconditions.checkState((sortTupleSlots.size() > 0 ? 1 : 0) != 0, (Object)"empty sort tuple descriptor");
        List<Expr> slotExprs = this.info_.getMaterializedExprs();
        this.resolvedTupleExprs_ = new ArrayList<Expr>();
        this.outputSmap_ = new ExprSubstitutionMap();
        for (int i = 0; i < slotExprs.size(); ++i) {
            if (!sortTupleSlots.get(i).isMaterialized()) continue;
            this.resolvedTupleExprs_.add(slotExprs.get(i));
            this.outputSmap_.put(slotExprs.get(i), new SlotRef(sortTupleSlots.get(i)));
        }
        ExprSubstitutionMap childSmap = this.getCombinedChildSmap();
        this.resolvedTupleExprs_ = Expr.substituteList(this.resolvedTupleExprs_, childSmap, analyzer, true);
        this.outputSmap_ = ExprSubstitutionMap.compose(childSmap, this.outputSmap_, analyzer);
        this.info_.substituteSortExprs(this.outputSmap_, analyzer);
        this.info_.checkConsistency();
        if (LOG.isTraceEnabled()) {
            LOG.trace("sort id " + ((TupleId)this.tupleIds_.get(0)).toString() + " smap: " + this.outputSmap_.debugString());
            LOG.trace("sort input exprs: " + Expr.debugString(this.resolvedTupleExprs_));
        }
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = this.isTypeTopN() && this.includeTies_ ? SortNode.capCardinalityAtLimit(((PlanNode)this.getChild((int)0)).cardinality_, this.limitWithTies_) : this.capCardinalityAtLimit(((PlanNode)this.getChild((int)0)).cardinality_);
        if (this.type_ == TSortType.PARTITIONED_TOPN) {
            long partNdv;
            List<Expr> partExprs = this.info_.getSortExprs().subList(0, this.numPartitionExprs_);
            long l = partNdv = this.numPartitionExprs_ == 0 ? 1L : Expr.getNumDistinctValues(partExprs);
            if (partNdv >= 0L) {
                long maxRowsInHeaps = partNdv * this.getPerPartitionLimit();
                if (this.cardinality_ < 0L || this.cardinality_ > maxRowsInHeaps) {
                    this.cardinality_ = maxRowsInHeaps;
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("stats Sort: cardinality=" + Long.toString(this.cardinality_));
        }
    }

    @Override
    protected String debugString() {
        ArrayList<String> strings = new ArrayList<String>();
        for (Boolean isAsc : this.info_.getIsAscOrder()) {
            strings.add(isAsc != false ? "a" : "d");
        }
        return MoreObjects.toStringHelper((Object)this).add("type_", (Object)this.type_).add("ordering_exprs", (Object)Expr.debugString(this.info_.getSortExprs())).add("is_asc", (Object)("[" + Joiner.on((String)" ").join(strings) + "]")).add("nulls_first", (Object)("[" + Joiner.on((String)" ").join(this.info_.getNullsFirst()) + "]")).add("offset_", this.offset_).add("includeTies_", this.includeTies_).add("limitWithTies_", this.limitWithTies_).add("numPartitionExprs_", this.numPartitionExprs_).add("perPartitionLimit_", this.perPartitionLimit_).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        if (this.isTypeTopN()) {
            Preconditions.checkState((this.hasLimit() || this.includeTies_ && this.limitWithTies_ >= 0L ? 1 : 0) != 0, (String)"Top-N must have limit", (Object)this.debugString());
            Preconditions.checkState((!this.includeTies_ || !this.hasLimit() && this.limitWithTies_ >= 0L ? 1 : 0) != 0, (Object)"Top-N with tie handling must set limitWithTies_ only");
        }
        Preconditions.checkState((this.offset_ >= 0L ? 1 : 0) != 0);
        msg.node_type = TPlanNodeType.SORT_NODE;
        TSortInfo sort_info = new TSortInfo(Expr.treesToThrift(this.info_.getSortExprs()), this.info_.getIsAscOrder(), this.info_.getNullsFirst(), this.info_.getSortingOrder());
        sort_info.setNum_lexical_keys_in_zorder(this.info_.getNumLexicalKeysInZOrder());
        Preconditions.checkState((this.tupleIds_.size() == 1 ? 1 : 0) != 0, (Object)"Incorrect size for tupleIds_ in SortNode");
        sort_info.setSort_tuple_slot_exprs(Expr.treesToThrift(this.resolvedTupleExprs_));
        TSortNode sort_node = new TSortNode(sort_info, this.type_);
        sort_node.setOffset(this.offset_);
        sort_node.setEstimated_full_input_size(this.estimatedFullInputSize_);
        if (this.type_ == TSortType.PARTITIONED_TOPN) {
            sort_node.setPer_partition_limit(this.perPartitionLimit_);
            List<Expr> partExprs = this.info_.getSortExprs().subList(0, this.numPartitionExprs_);
            sort_node.setPartition_exprs(Expr.treesToThrift(partExprs));
            int totalExprs = this.info_.getSortExprs().size();
            List<Expr> sortExprs = this.info_.getSortExprs().subList(this.numPartitionExprs_, totalExprs);
            sort_node.setIntra_partition_sort_info(new TSortInfo(Expr.treesToThrift(sortExprs), this.info_.getIsAscOrder().subList(this.numPartitionExprs_, totalExprs), this.info_.getNullsFirst().subList(this.numPartitionExprs_, totalExprs), this.info_.getSortingOrder()));
        }
        Preconditions.checkState((this.type_ == TSortType.PARTITIONED_TOPN || this.type_ == TSortType.TOPN || !this.includeTies_ ? 1 : 0) != 0);
        sort_node.setInclude_ties(this.includeTies_);
        if (this.includeTies_) {
            sort_node.setLimit_with_ties(this.limitWithTies_);
        }
        msg.sort_node = sort_node;
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s:%s%s\n", prefix, this.id_.toString(), this.displayName_, this.getNodeExplainDetail(detailLevel)));
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
            if (this.type_ == TSortType.PARTITIONED_TOPN) {
                output.append(detailPrefix + "partition by:");
                List<Expr> partExprs = this.info_.getSortExprs().subList(0, this.numPartitionExprs_);
                if (partExprs.size() > 0) {
                    output.append(" ");
                    output.append(Expr.toSql(partExprs, ToSqlOptions.DEFAULT));
                }
                int totalExprs = this.info_.getSortExprs().size();
                List<Expr> sortExprs = this.info_.getSortExprs().subList(this.numPartitionExprs_, totalExprs);
                output.append("\n" + detailPrefix + "order by: ");
                output.append(this.getSortingOrderExplainString(sortExprs, this.info_.getIsAscOrder().subList(this.numPartitionExprs_, totalExprs), this.info_.getNullsFirstParams().subList(this.numPartitionExprs_, totalExprs), this.info_.getSortingOrder(), this.info_.getNumLexicalKeysInZOrder()));
                output.append(detailPrefix + "partition limit: " + this.perPartitionLimit_);
                if (this.includeTies_) {
                    output.append(" (include ties)");
                }
                output.append("\n");
            } else {
                output.append(detailPrefix + "order by: ");
                output.append(this.getSortingOrderExplainString(this.info_.getSortExprs(), this.info_.getIsAscOrder(), this.info_.getNullsFirstParams(), this.info_.getSortingOrder(), this.info_.getNumLexicalKeysInZOrder()));
                if (this.includeTies_) {
                    output.append(detailPrefix + "limit with ties: " + this.limitWithTies_ + "\n");
                }
            }
            if (this.limitSrcPred_ != null) {
                output.append(detailPrefix + "source expr: " + this.limitSrcPred_.toSql(ToSqlOptions.SHOW_IMPLICIT_CASTS) + "\n");
            }
        }
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            ArrayList<Expr> nonSlotRefExprs = new ArrayList<Expr>();
            for (Expr e : this.info_.getMaterializedExprs()) {
                if (e instanceof SlotRef) continue;
                nonSlotRefExprs.add(e);
            }
            if (!nonSlotRefExprs.isEmpty()) {
                output.append(detailPrefix + "materialized: ");
                for (int i = 0; i < nonSlotRefExprs.size(); ++i) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    output.append(((Expr)nonSlotRefExprs.get(i)).toSql());
                }
                output.append("\n");
            }
        }
        return output.toString();
    }

    private String getNodeExplainDetail(TExplainLevel detailLevel) {
        if (!this.hasLimit()) {
            return "";
        }
        if (this.hasOffset()) {
            return String.format(" [LIMIT=%s OFFSET=%s]", this.limit_, this.offset_);
        }
        return String.format(" [LIMIT=%s]", this.limit_);
    }

    @Override
    protected String getOffsetExplainString(String prefix) {
        return this.offset_ != 0L ? prefix + "offset: " + Long.toString(this.offset_) + "\n" : "";
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        double log2InputCardinality;
        double totalCost = 0.0;
        long inputCardinality = Math.max(0L, ((PlanNode)this.getChild(0)).getFilteredCardinality());
        double d = log2InputCardinality = inputCardinality <= 0L ? 0.0 : Math.log(inputCardinality) / Math.log(2.0);
        if (this.type_ == TSortType.TOTAL || this.type_ == TSortType.PARTIAL) {
            if (this.avgRowSize_ <= 10.0f) {
                totalCost = (double)inputCardinality * log2InputCardinality * 0.0301;
            } else {
                double fullInputSize = (float)inputCardinality * this.avgRowSize_;
                totalCost = (double)inputCardinality * 0.4071 + fullInputSize * 0.0435;
            }
        } else {
            Preconditions.checkState((this.type_ == TSortType.TOPN || this.type_ == TSortType.PARTITIONED_TOPN ? 1 : 0) != 0);
            totalCost = (double)inputCardinality * log2InputCardinality * 0.5638;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sort CPU cost estimate: " + totalCost + ", Type: " + (Object)((Object)this.type_) + ", Input Card: " + inputCardinality + ", Row Size: " + this.avgRowSize_);
        }
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), totalCost);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        long perInstanceMinMemReservation;
        long perInstanceMemEstimate;
        int pageMultiplier;
        Preconditions.checkState((boolean)this.hasValidStats());
        if (this.type_ == TSortType.TOPN) {
            this.nodeResourceProfile_ = ResourceProfile.noReservation(this.getSortInfo().estimateTopNMaterializedSize(this.cardinality_, this.offset_));
            return;
        }
        double fullInputSize = (float)((PlanNode)this.getChild((int)0)).cardinality_ * this.avgRowSize_;
        this.estimatedFullInputSize_ = fullInputSize < 0.0 ? -1L : (long)Math.ceil(fullInputSize);
        boolean usesVarLenBlocks = false;
        for (SlotDescriptor slotDesc : this.info_.getSortTupleDescriptor().getSlots()) {
            if (!slotDesc.isMaterialized() || slotDesc.getType().isFixedLengthType()) continue;
            usesVarLenBlocks = true;
            break;
        }
        long bufferSize = SortNode.computeMaxSpillableBufferSize(queryOptions.getDefault_spillable_buffer_size(), queryOptions.getMax_row_size());
        int n = pageMultiplier = usesVarLenBlocks ? 2 : 1;
        if (this.type_ == TSortType.PARTIAL) {
            long mem_limit = Math.max(0x8000000L, bufferSize * (long)pageMultiplier);
            perInstanceMemEstimate = fullInputSize < 0.0 ? mem_limit : Math.min((long)Math.ceil(fullInputSize), mem_limit);
            perInstanceMinMemReservation = bufferSize * (long)pageMultiplier;
        } else {
            Preconditions.checkState((this.type_ == TSortType.TOTAL || this.type_ == TSortType.PARTITIONED_TOPN ? 1 : 0) != 0);
            long numInstances = this.fragment_.getNumInstances();
            perInstanceMemEstimate = fullInputSize < 0.0 ? 0x8000000L : (long)Math.ceil(fullInputSize / (double)numInstances);
            perInstanceMinMemReservation = 3L * bufferSize * (long)pageMultiplier;
            if (this.type_ == TSortType.PARTITIONED_TOPN && this.cardinality_ >= 0L) {
                long totalHeapBytes = this.getSortInfo().estimateMaterializedSize(this.cardinality_);
                perInstanceMemEstimate = Math.min(perInstanceMemEstimate, totalHeapBytes);
            }
        }
        this.nodeResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(perInstanceMemEstimate).setMinMemReservationBytes(perInstanceMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(bufferSize).build();
    }

    private static String getDisplayName(TSortType type) {
        if (type == TSortType.TOPN || type == TSortType.PARTITIONED_TOPN) {
            return "TOP-N";
        }
        if (type == TSortType.PARTIAL) {
            return "PARTIAL SORT";
        }
        Preconditions.checkState((type == TSortType.TOTAL ? 1 : 0) != 0);
        return "SORT";
    }
}

