/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.NotImplementedException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.KuduScanNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.Planner;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScanNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(ScanNode.class);
    protected static final double SCAN_RANGE_SKEW_FACTOR = 1.2;
    protected static final int MIN_NUM_SCAN_THREADS = 1;
    protected final TupleDescriptor desc_;
    protected long inputCardinality_ = -1L;
    protected long filteredInputCardinality_ = -1L;
    protected TScanRangeSpec scanRangeSpecs_;
    protected MultiAggregateInfo aggInfo_ = null;
    protected static final String STATS_NUM_ROWS = "stats: num_rows";
    protected ExprSubstitutionMap optimizedAggSmap_;
    protected long tableNumRowsHint_ = -1L;
    protected double scanRangeSelectivity_ = 1.0;

    public ScanNode(PlanNodeId id, TupleDescriptor desc, String displayName) {
        super(id, desc.getId().asList(), displayName);
        this.desc_ = desc;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.hasHardEstimates_ = !this.hasScanConjuncts() && !this.isAccessingCollectionType();
    }

    public TupleDescriptor getTupleDesc() {
        return this.desc_;
    }

    @Override
    protected boolean shouldPickUpZippingUnnestConjuncts() {
        return true;
    }

    protected void checkForSupportedFileFormats() throws NotImplementedException {
        Preconditions.checkNotNull((Object)this.desc_);
        Preconditions.checkNotNull((Object)this.desc_.getTable());
        for (SlotDescriptor slotDesc : this.desc_.getSlots()) {
            if (!slotDesc.getType().isComplexType() && slotDesc.getColumn() != null) continue;
            Preconditions.checkNotNull((Object)slotDesc.getPath());
            throw new NotImplementedException(String.format("Scan of table '%s' is not supported because '%s' references a nested field/collection.\nComplex types are supported for these file formats: %s.", slotDesc.getPath().toString(), this.desc_.getAlias(), Joiner.on((String)", ").join(HdfsFileFormat.complexTypesFormats())));
        }
    }

    protected boolean isCountStarOptimizationDescriptor(SlotDescriptor desc) {
        return desc.getLabel().equals(STATS_NUM_ROWS);
    }

    protected SlotDescriptor applyCountStarOptimization(Analyzer analyzer) {
        return this.applyCountStarOptimization(analyzer, null);
    }

    protected SlotDescriptor applyCountStarOptimization(Analyzer analyzer, FunctionCallExpr countFnExpr) {
        FunctionCallExpr countFn = countFnExpr != null ? countFnExpr : new FunctionCallExpr(new FunctionName("count"), FunctionParams.createStarParam());
        countFn.analyzeNoThrow(analyzer);
        SlotDescriptor sd = analyzer.addSlotDescriptor(this.getTupleDesc());
        sd.setType(Type.BIGINT);
        sd.setIsMaterialized(true);
        sd.setIsNullable(false);
        sd.setLabel(STATS_NUM_ROWS);
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(new SlotRef(sd));
        FunctionCallExpr sumFn = new FunctionCallExpr("sum_init_zero", args);
        sumFn.analyzeNoThrow(analyzer);
        this.optimizedAggSmap_ = new ExprSubstitutionMap();
        this.optimizedAggSmap_.put(countFn, sumFn);
        return sd;
    }

    protected boolean canApplyCountStarOptimization(Analyzer analyzer) {
        if (analyzer.getNumTableRefs() != 1) {
            return false;
        }
        if (this.aggInfo_ == null || this.aggInfo_.getMaterializedAggClasses().size() != 1 || !this.aggInfo_.getMaterializedAggClass(0).hasCountStarOnly()) {
            return false;
        }
        if (!this.conjuncts_.isEmpty()) {
            return false;
        }
        return !this.desc_.hasMaterializedSlots() || this.desc_.hasClusteringColsOnly();
    }

    public TScanRangeSpec getScanRangeSpecs() {
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_, (Object)"Need to call init() first.");
        return this.scanRangeSpecs_;
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("tid", this.desc_.getId().asInt()).add("tblName", (Object)this.desc_.getTable().getFullName()).add("keyRanges", (Object)"").addValue((Object)super.debugString()).toString();
    }

    protected String getTableStatsExplainString(String prefix) {
        TTableStats tblStats = this.desc_.getTable().getTTableStats();
        return prefix + "table: rows=" + PrintUtils.printEstCardinality(tblStats.num_rows);
    }

    protected String getColumnStatsExplainString(String prefix) {
        StringBuilder output = new StringBuilder();
        ArrayList<String> columnsMissingStats = new ArrayList<String>();
        for (SlotDescriptor slot : this.desc_.getSlots()) {
            if (slot.getStats().hasStats() || slot.getColumn() == null) continue;
            columnsMissingStats.add(slot.getColumn().getName());
        }
        output.append(prefix);
        if (columnsMissingStats.isEmpty()) {
            output.append("columns: all");
        } else if (columnsMissingStats.size() == this.desc_.getSlots().size()) {
            output.append("columns: unavailable");
        } else {
            output.append(String.format("columns missing stats: %s", Joiner.on((String)", ").join(columnsMissingStats)));
        }
        return output.toString();
    }

    protected String getStatsExplainString(String prefix) {
        StringBuilder output = new StringBuilder(prefix);
        output.append("stored statistics:\n");
        prefix = prefix + "  ";
        output.append(this.getTableStatsExplainString(prefix));
        output.append("\n");
        output.append(this.getColumnStatsExplainString(prefix));
        return output.toString();
    }

    public boolean isTableMissingStats() {
        return this.isTableMissingColumnStats() || this.isTableMissingTableStats();
    }

    public boolean isTableMissingTableStats() {
        return this.desc_.getTable().getNumRows() == -1L;
    }

    public boolean isAccessingCollectionType() {
        for (Type t : this.desc_.getPath().getMatchedTypes()) {
            if (!t.isCollectionType()) continue;
            return true;
        }
        return false;
    }

    public boolean isTableMissingColumnStats() {
        for (SlotDescriptor slot : this.desc_.getSlots()) {
            if (slot.getColumn() == null || slot.getStats().hasStats() || slot.getColumn().getType().isComplexType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCorruptTableStats() {
        return false;
    }

    protected static TNetworkAddress addressToTNetworkAddress(String address) {
        TNetworkAddress result = new TNetworkAddress();
        String[] hostPort = address.split(":");
        result.hostname = hostPort[0];
        result.port = Integer.parseInt(hostPort[1]);
        return result;
    }

    public boolean hasSimpleLimit() {
        return this.hasLimit() && !this.hasScanConjuncts() && !this.hasStorageLayerConjuncts();
    }

    private long capInputCardinalityWithLimit(long inputCardinality) {
        if (this.hasSimpleLimit()) {
            if (inputCardinality < 0L) {
                return this.getLimit();
            }
            return Math.min(this.getLimit(), inputCardinality);
        }
        return inputCardinality;
    }

    @Override
    public long getInputCardinality() {
        return this.capInputCardinalityWithLimit(this.inputCardinality_);
    }

    public long getFilteredInputCardinality() {
        return this.capInputCardinalityWithLimit(this.filteredInputCardinality_ > -1L ? this.filteredInputCardinality_ : this.inputCardinality_);
    }

    @Override
    protected String getDisplayLabelDetail() {
        Preconditions.checkNotNull((Object)this.desc_.getPath());
        if (this.desc_.hasExplicitAlias()) {
            return this.desc_.getPath().toString() + " " + this.desc_.getAlias();
        }
        return this.desc_.getPath().toString();
    }

    protected int estimatePerHostScanRanges(long totalNumOfScanRanges) {
        return (int)Math.ceil((double)totalNumOfScanRanges / (double)this.numNodes_ * 1.2);
    }

    protected int computeMaxNumberOfScannerThreads(TQueryOptions queryOptions, int perHostScanRanges) {
        if (Planner.useMTFragment(queryOptions)) {
            return 1;
        }
        int maxScannerThreads = Math.min(perHostScanRanges, RuntimeEnv.INSTANCE.getNumCores());
        if (queryOptions.isSetNum_scanner_threads() && queryOptions.getNum_scanner_threads() > 0) {
            maxScannerThreads = Math.min(maxScannerThreads, queryOptions.getNum_scanner_threads());
        }
        return maxScannerThreads;
    }

    protected int computeMaxScannerThreadsForCPC(TQueryOptions queryOptions) {
        int maxThreadsPerNode = Math.max(queryOptions.getProcessing_cost_min_threads(), queryOptions.getMax_fragment_instances_per_node());
        int maxThreadsGlobal = IntMath.saturatedMultiply((int)this.getNumNodes(), (int)maxThreadsPerNode);
        int maxScannerThreads = Math.max(1, Math.min(this.estScanRangeAfterRuntimeFilter(), maxThreadsGlobal));
        return maxScannerThreads;
    }

    protected ProcessingCost computeScanProcessingCost(TQueryOptions queryOptions) {
        int maxScannerThreads = this.computeMaxScannerThreadsForCPC(queryOptions);
        long inputCardinality = this.getFilteredInputCardinality();
        if (inputCardinality >= 0L) {
            ProcessingCost cardinalityBasedCost = ProcessingCost.basicCost(this.getDisplayLabel(), inputCardinality, ExprUtil.computeExprsTotalCost(this.conjuncts_), this.rowMaterializationCost());
            if (inputCardinality == 0L) {
                Preconditions.checkState((cardinalityBasedCost.getTotalCost() == 0L ? 1 : 0) != 0, (Object)"Scan is empty but cost is non-zero.");
            }
            return cardinalityBasedCost;
        }
        long syntheticCardinality = Math.max(1L, Math.min(inputCardinality, (long)maxScannerThreads));
        long syntheticPerRowCost = LongMath.saturatedMultiply((long)Math.max(1L, BackendConfig.INSTANCE.getMinProcessingPerThread() / syntheticCardinality), (long)maxScannerThreads);
        return ProcessingCost.basicCost(this.getDisplayLabel(), syntheticCardinality, 0.0f, syntheticPerRowCost);
    }

    private float rowMaterializationCost() {
        float perRowCost = this.getAvgRowSize() / 1024.0f;
        if (this.getFilteredInputCardinality() <= 0L) {
            return perRowCost;
        }
        float perScanRangeCost = (float)BackendConfig.INSTANCE.getMinProcessingPerThread() * BackendConfig.INSTANCE.getScanRangeCostFactor();
        float scanRangeCostPerRow = perScanRangeCost / (float)this.getFilteredInputCardinality() * (float)this.estScanRangeAfterRuntimeFilter();
        return perRowCost + scanRangeCostPerRow;
    }

    protected int estScanRangeAfterRuntimeFilter() {
        return (int)Math.ceil((double)this.getEffectiveNumScanRanges() * this.scanRangeSelectivity_);
    }

    public boolean hasScanConjuncts() {
        return !this.getConjuncts().isEmpty();
    }

    public boolean hasStorageLayerConjuncts() {
        return false;
    }

    public ExprSubstitutionMap getOptimizedAggSmap() {
        return this.optimizedAggSmap_;
    }

    protected long getEffectiveNumScanRanges() {
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_);
        return this.scanRangeSpecs_.getConcrete_rangesSize();
    }

    private Map<PlanNodeId, List<RuntimeFilterGenerator.RuntimeFilter>> groupFiltersForCardinalityReduction() {
        boolean evalAtRowLevel = this instanceof KuduScanNode || this instanceof HdfsScanNode && ((HdfsScanNode)this).isAllColumnarScanner();
        HashMap<PlanNodeId, List<RuntimeFilterGenerator.RuntimeFilter>> filtersByJoinId = new HashMap<PlanNodeId, List<RuntimeFilterGenerator.RuntimeFilter>>();
        for (RuntimeFilterGenerator.RuntimeFilter filter : this.getRuntimeFilters()) {
            PlanNodeId filterSourceId = filter.getSrc().getId();
            boolean isPartitionFilter = filter.isPartitionFilterAt(this.id_);
            if (!filter.isHighlySelective() || !isPartitionFilter && !evalAtRowLevel) continue;
            filtersByJoinId.computeIfAbsent(filterSourceId, id -> new ArrayList()).add(filter);
        }
        return filtersByJoinId;
    }

    private Pair<Long, Double> getReducedCardinalityByFilter(Stack<PlanNode> nodeStack, double reductionScale) {
        Map<PlanNodeId, List<RuntimeFilterGenerator.RuntimeFilter>> filtersByJoinId = this.groupFiltersForCardinalityReduction();
        long reducedCardinality = this.cardinality_;
        HashMap<String, Double> partitionSelectivities = new HashMap<String, Double>();
        for (int i = nodeStack.size() - 1; i >= 0; --i) {
            PlanNode node = (PlanNode)nodeStack.get(i);
            if (node instanceof ExchangeNode) continue;
            Preconditions.checkState((boolean)(node instanceof JoinNode));
            JoinNode join = (JoinNode)node;
            PlanNodeId joinId = join.getId();
            if (!filtersByJoinId.containsKey(joinId)) continue;
            long cardOnThisJoin = reducedCardinality;
            for (RuntimeFilterGenerator.RuntimeFilter filter : filtersByJoinId.get(joinId)) {
                long estCardAfterFilter = filter.reducedCardinalityForScanNode(this, reducedCardinality, partitionSelectivities);
                if (estCardAfterFilter <= -1L) continue;
                cardOnThisJoin = Math.min(cardOnThisJoin, estCardAfterFilter);
            }
            reducedCardinality = cardOnThisJoin;
        }
        double partSel = partitionSelectivities.values().stream().reduce(1.0, (a, b) -> a * b);
        double scaledPartSel = 1.0 - (1.0 - partSel) * reductionScale;
        long lowestJoinCard = ((PlanNode)nodeStack.get(0)).getCardinality();
        long scaledReduction = (long)((double)(this.cardinality_ - reducedCardinality) * reductionScale);
        long scaledCardinality = Math.max(lowestJoinCard, this.cardinality_ - scaledReduction);
        return Pair.create(scaledCardinality, scaledPartSel);
    }

    @Override
    protected void reduceCardinalityByRuntimeFilter(Stack<PlanNode> nodeStack, double reductionScale) {
        long inputCardinalityEst;
        if (nodeStack.isEmpty() || this.inputCardinality_ <= 0L) {
            nodeStack.clear();
            return;
        }
        long prevCardinality = this.cardinality_;
        for (int i = nodeStack.size() - 1; i >= 0; --i) {
            long currentCardinality = ((PlanNode)nodeStack.get(i)).getCardinality();
            Preconditions.checkState((currentCardinality <= prevCardinality ? 1 : 0) != 0, (Object)("Original cardinality of " + ((PlanNode)nodeStack.get(i)).getDisplayLabel() + " is larger than node below it."));
            prevCardinality = currentCardinality;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("reduceCardinalityByRuntimeFilter from " + this.getDisplayLabel() + " to " + ((PlanNode)nodeStack.get(0)).getDisplayLabel());
        }
        Pair<Long, Double> reducedCardinality = this.getReducedCardinalityByFilter(nodeStack, reductionScale);
        long scanCardinalityAfterFilter = reducedCardinality.getFirst();
        long numRanges = this.getEffectiveNumScanRanges();
        this.scanRangeSelectivity_ = reducedCardinality.getSecond();
        if (numRanges > 0L && this.scanRangeSelectivity_ < 1.0 / (double)numRanges) {
            this.scanRangeSelectivity_ = 1.0 / (double)numRanges;
        }
        long l = inputCardinalityEst = this instanceof KuduScanNode ? scanCardinalityAfterFilter : Math.max(scanCardinalityAfterFilter, (long)Math.ceil((double)this.inputCardinality_ * this.scanRangeSelectivity_));
        if (this.inputCardinality_ > inputCardinalityEst) {
            this.filteredInputCardinality_ = inputCardinalityEst;
        }
        if (this.cardinality_ > scanCardinalityAfterFilter) {
            this.setFilteredCardinality(scanCardinalityAfterFilter);
            while (nodeStack.size() > 1 && nodeStack.peek().cardinality_ > scanCardinalityAfterFilter) {
                PlanNode node = nodeStack.pop();
                node.setFilteredCardinality(scanCardinalityAfterFilter);
            }
        }
        nodeStack.clear();
        if (LOG.isTraceEnabled()) {
            LOG.trace("reduceCardinalityByRuntimeFilter completed at " + this.getDisplayLabel() + ". inputCardinality=" + this.getInputCardinality() + " filteredInputCardinality=" + this.getFilteredInputCardinality() + " cardinality=" + this.getCardinality() + " filteredCardinality=" + this.getFilteredCardinality());
        }
    }
}

