/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.planner.PlanFragmentId;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.EventSequence;

public class PlannerContext {
    public static final double HASH_TBL_SPACE_OVERHEAD = 1.1;
    public static final double SIZE_OF_BUCKET = 12.0;
    public static final double SIZE_OF_DUPLICATENODE = 16.0;
    public static final long AVG_COLLECTION_SIZE = 10L;
    private final IdGenerator<PlanNodeId> nodeIdGenerator_ = PlanNodeId.createGenerator();
    private final IdGenerator<PlanFragmentId> fragmentIdGenerator_ = PlanFragmentId.createGenerator();
    private final LinkedList<SubplanNode> subplans_ = Lists.newLinkedList();
    private final AnalysisContext.AnalysisResult analysisResult_;
    private final EventSequence timeline_;
    private final TQueryCtx queryCtx_;
    private final QueryStmt queryStmt_;
    private final Analyzer rootAnalyzer_;

    public PlannerContext(AnalysisContext.AnalysisResult analysisResult, TQueryCtx queryCtx, EventSequence timeline) {
        this.analysisResult_ = analysisResult;
        this.queryCtx_ = queryCtx;
        this.timeline_ = timeline;
        this.queryStmt_ = this.isInsertOrCtas() ? analysisResult.getInsertStmt().getQueryStmt() : (analysisResult.isUpdateStmt() ? analysisResult.getUpdateStmt().getQueryStmt() : (analysisResult.isDeleteStmt() ? analysisResult.getDeleteStmt().getQueryStmt() : (analysisResult.isOptimizeStmt() ? analysisResult.getOptimizeStmt().getQueryStmt() : analysisResult.getQueryStmt())));
        this.rootAnalyzer_ = analysisResult.getAnalyzer();
    }

    public PlannerContext(TQueryCtx queryCtx, EventSequence timeline) {
        this((Analyzer)null, queryCtx, timeline);
    }

    public PlannerContext(Analyzer analyzer, TQueryCtx queryCtx, EventSequence timeline) {
        this.queryCtx_ = queryCtx;
        this.timeline_ = timeline;
        this.analysisResult_ = null;
        this.queryStmt_ = null;
        this.rootAnalyzer_ = analyzer;
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt_;
    }

    public TQueryCtx getQueryCtx() {
        return this.queryCtx_;
    }

    public TQueryOptions getQueryOptions() {
        return this.getRootAnalyzer().getQueryOptions();
    }

    public AnalysisContext.AnalysisResult getAnalysisResult() {
        return this.analysisResult_;
    }

    public EventSequence getTimeline() {
        return this.timeline_;
    }

    public Analyzer getRootAnalyzer() {
        return this.rootAnalyzer_;
    }

    public boolean isSingleNodeExec() {
        return this.getQueryOptions().num_nodes == 1;
    }

    public PlanNodeId getNextNodeId() {
        return this.nodeIdGenerator_.getNextId();
    }

    public PlanFragmentId getNextFragmentId() {
        return this.fragmentIdGenerator_.getNextId();
    }

    public boolean isInsertOrCtas() {
        return this.analysisResult_.isInsertStmt() || this.analysisResult_.isCreateTableAsSelectStmt();
    }

    public boolean isInsert() {
        return this.analysisResult_.isInsertStmt();
    }

    public boolean isOptimize() {
        return this.analysisResult_.isOptimizeStmt();
    }

    public boolean isCtas() {
        return this.analysisResult_.isCreateTableAsSelectStmt();
    }

    public boolean isUpdateOrDelete() {
        return this.analysisResult_.isUpdateStmt() || this.analysisResult_.isDeleteStmt();
    }

    public boolean isQuery() {
        return this.analysisResult_.isQueryStmt();
    }

    public boolean hasTableSink() {
        return this.isInsertOrCtas() || this.analysisResult_.isUpdateStmt() || this.analysisResult_.isDeleteStmt() || this.analysisResult_.isOptimizeStmt();
    }

    public boolean hasSubplan() {
        return !this.subplans_.isEmpty();
    }

    public SubplanNode getSubplan() {
        return this.subplans_.getFirst();
    }

    public boolean pushSubplan(SubplanNode n) {
        return this.subplans_.offerFirst(n);
    }

    public void popSubplan() {
        this.subplans_.removeFirst();
    }

    public boolean isUpdate() {
        return this.analysisResult_.isUpdateStmt();
    }

    public boolean isDelete() {
        return this.analysisResult_.isDeleteStmt();
    }
}

