/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnLineageGraph;
import org.apache.impala.analysis.DeleteStmt;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.planner.CoreCount;
import org.apache.impala.planner.DataPartition;
import org.apache.impala.planner.DistributedPlanner;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.JoinBuildSink;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.ParallelPlanner;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanFragmentId;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.planner.SingleNodePlanner;
import org.apache.impala.planner.SingularRowSrcNode;
import org.apache.impala.planner.SortNode;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.planner.TrivialQueryChecker;
import org.apache.impala.planner.TupleCachePlanner;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TMinmaxFilteringLevel;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryExecRequest;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TRuntimeFilterMode;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.KuduUtil;
import org.apache.impala.util.MathUtil;
import org.apache.impala.util.MaxRowsProcessedVisitor;
import org.apache.kudu.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Planner {
    private static final Logger LOG = LoggerFactory.getLogger(Planner.class);
    public static final long MIN_PER_HOST_MEM_ESTIMATE_BYTES = 0xA00000L;
    public static final long DEDICATED_COORD_SAFETY_BUFFER_BYTES = 0x6400000L;
    public static final ResourceProfile MIN_PER_HOST_RESOURCES = new ResourceProfileBuilder().setMemEstimateBytes(0xA00000L).setMinMemReservationBytes(0L).build();
    private final PlannerContext ctx_;

    public Planner(AnalysisContext.AnalysisResult analysisResult, TQueryCtx queryCtx, EventSequence timeline) {
        this.ctx_ = new PlannerContext(analysisResult, queryCtx, timeline);
    }

    public TQueryCtx getQueryCtx() {
        return this.ctx_.getQueryCtx();
    }

    public PlannerContext getPlannerCtx() {
        return this.ctx_;
    }

    public AnalysisContext.AnalysisResult getAnalysisResult() {
        return this.ctx_.getAnalysisResult();
    }

    private List<PlanFragment> createPlanFragments() throws ImpalaException {
        SingleNodePlanner singleNodePlanner = new SingleNodePlanner(this.ctx_);
        DistributedPlanner distributedPlanner = new DistributedPlanner(this.ctx_);
        PlanNode singleNodePlan = singleNodePlanner.createSingleNodePlan();
        this.ctx_.getTimeline().markEvent("Single node plan created");
        ArrayList fragments = null;
        this.checkForSmallQueryOptimization(singleNodePlan);
        Planner.invertJoins(singleNodePlan, this.ctx_.isSingleNodeExec());
        singleNodePlan = this.useNljForSingularRowBuilds(singleNodePlan, this.ctx_.getRootAnalyzer());
        SingleNodePlanner.validatePlan(this.ctx_, singleNodePlan);
        fragments = this.ctx_.isSingleNodeExec() ? Lists.newArrayList((Object[])new PlanFragment[]{new PlanFragment(this.ctx_.getNextFragmentId(), singleNodePlan, DataPartition.UNPARTITIONED)}) : distributedPlanner.createPlanFragments(singleNodePlan);
        PlanFragment rootFragment = fragments.get(fragments.size() - 1);
        if (this.ctx_.getQueryOptions().getRuntime_filter_mode() != TRuntimeFilterMode.OFF) {
            RuntimeFilterGenerator.generateRuntimeFilters(this.ctx_, rootFragment.getPlanRoot());
            this.ctx_.getTimeline().markEvent("Runtime filters computed");
            this.checkAndOverrideMinmaxFilterThresholdAndLevel(this.ctx_.getQueryOptions());
        }
        rootFragment.verifyTree();
        ExprSubstitutionMap rootNodeSmap = rootFragment.getPlanRoot().getOutputSmap();
        if (this.ctx_.isInsertOrCtas()) {
            InsertStmt insertStmt = this.ctx_.getAnalysisResult().getInsertStmt();
            insertStmt.substituteResultExprs(rootNodeSmap, this.ctx_.getRootAnalyzer());
            if (!this.ctx_.isSingleNodeExec()) {
                rootFragment = distributedPlanner.createDmlFragment(rootFragment, insertStmt, this.ctx_.getRootAnalyzer(), fragments);
            }
            this.createPreInsertSort(insertStmt, rootFragment, this.ctx_.getRootAnalyzer());
            rootFragment.setSink(insertStmt.createDataSink());
        } else if (this.ctx_.isUpdate() || this.ctx_.isDelete() || this.ctx_.isOptimize()) {
            DmlStatementBase stmt = this.ctx_.isUpdate() ? this.ctx_.getAnalysisResult().getUpdateStmt() : (this.ctx_.isDelete() ? this.ctx_.getAnalysisResult().getDeleteStmt() : this.ctx_.getAnalysisResult().getOptimizeStmt());
            Preconditions.checkNotNull((Object)stmt);
            stmt.substituteResultExprs(rootNodeSmap, this.ctx_.getRootAnalyzer());
            if (stmt.getTargetTable() instanceof FeIcebergTable) {
                rootFragment = this.createIcebergDmlPlanFragment(rootFragment, distributedPlanner, stmt, fragments);
            }
            rootFragment.setSink(stmt.createDataSink());
        } else if (this.ctx_.isQuery()) {
            QueryStmt queryStmt = this.ctx_.getQueryStmt();
            queryStmt.substituteResultExprs(rootNodeSmap, this.ctx_.getRootAnalyzer());
            List<Expr> resultExprs = queryStmt.getResultExprs();
            rootFragment.setSink(this.ctx_.getAnalysisResult().getQueryStmt().createDataSink(resultExprs));
        }
        this.checkForDisableCodegen(rootFragment.getPlanRoot());
        if (LOG.isTraceEnabled()) {
            LOG.trace("desctbl: " + this.ctx_.getRootAnalyzer().getDescTbl().debugString());
            LOG.trace("root sink: " + rootFragment.getSink().getExplainString("", "", this.ctx_.getQueryOptions(), TExplainLevel.VERBOSE));
            LOG.trace("finalize plan fragments");
        }
        for (PlanFragment fragment : fragments) {
            fragment.finalizeExchanges(this.ctx_.getRootAnalyzer());
        }
        Collections.reverse(fragments);
        this.ctx_.getTimeline().markEvent("Distributed plan created");
        this.ctx_.getRootAnalyzer().logCacheStats();
        ColumnLineageGraph graph = this.ctx_.getRootAnalyzer().getColumnLineageGraph();
        if (BackendConfig.INSTANCE.getComputeLineage() || RuntimeEnv.INSTANCE.isTestEnv()) {
            if (this.ctx_.isUpdateOrDelete()) {
                return fragments;
            }
            if (this.ctx_.isInsertOrCtas()) {
                InsertStmt insertStmt = this.ctx_.getAnalysisResult().getInsertStmt();
                FeTable targetTable = insertStmt.getTargetTable();
                Preconditions.checkNotNull((Object)targetTable);
                if (targetTable instanceof FeKuduTable) {
                    if (this.ctx_.isInsert()) {
                        List<String> mentionedColumns = insertStmt.getMentionedColumns();
                        Preconditions.checkState((!mentionedColumns.isEmpty() ? 1 : 0) != 0);
                        ArrayList<ColumnLineageGraph.ColumnLabel> targetColLabels = new ArrayList<ColumnLineageGraph.ColumnLabel>();
                        for (String column : mentionedColumns) {
                            targetColLabels.add(new ColumnLineageGraph.ColumnLabel(column, targetTable.getTableName(), ColumnLineageGraph.getTableType(targetTable)));
                        }
                        graph.addTargetColumnLabels(targetColLabels);
                    } else {
                        Preconditions.checkState((boolean)this.ctx_.isCtas());
                        if (((FeKuduTable)targetTable).hasAutoIncrementingColumn()) {
                            ArrayList<ColumnLineageGraph.ColumnLabel> targetColLabels = new ArrayList<ColumnLineageGraph.ColumnLabel>();
                            for (String column : targetTable.getColumnNames()) {
                                if (column.equals(Schema.getAutoIncrementingColumnName())) continue;
                                targetColLabels.add(new ColumnLineageGraph.ColumnLabel(column, targetTable.getTableName(), ColumnLineageGraph.getTableType(targetTable)));
                            }
                            graph.addTargetColumnLabels(targetColLabels);
                        } else {
                            graph.addTargetColumnLabels(targetTable);
                        }
                    }
                } else if (targetTable instanceof FeHBaseTable) {
                    graph.addTargetColumnLabels(targetTable);
                } else {
                    graph.addTargetColumnLabels(targetTable);
                }
            } else {
                graph.addTargetColumnLabels(this.ctx_.getQueryStmt().getColLabels().stream().map(col -> new ColumnLineageGraph.ColumnLabel((String)col)).collect(Collectors.toList()));
            }
            ArrayList<Expr> outputExprs = new ArrayList<Expr>();
            rootFragment.getSink().collectExprs(outputExprs);
            graph.computeLineageGraph(outputExprs, this.ctx_.getRootAnalyzer());
            if (LOG.isTraceEnabled()) {
                LOG.trace("lineage: " + graph.debugString());
            }
            this.ctx_.getTimeline().markEvent("Lineage info computed");
        }
        return fragments;
    }

    public PlanFragment createIcebergDmlPlanFragment(PlanFragment rootFragment, DistributedPlanner distributedPlanner, DmlStatementBase stmt, List<PlanFragment> fragments) throws ImpalaException {
        if (!this.ctx_.isSingleNodeExec()) {
            rootFragment = distributedPlanner.createDmlFragment(rootFragment, stmt, this.ctx_.getRootAnalyzer(), fragments);
        }
        if (!(stmt instanceof DeleteStmt)) {
            this.createPreDmlSort(stmt, rootFragment, this.ctx_.getRootAnalyzer());
        }
        return rootFragment;
    }

    public List<PlanFragment> createPlans() throws ImpalaException {
        List<PlanFragment> distrPlan = this.createPlanFragments();
        Preconditions.checkNotNull(distrPlan);
        if (Planner.useParallelPlan(this.ctx_)) {
            ParallelPlanner parallelPlanner = new ParallelPlanner(this.ctx_);
            distrPlan = parallelPlanner.createPlans(distrPlan.get(0));
            this.ctx_.getTimeline().markEvent("Parallel plans created");
        } else {
            distrPlan = Collections.singletonList(distrPlan.get(0));
        }
        if (Planner.useTupleCache(this.ctx_)) {
            TupleCachePlanner cachePlanner = new TupleCachePlanner(this.ctx_);
            distrPlan = cachePlanner.createPlans(distrPlan);
            this.ctx_.getTimeline().markEvent("Tuple caching plan created");
        }
        return distrPlan;
    }

    public static boolean useParallelPlan(PlannerContext planCtx) {
        return Planner.useMTFragment(planCtx.getQueryOptions()) && !planCtx.isSingleNodeExec();
    }

    public static boolean useMTFragment(TQueryOptions queryOptions) {
        Preconditions.checkState((boolean)queryOptions.isSetMt_dop());
        return queryOptions.getMt_dop() > 0 || queryOptions.isCompute_processing_cost();
    }

    public static boolean useTupleCache(PlannerContext planCtx) {
        return planCtx.getQueryOptions().isEnable_tuple_cache();
    }

    public String getExplainString(List<PlanFragment> fragments, TQueryExecRequest request) {
        TExplainLevel explainLevel = TExplainLevel.EXTENDED;
        if (this.ctx_.getAnalysisResult().isExplainStmt() || RuntimeEnv.INSTANCE.isTestEnv()) {
            explainLevel = this.ctx_.getQueryOptions().getExplain_level();
        }
        return this.getExplainString(fragments, request, explainLevel);
    }

    public String getExplainString(List<PlanFragment> fragments, TQueryExecRequest request, TExplainLevel explainLevel) {
        ArrayList<String> tableNames;
        StringBuilder str = new StringBuilder();
        boolean hasHeader = false;
        if (request.isSetMax_per_host_min_mem_reservation()) {
            Preconditions.checkState((boolean)request.isSetMax_per_host_thread_reservation());
            Preconditions.checkState((boolean)request.isSetPer_host_mem_estimate());
            str.append(String.format("Max Per-Host Resource Reservation: Memory=%s Threads=%d\n", PrintUtils.printBytes(request.getMax_per_host_min_mem_reservation()), request.getMax_per_host_thread_reservation()));
            str.append(String.format("Per-Host Resource Estimates: Memory=%s\n", PrintUtils.printBytesRoundedToMb(request.getPer_host_mem_estimate())));
            if (BackendConfig.INSTANCE.useDedicatedCoordinatorEstimates()) {
                str.append(String.format("Dedicated Coordinator Resource Estimate: Memory=%s\n", PrintUtils.printBytesRoundedToMb(request.getDedicated_coord_mem_estimate())));
            }
            hasHeader = true;
        }
        if (request.query_ctx.client_request.query_options.planner_testcase_mode) {
            str.append("WARNING: The planner is running in TESTCASE mode. This should only be used by developers for debugging.\nTo disable it, do SET PLANNER_TESTCASE_MODE=false.\n");
        }
        if (request.query_ctx.disable_codegen_hint) {
            str.append("Codegen disabled by planner\n");
        }
        if (!request.query_ctx.isSetParent_query_id() && request.query_ctx.isSetTables_with_corrupt_stats() && !request.query_ctx.getTables_with_corrupt_stats().isEmpty()) {
            tableNames = new ArrayList();
            for (TTableName tableName : request.query_ctx.getTables_with_corrupt_stats()) {
                tableNames.add(tableName.db_name + "." + tableName.table_name);
            }
            str.append("The row count in one or more partitions in the following tables \nis either a) less than -1, or b) 0 but the size of all the files inside \nthe partition(s) is positive.\nThe latter case does not necessarily imply the existence of corrupt \nstatistics when the corresponding tables are transactional.\nIf it is suspected that there may be corrupt statistics, dropping and \nre-computing statistics could resolve this problem.\n" + Joiner.on((String)", ").join(tableNames) + "\n");
            hasHeader = true;
        }
        if (!request.query_ctx.isSetParent_query_id() && request.query_ctx.isSetTables_missing_stats() && !request.query_ctx.getTables_missing_stats().isEmpty()) {
            tableNames = new ArrayList();
            for (TTableName tableName : request.query_ctx.getTables_missing_stats()) {
                tableNames.add(tableName.db_name + "." + tableName.table_name);
            }
            str.append("WARNING: The following tables are missing relevant table and/or column statistics.\n" + Joiner.on((String)", ").join(tableNames) + "\n");
            hasHeader = true;
        }
        if (request.query_ctx.isSetTables_missing_diskids()) {
            tableNames = new ArrayList<String>();
            for (TTableName tableName : request.query_ctx.getTables_missing_diskids()) {
                tableNames.add(tableName.db_name + "." + tableName.table_name);
            }
            str.append("WARNING: The following tables have scan ranges with missing disk id information.\n" + Joiner.on((String)", ").join(tableNames) + "\n");
            hasHeader = true;
        }
        if (request.query_ctx.isDisable_spilling()) {
            str.append("WARNING: Spilling is disabled for this query as a safety guard.\nReason: Query option disable_unsafe_spills is set, at least one table\nis missing relevant stats, and no plan hints were given.\n");
            hasHeader = true;
        }
        if (explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            String queryText = this.ctx_.getQueryStmt().toSql(ToSqlOptions.SHOW_IMPLICIT_CASTS);
            String wrappedText = PrintUtils.wrapString("Analyzed query: " + queryText, 80);
            str.append(wrappedText).append("\n");
            hasHeader = true;
        }
        if (hasHeader) {
            str.append("\n");
        }
        if (explainLevel.ordinal() < TExplainLevel.VERBOSE.ordinal()) {
            str.append(fragments.get(0).getExplainString(this.ctx_.getQueryOptions(), explainLevel));
        } else {
            for (int i = 0; i < fragments.size(); ++i) {
                PlanFragment fragment = fragments.get(i);
                str.append(fragment.getExplainString(this.ctx_.getQueryOptions(), explainLevel));
                if (i >= fragments.size() - 1) continue;
                str.append("\n");
            }
        }
        return str.toString();
    }

    private static void computeEffectiveParallelism(List<PlanFragment> postOrderFragments, int minThreadPerNode, int maxThreadPerNode, TQueryOptions queryOptions) {
        Preconditions.checkArgument((minThreadPerNode > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxThreadPerNode >= minThreadPerNode ? 1 : 0) != 0);
        Preconditions.checkArgument((128 >= maxThreadPerNode ? 1 : 0) != 0);
        for (PlanFragment fragment : postOrderFragments) {
            if (fragment.getSink() instanceof JoinBuildSink) continue;
            fragment.traverseEffectiveParallelism(minThreadPerNode, maxThreadPerNode, null, queryOptions);
        }
        for (PlanFragment fragment : postOrderFragments) {
            fragment.setEffectiveNumInstance();
        }
    }

    private static CoreCount computeBlockingAwareCores(List<PlanFragment> postOrderFragments, boolean findUnboundedCount) {
        HashMap fragmentCoreState = Maps.newHashMap();
        for (PlanFragment fragment : postOrderFragments) {
            fragment.computeBlockingAwareCores(fragmentCoreState, findUnboundedCount);
        }
        PlanFragment root = postOrderFragments.get(postOrderFragments.size() - 1);
        Pair rootCores = (Pair)fragmentCoreState.get(root.getId());
        CoreCount maxCores = root.maxCore((CoreCount)rootCores.first, CoreCount.sum((List)rootCores.second), findUnboundedCount);
        return maxCores;
    }

    public static void reduceCardinalityByRuntimeFilter(List<PlanFragment> planRoots, PlannerContext planCtx) {
        double reductionScale = planCtx.getRootAnalyzer().getQueryOptions().getRuntime_filter_cardinality_reduction_scale();
        if (reductionScale <= 0.0) {
            return;
        }
        PlanFragment rootFragment = planRoots.get(0);
        Stack<PlanNode> nodeStack = new Stack<PlanNode>();
        rootFragment.getPlanRoot().reduceCardinalityByRuntimeFilter(nodeStack, reductionScale);
    }

    public static void computeProcessingCost(List<PlanFragment> planRoots, TQueryExecRequest request, PlannerContext planCtx) {
        boolean testCostCalculation;
        Analyzer rootAnalyzer = planCtx.getRootAnalyzer();
        TQueryOptions queryOptions = rootAnalyzer.getQueryOptions();
        PlanFragment rootFragment = planRoots.get(0);
        List<Object> postOrderFragments = new ArrayList();
        boolean bl = testCostCalculation = queryOptions.isEnable_replan() && (RuntimeEnv.INSTANCE.isTestEnv() || queryOptions.isTest_replan());
        if (queryOptions.isCompute_processing_cost() || testCostCalculation) {
            postOrderFragments = rootFragment.getNodesPostOrder();
            for (PlanFragment planFragment : postOrderFragments) {
                planFragment.computeCostingSegment(queryOptions);
            }
        }
        if (!queryOptions.isCompute_processing_cost()) {
            request.setCores_required(-1);
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computing effective parallelism. numNode=" + rootAnalyzer.numExecutorsForPlanning() + " availableCoresPerNode=" + rootAnalyzer.getAvailableCoresPerNode() + " minThreads=" + rootAnalyzer.getMinParallelismPerNode() + " maxThreads=" + rootAnalyzer.getMaxParallelismPerNode());
        }
        Planner.computeEffectiveParallelism(postOrderFragments, rootAnalyzer.getMinParallelismPerNode(), rootAnalyzer.getMaxParallelismPerNode(), queryOptions);
        CoreCount boundedCores = Planner.computeBlockingAwareCores(postOrderFragments, false);
        HashSet<PlanFragmentId> hashSet = new HashSet<PlanFragmentId>((Collection<PlanFragmentId>)boundedCores.getUniqueFragmentIds());
        int coresRequired = Math.max(1, boundedCores.totalWithoutCoordinator());
        if (boundedCores.hasCoordinator()) {
            hashSet.remove(rootFragment.getId());
        }
        request.setCores_required(coresRequired);
        LOG.info("CoreCount=" + boundedCores + ", coresRequired=" + coresRequired);
        for (PlanFragment planFragment : postOrderFragments) {
            if (!hashSet.contains(planFragment.getId())) continue;
            planFragment.markDominant();
        }
        CoreCount unboundedCores = Planner.computeBlockingAwareCores(postOrderFragments, true);
        int n = Math.max(1, unboundedCores.totalWithoutCoordinator());
        request.setCores_required_unbounded(n);
        LOG.info("CoreCountUnbounded=" + unboundedCores + ", coresRequiredUnbounded=" + n);
    }

    public static void computeResourceReqs(List<PlanFragment> planRoots, TQueryCtx queryCtx, TQueryExecRequest request, PlannerContext planCtx, boolean isQueryStmt) {
        Preconditions.checkState((!planRoots.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)request);
        TQueryOptions queryOptions = planCtx.getRootAnalyzer().getQueryOptions();
        ResourceProfile maxPerHostPeakResources = ResourceProfile.invalid();
        long totalRuntimeFilterMemBytes = 0L;
        PlanFragment rootFragment = planRoots.get(0);
        List allFragments = rootFragment.getNodesPostOrder();
        boolean trivial = TrivialQueryChecker.IsTrivial(rootFragment, queryOptions, isQueryStmt);
        for (PlanFragment fragment : allFragments) {
            fragment.computeResourceProfile(planCtx.getRootAnalyzer());
            maxPerHostPeakResources = maxPerHostPeakResources.sum(fragment.getTotalPerBackendResourceProfile(queryOptions));
            totalRuntimeFilterMemBytes += fragment.getProducedRuntimeFiltersMemReservationBytes();
        }
        rootFragment.computePipelineMembership();
        Preconditions.checkState((maxPerHostPeakResources.getMemEstimateBytes() >= 0L ? 1 : 0) != 0, (Object)maxPerHostPeakResources.getMemEstimateBytes());
        Preconditions.checkState((maxPerHostPeakResources.getMinMemReservationBytes() >= 0L ? 1 : 0) != 0, (Object)maxPerHostPeakResources.getMinMemReservationBytes());
        maxPerHostPeakResources = MIN_PER_HOST_RESOURCES.max(maxPerHostPeakResources);
        request.setPer_host_mem_estimate(maxPerHostPeakResources.getMemEstimateBytes());
        request.setPlanner_per_host_mem_estimate(maxPerHostPeakResources.getMemEstimateBytes());
        request.setIs_trivial_query(trivial);
        request.setMax_per_host_min_mem_reservation(maxPerHostPeakResources.getMinMemReservationBytes());
        request.setMax_per_host_thread_reservation(maxPerHostPeakResources.getThreadReservation());
        if (isQueryStmt) {
            ResourceProfile rootFragmentResourceProfile = rootFragment.getPerInstanceResourceProfile().sum(rootFragment.getPerBackendResourceProfile());
            request.setDedicated_coord_mem_estimate(MathUtil.saturatingAdd(rootFragmentResourceProfile.getMemEstimateBytes(), totalRuntimeFilterMemBytes + 0x6400000L));
        } else {
            request.setDedicated_coord_mem_estimate(totalRuntimeFilterMemBytes + 0x6400000L);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Max per-host min reservation: " + maxPerHostPeakResources.getMinMemReservationBytes());
            LOG.trace("Max estimated per-host memory: " + maxPerHostPeakResources.getMemEstimateBytes());
            LOG.trace("Max estimated per-host thread reservation: " + maxPerHostPeakResources.getThreadReservation());
        }
    }

    public static void invertJoins(PlanNode root, boolean isLocalPlan) {
        if (root instanceof SubplanNode) {
            Planner.invertJoins((PlanNode)root.getChild(0), isLocalPlan);
            Planner.invertJoins((PlanNode)root.getChild(1), true);
        } else {
            for (PlanNode child : root.getChildren()) {
                Planner.invertJoins(child, isLocalPlan);
            }
        }
        if (root instanceof JoinNode) {
            JoinNode joinNode = (JoinNode)root;
            JoinOperator joinOp = joinNode.getJoinOp();
            if (!joinNode.isInvertible(isLocalPlan)) {
                root.computeTupleIds();
                return;
            }
            if (joinNode.getChild(0) instanceof SingularRowSrcNode) {
                joinNode.invertJoin();
            } else if (!isLocalPlan && joinNode instanceof NestedLoopJoinNode && (joinOp.isRightSemiJoin() || joinOp.isRightOuterJoin())) {
                joinNode.invertJoin();
            } else if (Planner.isInvertedJoinCheaper(joinNode, isLocalPlan)) {
                joinNode.invertJoin();
            }
            joinNode.recomputeNodes();
        }
        root.computeTupleIds();
    }

    public static boolean isInvertedJoinCheaper(JoinNode joinNode, boolean isLocalPlan) {
        int rhsNumNodes;
        long lhsCard = ((PlanNode)joinNode.getChild(0)).getCardinality();
        long rhsCard = ((PlanNode)joinNode.getChild(1)).getCardinality();
        if (lhsCard == -1L || rhsCard == -1L) {
            return false;
        }
        double lhsBytes = (float)lhsCard * ((PlanNode)joinNode.getChild(0)).getAvgRowSize();
        double rhsBytes = (float)rhsCard * ((PlanNode)joinNode.getChild(1)).getAvgRowSize();
        if (joinNode instanceof NestedLoopJoinNode) {
            return lhsBytes < rhsBytes;
        }
        Preconditions.checkState((boolean)(joinNode instanceof HashJoinNode));
        int lhsNumNodes = isLocalPlan ? 1 : ((PlanNode)joinNode.getChild(0)).getNumNodes();
        int n = rhsNumNodes = isLocalPlan ? 1 : ((PlanNode)joinNode.getChild(1)).getNumNodes();
        if (lhsNumNodes <= 0 || rhsNumNodes <= 0) {
            return false;
        }
        long CONSTANT_COST_PER_BYTE = 5L;
        double totalCost = (Math.log10(rhsBytes + 1.0) + 5.0) * (lhsBytes + 2.0 * rhsBytes);
        double invertedTotalCost = (Math.log10(lhsBytes + 1.0) + 5.0) * (rhsBytes + 2.0 * lhsBytes);
        double perNodeCost = totalCost / (double)lhsNumNodes;
        double invertedPerNodeCost = invertedTotalCost / (double)rhsNumNodes;
        if (LOG.isTraceEnabled()) {
            LOG.trace("isInvertedJoinCheaper() " + TupleId.printIds(joinNode.getTupleIds()));
            LOG.trace("lhsCard " + lhsCard + " lhsBytes " + lhsBytes + " lhsNumNodes " + lhsNumNodes);
            LOG.trace("rhsCard " + rhsCard + " rhsBytes " + rhsBytes + " rhsNumNodes " + rhsNumNodes);
            LOG.trace("cost " + perNodeCost + " invCost " + invertedPerNodeCost);
            LOG.trace("INVERT? " + (invertedPerNodeCost < perNodeCost));
        }
        return invertedPerNodeCost < perNodeCost;
    }

    private PlanNode useNljForSingularRowBuilds(PlanNode root, Analyzer analyzer) throws ImpalaException {
        for (int i = 0; i < root.getChildren().size(); ++i) {
            root.setChild(i, this.useNljForSingularRowBuilds((PlanNode)root.getChild(i), analyzer));
        }
        if (!(root instanceof JoinNode)) {
            return root;
        }
        if (root instanceof NestedLoopJoinNode) {
            return root;
        }
        if (!(root.getChild(1) instanceof SingularRowSrcNode)) {
            return root;
        }
        JoinNode joinNode = (JoinNode)root;
        if (joinNode.getJoinOp().isNullAwareLeftAntiJoin()) {
            Preconditions.checkState((boolean)(joinNode instanceof HashJoinNode));
            return root;
        }
        ArrayList otherJoinConjuncts = Lists.newArrayList(joinNode.getOtherJoinConjuncts());
        otherJoinConjuncts.addAll(joinNode.getEqJoinConjuncts());
        NestedLoopJoinNode newJoinNode = new NestedLoopJoinNode((PlanNode)joinNode.getChild(0), (PlanNode)joinNode.getChild(1), joinNode.isStraightJoin(), joinNode.getDistributionModeHint(), joinNode.getJoinOp(), otherJoinConjuncts);
        newJoinNode.getConjuncts().addAll(joinNode.getConjuncts());
        newJoinNode.setId(joinNode.getId());
        ((JoinNode)newJoinNode).init(analyzer);
        return newJoinNode;
    }

    public static void checkForSmallQueryOptimization(PlanNode singleNodePlan, PlannerContext ctx) {
        int threshold;
        MaxRowsProcessedVisitor visitor = new MaxRowsProcessedVisitor();
        singleNodePlan.accept(visitor);
        if (!visitor.valid()) {
            return;
        }
        long maxRowsProcessed = visitor.getMaxRowsProcessed();
        if (maxRowsProcessed < (long)(threshold = ctx.getQueryOptions().exec_single_node_rows_threshold)) {
            LOG.trace("Query is small enough to execute on a single node: maxRowsProcessed = " + maxRowsProcessed);
            ctx.getQueryOptions().setNum_nodes(1);
            ctx.getQueryCtx().disable_codegen_hint = true;
            if (maxRowsProcessed < (long)ctx.getQueryOptions().batch_size || maxRowsProcessed < 1024L && ctx.getQueryOptions().batch_size == 0) {
                ctx.getQueryOptions().setNum_scanner_threads(1);
            }
            ctx.getQueryOptions().setRuntime_filter_mode(TRuntimeFilterMode.OFF);
        }
    }

    private void checkForSmallQueryOptimization(PlanNode singleNodePlan) {
        Planner.checkForSmallQueryOptimization(singleNodePlan, this.ctx_);
    }

    private void checkAndOverrideMinmaxFilterThresholdAndLevel(TQueryOptions queryOptions) {
        if (queryOptions.parquet_read_statistics) {
            if (queryOptions.isMinmax_filter_sorted_columns() && queryOptions.getMinmax_filter_threshold() == 0.0) {
                queryOptions.setMinmax_filter_threshold(0.5);
                queryOptions.setMinmax_filtering_level(TMinmaxFilteringLevel.PAGE);
            }
            if (queryOptions.isMinmax_filter_partition_columns() && queryOptions.getMinmax_filter_threshold() == 0.0) {
                queryOptions.setMinmax_filter_threshold(0.5);
            }
        }
    }

    public static void checkForDisableCodegen(PlanNode distributedPlan, PlannerContext ctx) {
        MaxRowsProcessedVisitor visitor = new MaxRowsProcessedVisitor();
        distributedPlan.accept(visitor);
        if (!visitor.valid()) {
            return;
        }
        if (visitor.getMaxRowsProcessedPerNode() < (long)ctx.getQueryOptions().getDisable_codegen_rows_threshold()) {
            ctx.getQueryCtx().disable_codegen_hint = true;
        }
    }

    private void checkForDisableCodegen(PlanNode distributedPlan) {
        Planner.checkForDisableCodegen(distributedPlan, this.ctx_);
    }

    public void createPreInsertSort(InsertStmt insertStmt, PlanFragment inputFragment, Analyzer analyzer) throws ImpalaException {
        ArrayList<Expr> orderingExprs = new ArrayList<Expr>();
        boolean partialSort = false;
        int numPartitionKeys = 0;
        if (insertStmt.getTargetTable() instanceof FeKuduTable) {
            if (insertStmt.hasClusteredHint() || !insertStmt.hasNoClusteredHint() && !this.ctx_.isSingleNodeExec() && !insertStmt.getPartitionKeyExprs().isEmpty()) {
                orderingExprs.add(KuduUtil.createPartitionExpr(insertStmt, this.ctx_.getRootAnalyzer()));
                orderingExprs.addAll(insertStmt.getPrimaryKeyExprs());
                partialSort = true;
            }
        } else if (insertStmt.requiresClustering()) {
            List<Expr> partKeys = insertStmt.getPartitionKeyExprs();
            orderingExprs.addAll(partKeys);
            Expr.removeConstants(orderingExprs);
            numPartitionKeys = orderingExprs.size();
        }
        orderingExprs.addAll(insertStmt.getSortExprs());
        Expr.removeConstants(orderingExprs);
        if (orderingExprs.isEmpty()) {
            return;
        }
        List<Boolean> isAscOrder = Collections.nCopies(orderingExprs.size(), true);
        List<Boolean> nullsFirstParams = Collections.nCopies(orderingExprs.size(), false);
        SortInfo sortInfo = new SortInfo(orderingExprs, isAscOrder, nullsFirstParams, insertStmt.getSortingOrder());
        sortInfo.setNumLexicalKeysInZOrder(numPartitionKeys);
        sortInfo.createSortTupleInfo(insertStmt.getResultExprs(), analyzer);
        sortInfo.getSortTupleDescriptor().materializeSlots();
        insertStmt.substituteResultExprs(sortInfo.getOutputSmap(), analyzer);
        SortNode node = null;
        node = partialSort ? SortNode.createPartialSortNode(this.ctx_.getNextNodeId(), inputFragment.getPlanRoot(), sortInfo) : SortNode.createTotalSortNode(this.ctx_.getNextNodeId(), inputFragment.getPlanRoot(), sortInfo, 0L);
        ((PlanNode)node).init(analyzer);
        inputFragment.setPlanRoot(node);
    }

    public void createPreDmlSort(DmlStatementBase dmlStmt, PlanFragment inputFragment, Analyzer analyzer) throws ImpalaException {
        ArrayList<Expr> orderingExprs = new ArrayList<Expr>();
        List<Expr> partitionKeyExprs = dmlStmt.getPartitionKeyExprs();
        orderingExprs.addAll(partitionKeyExprs);
        orderingExprs.addAll(dmlStmt.getSortExprs());
        if (orderingExprs.isEmpty()) {
            return;
        }
        List<Boolean> isAscOrder = Collections.nCopies(orderingExprs.size(), true);
        List<Boolean> nullsFirstParams = Collections.nCopies(orderingExprs.size(), false);
        SortInfo sortInfo = new SortInfo(orderingExprs, isAscOrder, nullsFirstParams, dmlStmt.getSortingOrder());
        int numPartitionKeys = partitionKeyExprs.size();
        sortInfo.setNumLexicalKeysInZOrder(numPartitionKeys);
        sortInfo.createSortTupleInfo(dmlStmt.getResultExprs(), analyzer);
        sortInfo.getSortTupleDescriptor().materializeSlots();
        dmlStmt.substituteResultExprs(sortInfo.getOutputSmap(), analyzer);
        SortNode node = SortNode.createTotalSortNode(this.ctx_.getNextNodeId(), inputFragment.getPlanRoot(), sortInfo, 0L);
        ((PlanNode)node).init(analyzer);
        inputFragment.setPlanRoot(node);
    }
}

