/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprId;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.common.TreeNode;
import org.apache.impala.planner.EmptySetNode;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.PipelineMembership;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.planner.SelectNode;
import org.apache.impala.planner.SortNode;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.thrift.TExecNodePhase;
import org.apache.impala.thrift.TExecStats;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPipelineMembership;
import org.apache.impala.thrift.TPlan;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.BitUtil;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlanNode
extends TreeNode<PlanNode> {
    private static final Logger LOG = LoggerFactory.getLogger(PlanNode.class);
    protected static final int DEFAULT_ROWBATCH_SIZE = 1024;
    protected static final int ROWBATCH_MAX_MEM_USAGE = 0x800000;
    protected String displayName_;
    protected PlanNodeId id_;
    protected long limit_;
    protected List<TupleId> tupleIds_;
    protected List<TupleId> tblRefIds_;
    protected Set<TupleId> nullableTupleIds_ = new HashSet<TupleId>();
    protected List<Expr> conjuncts_ = new ArrayList<Expr>();
    protected PlanFragment fragment_;
    protected ExprSubstitutionMap outputSmap_;
    protected Set<ExprId> assignedConjuncts_;
    protected long cardinality_;
    protected long filteredCardinality_ = -1L;
    protected int numNodes_;
    protected int numInstances_;
    protected ResourceProfile nodeResourceProfile_ = ResourceProfile.invalid();
    protected List<PipelineMembership> pipelines_;
    protected float avgRowSize_;
    protected float rowPadSize_;
    protected boolean disableCodegen_;
    protected List<RuntimeFilterGenerator.RuntimeFilter> runtimeFilters_ = new ArrayList<RuntimeFilterGenerator.RuntimeFilter>();
    protected ProcessingCost processingCost_ = ProcessingCost.invalid();
    protected boolean hasHardEstimates_ = false;
    protected TupleCacheInfo tupleCacheInfo_;

    protected PlanNode(PlanNodeId id, List<TupleId> tupleIds, String displayName) {
        this(id, displayName);
        this.tupleIds_.addAll(tupleIds);
        this.tblRefIds_.addAll(tupleIds);
    }

    protected PlanNode(String displayName) {
        this(null, displayName);
    }

    protected PlanNode(PlanNodeId id, String displayName) {
        this.id_ = id;
        this.limit_ = -1L;
        this.tupleIds_ = new ArrayList<TupleId>();
        this.tblRefIds_ = new ArrayList<TupleId>();
        this.cardinality_ = -1L;
        this.numNodes_ = -1;
        this.numInstances_ = -1;
        this.displayName_ = displayName;
        this.disableCodegen_ = false;
    }

    protected PlanNode(PlanNodeId id, PlanNode node, String displayName) {
        this.id_ = id;
        this.limit_ = node.limit_;
        this.tupleIds_ = Lists.newArrayList(node.tupleIds_);
        this.tblRefIds_ = Lists.newArrayList(node.tblRefIds_);
        this.nullableTupleIds_ = Sets.newHashSet(node.nullableTupleIds_);
        this.conjuncts_ = Expr.cloneList(node.conjuncts_);
        this.cardinality_ = -1L;
        this.numNodes_ = -1;
        this.numInstances_ = -1;
        this.displayName_ = displayName;
        this.disableCodegen_ = node.disableCodegen_;
    }

    public void computeTupleIds() {
        Preconditions.checkState((this.children_.isEmpty() || !this.tupleIds_.isEmpty() ? 1 : 0) != 0);
    }

    protected void clearTupleIds() {
        this.tblRefIds_.clear();
        this.tupleIds_.clear();
        this.nullableTupleIds_.clear();
    }

    public PlanNodeId getId() {
        return this.id_;
    }

    public List<PipelineMembership> getPipelines() {
        return this.pipelines_;
    }

    public void setId(PlanNodeId id) {
        Preconditions.checkState((this.id_ == null ? 1 : 0) != 0);
        this.id_ = id;
    }

    public long getLimit() {
        return this.limit_;
    }

    public boolean hasLimit() {
        return this.limit_ > -1L;
    }

    public long getCardinality() {
        return this.cardinality_;
    }

    public int getNumNodes() {
        return this.numNodes_;
    }

    public int getNumInstances() {
        return this.numInstances_;
    }

    public ResourceProfile getNodeResourceProfile() {
        return this.nodeResourceProfile_;
    }

    public float getAvgRowSize() {
        return this.avgRowSize_;
    }

    public float getRowPadSize() {
        return this.rowPadSize_;
    }

    public float getAvgRowSizeWithoutPad() {
        return Math.max(0.0f, this.avgRowSize_ - this.rowPadSize_);
    }

    public void setFragment(PlanFragment fragment) {
        this.fragment_ = fragment;
    }

    public PlanFragment getFragment() {
        return this.fragment_;
    }

    public List<Expr> getConjuncts() {
        return this.conjuncts_;
    }

    public ExprSubstitutionMap getOutputSmap() {
        return this.outputSmap_;
    }

    public void setOutputSmap(ExprSubstitutionMap smap) {
        this.outputSmap_ = smap;
    }

    public Set<ExprId> getAssignedConjuncts() {
        return this.assignedConjuncts_;
    }

    public void setAssignedConjuncts(Set<ExprId> conjuncts) {
        this.assignedConjuncts_ = conjuncts;
    }

    public ProcessingCost getProcessingCost() {
        return this.processingCost_;
    }

    public void setLimit(long limit) {
        if (this.limit_ == -1L || limit != -1L && this.limit_ > limit) {
            this.limit_ = limit;
        }
    }

    public void unsetLimit() {
        this.limit_ = -1L;
    }

    public List<TupleId> getTupleIds() {
        Preconditions.checkState((this.tupleIds_ != null ? 1 : 0) != 0);
        return this.tupleIds_;
    }

    public List<TupleId> getTblRefIds() {
        return this.tblRefIds_;
    }

    public void setTblRefIds(List<TupleId> ids) {
        this.tblRefIds_ = ids;
    }

    public Set<TupleId> getNullableTupleIds() {
        Preconditions.checkState((this.nullableTupleIds_ != null ? 1 : 0) != 0);
        return this.nullableTupleIds_;
    }

    public void addConjuncts(List<Expr> conjuncts) {
        if (conjuncts == null) {
            return;
        }
        this.conjuncts_.addAll(conjuncts);
    }

    public void transferConjuncts(PlanNode recipient) {
        recipient.conjuncts_.addAll(this.conjuncts_);
        this.conjuncts_.clear();
    }

    public String getExplainString(TQueryOptions queryOptions) {
        return this.getExplainString("", "", queryOptions, TExplainLevel.VERBOSE);
    }

    protected void setDisplayName(String s) {
        this.displayName_ = s;
    }

    protected final String getDisplayLabel() {
        return String.format("%s:%s", this.id_.toString(), this.displayName_);
    }

    protected String getDisplayLabelDetail() {
        return "";
    }

    protected final String getExplainString(String rootPrefix, String prefix, TQueryOptions queryOptions, TExplainLevel detailLevel) {
        String filler;
        boolean traverseChildren;
        StringBuilder expBuilder = new StringBuilder();
        String detailPrefix = prefix;
        boolean printFiller = detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal();
        boolean bl = traverseChildren = !this.children_.isEmpty() && (!(this instanceof ExchangeNode) || detailLevel != TExplainLevel.VERBOSE);
        if (traverseChildren) {
            detailPrefix = detailPrefix + "|  ";
            filler = prefix + "|";
        } else {
            detailPrefix = detailPrefix + "   ";
            filler = prefix;
        }
        expBuilder.append(this.getNodeExplainString(rootPrefix, detailPrefix, detailLevel));
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal() && !(this instanceof SortNode)) {
            if (this.limit_ != -1L) {
                expBuilder.append(detailPrefix + "limit: " + this.limit_ + "\n");
            }
            expBuilder.append(this.getOffsetExplainString(detailPrefix));
        }
        boolean displayCardinality = this.displayCardinality(detailLevel);
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            expBuilder.append(detailPrefix);
            expBuilder.append(this.nodeResourceProfile_.getExplainString());
            expBuilder.append("\n");
            if (queryOptions.isCompute_processing_cost() && this.processingCost_.isValid() && detailLevel.ordinal() >= TExplainLevel.VERBOSE.ordinal()) {
                expBuilder.append(this.processingCost_.getExplainString(detailPrefix, false));
                expBuilder.append("\n");
            }
            expBuilder.append(detailPrefix + "tuple-ids=");
            for (int i = 0; i < this.tupleIds_.size(); ++i) {
                TupleId tupleId = this.tupleIds_.get(i);
                String nullIndicator = this.nullableTupleIds_.contains(tupleId) ? "N" : "";
                expBuilder.append(tupleId.asInt() + nullIndicator);
                if (i + 1 == this.tupleIds_.size()) continue;
                expBuilder.append(",");
            }
            expBuilder.append(displayCardinality ? " " : "\n");
        }
        if (displayCardinality) {
            if (detailLevel == TExplainLevel.STANDARD) {
                expBuilder.append(detailPrefix);
            }
            expBuilder.append("row-size=").append(PrintUtils.printBytes(Math.round(this.avgRowSize_))).append(" cardinality=");
            if (this.filteredCardinality_ > -1L) {
                expBuilder.append(PrintUtils.printEstCardinality(this.filteredCardinality_)).append("(filtered from ").append(PrintUtils.printEstCardinality(this.cardinality_)).append(")");
            } else {
                expBuilder.append(PrintUtils.printEstCardinality(this.cardinality_));
            }
            if (queryOptions.isCompute_processing_cost()) {
                expBuilder.append(" cost=");
                if (this.processingCost_.isValid()) {
                    expBuilder.append(this.processingCost_.getTotalCost());
                } else {
                    expBuilder.append("<invalid>");
                }
            }
            expBuilder.append("\n");
        }
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            expBuilder.append(detailPrefix);
            expBuilder.append("in pipelines: ");
            if (this.pipelines_ != null) {
                ArrayList<String> pipelines = new ArrayList<String>();
                for (PipelineMembership pipe : this.pipelines_) {
                    pipelines.add(pipe.getExplainString());
                }
                if (pipelines.isEmpty()) {
                    expBuilder.append("<none>");
                } else {
                    expBuilder.append(Joiner.on((String)", ").join(pipelines));
                }
                expBuilder.append("\n");
            } else {
                expBuilder.append("<not computed>");
            }
        }
        if (traverseChildren) {
            if (printFiller) {
                expBuilder.append(filler + "\n");
            }
            String childHeadlinePrefix = prefix + "|--";
            String childDetailPrefix = prefix + "|  ";
            for (int i = this.children_.size() - 1; i >= 1; --i) {
                PlanNode child = (PlanNode)this.getChild(i);
                if (this.fragment_ != child.fragment_) {
                    if (detailLevel == TExplainLevel.VERBOSE) continue;
                    expBuilder.append(child.fragment_.getExplainString(childHeadlinePrefix, childDetailPrefix, queryOptions, detailLevel));
                } else {
                    expBuilder.append(child.getExplainString(childHeadlinePrefix, childDetailPrefix, queryOptions, detailLevel));
                }
                if (!printFiller) continue;
                expBuilder.append(filler + "\n");
            }
            PlanFragment childFragment = ((PlanNode)this.children_.get((int)0)).fragment_;
            if (this.fragment_ != childFragment && detailLevel == TExplainLevel.EXTENDED) {
                expBuilder.append(childFragment.getFragmentHeaderString(prefix, prefix, queryOptions, detailLevel));
            }
            expBuilder.append(((PlanNode)this.children_.get(0)).getExplainString(prefix, prefix, queryOptions, detailLevel));
        }
        return expBuilder.toString();
    }

    protected boolean displayCardinality(TExplainLevel detailLevel) {
        return detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal();
    }

    protected String getNodeExplainString(String rootPrefix, String detailPrefix, TExplainLevel detailLevel) {
        return "";
    }

    protected String getOffsetExplainString(String prefix) {
        return "";
    }

    public TPlan treeToThrift() {
        TPlan result = new TPlan();
        this.treeToThriftHelper(result);
        return result;
    }

    private void initThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        msg.limit = this.limit_;
        if (!serialCtx.isTupleCache()) {
            msg.node_id = this.id_.asInt();
            TExecStats estimatedStats = new TExecStats();
            estimatedStats.setCardinality(this.filteredCardinality_ > -1L ? this.filteredCardinality_ : this.cardinality_);
            estimatedStats.setMemory_used(this.nodeResourceProfile_.getMemEstimateBytes());
            msg.setLabel(this.getDisplayLabel());
            msg.setLabel_detail(this.getDisplayLabelDetail());
            msg.setEstimated_stats(estimatedStats);
        } else {
            msg.node_id = 0;
        }
        Preconditions.checkState((this.tupleIds_.size() > 0 ? 1 : 0) != 0);
        msg.setRow_tuples(Lists.newArrayListWithCapacity((int)this.tupleIds_.size()));
        msg.setNullable_tuples(Lists.newArrayListWithCapacity((int)this.tupleIds_.size()));
        for (TupleId tid : this.tupleIds_) {
            serialCtx.registerTuple(tid);
            msg.addToRow_tuples(serialCtx.translateTupleId(tid).asInt());
            msg.addToNullable_tuples(this.nullableTupleIds_.contains(tid));
        }
        for (Expr e : this.conjuncts_) {
            msg.addToConjuncts(e.treeToThrift(serialCtx));
        }
        for (RuntimeFilterGenerator.RuntimeFilter filter : this.runtimeFilters_) {
            msg.addToRuntime_filters(filter.toThrift());
        }
        msg.setDisable_codegen(this.disableCodegen_);
        msg.pipelines = new ArrayList<TPipelineMembership>();
        if (serialCtx.isTupleCache()) {
            msg.resource_profile = ResourceProfile.noReservation(0L).toThrift();
        } else {
            Preconditions.checkState((boolean)this.nodeResourceProfile_.isValid());
            msg.resource_profile = this.nodeResourceProfile_.toThrift();
            for (PipelineMembership pipe : this.pipelines_) {
                msg.pipelines.add(pipe.toThrift());
            }
        }
    }

    private void treeToThriftHelper(TPlan container) {
        TPlanNode msg = new TPlanNode();
        ThriftSerializationCtx serialCtx = new ThriftSerializationCtx();
        this.initThrift(msg, serialCtx);
        this.toThrift(msg, serialCtx);
        container.addToNodes(msg);
        int numChildren = 0;
        for (PlanNode child : this.children_) {
            if (child.getFragment() != this.getFragment()) continue;
            child.treeToThriftHelper(container);
            ++numChildren;
        }
        msg.num_children = numChildren;
    }

    public static void removeZippingUnnestConjuncts(List<Expr> conjuncts, Analyzer analyzer) {
        Set<TupleId> zippingUnnestTupleIds = analyzer.getZippingUnnestTupleIds();
        Iterator<Expr> it = conjuncts.iterator();
        block0: while (it.hasNext()) {
            Expr e = it.next();
            ArrayList slotRefs = new ArrayList();
            e.collect(SlotRef.class, slotRefs);
            for (SlotRef slotRef : slotRefs) {
                if (!zippingUnnestTupleIds.contains(slotRef.getDesc().getParent().getId())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public void init(Analyzer analyzer) throws ImpalaException {
        this.assignConjuncts(analyzer);
        this.computeStats(analyzer);
        this.createDefaultSmap(analyzer);
    }

    protected void assignConjuncts(Analyzer analyzer) {
        List<Expr> unassigned = analyzer.getUnassignedConjuncts(this);
        if (!this.shouldPickUpZippingUnnestConjuncts()) {
            PlanNode.removeZippingUnnestConjuncts(unassigned, analyzer);
        }
        this.conjuncts_.addAll(unassigned);
        analyzer.markConjunctsAssigned(unassigned);
    }

    protected boolean shouldPickUpZippingUnnestConjuncts() {
        return false;
    }

    public PlanNode addConjunctsToNode(PlannerContext plannerCtx, Analyzer analyzer, List<TupleId> tupleIds, List<Expr> conjuncts) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("conjuncts for (Node %s): %s", this.getDisplayLabel(), Expr.debugString(conjuncts)));
            LOG.trace("all conjuncts: " + analyzer.conjunctAssignmentsDebugString());
        }
        if (this instanceof EmptySetNode) {
            return this;
        }
        for (TupleId tid : tupleIds) {
            analyzer.createEquivConjuncts(tid, conjuncts);
        }
        if (conjuncts.isEmpty()) {
            return this;
        }
        ArrayList<Expr> finalConjuncts = new ArrayList<Expr>();
        for (Expr e : conjuncts) {
            if (e instanceof BinaryPredicate && ((BinaryPredicate)e).isInferred()) {
                Expr lhsSrcExpr = ((Expr)((BinaryPredicate)e).getChild(0)).findSrcExpr();
                Expr rhsSrcExpr = ((Expr)((BinaryPredicate)e).getChild(1)).findSrcExpr();
                if (lhsSrcExpr != null && rhsSrcExpr != null) {
                    if (lhsSrcExpr.isConstant() && rhsSrcExpr.isConstant() && lhsSrcExpr.equals(rhsSrcExpr)) continue;
                    if (lhsSrcExpr instanceof SlotRef && rhsSrcExpr instanceof SlotRef) {
                        SlotRef lhsSlotRef = (SlotRef)lhsSrcExpr;
                        SlotRef rhsSlotRef = (SlotRef)rhsSrcExpr;
                        if (lhsSlotRef.getDesc().equals(rhsSlotRef.getDesc())) continue;
                    }
                }
            }
            finalConjuncts.add(e);
        }
        if (finalConjuncts.isEmpty()) {
            return this;
        }
        return SelectNode.create(plannerCtx, analyzer, this, finalConjuncts);
    }

    protected ExprSubstitutionMap getCombinedChildSmap() {
        if (this.getChildren().size() == 0) {
            return new ExprSubstitutionMap();
        }
        if (this.getChildren().size() == 1) {
            return ((PlanNode)this.getChild(0)).getOutputSmap();
        }
        ExprSubstitutionMap result = ExprSubstitutionMap.combine(((PlanNode)this.getChild(0)).getOutputSmap(), ((PlanNode)this.getChild(1)).getOutputSmap());
        for (int i = 2; i < this.getChildren().size(); ++i) {
            result = ExprSubstitutionMap.combine(result, ((PlanNode)this.getChild(i)).getOutputSmap());
        }
        return result;
    }

    protected void createDefaultSmap(Analyzer analyzer) {
        ExprSubstitutionMap combinedChildSmap = this.getCombinedChildSmap();
        this.outputSmap_ = ExprSubstitutionMap.compose(this.outputSmap_, combinedChildSmap, analyzer);
        this.conjuncts_ = Expr.substituteList(this.conjuncts_, this.outputSmap_, analyzer, false);
    }

    public void computeStats(Analyzer analyzer) {
        this.avgRowSize_ = 0.0f;
        this.rowPadSize_ = 0.0f;
        for (TupleId tid : this.tupleIds_) {
            TupleDescriptor desc = analyzer.getTupleDesc(tid);
            this.avgRowSize_ += desc.getAvgSerializedSize();
            this.rowPadSize_ += desc.getSerializedPadSize();
        }
        if (!this.children_.isEmpty()) {
            this.numNodes_ = ((PlanNode)this.getChild((int)0)).numNodes_;
            this.numInstances_ = ((PlanNode)this.getChild((int)0)).numInstances_;
        }
    }

    protected long capCardinalityAtLimit(long cardinality) {
        if (this.hasLimit()) {
            return PlanNode.capCardinalityAtLimit(cardinality, this.limit_);
        }
        return cardinality;
    }

    protected ProcessingCost computeDefaultProcessingCost() {
        Preconditions.checkState((boolean)this.hasValidStats());
        return ProcessingCost.basicCost(this.getDisplayLabel(), this.getInputCardinality(), ExprUtil.computeExprsTotalCost(this.getConjuncts()));
    }

    public static long capCardinalityAtLimit(long cardinality, long limit) {
        return cardinality == -1L ? limit : Math.min(cardinality, limit);
    }

    protected void computeMemLayout(Analyzer analyzer) {
        for (TupleId id : this.tupleIds_) {
            analyzer.getDescTbl().getTupleDesc(id).computeMemLayout();
        }
    }

    protected static double computeCombinedSelectivity(List<Expr> conjuncts) {
        ArrayList<Double> selectivities = new ArrayList<Double>();
        HashMap<SlotId, Double> perSlotBetweenSelectivities = new HashMap<SlotId, Double>();
        int conjunctSize = 0;
        for (Expr e : conjuncts) {
            BinaryPredicate pred;
            if (e instanceof BinaryPredicate && ((BinaryPredicate)e).derivedFromBetween()) {
                pred = (BinaryPredicate)e;
                PlanNode.insertBetweenSelectivity(pred, perSlotBetweenSelectivities);
                continue;
            }
            if (e instanceof CompoundPredicate && ((CompoundPredicate)e).derivedFromBetween() && ((CompoundPredicate)e).getChild(0) instanceof BinaryPredicate) {
                pred = (BinaryPredicate)((CompoundPredicate)e).getChild(0);
                PlanNode.insertBetweenSelectivity(pred, perSlotBetweenSelectivities);
                continue;
            }
            if (e.hasSelectivity()) {
                selectivities.add(e.getSelectivity());
            }
            ++conjunctSize;
        }
        if (!perSlotBetweenSelectivities.isEmpty()) {
            selectivities.addAll(perSlotBetweenSelectivities.values());
            conjunctSize += perSlotBetweenSelectivities.size();
        }
        if (selectivities.size() != conjunctSize) {
            selectivities.add(0.1);
        }
        Collections.sort(selectivities);
        double result = 1.0;
        for (int i = 0; i < selectivities.size(); ++i) {
            result *= Math.pow((Double)selectivities.get(i), 1.0 / (double)(i + 1));
        }
        return Math.max(0.0, Math.min(1.0, result));
    }

    private static void insertBetweenSelectivity(BinaryPredicate pred, Map<SlotId, Double> perSlotBetweenSelectivities) {
        Preconditions.checkNotNull((Object)pred.getBoundSlot());
        Preconditions.checkState((pred.getBetweenSelectivity() >= 0.0 ? 1 : 0) != 0);
        SlotId targetSlotId = pred.getBoundSlot().getSlotId();
        double sel = pred.getBetweenSelectivity();
        perSlotBetweenSelectivities.merge(targetSlotId, sel, (v1, v2) -> Math.min(v1, v2));
    }

    protected double computeSelectivity() {
        return PlanNode.computeCombinedSelectivity(this.conjuncts_);
    }

    protected long applyConjunctsSelectivity(long preConjunctCardinality) {
        return this.applySelectivity(preConjunctCardinality, this.computeSelectivity());
    }

    protected long applySelectivity(long preConjunctCardinality, double selectivity) {
        long cardinality = Math.round((double)preConjunctCardinality * selectivity);
        if (cardinality == 0L && preConjunctCardinality > 0L) {
            return 1L;
        }
        return cardinality;
    }

    protected void toThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        Preconditions.checkState((!this.isTupleCachingImplemented() ? 1 : 0) != 0);
        this.toThrift(msg);
    }

    protected abstract void toThrift(TPlanNode var1);

    protected String debugString() {
        StringBuilder output = new StringBuilder();
        output.append("preds=" + Expr.debugString(this.conjuncts_));
        output.append(" limit=" + Long.toString(this.limit_));
        return output.toString();
    }

    protected String getExplainString(List<? extends Expr> exprs, TExplainLevel detailLevel) {
        if (exprs == null) {
            return "";
        }
        ToSqlOptions toSqlOptions = detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal() ? ToSqlOptions.SHOW_IMPLICIT_CASTS : ToSqlOptions.DEFAULT;
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < exprs.size(); ++i) {
            if (i > 0) {
                output.append(", ");
            }
            output.append(exprs.get(i).toSql(toSqlOptions));
        }
        return output.toString();
    }

    protected String getSortingOrderExplainString(List<? extends Expr> exprs, List<Boolean> isAscOrder, List<Boolean> nullsFirstParams, TSortingOrder sortingOrder, int numLexicalKeysInZOrder) {
        StringBuilder output = new StringBuilder();
        switch (sortingOrder) {
            case LEXICAL: {
                for (int i = 0; i < exprs.size(); ++i) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    output.append(exprs.get(i).toSql() + " ");
                    output.append(isAscOrder.get(i) != false ? "ASC" : "DESC");
                    Boolean nullsFirstParam = nullsFirstParams.get(i);
                    if (nullsFirstParam == null) continue;
                    output.append(nullsFirstParam != false ? " NULLS FIRST" : " NULLS LAST");
                }
                break;
            }
            case ZORDER: {
                int i;
                if (numLexicalKeysInZOrder > 0) {
                    Preconditions.checkElementIndex((int)numLexicalKeysInZOrder, (int)exprs.size());
                    output.append("LEXICAL: ");
                    for (i = 0; i < numLexicalKeysInZOrder; ++i) {
                        if (i > 0) {
                            output.append(", ");
                        }
                        output.append(exprs.get(i).toSql()).append(" ASC NULLS LAST");
                    }
                    output.append(", ");
                }
                output.append("ZORDER: ");
                for (i = numLexicalKeysInZOrder; i < exprs.size(); ++i) {
                    if (i > numLexicalKeysInZOrder) {
                        output.append(", ");
                    }
                    output.append(exprs.get(i).toSql());
                }
                break;
            }
        }
        output.append("\n");
        return output.toString();
    }

    public boolean hasValidStats() {
        return !(this.numNodes_ != -1 && this.numNodes_ < 0 || this.numInstances_ != -1 && this.numInstances_ < 0 || this.cardinality_ != -1L && this.cardinality_ < 0L);
    }

    public static long checkedAdd(long a, long b) {
        try {
            return LongMath.checkedAdd((long)a, (long)b);
        }
        catch (ArithmeticException e) {
            LOG.warn("overflow when adding longs: " + a + ", " + b);
            return Long.MAX_VALUE;
        }
    }

    public static long checkedMultiply(long a, long b) {
        try {
            return LongMath.checkedMultiply((long)a, (long)b);
        }
        catch (ArithmeticException e) {
            LOG.warn("overflow when multiplying longs: " + a + ", " + b);
            return Long.MAX_VALUE;
        }
    }

    public boolean isBlockingNode() {
        return false;
    }

    public void computePipelineMembership() {
        Preconditions.checkState((this.children_.size() <= 1 ? 1 : 0) != 0, (Object)"Plan nodes with > 1 child must override");
        if (this.children_.size() == 0) {
            this.pipelines_ = Arrays.asList(new PipelineMembership(this.id_, 0, TExecNodePhase.GETNEXT));
            return;
        }
        ((PlanNode)this.children_.get(0)).computePipelineMembership();
        if (this.isBlockingNode()) {
            this.pipelines_ = Lists.newArrayList((Object[])new PipelineMembership[]{new PipelineMembership(this.id_, 0, TExecNodePhase.GETNEXT)});
            for (PipelineMembership childPipeline : ((PlanNode)this.children_.get(0)).getPipelines()) {
                if (childPipeline.getPhase() != TExecNodePhase.GETNEXT) continue;
                this.pipelines_.add(new PipelineMembership(childPipeline.getId(), childPipeline.getHeight() + 1, TExecNodePhase.OPEN));
            }
        } else {
            this.pipelines_ = new ArrayList<PipelineMembership>();
            for (PipelineMembership childPipeline : ((PlanNode)this.children_.get(0)).getPipelines()) {
                if (childPipeline.getPhase() != TExecNodePhase.GETNEXT) continue;
                this.pipelines_.add(new PipelineMembership(childPipeline.getId(), childPipeline.getHeight() + 1, TExecNodePhase.GETNEXT));
            }
        }
    }

    protected void setPipelinesRecursive(List<PipelineMembership> pipelines) {
        this.pipelines_ = pipelines;
        for (PlanNode child : this.children_) {
            child.setPipelinesRecursive(pipelines);
        }
    }

    public abstract void computeProcessingCost(TQueryOptions var1);

    public abstract void computeNodeResourceProfile(TQueryOptions var1);

    public void computeRowConsumptionAndProductionToCost() {
        Preconditions.checkState((boolean)this.processingCost_.isValid(), (String)"Processing cost of PlanNode %s is invalid! %s", (Object)this.getDisplayLabel(), (Object)this.processingCost_);
        this.processingCost_.setNumRowToConsume(this.getInputCardinality());
        this.processingCost_.setNumRowToProduce(this.getCardinality());
    }

    protected static long getRowBatchSize(TQueryOptions queryOptions) {
        return queryOptions.isSetBatch_size() && queryOptions.batch_size > 0 ? (long)queryOptions.batch_size : 1024L;
    }

    public ExecPhaseResourceProfiles computeTreeResourceProfiles(TQueryOptions queryOptions) {
        Preconditions.checkState((this.children_.size() <= 1 ? 1 : 0) != 0, (Object)"Plan nodes with > 1 child must override");
        if (this.children_.isEmpty()) {
            return new ExecPhaseResourceProfiles(this.nodeResourceProfile_, this.nodeResourceProfile_);
        }
        ExecPhaseResourceProfiles childResources = ((PlanNode)this.getChild(0)).computeTreeResourceProfiles(queryOptions);
        if (this.isBlockingNode()) {
            ResourceProfile duringOpenProfile = childResources.duringOpenProfile.max(childResources.postOpenProfile.sum(this.nodeResourceProfile_));
            return new ExecPhaseResourceProfiles(duringOpenProfile, this.nodeResourceProfile_);
        }
        return new ExecPhaseResourceProfiles(childResources.duringOpenProfile.sum(this.nodeResourceProfile_), childResources.postOpenProfile.sum(this.nodeResourceProfile_));
    }

    protected static long computeMaxSpillableBufferSize(long defaultBufferSize, long maxRowSize) {
        return Math.max(defaultBufferSize, BitUtil.roundUpToPowerOf2(maxRowSize));
    }

    public long getInputCardinality() {
        long sum = 0L;
        for (PlanNode p : this.children_) {
            long tmp = p.getCardinality();
            if (tmp == -1L) {
                return -1L;
            }
            sum = PlanNode.checkedAdd(sum, tmp);
        }
        return sum;
    }

    protected int getMaxInstancesPerNode(Analyzer analyzer) {
        return Math.max(1, analyzer.getMaxParallelismPerNode());
    }

    protected void addRuntimeFilter(RuntimeFilterGenerator.RuntimeFilter filter) {
        this.runtimeFilters_.add(filter);
    }

    protected Collection<RuntimeFilterGenerator.RuntimeFilter> getRuntimeFilters() {
        return this.runtimeFilters_;
    }

    protected String getRuntimeFilterExplainString(boolean isBuildNode, TExplainLevel detailLevel) {
        return PlanNode.getRuntimeFilterExplainString(this.runtimeFilters_, isBuildNode, this.id_, detailLevel);
    }

    public static String getRuntimeFilterExplainString(List<RuntimeFilterGenerator.RuntimeFilter> filters, boolean isBuildNode, PlanNodeId nodeId, TExplainLevel detailLevel) {
        if (filters.isEmpty()) {
            return "";
        }
        ArrayList<String> filtersStr = new ArrayList<String>();
        for (RuntimeFilterGenerator.RuntimeFilter filter : filters) {
            StringBuilder filterStr = new StringBuilder();
            filterStr.append(filter.getFilterId());
            if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
                filterStr.append("[");
                filterStr.append(filter.getType().toString().toLowerCase());
                filterStr.append("]");
            }
            if (isBuildNode) {
                filterStr.append(" <- ");
                filterStr.append(filter.getSrcExpr().toSql());
            } else {
                filterStr.append(" -> ");
                filterStr.append(filter.getTargetExpr(nodeId).toSql());
            }
            filtersStr.add(filterStr.toString());
        }
        return Joiner.on((String)", ").join(filtersStr) + "\n";
    }

    public static <T extends Expr> List<T> orderConjunctsByCost(List<T> conjuncts) {
        if (conjuncts.size() <= 1) {
            return conjuncts;
        }
        float totalCost = 0.0f;
        int numWithoutSel = 0;
        ArrayList remaining = Lists.newArrayListWithCapacity((int)conjuncts.size());
        for (Expr e : conjuncts) {
            if (!e.hasCost()) {
                Preconditions.checkState((boolean)false, (Object)e.toSql());
            }
            totalCost += e.getCost();
            remaining.add(e);
            if (e.hasSelectivity()) continue;
            ++numWithoutSel;
        }
        double defaultSel = 0.1;
        if (numWithoutSel != 0) {
            defaultSel = Math.pow(Math.E, Math.log(0.1) / (double)numWithoutSel);
        }
        ArrayList sortedConjuncts = Lists.newArrayListWithCapacity((int)conjuncts.size());
        while (!remaining.isEmpty()) {
            double smallestCost = 3.4028234663852886E38;
            Expr bestConjunct = null;
            int bestConjunctIdx = 0;
            double backoffExp = 1.0 / (double)(sortedConjuncts.size() + 1);
            for (int i = 0; i < remaining.size(); ++i) {
                Expr e = (Expr)remaining.get(i);
                double sel = Math.pow(e.hasSelectivity() ? e.getSelectivity() : defaultSel, backoffExp);
                double cost = (double)e.getCost() + (double)(totalCost - e.getCost()) * sel;
                if (cost < smallestCost) {
                    smallestCost = cost;
                    bestConjunct = e;
                    bestConjunctIdx = i;
                    continue;
                }
                if (cost != smallestCost || e.toSql().compareTo(bestConjunct.toSql()) >= 0) continue;
                bestConjunct = e;
                bestConjunctIdx = i;
            }
            sortedConjuncts.add(bestConjunct);
            remaining.remove(bestConjunctIdx);
            totalCost -= bestConjunct.getCost();
        }
        return sortedConjuncts;
    }

    public void setDisableCodegen(boolean disableCodegen) {
        this.disableCodegen_ = disableCodegen;
    }

    public boolean allowPartitioned() {
        return !this.hasLimit();
    }

    public int getNumMaterializedSlots(TupleDescriptor desc) {
        int numCols = 0;
        for (SlotDescriptor slot : desc.getSlots()) {
            if (!slot.isMaterialized()) continue;
            ++numCols;
        }
        return numCols;
    }

    protected void setFilteredCardinality(long newCardinality) {
        Preconditions.checkState((newCardinality > -1L ? 1 : 0) != 0);
        Preconditions.checkState((newCardinality < this.cardinality_ ? 1 : 0) != 0);
        this.filteredCardinality_ = newCardinality;
    }

    protected long getFilteredCardinality() {
        return this.filteredCardinality_ > -1L ? this.filteredCardinality_ : this.getCardinality();
    }

    protected void reduceCardinalityByRuntimeFilter(Stack<PlanNode> nodeStack, double reductionScale) {
        nodeStack.clear();
        for (PlanNode child : this.getChildren()) {
            child.reduceCardinalityByRuntimeFilter(nodeStack, reductionScale);
        }
    }

    public TupleCacheInfo getTupleCacheInfo() {
        return this.tupleCacheInfo_;
    }

    public void computeTupleCacheInfo(DescriptorTable descTbl) {
        this.tupleCacheInfo_ = new TupleCacheInfo(descTbl);
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((PlanNode)this.getChild(i)).computeTupleCacheInfo(descTbl);
            this.tupleCacheInfo_.mergeChild(((PlanNode)this.getChild(i)).getTupleCacheInfo());
        }
        if (!this.isTupleCachingImplemented()) {
            this.tupleCacheInfo_.setIneligible(TupleCacheInfo.IneligibilityReason.NOT_IMPLEMENTED);
        }
        if (!this.tupleCacheInfo_.isEligible()) {
            this.tupleCacheInfo_.finalizeHash();
            return;
        }
        TPlanNode msg = new TPlanNode();
        ThriftSerializationCtx serialCtx = new ThriftSerializationCtx(this.tupleCacheInfo_);
        this.initThrift(msg, serialCtx);
        this.toThrift(msg, serialCtx);
        this.tupleCacheInfo_.hashThrift(msg);
        this.tupleCacheInfo_.finalizeHash();
    }

    public boolean isTupleCachingImplemented() {
        return false;
    }

    public static class ExecPhaseResourceProfiles {
        public final ResourceProfile duringOpenProfile;
        public final ResourceProfile postOpenProfile;

        public ExecPhaseResourceProfiles(ResourceProfile duringOpenProfile, ResourceProfile postOpenProfile) {
            this.duringOpenProfile = duringOpenProfile;
            this.postOpenProfile = postOpenProfile;
        }
    }
}

