/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.common.TreeNode;
import org.apache.impala.planner.CohortId;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.JoinBuildSink;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.JoinTableId;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanId;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.SubplanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPlanner.class);
    private final IdGenerator<JoinTableId> joinTableIdGenerator_ = JoinTableId.createGenerator();
    private final IdGenerator<PlanId> planIdGenerator_ = PlanId.createGenerator();
    private final IdGenerator<CohortId> cohortIdGenerator_ = CohortId.createGenerator();
    private final PlannerContext ctx_;
    private List<PlanFragment> planRoots_ = new ArrayList<PlanFragment>();

    public ParallelPlanner(PlannerContext ctx) {
        this.ctx_ = ctx;
    }

    public List<PlanFragment> createPlans(PlanFragment root) {
        root.setPlanId(this.planIdGenerator_.getNextId());
        root.setCohortId(this.cohortIdGenerator_.getNextId());
        this.planRoots_.add(root);
        this.createBuildPlans(root, null);
        return this.planRoots_;
    }

    private void createBuildPlans(PlanFragment fragment, CohortId buildCohortId) {
        ArrayList<JoinNode> joins = new ArrayList<JoinNode>();
        this.collectJoins(fragment.getPlanRoot(), joins);
        if (!joins.isEmpty()) {
            if (buildCohortId == null) {
                buildCohortId = this.cohortIdGenerator_.getNextId();
            }
            for (JoinNode join : joins) {
                this.createBuildPlan(join, buildCohortId);
            }
        }
        for (PlanFragment child : fragment.getChildren()) {
            if (child.getSink() instanceof JoinBuildSink) continue;
            child.setPlanId(fragment.getPlanId());
            child.setCohortId(fragment.getCohortId());
            this.createBuildPlans(child, buildCohortId);
        }
    }

    private void collectJoins(PlanNode node, List<JoinNode> result) {
        if (node instanceof JoinNode) {
            result.add((JoinNode)node);
            this.collectJoins((PlanNode)node.getChild(0), result);
            return;
        }
        if (node instanceof ExchangeNode) {
            return;
        }
        if (node instanceof SubplanNode) {
            this.collectJoins((PlanNode)node.getChild(0), result);
            return;
        }
        for (PlanNode child : node.getChildren()) {
            this.collectJoins(child, result);
        }
    }

    private void collectExchangeNodes(PlanNode node, List<ExchangeNode> result) {
        if (node instanceof ExchangeNode) {
            result.add((ExchangeNode)node);
            return;
        }
        for (PlanNode child : node.getChildren()) {
            this.collectExchangeNodes(child, result);
        }
    }

    private void createBuildPlan(JoinNode join, CohortId cohortId) {
        Preconditions.checkNotNull((Object)cohortId);
        final ArrayList<ExchangeNode> exchNodes = new ArrayList<ExchangeNode>();
        this.collectExchangeNodes((PlanNode)join.getChild(1), exchNodes);
        Predicate<PlanFragment> isInputFragment = new Predicate<PlanFragment>(){

            public boolean apply(PlanFragment f) {
                if (f.getDestNode() == null) {
                    return false;
                }
                for (ExchangeNode exch : exchNodes) {
                    if (exch.getId() != f.getDestNode().getId()) continue;
                    return true;
                }
                return false;
            }
        };
        ArrayList inputFragments = new ArrayList();
        join.getFragment().collect(isInputFragment, inputFragments);
        Preconditions.checkState((exchNodes.size() == inputFragments.size() ? 1 : 0) != 0);
        JoinBuildSink buildSink = new JoinBuildSink(this.joinTableIdGenerator_.getNextId(), join);
        join.setJoinTableId(buildSink.getJoinTableId());
        join.getRuntimeFilters().clear();
        PlanFragment buildFragment = new PlanFragment(this.ctx_.getNextFragmentId(), (PlanNode)join.getChild(1), join.getFragment().getDataPartition());
        buildFragment.setSink(buildSink);
        for (int i = 0; i < exchNodes.size(); ++i) {
            Preconditions.checkState((((ExchangeNode)exchNodes.get(i)).getFragment() == buildFragment ? 1 : 0) != 0);
            join.getFragment().removeChild((TreeNode)inputFragments.get(i));
            buildFragment.getChildren().add(inputFragments.get(i));
        }
        buildFragment.setDestination(join);
        buildFragment.setPlanId(this.planIdGenerator_.getNextId());
        buildFragment.setCohortId(cohortId);
        this.planRoots_.add(buildFragment);
        if (LOG.isTraceEnabled()) {
            LOG.trace("new build fragment " + buildFragment.getId().toString());
            LOG.trace("in cohort " + buildFragment.getCohortId().toString());
            LOG.trace("for join node " + join.getId().toString());
        }
        this.createBuildPlans(buildFragment, null);
    }
}

