/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TQueryOptions;

public class MultiDataSink
extends DataSink {
    private List<DataSink> dataSinks_ = new ArrayList<DataSink>();

    @Override
    public void setFragment(PlanFragment fragment) {
        this.fragment_ = fragment;
        for (DataSink tsink : this.dataSinks_) {
            tsink.setFragment(fragment);
        }
    }

    public void addDataSink(DataSink tsink) {
        this.dataSinks_.add(tsink);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        for (int i = 0; i < this.dataSinks_.size(); ++i) {
            DataSink dsink = this.dataSinks_.get(i);
            dsink.computeProcessingCost(queryOptions);
            ProcessingCost dsinkCost = dsink.getProcessingCost();
            this.processingCost_ = i == 0 ? dsinkCost : ProcessingCost.sumCost(this.processingCost_, dsinkCost);
        }
    }

    @Override
    public void computeResourceProfile(TQueryOptions queryOptions) {
        for (int i = 0; i < this.dataSinks_.size(); ++i) {
            DataSink dsink = this.dataSinks_.get(i);
            dsink.computeResourceProfile(queryOptions);
            ResourceProfile dsinkProfile = dsink.getResourceProfile();
            if (i == 0) {
                this.resourceProfile_ = dsinkProfile;
                continue;
            }
            this.resourceProfile_.combine(dsinkProfile);
        }
    }

    @Override
    public void appendSinkExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel, StringBuilder output) {
        output.append(String.format("%sMULTI DATA SINK\n", prefix));
        for (DataSink dsink : this.dataSinks_) {
            dsink.appendSinkExplainString(prefix + "|->", detailPrefix + "  ", queryOptions, explainLevel, output);
        }
    }

    @Override
    protected String getLabel() {
        return "MULTI DATA SINK";
    }

    @Override
    protected void toThriftImpl(TDataSink tdsink) {
        for (int i = 0; i < this.dataSinks_.size(); ++i) {
            DataSink dsink = this.dataSinks_.get(i);
            tdsink.addToChild_data_sinks(dsink.toThrift());
        }
    }

    @Override
    protected TDataSinkType getSinkType() {
        return TDataSinkType.MULTI_DATA_SINK;
    }

    @Override
    public void collectExprs(List<Expr> exprs) {
        for (int i = 0; i < this.dataSinks_.size(); ++i) {
            DataSink dsink = this.dataSinks_.get(i);
            dsink.collectExprs(exprs);
        }
    }

    @Override
    public void computeRowConsumptionAndProductionToCost() {
        super.computeRowConsumptionAndProductionToCost();
        this.fragment_.setFixedInstanceCount(this.fragment_.getNumInstances());
    }
}

