/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.TableSink;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TKuduTableSink;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TTableSink;
import org.apache.impala.thrift.TTableSinkType;
import org.apache.impala.util.KuduUtil;
import org.apache.kudu.client.KuduClient;
import org.apache.thrift.TBaseHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduTableSink
extends TableSink {
    private static final Logger LOG = LoggerFactory.getLogger(KuduTableSink.class);
    private final List<Integer> targetColIdxs_;
    private ByteBuffer txnToken_;
    private boolean supportsIgnoreOperations_ = false;

    public KuduTableSink(FeTable targetTable, TableSink.Op sinkOp, List<Integer> referencedColumns, List<Expr> outputExprs, ByteBuffer txnToken) {
        super(targetTable, sinkOp, outputExprs);
        this.targetColIdxs_ = referencedColumns != null ? Lists.newArrayList(referencedColumns) : null;
        this.txnToken_ = txnToken != null ? TBaseHelper.copyBinary((ByteBuffer)txnToken) : null;
        Preconditions.checkState((boolean)(targetTable instanceof FeKuduTable));
        KuduClient client = KuduUtil.getKuduClient(((FeKuduTable)targetTable).getKuduMasterHosts());
        try {
            this.supportsIgnoreOperations_ = client.supportsIgnoreOperations();
        }
        catch (Exception e) {
            LOG.error("Unable to check Kudu ignore operation support", (Throwable)e);
        }
    }

    @Override
    public void appendSinkExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel, StringBuilder output) {
        output.append(prefix + this.sinkOp_.toExplainString());
        output.append(" KUDU [" + this.targetTable_.getFullName() + "]\n");
        if (explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(detailPrefix + "output exprs: ").append(Expr.getExplainString(this.outputExprs_, explainLevel) + "\n");
        }
    }

    @Override
    protected String getLabel() {
        return "KUDU WRITER";
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }

    @Override
    public void computeResourceProfile(TQueryOptions queryOptions) {
        long kuduMutationBufferSize = BackendConfig.INSTANCE.getBackendCfg().kudu_mutation_buffer_size;
        long kuduErrorBufferSize = BackendConfig.INSTANCE.getBackendCfg().kudu_error_buffer_size;
        this.resourceProfile_ = ResourceProfile.noReservation(kuduMutationBufferSize + kuduErrorBufferSize);
    }

    @Override
    protected void toThriftImpl(TDataSink tsink) {
        TTableSink tTableSink = new TTableSink(0, TTableSinkType.KUDU, this.sinkOp_.toThrift());
        TKuduTableSink tKuduSink = new TKuduTableSink();
        tKuduSink.setReferenced_columns(this.targetColIdxs_);
        if (this.txnToken_ != null) {
            tKuduSink.setKudu_txn_token(this.txnToken_);
        }
        tKuduSink.setIgnore_not_found_or_duplicate(this.supportsIgnoreOperations_);
        tTableSink.setKudu_table_sink(tKuduSink);
        tsink.table_sink = tTableSink;
        tsink.output_exprs = Expr.treesToThrift(this.outputExprs_);
    }

    @Override
    protected TDataSinkType getSinkType() {
        return TDataSinkType.TABLE_SINK;
    }

    @Override
    public void collectExprs(List<Expr> exprs) {
        exprs.addAll(this.outputExprs_);
    }
}

