/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.InternalException;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.Planner;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TKuduReplicaSelection;
import org.apache.impala.thrift.TKuduScanNode;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TScanRange;
import org.apache.impala.thrift.TScanRangeLocation;
import org.apache.impala.thrift.TScanRangeLocationList;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.util.ExecutorMembershipSnapshot;
import org.apache.impala.util.ExprUtil;
import org.apache.impala.util.KuduUtil;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.consensus.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduScanNode
extends ScanNode {
    private static final Logger LOG = LoggerFactory.getLogger(KuduScanNode.class);
    private final FeKuduTable kuduTable_;
    private boolean useMtScanNode_;
    private boolean replicaSelectionLeaderOnly_ = false;
    private final Set<Integer> hostIndexSet_ = new HashSet<Integer>();
    private final List<Expr> kuduConjuncts_ = new ArrayList<Expr>();
    private final List<KuduPredicate> kuduPredicates_ = new ArrayList<KuduPredicate>();
    private SlotDescriptor countStarSlot_ = null;
    boolean isPointLookupQuery_ = false;
    boolean currentPredicateNeedCheckAgain_ = false;

    public KuduScanNode(PlanNodeId id, TupleDescriptor desc, List<Expr> conjuncts, MultiAggregateInfo aggInfo, TableRef kuduTblRef) {
        super(id, desc, "SCAN KUDU");
        this.kuduTable_ = (FeKuduTable)this.desc_.getTable();
        this.conjuncts_ = conjuncts;
        this.aggInfo_ = aggInfo;
        this.tableNumRowsHint_ = kuduTblRef.getTableNumRowsHint();
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaRuntimeException {
        this.conjuncts_ = KuduScanNode.orderConjunctsByCost(this.conjuncts_);
        KuduClient client = KuduUtil.getKuduClient(this.kuduTable_.getKuduMasterHosts());
        try {
            KuduTable rpcTable = analyzer.getKuduTable(this.kuduTable_);
            this.validateSchema(rpcTable);
            if (this.canApplyCountStarOptimization(analyzer)) {
                Preconditions.checkState((this.desc_.getPath().destTable() != null ? 1 : 0) != 0);
                Preconditions.checkState((boolean)this.kuduConjuncts_.isEmpty());
                this.countStarSlot_ = this.applyCountStarOptimization(analyzer);
            }
            this.extractKuduConjuncts(analyzer, client, rpcTable);
            analyzer.materializeSlots(this.conjuncts_);
            this.computeMemLayout(analyzer);
            this.computeScanRangeLocations(analyzer, client, rpcTable);
        }
        catch (Exception e) {
            throw new ImpalaRuntimeException("Unable to initialize the Kudu scan node", e);
        }
        this.computeStats(analyzer);
    }

    private void validateSchema(KuduTable rpcTable) throws ImpalaRuntimeException {
        Schema tableSchema = rpcTable.getSchema();
        for (SlotDescriptor desc : this.getTupleDesc().getSlots()) {
            String actual;
            String expected;
            if (!desc.isScanSlot()) continue;
            String colName = ((KuduColumn)desc.getColumn()).getKuduName();
            Type colType = desc.getColumn().getType();
            ColumnSchema kuduCol = null;
            try {
                kuduCol = tableSchema.getColumn(colName);
            }
            catch (Exception e) {
                throw new ImpalaRuntimeException("Column '" + colName + "' not found in kudu table " + rpcTable.getName() + ". The table metadata in Impala may be outdated and need to be refreshed.");
            }
            Type kuduColType = KuduUtil.toImpalaType(kuduCol.getType(), kuduCol.getTypeAttributes());
            if (!colType.equals(kuduColType)) {
                throw new ImpalaRuntimeException("Column '" + colName + "' is type " + kuduColType.toSql() + " but Impala expected " + colType.toSql() + ". The table metadata in Impala may be outdated and need to be refreshed.");
            }
            if (desc.getIsNullable() == kuduCol.isNullable()) continue;
            if (desc.getIsNullable()) {
                expected = "nullable";
                actual = "not nullable";
            } else {
                expected = "not nullable";
                actual = "nullable";
            }
            throw new ImpalaRuntimeException("Column '" + colName + "' is " + actual + " but Impala expected it to be " + expected + ". The table metadata in Impala may be outdated and need to be refreshed.");
        }
    }

    private void computeScanRangeLocations(Analyzer analyzer, KuduClient client, KuduTable rpcTable) throws ImpalaRuntimeException {
        this.scanRangeSpecs_ = new TScanRangeSpec();
        this.replicaSelectionLeaderOnly_ = analyzer.getQueryOptions().getKudu_replica_selection() == TKuduReplicaSelection.LEADER_ONLY;
        List<KuduScanToken> scanTokens = this.createScanTokens(analyzer, client, rpcTable);
        for (KuduScanToken token : scanTokens) {
            LocatedTablet tablet = token.getTablet();
            ArrayList<TScanRangeLocation> locations = new ArrayList<TScanRangeLocation>();
            if (tablet.getReplicas().isEmpty()) {
                throw new ImpalaRuntimeException(String.format("At least one tablet does not have any replicas. Tablet ID: %s", new String(tablet.getTabletId(), Charsets.UTF_8)));
            }
            for (LocatedTablet.Replica replica : tablet.getReplicas()) {
                if (this.replicaSelectionLeaderOnly_ && !replica.getRole().equals(Metadata.RaftPeerPB.Role.LEADER.toString())) continue;
                TNetworkAddress address = new TNetworkAddress(replica.getRpcHost(), replica.getRpcPort());
                Integer hostIndex = analyzer.getHostIndex().getOrAddIndex(address);
                locations.add(new TScanRangeLocation(hostIndex));
                this.hostIndexSet_.add(hostIndex);
            }
            TScanRange scanRange = new TScanRange();
            try {
                scanRange.setKudu_scan_token(token.serialize());
            }
            catch (IOException e) {
                throw new ImpalaRuntimeException("Unable to serialize Kudu scan token=" + token.toString(), e);
            }
            TScanRangeLocationList locs = new TScanRangeLocationList();
            locs.setScan_range(scanRange);
            locs.setLocations(locations);
            this.scanRangeSpecs_.addToConcrete_ranges(locs);
        }
    }

    private List<KuduScanToken> createScanTokens(Analyzer analyzer, KuduClient client, KuduTable rpcTable) {
        ArrayList<String> projectedCols = new ArrayList<String>();
        for (SlotDescriptor desc : this.getTupleDesc().getSlotsOrderedByOffset()) {
            if (this.isCountStarOptimizationDescriptor(desc)) continue;
            projectedCols.add(((KuduColumn)desc.getColumn()).getKuduName());
        }
        KuduScanToken.KuduScanTokenBuilder tokenBuilder = client.newScanTokenBuilder(rpcTable);
        tokenBuilder.setProjectedColumnNames(projectedCols);
        long split_size_hint = analyzer.getQueryOptions().getTargeted_kudu_scan_range_length();
        if (split_size_hint > 0L) {
            tokenBuilder.setSplitSizeBytes(split_size_hint);
        }
        for (KuduPredicate predicate : this.kuduPredicates_) {
            tokenBuilder.addPredicate(predicate);
        }
        return tokenBuilder.build();
    }

    @Override
    protected double computeSelectivity() {
        ArrayList allConjuncts = Lists.newArrayList((Iterable)Iterables.concat((Iterable)this.conjuncts_, this.kuduConjuncts_));
        return KuduScanNode.computeCombinedSelectivity(allConjuncts);
    }

    protected void computeNumNodes(Analyzer analyzer) {
        ExecutorMembershipSnapshot cluster = ExecutorMembershipSnapshot.getCluster();
        int maxInstancesPerNode = this.getMaxInstancesPerNode(analyzer);
        int maxPossibleInstances = analyzer.numExecutorsForPlanning() * maxInstancesPerNode;
        int totalNodes = 0;
        int totalInstances = 0;
        int numLocalRanges = 0;
        int numRemoteRanges = 0;
        HashMap<TNetworkAddress, Integer> localRangeCounts = new HashMap<TNetworkAddress, Integer>();
        int totalLocalParallelism = 0;
        if (this.scanRangeSpecs_.isSetConcrete_ranges()) {
            for (TScanRangeLocationList range : this.scanRangeSpecs_.concrete_ranges) {
                boolean anyLocal = false;
                if (range.isSetLocations()) {
                    for (TScanRangeLocation loc : range.locations) {
                        TNetworkAddress address = analyzer.getHostIndex().getEntry(loc.getHost_idx());
                        if (!cluster.contains(address)) continue;
                        anyLocal = true;
                        int count = localRangeCounts.getOrDefault(address, 0);
                        if (count >= maxInstancesPerNode) continue;
                        ++totalLocalParallelism;
                        localRangeCounts.put(address, count + 1);
                    }
                }
                if (anyLocal) {
                    ++numLocalRanges;
                } else {
                    ++numRemoteRanges;
                }
                int numLocalNodes = Math.min(numLocalRanges, localRangeCounts.size());
                int numRemoteNodes = Math.min(numRemoteRanges, analyzer.numExecutorsForPlanning());
                totalNodes = Math.min(numLocalNodes + numRemoteNodes, analyzer.numExecutorsForPlanning());
                int numLocalInstances = Math.min(numLocalRanges, totalLocalParallelism);
                totalInstances = Math.min(numLocalInstances + numRemoteRanges, totalNodes * maxInstancesPerNode);
                if (totalInstances != maxPossibleInstances) continue;
                break;
            }
        }
        this.numNodes_ = Math.max(totalNodes, 1);
        this.numInstances_ = Math.max(totalInstances, 1);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.computeNumNodes(analyzer);
        this.cardinality_ = this.kuduTable_.getNumRows() == -1L ? this.tableNumRowsHint_ : this.kuduTable_.getNumRows();
        this.inputCardinality_ = this.cardinality_;
        if (this.isPointLookupQuery_) {
            if (this.cardinality_ != 0L) {
                this.cardinality_ = 1L;
            }
            this.inputCardinality_ = this.cardinality_;
        } else {
            this.cardinality_ = this.applyConjunctsSelectivity(this.cardinality_);
            this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("computeStats KuduScan: cardinality=" + Long.toString(this.cardinality_));
        }
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeScanProcessingCost(queryOptions);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        int numOfScanRanges = this.scanRangeSpecs_.getConcrete_rangesSize();
        int perHostScanRanges = this.estimatePerHostScanRanges(numOfScanRanges);
        int maxScannerThreads = this.computeMaxNumberOfScannerThreads(queryOptions, perHostScanRanges);
        long estimated_bytes_per_column_per_thread = BackendConfig.INSTANCE.getBackendCfg().kudu_scanner_thread_estimated_bytes_per_column;
        long max_estimated_bytes_per_thread = BackendConfig.INSTANCE.getBackendCfg().kudu_scanner_thread_max_estimated_bytes;
        long mem_estimate_per_thread = Math.min((long)this.getNumMaterializedSlots(this.desc_) * estimated_bytes_per_column_per_thread, max_estimated_bytes_per_thread);
        this.useMtScanNode_ = Planner.useMTFragment(queryOptions);
        this.nodeResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(mem_estimate_per_thread * (long)maxScannerThreads).setThreadReservation(this.useMtScanNode_ ? 0L : 1L).build();
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder result = new StringBuilder();
        String aliasStr = this.desc_.hasExplicitAlias() ? " " + this.desc_.getAlias() : "";
        result.append(String.format(this.replicaSelectionLeaderOnly_ ? "%s%s:%s [%s%s, LEADER-only]\n" : "%s%s:%s [%s%s]\n", prefix, this.id_.toString(), this.displayName_, this.kuduTable_.getFullName(), aliasStr));
        switch (detailLevel) {
            case MINIMAL: {
                break;
            }
            case STANDARD: 
            case EXTENDED: 
            case VERBOSE: {
                if (!this.conjuncts_.isEmpty()) {
                    result.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
                }
                if (!this.kuduConjuncts_.isEmpty()) {
                    result.append(detailPrefix + "kudu predicates: " + Expr.getExplainString(this.kuduConjuncts_, detailLevel) + "\n");
                }
                if (this.runtimeFilters_.isEmpty()) break;
                result.append(detailPrefix + "runtime filters: ");
                result.append(this.getRuntimeFilterExplainString(false, detailLevel));
            }
        }
        return result.toString();
    }

    @Override
    protected void toThrift(TPlanNode node) {
        node.node_type = TPlanNodeType.KUDU_SCAN_NODE;
        node.kudu_scan_node = new TKuduScanNode(this.desc_.getId().asInt());
        node.kudu_scan_node.setUse_mt_scan_node(this.useMtScanNode_);
        Preconditions.checkState((this.optimizedAggSmap_ == null == (this.countStarSlot_ == null) ? 1 : 0) != 0);
        if (this.countStarSlot_ != null) {
            node.kudu_scan_node.setCount_star_slot_offset(this.countStarSlot_.getByteOffset());
        }
    }

    private void extractKuduConjuncts(Analyzer analyzer, KuduClient client, KuduTable rpcTable) {
        HashSet<Integer> primaryKeyColsInEqualPred = new HashSet<Integer>();
        ListIterator it = this.conjuncts_.listIterator();
        while (it.hasNext()) {
            Expr predicate = (Expr)it.next();
            if (!this.tryConvertBinaryKuduPredicate(analyzer, rpcTable, predicate, primaryKeyColsInEqualPred) && !this.tryConvertInListKuduPredicate(analyzer, rpcTable, predicate) && !this.tryConvertIsNullKuduPredicate(analyzer, rpcTable, predicate)) continue;
            if (this.currentPredicateNeedCheckAgain_) {
                this.currentPredicateNeedCheckAgain_ = false;
                continue;
            }
            it.remove();
        }
        if (primaryKeyColsInEqualPred.size() >= 1 && primaryKeyColsInEqualPred.size() == rpcTable.getSchema().getPrimaryKeyColumnCount()) {
            this.isPointLookupQuery_ = true;
        }
    }

    private boolean tryConvertBinaryKuduPredicate(Analyzer analyzer, KuduTable table, Expr expr, Set<Integer> primaryKeyColsInEqualPred) {
        if (!(expr instanceof BinaryPredicate)) {
            return false;
        }
        BinaryPredicate predicate = (BinaryPredicate)expr;
        KuduPredicate.ComparisonOp op = KuduScanNode.getKuduOperator(predicate.getOp());
        if (op == null) {
            return false;
        }
        if (!(predicate.getChild(0) instanceof SlotRef)) {
            return false;
        }
        SlotRef ref = (SlotRef)predicate.getChild(0);
        if (!(predicate.getChild(1) instanceof LiteralExpr)) {
            return false;
        }
        LiteralExpr literal = (LiteralExpr)predicate.getChild(1);
        if (Expr.IS_NULL_LITERAL.apply((Object)literal)) {
            return false;
        }
        String colName = ((KuduColumn)ref.getDesc().getColumn()).getKuduName();
        ColumnSchema column = table.getSchema().getColumn(colName);
        KuduPredicate kuduPredicate = null;
        switch (literal.getType().getPrimitiveType()) {
            case BOOLEAN: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (boolean)((BoolLiteral)literal).getValue());
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (long)((NumericLiteral)literal).getIntValue());
                break;
            }
            case BIGINT: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (long)((NumericLiteral)literal).getLongValue());
                break;
            }
            case FLOAT: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (float)((float)((NumericLiteral)literal).getDoubleValue()));
                break;
            }
            case DOUBLE: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (double)((NumericLiteral)literal).getDoubleValue());
                break;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (String)((StringLiteral)literal).getUnescapedValue());
                break;
            }
            case BINARY: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (byte[])((StringLiteral)literal).getUnescapedValue().getBytes());
                break;
            }
            case TIMESTAMP: {
                try {
                    kuduPredicate = analyzer.getQueryOptions().isConvert_kudu_utc_timestamps() ? this.convertLocalTimestampBinaryKuduPredicate(analyzer, column, op, literal) : KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (long)ExprUtil.utcTimestampToUnixTimeMicros(analyzer, literal));
                    break;
                }
                catch (Exception e) {
                    LOG.info("Exception converting Kudu timestamp predicate: " + expr.toSql(), (Throwable)e);
                    return false;
                }
            }
            case DATE: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (long)((DateLiteral)literal).getValue());
                break;
            }
            case DECIMAL: {
                kuduPredicate = KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (BigDecimal)((NumericLiteral)literal).getValue());
                break;
            }
            default: {
                Preconditions.checkState((boolean)false);
            }
        }
        Preconditions.checkState((kuduPredicate != null ? 1 : 0) != 0);
        this.kuduConjuncts_.add(predicate);
        this.kuduPredicates_.add(kuduPredicate);
        if (predicate.getOp().isEquivalence() && column.isKey()) {
            Integer colIndex = table.getSchema().getColumnIndex(colName);
            primaryKeyColsInEqualPred.add(colIndex);
        }
        return true;
    }

    private KuduPredicate convertLocalTimestampBinaryKuduPredicate(Analyzer analyzer, ColumnSchema column, KuduPredicate.ComparisonOp op, LiteralExpr literal) throws AnalysisException, InternalException {
        Long preUnixTimeMicros = ExprUtil.localTimestampToUnixTimeMicros(analyzer, literal, true);
        Long postUnixTimeMicros = ExprUtil.localTimestampToUnixTimeMicros(analyzer, literal, false);
        if (preUnixTimeMicros == null || postUnixTimeMicros == null) {
            if (preUnixTimeMicros == null) {
                return null;
            }
            if (op == KuduPredicate.ComparisonOp.EQUAL) {
                return KuduPredicate.newInListPredicate((ColumnSchema)column, (List)Lists.newArrayList());
            }
            postUnixTimeMicros = preUnixTimeMicros;
        }
        if (preUnixTimeMicros.equals(postUnixTimeMicros)) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (Object)preUnixTimeMicros);
        }
        switch (op) {
            case EQUAL: {
                return KuduPredicate.newInListPredicate((ColumnSchema)column, (List)Lists.newArrayList((Object[])new Long[]{preUnixTimeMicros, postUnixTimeMicros}));
            }
            case LESS: 
            case LESS_EQUAL: {
                this.currentPredicateNeedCheckAgain_ = true;
                return KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (Object)postUnixTimeMicros);
            }
            case GREATER: 
            case GREATER_EQUAL: {
                this.currentPredicateNeedCheckAgain_ = true;
                return KuduPredicate.newComparisonPredicate((ColumnSchema)column, (KuduPredicate.ComparisonOp)op, (Object)preUnixTimeMicros);
            }
        }
        throw new InternalException("Unexpected operator: " + op);
    }

    private boolean tryConvertInListKuduPredicate(Analyzer analyzer, KuduTable table, Expr expr) {
        if (!(expr instanceof InPredicate)) {
            return false;
        }
        InPredicate predicate = (InPredicate)expr;
        if (predicate.isNotIn()) {
            return false;
        }
        if (!(predicate.getChild(0) instanceof SlotRef)) {
            return false;
        }
        SlotRef ref = (SlotRef)predicate.getChild(0);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 1; i < predicate.getChildren().size(); ++i) {
            if (!Expr.IS_LITERAL.apply(predicate.getChild(i))) {
                return false;
            }
            LiteralExpr literal = (LiteralExpr)predicate.getChild(i);
            if (Expr.IS_NULL_LITERAL.apply((Object)literal)) {
                return false;
            }
            Object value = KuduScanNode.getKuduInListValue(analyzer, literal);
            if (value == null) {
                return false;
            }
            if (value instanceof List) {
                values.addAll((List)value);
                continue;
            }
            values.add(value);
        }
        String colName = ((KuduColumn)ref.getDesc().getColumn()).getKuduName();
        ColumnSchema column = table.getSchema().getColumn(colName);
        this.kuduPredicates_.add(KuduPredicate.newInListPredicate((ColumnSchema)column, values));
        this.kuduConjuncts_.add(predicate);
        return true;
    }

    private boolean tryConvertIsNullKuduPredicate(Analyzer analyzer, KuduTable table, Expr expr) {
        if (!(expr instanceof IsNullPredicate)) {
            return false;
        }
        IsNullPredicate predicate = (IsNullPredicate)expr;
        if (!(predicate.getChild(0) instanceof SlotRef)) {
            return false;
        }
        SlotRef ref = (SlotRef)predicate.getChild(0);
        String colName = ((KuduColumn)ref.getDesc().getColumn()).getKuduName();
        ColumnSchema column = table.getSchema().getColumn(colName);
        KuduPredicate kuduPredicate = null;
        kuduPredicate = predicate.isNotNull() ? KuduPredicate.newIsNotNullPredicate((ColumnSchema)column) : KuduPredicate.newIsNullPredicate((ColumnSchema)column);
        this.kuduConjuncts_.add(predicate);
        this.kuduPredicates_.add(kuduPredicate);
        return true;
    }

    private static Object getKuduInListValue(Analyzer analyzer, LiteralExpr e) {
        switch (e.getType().getPrimitiveType()) {
            case BOOLEAN: {
                return ((BoolLiteral)e).getValue();
            }
            case TINYINT: {
                return (byte)((NumericLiteral)e).getLongValue();
            }
            case SMALLINT: {
                return (short)((NumericLiteral)e).getLongValue();
            }
            case INT: {
                return (int)((NumericLiteral)e).getLongValue();
            }
            case BIGINT: {
                return ((NumericLiteral)e).getLongValue();
            }
            case FLOAT: {
                return Float.valueOf((float)((NumericLiteral)e).getDoubleValue());
            }
            case DOUBLE: {
                return ((NumericLiteral)e).getDoubleValue();
            }
            case STRING: {
                return ((StringLiteral)e).getUnescapedValue();
            }
            case TIMESTAMP: {
                try {
                    if (analyzer.getQueryOptions().isConvert_kudu_utc_timestamps()) {
                        Long preUnixTimeMicros = ExprUtil.localTimestampToUnixTimeMicros(analyzer, e, true);
                        Long postUnixTimeMicros = ExprUtil.localTimestampToUnixTimeMicros(analyzer, e, false);
                        if (preUnixTimeMicros == null || postUnixTimeMicros == null) {
                            if (preUnixTimeMicros == null) {
                                return null;
                            }
                            return Lists.newArrayList();
                        }
                        if (preUnixTimeMicros.equals(postUnixTimeMicros)) {
                            return preUnixTimeMicros;
                        }
                        return Lists.newArrayList((Object[])new Long[]{preUnixTimeMicros, postUnixTimeMicros});
                    }
                    return ExprUtil.utcTimestampToUnixTimeMicros(analyzer, e);
                }
                catch (Exception ex) {
                    LOG.info("Exception converting Kudu timestamp expr: " + e.toSql(), (Throwable)ex);
                    break;
                }
            }
            case DECIMAL: {
                return ((NumericLiteral)e).getValue();
            }
            default: {
                Preconditions.checkState((boolean)false, (String)"Unsupported Kudu type considered for predicate: %s", (Object)e.getType().toSql());
            }
        }
        return null;
    }

    private static KuduPredicate.ComparisonOp getKuduOperator(BinaryPredicate.Operator op) {
        switch (op) {
            case GT: {
                return KuduPredicate.ComparisonOp.GREATER;
            }
            case LT: {
                return KuduPredicate.ComparisonOp.LESS;
            }
            case GE: {
                return KuduPredicate.ComparisonOp.GREATER_EQUAL;
            }
            case LE: {
                return KuduPredicate.ComparisonOp.LESS_EQUAL;
            }
            case EQ: {
                return KuduPredicate.ComparisonOp.EQUAL;
            }
        }
        return null;
    }

    @Override
    public boolean hasStorageLayerConjuncts() {
        return !this.kuduConjuncts_.isEmpty();
    }
}

