/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.IcebergDeleteNode;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.JoinTableId;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TJoinBuildSink;
import org.apache.impala.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinBuildSink
extends DataSink {
    private static final Logger LOG = LoggerFactory.getLogger(JoinBuildSink.class);
    private final JoinTableId joinTableId_;
    private final JoinNode joinNode_;
    private final List<Expr> buildExprs_ = new ArrayList<Expr>();
    private final List<RuntimeFilterGenerator.RuntimeFilter> runtimeFilters_ = new ArrayList<RuntimeFilterGenerator.RuntimeFilter>();

    public JoinBuildSink(JoinTableId joinTableId, JoinNode joinNode) {
        Preconditions.checkState((boolean)joinTableId.isValid());
        this.joinTableId_ = joinTableId;
        this.joinNode_ = joinNode;
        Preconditions.checkNotNull((Object)joinNode);
        Preconditions.checkState((boolean)(joinNode instanceof JoinNode));
        if (joinNode instanceof HashJoinNode) {
            for (Expr expr : joinNode.getEqJoinConjuncts()) {
                BinaryPredicate p = (BinaryPredicate)expr;
                this.buildExprs_.add(((Expr)p.getChild(1)).clone());
            }
        }
        this.runtimeFilters_.addAll(joinNode.getRuntimeFilters());
    }

    public JoinTableId getJoinTableId() {
        return this.joinTableId_;
    }

    @Override
    public List<RuntimeFilterGenerator.RuntimeFilter> getRuntimeFilters() {
        return this.runtimeFilters_;
    }

    @Override
    protected void toThriftImpl(TDataSink tsink) {
        TJoinBuildSink tBuildSink = new TJoinBuildSink();
        tBuildSink.setDest_node_id(this.joinNode_.getId().asInt());
        tBuildSink.setJoin_op(this.joinNode_.getJoinOp().toThrift());
        if (this.joinNode_ instanceof HashJoinNode) {
            tBuildSink.setEq_join_conjuncts(((HashJoinNode)this.joinNode_).getThriftEquiJoinConjuncts());
            tBuildSink.setHash_seed(this.joinNode_.getFragment().getHashSeed());
        }
        if (this.joinNode_ instanceof IcebergDeleteNode) {
            tBuildSink.setEq_join_conjuncts(((IcebergDeleteNode)this.joinNode_).getThriftEquiJoinConjuncts());
            tBuildSink.setHash_seed(this.joinNode_.getFragment().getHashSeed());
        }
        for (RuntimeFilterGenerator.RuntimeFilter filter : this.runtimeFilters_) {
            tBuildSink.addToRuntime_filters(filter.toThrift());
        }
        tBuildSink.setShare_build(this.joinNode_.canShareBuild());
        tsink.setJoin_build_sink(tBuildSink);
    }

    @Override
    protected TDataSinkType getSinkType() {
        if (this.joinNode_ instanceof HashJoinNode) {
            return TDataSinkType.HASH_JOIN_BUILDER;
        }
        if (this.joinNode_ instanceof NestedLoopJoinNode) {
            return TDataSinkType.NESTED_LOOP_JOIN_BUILDER;
        }
        Preconditions.checkState((boolean)(this.joinNode_ instanceof IcebergDeleteNode));
        return TDataSinkType.ICEBERG_DELETE_BUILDER;
    }

    @Override
    public void appendSinkExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel detailLevel, StringBuilder output) {
        output.append(String.format("%s%s\n", prefix, "JOIN BUILD"));
        if (detailLevel.ordinal() > TExplainLevel.MINIMAL.ordinal()) {
            output.append(detailPrefix + "join-table-id=" + this.joinTableId_.toString() + " plan-id=" + this.fragment_.getPlanId().toString() + " cohort-id=" + this.fragment_.getCohortId().toString() + "\n");
            if (!this.buildExprs_.isEmpty()) {
                output.append(detailPrefix + "build expressions: ").append(Expr.toSql(this.buildExprs_, ToSqlOptions.DEFAULT) + "\n");
            }
            if (!this.runtimeFilters_.isEmpty()) {
                output.append(detailPrefix + "runtime filters: ");
                output.append(PlanNode.getRuntimeFilterExplainString(this.runtimeFilters_, true, this.joinNode_.getId(), detailLevel));
            }
        }
    }

    public int getNumNodes() {
        return this.joinNode_.getFragment().getNumNodes();
    }

    public int getNumInstances() {
        return this.joinNode_.canShareBuild() ? this.joinNode_.getFragment().getNumNodes() : this.joinNode_.getFragment().getNumInstances();
    }

    public boolean isShared() {
        return this.joinNode_.canShareBuild();
    }

    @Override
    protected String getLabel() {
        return "JOIN BUILD";
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = (ProcessingCost)this.joinNode_.computeJoinProcessingCost().second;
    }

    @Override
    public void computeResourceProfile(TQueryOptions queryOptions) {
        this.resourceProfile_ = (ResourceProfile)this.joinNode_.computeJoinResourceProfile((TQueryOptions)queryOptions).second;
    }

    @Override
    public void collectExprs(List<Expr> exprs) {
        exprs.addAll(this.buildExprs_);
    }

    @Override
    public void computeRowConsumptionAndProductionToCost() {
        super.computeRowConsumptionAndProductionToCost();
        if (this.isShared()) {
            this.fragment_.setFixedInstanceCount(this.getNumInstances());
        }
    }
}

