/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.IcebergExpressionCollector;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TimeTravelSpec;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergEqualityDeleteTable;
import org.apache.impala.catalog.IcebergPositionDeleteTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.IcebergPredicateConverter;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Pair;
import org.apache.impala.fb.FbIcebergMetadata;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.IcebergDeleteNode;
import org.apache.impala.planner.IcebergScanNode;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.SingleNodePlanner;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.thrift.TColumnStats;
import org.apache.impala.thrift.TIcebergPartitionTransformType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TVirtualColumnType;
import org.apache.impala.util.IcebergUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergScanPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergScanPlanner.class);
    private Analyzer analyzer_;
    private PlannerContext ctx_;
    private TableRef tblRef_;
    private List<Expr> conjuncts_;
    private MultiAggregateInfo aggInfo_;
    private final Map<Expression, Expr> impalaIcebergPredicateMapping_ = new LinkedHashMap<Expression, Expr>();
    private final Set<Expression> residualExpressions_ = new TreeSet<Expression>(Comparator.comparing(ExpressionUtil::toSanitizedString));
    private final List<Expr> skippedExpressions_ = new ArrayList<Expr>();
    private final List<Expr> untranslatedExpressions_ = new ArrayList<Expr>();
    private List<Expr> nonIdentityConjuncts_ = new ArrayList<Expr>();
    private List<HdfsPartition.FileDescriptor> dataFilesWithoutDeletes_ = new ArrayList<HdfsPartition.FileDescriptor>();
    private List<HdfsPartition.FileDescriptor> dataFilesWithDeletes_ = new ArrayList<HdfsPartition.FileDescriptor>();
    private Set<HdfsPartition.FileDescriptor> positionDeleteFiles_ = new HashSet<HdfsPartition.FileDescriptor>();
    private Set<Integer> allEqualityFieldIds_ = new HashSet<Integer>();
    private Map<List<Integer>, Set<HdfsPartition.FileDescriptor>> equalityIdsToDeleteFiles_ = new HashMap<List<Integer>, Set<HdfsPartition.FileDescriptor>>();
    private long positionDeletesRecordCount_ = 0L;
    private long dataFilesWithDeletesSumPaths_ = 0L;
    private long dataFilesWithDeletesMaxPath_ = 0L;
    private Map<List<Integer>, Long> equalityDeletesRecordCount_ = new HashMap<List<Integer>, Long>();
    private Set<Long> equalityDeleteSequenceNumbers_ = new HashSet<Long>();
    private final long snapshotId_;

    public IcebergScanPlanner(Analyzer analyzer, PlannerContext ctx, TableRef iceTblRef, List<Expr> conjuncts, MultiAggregateInfo aggInfo) throws ImpalaException {
        Preconditions.checkState((iceTblRef.getTable() instanceof FeIcebergTable || iceTblRef.getTable() instanceof IcebergMetadataTable ? 1 : 0) != 0);
        this.analyzer_ = analyzer;
        this.ctx_ = ctx;
        this.tblRef_ = iceTblRef;
        this.conjuncts_ = conjuncts;
        this.aggInfo_ = aggInfo;
        this.extractIcebergConjuncts();
        this.snapshotId_ = IcebergUtil.getSnapshotId(this.getIceTable(), this.tblRef_.getTimeTravelSpec());
    }

    public PlanNode createIcebergScanPlan() throws ImpalaException {
        if (!this.needIcebergForPlanning()) {
            this.analyzer_.materializeSlots(this.conjuncts_);
            this.setFileDescriptorsBasedOnFileStore();
            return this.createIcebergScanPlanImpl();
        }
        this.filterFileDescriptors();
        this.filterConjuncts();
        this.analyzer_.materializeSlots(this.conjuncts_);
        return this.createIcebergScanPlanImpl();
    }

    private boolean needIcebergForPlanning() {
        return !this.impalaIcebergPredicateMapping_.isEmpty() || this.tblRef_.getTimeTravelSpec() != null;
    }

    private void setFileDescriptorsBasedOnFileStore() throws ImpalaException {
        IcebergContentFileStore fileStore = this.getIceTable().getContentFileStore();
        this.dataFilesWithoutDeletes_ = fileStore.getDataFilesWithoutDeletes();
        this.dataFilesWithDeletes_ = fileStore.getDataFilesWithDeletes();
        this.positionDeleteFiles_ = new HashSet<HdfsPartition.FileDescriptor>(fileStore.getPositionDeleteFiles());
        this.initEqualityIds(fileStore.getEqualityDeleteFiles());
        this.updateDeleteStatistics();
    }

    private boolean noDeleteFiles() {
        return this.positionDeleteFiles_.isEmpty() && this.equalityIdsToDeleteFiles_.isEmpty();
    }

    private PlanNode createIcebergScanPlanImpl() throws ImpalaException {
        if (this.noDeleteFiles()) {
            Preconditions.checkState((!this.ctx_.getQueryCtx().isOptimize_count_star_for_iceberg_v2() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.dataFilesWithDeletes_.isEmpty());
            IcebergScanNode ret = new IcebergScanNode(this.ctx_.getNextNodeId(), this.tblRef_, this.conjuncts_, this.aggInfo_, this.dataFilesWithoutDeletes_, this.nonIdentityConjuncts_, this.getSkippedConjuncts(), this.snapshotId_);
            ((PlanNode)ret).init(this.analyzer_);
            return ret;
        }
        PlanNode joinNode = null;
        if (!this.positionDeleteFiles_.isEmpty()) {
            joinNode = this.createPositionJoinNode();
        }
        if (!this.equalityIdsToDeleteFiles_.isEmpty()) {
            joinNode = this.createEqualityJoinNode(joinNode);
        }
        Preconditions.checkNotNull((Object)joinNode);
        if (this.ctx_.getQueryCtx().isOptimize_count_star_for_iceberg_v2()) {
            return joinNode;
        }
        if (this.dataFilesWithoutDeletes_.isEmpty()) {
            return joinNode;
        }
        IcebergScanNode dataScanNode = new IcebergScanNode(this.ctx_.getNextNodeId(), this.tblRef_, this.conjuncts_, this.aggInfo_, this.dataFilesWithoutDeletes_, this.nonIdentityConjuncts_, this.getSkippedConjuncts(), this.snapshotId_);
        dataScanNode.init(this.analyzer_);
        List<Expr> outputExprs = this.tblRef_.getDesc().getSlots().stream().map(SlotRef::new).collect(Collectors.toList());
        UnionNode unionNode = new UnionNode(this.ctx_.getNextNodeId(), this.tblRef_.getId(), outputExprs, false);
        unionNode.addChild(dataScanNode, outputExprs);
        unionNode.addChild(joinNode, outputExprs);
        unionNode.init(this.analyzer_);
        Preconditions.checkState((unionNode.getChildCount() == 2 ? 1 : 0) != 0);
        Preconditions.checkState((unionNode.getFirstNonPassthroughChildIndex() == 2 ? 1 : 0) != 0);
        return unionNode;
    }

    private PlanNode createPositionJoinNode() throws ImpalaException {
        Preconditions.checkState((this.positionDeletesRecordCount_ != 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.dataFilesWithDeletesSumPaths_ != 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.dataFilesWithDeletesMaxPath_ != 0L ? 1 : 0) != 0);
        PlanNodeId dataScanNodeId = this.ctx_.getNextNodeId();
        PlanNodeId deleteScanNodeId = this.ctx_.getNextNodeId();
        IcebergPositionDeleteTable deleteTable = new IcebergPositionDeleteTable(this.getIceTable(), this.getIceTable().getName() + "-POSITION-DELETE-" + deleteScanNodeId.toString(), this.positionDeleteFiles_, this.positionDeletesRecordCount_, this.getFilePathStats());
        this.analyzer_.addVirtualTable(deleteTable);
        TableRef deleteDeltaRef = TableRef.newTableRef(this.analyzer_, Arrays.asList(deleteTable.getDb().getName(), deleteTable.getName()), this.tblRef_.getUniqueAlias() + "-position-delete");
        this.addDataVirtualPositionSlots(this.tblRef_);
        if (!this.equalityIdsToDeleteFiles_.isEmpty()) {
            this.addAllSlotsForEqualityDeletes(this.tblRef_);
        }
        this.addDeletePositionSlots(deleteDeltaRef);
        IcebergScanNode dataScanNode = new IcebergScanNode(dataScanNodeId, this.tblRef_, this.conjuncts_, this.aggInfo_, this.dataFilesWithDeletes_, this.nonIdentityConjuncts_, this.getSkippedConjuncts(), deleteScanNodeId, this.snapshotId_);
        dataScanNode.init(this.analyzer_);
        IcebergScanNode deleteScanNode = new IcebergScanNode(deleteScanNodeId, deleteDeltaRef, Collections.emptyList(), this.aggInfo_, Lists.newArrayList(this.positionDeleteFiles_), Collections.emptyList(), Collections.emptyList(), this.snapshotId_);
        deleteScanNode.init(this.analyzer_);
        List<BinaryPredicate> positionJoinConjuncts = this.createPositionJoinConjuncts(this.analyzer_, this.tblRef_.getDesc(), deleteDeltaRef.getDesc());
        TQueryOptions queryOpts = this.analyzer_.getQueryCtx().client_request.query_options;
        JoinNode joinNode = null;
        joinNode = queryOpts.disable_optimized_iceberg_v2_read ? new HashJoinNode(dataScanNode, deleteScanNode, true, JoinNode.DistributionMode.NONE, JoinOperator.LEFT_ANTI_JOIN, positionJoinConjuncts, Collections.emptyList()) : new IcebergDeleteNode(dataScanNode, (PlanNode)deleteScanNode, positionJoinConjuncts);
        joinNode.setId(this.ctx_.getNextNodeId());
        joinNode.init(this.analyzer_);
        joinNode.setIsDeleteRowsJoin();
        return joinNode;
    }

    private void addDataVirtualPositionSlots(TableRef tblRef) throws AnalysisException {
        ArrayList rawPath = Lists.newArrayList((Object[])new String[]{tblRef.getUniqueAlias(), VirtualColumn.INPUT_FILE_NAME.getName()});
        SlotDescriptor fileNameSlotDesc = SingleNodePlanner.addSlotRefToDesc(this.analyzer_, rawPath);
        fileNameSlotDesc.setStats(this.virtualInputFileNameStats());
        rawPath = Lists.newArrayList((Object[])new String[]{tblRef.getUniqueAlias(), VirtualColumn.FILE_POSITION.getName()});
        SlotDescriptor filePosSlotDesc = SingleNodePlanner.addSlotRefToDesc(this.analyzer_, rawPath);
        filePosSlotDesc.setStats(this.virtualFilePositionStats());
    }

    private void addAllSlotsForEqualityDeletes(TableRef tblRef) throws AnalysisException {
        this.addSlotsForEqualityDeletes(Lists.newArrayList(this.allEqualityFieldIds_), tblRef);
    }

    private void addSlotsForEqualityDeletes(List<Integer> equalityFieldIds, TableRef tblRef) throws AnalysisException {
        Preconditions.checkState((!equalityFieldIds.isEmpty() ? 1 : 0) != 0);
        ArrayList rawPath = Lists.newArrayList((Object[])new String[]{tblRef.getUniqueAlias(), VirtualColumn.ICEBERG_DATA_SEQUENCE_NUMBER.getName()});
        SlotDescriptor slotDesc = SingleNodePlanner.addSlotRefToDesc(this.analyzer_, rawPath);
        slotDesc.setStats(this.virtualDataSeqNumStats());
        for (Integer eqId : equalityFieldIds) {
            String eqColName = this.getIceTable().getIcebergSchema().findColumnName(eqId.intValue());
            Preconditions.checkNotNull((Object)eqColName);
            rawPath = Lists.newArrayList((Object[])new String[]{tblRef.getUniqueAlias(), eqColName});
            SingleNodePlanner.addSlotRefToDesc(this.analyzer_, rawPath);
        }
    }

    private void addDeletePositionSlots(TableRef tblRef) throws AnalysisException {
        SingleNodePlanner.addSlotRefToDesc(this.analyzer_, Lists.newArrayList((Object[])new String[]{tblRef.getUniqueAlias(), IcebergPositionDeleteTable.FILE_PATH_COLUMN}));
        SingleNodePlanner.addSlotRefToDesc(this.analyzer_, Lists.newArrayList((Object[])new String[]{tblRef.getUniqueAlias(), IcebergPositionDeleteTable.POS_COLUMN}));
    }

    private List<BinaryPredicate> createPositionJoinConjuncts(Analyzer analyzer, TupleDescriptor insertTupleDesc, TupleDescriptor deleteTupleDesc) throws AnalysisException {
        ArrayList<BinaryPredicate> ret = new ArrayList<BinaryPredicate>();
        BinaryPredicate filePathEq = null;
        BinaryPredicate posEq = null;
        for (SlotDescriptor deleteSlotDesc : deleteTupleDesc.getSlots()) {
            boolean foundMatch = false;
            Column col = deleteSlotDesc.getParent().getTable().getColumns().get(deleteSlotDesc.getMaterializedPath().get(0));
            Preconditions.checkState((boolean)(col instanceof IcebergColumn));
            int fieldId = ((IcebergColumn)col).getFieldId();
            for (SlotDescriptor insertSlotDesc : insertTupleDesc.getSlots()) {
                TVirtualColumnType virtColType = insertSlotDesc.getVirtualColumnType();
                if (fieldId == 2147483546 && virtColType == TVirtualColumnType.INPUT_FILE_NAME) {
                    foundMatch = true;
                    filePathEq = new BinaryPredicate(BinaryPredicate.Operator.EQ, new SlotRef(insertSlotDesc), new SlotRef(deleteSlotDesc));
                    filePathEq.analyze(analyzer);
                    break;
                }
                if (fieldId != 0x7FFFFF99 || virtColType != TVirtualColumnType.FILE_POSITION) continue;
                foundMatch = true;
                posEq = new BinaryPredicate(BinaryPredicate.Operator.EQ, new SlotRef(insertSlotDesc), new SlotRef(deleteSlotDesc));
                posEq.analyze(analyzer);
                break;
            }
            Preconditions.checkState((boolean)foundMatch);
        }
        Preconditions.checkState((filePathEq != null ? 1 : 0) != 0);
        Preconditions.checkState((posEq != null ? 1 : 0) != 0);
        ret.add(filePathEq);
        ret.add(posEq);
        return ret;
    }

    private Pair<List<BinaryPredicate>, List<Expr>> createEqualityJoinConjuncts(Analyzer analyzer, TupleDescriptor dataTupleDesc, TupleDescriptor deleteTupleDesc) throws AnalysisException, ImpalaRuntimeException {
        HashMap<Integer, SlotDescriptor> fieldIdToIcebergColumn = new HashMap<Integer, SlotDescriptor>();
        SlotDescriptor dataSeqNumSlot = null;
        for (SlotDescriptor dataSlotDesc : dataTupleDesc.getSlots()) {
            if (dataSlotDesc.getVirtualColumnType() == TVirtualColumnType.ICEBERG_DATA_SEQUENCE_NUMBER) {
                dataSeqNumSlot = dataSlotDesc;
                continue;
            }
            if (!(dataSlotDesc.getColumn() instanceof IcebergColumn)) continue;
            IcebergColumn icebergCol = (IcebergColumn)dataSlotDesc.getColumn();
            fieldIdToIcebergColumn.put(icebergCol.getFieldId(), dataSlotDesc);
        }
        ArrayList<BinaryPredicate> eqPredicates = new ArrayList<BinaryPredicate>();
        ArrayList<BinaryPredicate> seqNumPredicate = new ArrayList<BinaryPredicate>();
        for (SlotDescriptor deleteSlotDesc : deleteTupleDesc.getSlots()) {
            if (deleteSlotDesc.getVirtualColumnType() == TVirtualColumnType.ICEBERG_DATA_SEQUENCE_NUMBER) {
                BinaryPredicate pred = new BinaryPredicate(BinaryPredicate.Operator.LT, new SlotRef(dataSeqNumSlot), new SlotRef(deleteSlotDesc));
                pred.analyze(analyzer);
                seqNumPredicate.add(pred);
                continue;
            }
            Preconditions.checkState((boolean)(deleteSlotDesc.getColumn() instanceof IcebergColumn));
            int fieldId = ((IcebergColumn)deleteSlotDesc.getColumn()).getFieldId();
            if (!fieldIdToIcebergColumn.containsKey(fieldId)) {
                throw new ImpalaRuntimeException("Field ID not found in table: " + fieldId);
            }
            SlotRef dataSlotRef = new SlotRef((SlotDescriptor)fieldIdToIcebergColumn.get(fieldId));
            SlotRef deleteSlotRef = new SlotRef(deleteSlotDesc);
            BinaryPredicate eqColPred = new BinaryPredicate(BinaryPredicate.Operator.NOT_DISTINCT, dataSlotRef, deleteSlotRef);
            eqColPred.analyze(analyzer);
            eqPredicates.add(eqColPred);
        }
        return new Pair<List<BinaryPredicate>, List<Expr>>(eqPredicates, seqNumPredicate);
    }

    private ColumnStats virtualInputFileNameStats() {
        ColumnStats ret = new ColumnStats(Type.STRING);
        ret.setNumDistinctValues(this.dataFilesWithDeletes_.size());
        return ret;
    }

    private ColumnStats virtualFilePositionStats() {
        ColumnStats ret = new ColumnStats(Type.BIGINT);
        ret.setNumDistinctValues(this.positionDeletesRecordCount_ / (long)this.dataFilesWithDeletes_.size());
        return ret;
    }

    private ColumnStats virtualDataSeqNumStats() {
        ColumnStats ret = new ColumnStats(Type.BIGINT);
        ret.setNumDistinctValues(this.equalityDeleteSequenceNumbers_.size());
        return ret;
    }

    private PlanNode createEqualityJoinNode(PlanNode positionJoinNode) throws ImpalaException {
        Preconditions.checkState((!this.equalityIdsToDeleteFiles_.isEmpty() ? 1 : 0) != 0);
        if (this.getIceTable().getPartitionSpecs().size() > 1) {
            throw new ImpalaRuntimeException("Equality delete files are not supported for tables with partition evolution");
        }
        PlanNode leftSideOfJoin = null;
        if (positionJoinNode != null) {
            leftSideOfJoin = positionJoinNode;
        } else {
            PlanNodeId dataScanNodeId = this.ctx_.getNextNodeId();
            IcebergScanNode dataScanNode = new IcebergScanNode(dataScanNodeId, this.tblRef_, this.conjuncts_, this.aggInfo_, this.dataFilesWithDeletes_, this.nonIdentityConjuncts_, this.getSkippedConjuncts(), this.snapshotId_);
            this.addAllSlotsForEqualityDeletes(this.tblRef_);
            dataScanNode.init(this.analyzer_);
            leftSideOfJoin = dataScanNode;
        }
        List<List<Integer>> orderedEqualityFieldIds = IcebergScanPlanner.getOrderedEqualityFieldIds(this.equalityDeletesRecordCount_);
        HashJoinNode joinNode = null;
        for (List<Integer> equalityIds : orderedEqualityFieldIds) {
            Set<HdfsPartition.FileDescriptor> equalityDeleteFiles = this.equalityIdsToDeleteFiles_.get(equalityIds);
            Preconditions.checkState((equalityDeleteFiles != null && !equalityDeleteFiles.isEmpty() ? 1 : 0) != 0);
            Long numRecordsInDeletes = this.equalityDeletesRecordCount_.get(equalityIds);
            Preconditions.checkState((numRecordsInDeletes != null && numRecordsInDeletes > 0L ? 1 : 0) != 0);
            PlanNodeId deleteScanNodeId = this.ctx_.getNextNodeId();
            IcebergEqualityDeleteTable deleteTable = new IcebergEqualityDeleteTable(this.getIceTable(), this.getIceTable().getName() + "-EQUALITY-DELETE-" + deleteScanNodeId.toString(), equalityDeleteFiles, equalityIds, numRecordsInDeletes);
            this.analyzer_.addVirtualTable(deleteTable);
            TableRef deleteTblRef = TableRef.newTableRef(this.analyzer_, Arrays.asList(deleteTable.getDb().getName(), deleteTable.getName()), this.tblRef_.getUniqueAlias() + "-equality-delete-" + deleteScanNodeId.toString());
            this.addSlotsForEqualityDeletes(equalityIds, deleteTblRef);
            IcebergScanNode deleteScanNode = new IcebergScanNode(deleteScanNodeId, deleteTblRef, Collections.emptyList(), this.aggInfo_, Lists.newArrayList(equalityDeleteFiles), Collections.emptyList(), Collections.emptyList(), this.snapshotId_);
            deleteScanNode.init(this.analyzer_);
            Pair<List<BinaryPredicate>, List<Expr>> equalityJoinConjuncts = this.createEqualityJoinConjuncts(this.analyzer_, this.tblRef_.getDesc(), deleteTblRef.getDesc());
            joinNode = new HashJoinNode(leftSideOfJoin, deleteScanNode, true, JoinNode.DistributionMode.NONE, JoinOperator.LEFT_ANTI_JOIN, (List)equalityJoinConjuncts.first, (List)equalityJoinConjuncts.second);
            joinNode.setId(this.ctx_.getNextNodeId());
            ((JoinNode)joinNode).init(this.analyzer_);
            leftSideOfJoin = joinNode;
        }
        return joinNode;
    }

    static List<List<Integer>> getOrderedEqualityFieldIds(Map<List<Integer>, Long> equalityDeletesRecordCount) {
        Preconditions.checkState((!equalityDeletesRecordCount.isEmpty() ? 1 : 0) != 0);
        return equalityDeletesRecordCount.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed().thenComparing((e1, e2) -> {
            List list1 = (List)e1.getKey();
            List list2 = (List)e2.getKey();
            if (list1.size() < list2.size()) {
                return 1;
            }
            if (list2.size() < list1.size()) {
                return -1;
            }
            for (int i = 0; i < list1.size(); ++i) {
                if ((Integer)list1.get(i) < (Integer)list2.get(i)) {
                    return -1;
                }
                if ((Integer)list2.get(i) >= (Integer)list1.get(i)) continue;
                return 1;
            }
            return 0;
        })).map(e -> (List)e.getKey()).collect(Collectors.toList());
    }

    private void filterFileDescriptors() throws ImpalaException {
        Preconditions.checkState((boolean)this.allEqualityFieldIds_.isEmpty());
        Preconditions.checkState((boolean)this.equalityIdsToDeleteFiles_.isEmpty());
        TimeTravelSpec timeTravelSpec = this.tblRef_.getTimeTravelSpec();
        try (CloseableIterable<FileScanTask> fileScanTasks = IcebergUtil.planFiles(this.getIceTable(), new ArrayList<Expression>(this.impalaIcebergPredicateMapping_.keySet()), timeTravelSpec);){
            long dataFilesCacheMisses = 0L;
            for (FileScanTask fileScanTask : fileScanTasks) {
                Expression residualExpr = fileScanTask.residual();
                if (residualExpr != null && !(residualExpr instanceof True)) {
                    this.residualExpressions_.add(residualExpr);
                }
                Pair<HdfsPartition.FileDescriptor, Boolean> fileDesc = this.getFileDescriptor(fileScanTask.file());
                if (!((Boolean)fileDesc.second).booleanValue()) {
                    ++dataFilesCacheMisses;
                }
                if (fileScanTask.deletes().isEmpty()) {
                    this.dataFilesWithoutDeletes_.add((HdfsPartition.FileDescriptor)fileDesc.first);
                    continue;
                }
                this.dataFilesWithDeletes_.add((HdfsPartition.FileDescriptor)fileDesc.first);
                for (DeleteFile delFile : fileScanTask.deletes()) {
                    Pair<HdfsPartition.FileDescriptor, Boolean> delFileDesc = this.getFileDescriptor((ContentFile)delFile);
                    if (!((Boolean)delFileDesc.second).booleanValue()) {
                        ++dataFilesCacheMisses;
                    }
                    if (delFile.content() == FileContent.EQUALITY_DELETES) {
                        this.addEqualityDeletesAndIds((HdfsPartition.FileDescriptor)delFileDesc.first);
                        continue;
                    }
                    Preconditions.checkState((delFile.content() == FileContent.POSITION_DELETES ? 1 : 0) != 0);
                    this.positionDeleteFiles_.add((HdfsPartition.FileDescriptor)delFileDesc.first);
                }
            }
            if (dataFilesCacheMisses > 0L) {
                Preconditions.checkState((timeTravelSpec != null ? 1 : 0) != 0);
                LOG.info("File descriptors had to be loaded on demand during time travel: {}", (Object)dataFilesCacheMisses);
            }
        }
        catch (IOException | TableLoadingException e) {
            throw new ImpalaRuntimeException(String.format("Failed to load data files for Iceberg table: %s", this.getIceTable().getFullName()), e);
        }
        this.updateDeleteStatistics();
    }

    private void addEqualityDeletesAndIds(HdfsPartition.FileDescriptor fd) {
        FbIcebergMetadata fileMetadata = fd.getFbFileMetadata().icebergMetadata();
        ArrayList<Integer> eqFieldIdList = new ArrayList<Integer>();
        for (int i = 0; i < fileMetadata.equalityFieldIdsLength(); ++i) {
            eqFieldIdList.add(fileMetadata.equalityFieldIds(i));
            this.allEqualityFieldIds_.add(fileMetadata.equalityFieldIds(i));
        }
        if (!this.equalityIdsToDeleteFiles_.containsKey(eqFieldIdList)) {
            this.equalityIdsToDeleteFiles_.put(eqFieldIdList, new HashSet());
        }
        this.equalityIdsToDeleteFiles_.get(eqFieldIdList).add(fd);
    }

    private void initEqualityIds(List<HdfsPartition.FileDescriptor> equalityDeleteFiles) {
        Preconditions.checkState((boolean)this.allEqualityFieldIds_.isEmpty());
        Preconditions.checkState((boolean)this.equalityIdsToDeleteFiles_.isEmpty());
        for (HdfsPartition.FileDescriptor fd : equalityDeleteFiles) {
            this.addEqualityDeletesAndIds(fd);
        }
    }

    private void filterConjuncts() {
        if (this.residualExpressions_.isEmpty()) {
            this.conjuncts_.removeAll(this.impalaIcebergPredicateMapping_.values());
            return;
        }
        if (!this.analyzer_.getQueryOptions().iceberg_predicate_pushdown_subsetting) {
            return;
        }
        this.trySubsettingPredicatesBeingPushedDown();
    }

    private boolean trySubsettingPredicatesBeingPushedDown() {
        long startTime = System.currentTimeMillis();
        ArrayList<Expr> expressionsToRetain = new ArrayList<Expr>(this.untranslatedExpressions_);
        for (Expression expression : this.residualExpressions_) {
            List locatedExpressions = (List)ExpressionVisitors.visit((Expression)expression, (ExpressionVisitors.ExpressionVisitor)new IcebergExpressionCollector());
            for (Expression located : locatedExpressions) {
                Expr expr2 = this.impalaIcebergPredicateMapping_.get(located);
                if (expr2 == null) {
                    return false;
                }
                expressionsToRetain.add(expr2);
            }
        }
        this.skippedExpressions_.addAll(this.conjuncts_.stream().filter(expr -> !expressionsToRetain.contains(expr)).collect(Collectors.toList()));
        this.conjuncts_ = expressionsToRetain;
        LOG.debug("Iceberg predicate pushdown subsetting took {} ms", (Object)(System.currentTimeMillis() - startTime));
        return true;
    }

    private List<Expr> getSkippedConjuncts() {
        if (!this.residualExpressions_.isEmpty()) {
            return this.skippedExpressions_;
        }
        return new ArrayList<Expr>(this.impalaIcebergPredicateMapping_.values());
    }

    private void updateDeleteStatistics() {
        for (HdfsPartition.FileDescriptor fileDescriptor : this.dataFilesWithDeletes_) {
            this.updateDataFilesWithDeletesStatistics(fileDescriptor);
        }
        for (HdfsPartition.FileDescriptor fileDescriptor : this.positionDeleteFiles_) {
            this.updatePositionDeleteFilesStatistics(fileDescriptor);
        }
        for (Map.Entry entry : this.equalityIdsToDeleteFiles_.entrySet()) {
            this.updateEqualityDeleteFilesStatistics((List)entry.getKey(), (Set)entry.getValue());
        }
    }

    private void updateDataFilesWithDeletesStatistics(HdfsPartition.FileDescriptor fd) {
        String path = fd.getAbsolutePath(this.getIceTable().getLocation());
        long pathSize = path.length();
        this.dataFilesWithDeletesSumPaths_ += pathSize;
        if (pathSize > this.dataFilesWithDeletesMaxPath_) {
            this.dataFilesWithDeletesMaxPath_ = pathSize;
        }
    }

    private void updatePositionDeleteFilesStatistics(HdfsPartition.FileDescriptor fd) {
        this.positionDeletesRecordCount_ += this.getRecordCount(fd);
    }

    private void updateEqualityDeleteFilesStatistics(List<Integer> equalityIds, Set<HdfsPartition.FileDescriptor> fileDescriptors) {
        long numRecords = 0L;
        for (HdfsPartition.FileDescriptor fd : fileDescriptors) {
            numRecords += this.getRecordCount(fd);
            this.equalityDeleteSequenceNumbers_.add(fd.getFbFileMetadata().icebergMetadata().dataSequenceNumber());
        }
        this.equalityDeletesRecordCount_.put(equalityIds, numRecords);
    }

    private long getRecordCount(HdfsPartition.FileDescriptor fd) {
        long recordCount = fd.getFbFileMetadata().icebergMetadata().recordCount();
        if (recordCount == -1L) {
            return 1000L;
        }
        return recordCount;
    }

    private FeIcebergTable getIceTable() {
        return (FeIcebergTable)this.tblRef_.getTable();
    }

    private TColumnStats getFilePathStats() {
        TColumnStats colStats = new TColumnStats();
        colStats.avg_size = this.dataFilesWithDeletesSumPaths_ / (long)this.dataFilesWithDeletes_.size();
        colStats.max_size = this.dataFilesWithDeletesMaxPath_;
        colStats.num_distinct_values = this.dataFilesWithDeletes_.size();
        colStats.num_nulls = 0L;
        return colStats;
    }

    private Pair<HdfsPartition.FileDescriptor, Boolean> getFileDescriptor(ContentFile cf) throws ImpalaRuntimeException {
        HdfsPartition.FileDescriptor fileDesc;
        boolean cachehit = true;
        String pathHash = IcebergUtil.getFilePathHash(cf);
        IcebergContentFileStore fileStore = this.getIceTable().getContentFileStore();
        HdfsPartition.FileDescriptor fileDescriptor = fileDesc = cf.content() == FileContent.DATA ? fileStore.getDataFileDescriptor(pathHash) : fileStore.getDeleteFileDescriptor(pathHash);
        if (fileDesc == null) {
            if (this.tblRef_.getTimeTravelSpec() == null) {
                throw new ImpalaRuntimeException("Cannot find file in cache: " + cf.path() + " with snapshot id: " + this.getIceTable().snapshotId());
            }
            fileDesc = fileStore.getOldFileDescriptor(pathHash);
            if (fileDesc != null) {
                return new Pair<HdfsPartition.FileDescriptor, Boolean>(fileDesc, true);
            }
            cachehit = false;
            try {
                fileDesc = FeIcebergTable.Utils.getFileDescriptor(cf, this.getIceTable());
            }
            catch (IOException ex) {
                throw new ImpalaRuntimeException("Cannot load file descriptor for " + cf.path(), ex);
            }
            if (fileDesc == null) {
                throw new ImpalaRuntimeException("Cannot load file descriptor for: " + cf.path());
            }
            fileDesc = fileDesc.cloneWithFileMetadata(IcebergUtil.createIcebergMetadata(this.getIceTable(), cf));
            fileStore.addOldFileDescriptor(pathHash, fileDesc);
        }
        return new Pair<HdfsPartition.FileDescriptor, Boolean>(fileDesc, cachehit);
    }

    private void extractIcebergConjuncts() throws ImpalaException {
        Expr expr;
        int i;
        boolean isPartitionColumnIncluded = false;
        HashMap<SlotId, SlotDescriptor> idToSlotDesc = new HashMap<SlotId, SlotDescriptor>();
        boolean[] identityConjunctIndex = new boolean[this.conjuncts_.size()];
        for (SlotDescriptor slotDesc : this.tblRef_.getDesc().getSlots()) {
            idToSlotDesc.put(slotDesc.getId(), slotDesc);
        }
        for (i = 0; i < this.conjuncts_.size(); ++i) {
            expr = this.conjuncts_.get(i);
            if (!this.isPartitionColumnIncluded(expr, idToSlotDesc)) continue;
            isPartitionColumnIncluded = true;
            if (!this.isIdentityPartitionIncluded(expr, idToSlotDesc)) continue;
            identityConjunctIndex[i] = true;
        }
        if (!isPartitionColumnIncluded) {
            this.nonIdentityConjuncts_ = this.conjuncts_;
            return;
        }
        for (i = 0; i < this.conjuncts_.size(); ++i) {
            expr = this.conjuncts_.get(i);
            if (this.tryConvertIcebergPredicate(expr)) {
                if (identityConjunctIndex[i]) continue;
                this.nonIdentityConjuncts_.add(expr);
                continue;
            }
            this.nonIdentityConjuncts_.add(expr);
        }
    }

    private boolean isPartitionColumnIncluded(Expr expr, Map<SlotId, SlotDescriptor> idToSlotDesc) {
        return this.hasPartitionTransformType(expr, idToSlotDesc, transformType -> transformType != TIcebergPartitionTransformType.VOID);
    }

    private boolean isIdentityPartitionIncluded(Expr expr, Map<SlotId, SlotDescriptor> idToSlotDesc) {
        return this.hasPartitionTransformType(expr, idToSlotDesc, transformType -> transformType == TIcebergPartitionTransformType.IDENTITY);
    }

    private boolean hasPartitionTransformType(Expr expr, Map<SlotId, SlotDescriptor> idToSlotDesc, Predicate<TIcebergPartitionTransformType> pred) {
        ArrayList tupleIds = Lists.newArrayList();
        ArrayList slotIds = Lists.newArrayList();
        expr.getIds(tupleIds, slotIds);
        if (tupleIds.size() != 1) {
            return false;
        }
        if (!((TupleId)tupleIds.get(0)).equals(this.tblRef_.getDesc().getId())) {
            return false;
        }
        for (SlotId sId : slotIds) {
            Column col;
            SlotDescriptor slotDesc = idToSlotDesc.get(sId);
            if (slotDesc == null || (col = slotDesc.getColumn()) == null) continue;
            Preconditions.checkState((boolean)(col instanceof IcebergColumn));
            IcebergColumn iceCol = (IcebergColumn)col;
            TIcebergPartitionTransformType transformType = IcebergUtil.getPartitionTransformType(iceCol, this.getIceTable().getDefaultPartitionSpec());
            if (!pred.test(transformType)) continue;
            return true;
        }
        return false;
    }

    private boolean tryConvertIcebergPredicate(Expr expr) {
        IcebergPredicateConverter converter = new IcebergPredicateConverter(this.getIceTable().getIcebergSchema(), this.analyzer_);
        try {
            Expression predicate = converter.convert(expr);
            this.impalaIcebergPredicateMapping_.put(predicate, expr);
            LOG.debug("Push down the predicate: {} to iceberg", (Object)predicate);
            return true;
        }
        catch (ImpalaException e) {
            this.untranslatedExpressions_.add(expr);
            return false;
        }
    }
}

