/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergScanNode
extends HdfsScanNode {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergScanNode.class);
    private List<HdfsPartition.FileDescriptor> fileDescs_;
    private boolean filesAreSorted_ = false;
    private List<Expr> nonIdentityConjuncts_;
    private List<Expr> skippedConjuncts_;
    private final long snapshotId_;
    private final PlanNodeId deleteFileScanNodeId;

    public IcebergScanNode(PlanNodeId id, TableRef tblRef, List<Expr> conjuncts, MultiAggregateInfo aggInfo, List<HdfsPartition.FileDescriptor> fileDescs, List<Expr> nonIdentityConjuncts, List<Expr> skippedConjuncts, long snapshotId) throws ImpalaRuntimeException {
        this(id, tblRef, conjuncts, aggInfo, fileDescs, nonIdentityConjuncts, skippedConjuncts, null, snapshotId);
    }

    public IcebergScanNode(PlanNodeId id, TableRef tblRef, List<Expr> conjuncts, MultiAggregateInfo aggInfo, List<HdfsPartition.FileDescriptor> fileDescs, List<Expr> nonIdentityConjuncts, List<Expr> skippedConjuncts, PlanNodeId deleteId, long snapshotId) throws ImpalaRuntimeException {
        super(id, tblRef.getDesc(), conjuncts, IcebergScanNode.getIcebergPartition(((FeIcebergTable)tblRef.getTable()).getFeFsTable()), tblRef, aggInfo, null, false);
        Preconditions.checkState((this.partitions_.size() == 1 ? 1 : 0) != 0);
        this.fileDescs_ = fileDescs;
        if (((FeIcebergTable)tblRef.getTable()).isPartitioned()) {
            this.fileDescs_ = new ArrayList<HdfsPartition.FileDescriptor>(this.fileDescs_);
            Collections.sort(this.fileDescs_);
            this.filesAreSorted_ = true;
        }
        this.nonIdentityConjuncts_ = nonIdentityConjuncts;
        this.snapshotId_ = snapshotId;
        boolean hasParquet = false;
        boolean hasOrc = false;
        boolean hasAvro = false;
        for (HdfsPartition.FileDescriptor fileDesc : this.fileDescs_) {
            byte fileFormat = fileDesc.getFbFileMetadata().icebergMetadata().fileFormat();
            if (fileFormat == 0) {
                hasParquet = true;
                continue;
            }
            if (fileFormat == 1) {
                hasOrc = true;
                continue;
            }
            if (fileFormat == 2) {
                hasAvro = true;
                continue;
            }
            throw new ImpalaRuntimeException(String.format("Invalid Iceberg file format of file: %s", fileDesc.getAbsolutePath()));
        }
        if (hasParquet) {
            this.fileFormats_.add(HdfsFileFormat.PARQUET);
        }
        if (hasOrc) {
            this.fileFormats_.add(HdfsFileFormat.ORC);
        }
        if (hasAvro) {
            this.fileFormats_.add(HdfsFileFormat.AVRO);
        }
        this.skippedConjuncts_ = skippedConjuncts;
        this.deleteFileScanNodeId = deleteId;
    }

    @Override
    protected void computeCardinalities(Analyzer analyzer) {
        this.cardinality_ = 0L;
        if (this.sampledFiles_ != null) {
            for (List sampledFileDescs : this.sampledFiles_.values()) {
                for (HdfsPartition.FileDescriptor fd : sampledFileDescs) {
                    this.cardinality_ += fd.getFbFileMetadata().icebergMetadata().recordCount();
                }
            }
        } else {
            for (HdfsPartition.FileDescriptor fd : this.fileDescs_) {
                this.cardinality_ += fd.getFbFileMetadata().icebergMetadata().recordCount();
            }
        }
        for (Type t : this.desc_.getPath().getMatchedTypes()) {
            if (!t.isCollectionType()) continue;
            this.cardinality_ *= 10L;
        }
        this.inputCardinality_ = this.cardinality_;
        if (this.cardinality_ > 0L) {
            double selectivity = IcebergScanNode.computeCombinedSelectivity(this.nonIdentityConjuncts_);
            if (LOG.isTraceEnabled()) {
                LOG.trace("cardinality_=" + Long.toString(this.cardinality_) + " sel=" + Double.toString(selectivity));
            }
            this.cardinality_ = this.applySelectivity(this.cardinality_, selectivity);
        }
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        if (this.countStarSlot_ != null) {
            this.inputCardinality_ = this.fileDescs_.size();
            this.cardinality_ = this.fileDescs_.size();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("IcebergScanNode: cardinality_=" + Long.toString(this.cardinality_));
        }
    }

    private static List<? extends FeFsPartition> getIcebergPartition(FeFsTable feFsTable) {
        Collection<? extends FeFsPartition> partitions = FeCatalogUtils.loadAllPartitions(feFsTable);
        return new ArrayList<FeFsPartition>(partitions);
    }

    @Override
    protected List<HdfsPartition.FileDescriptor> getFileDescriptorsWithLimit(FeFsPartition partition, boolean fsHasBlocks, long limit) {
        if (limit != -1L) {
            long cnt = 0L;
            ArrayList<HdfsPartition.FileDescriptor> ret = new ArrayList<HdfsPartition.FileDescriptor>();
            for (HdfsPartition.FileDescriptor fd : this.fileDescs_) {
                if (cnt == limit) break;
                ret.add(fd);
                ++cnt;
            }
            return ret;
        }
        return this.fileDescs_;
    }

    @Override
    protected Map<Long, List<HdfsPartition.FileDescriptor>> getFilesSample(long percentBytes, long minSampleBytes, long randomSeed) {
        HdfsPartition.FileDescriptor fd;
        Preconditions.checkState((percentBytes >= 0L && percentBytes <= 100L ? 1 : 0) != 0);
        Preconditions.checkState((minSampleBytes >= 0L ? 1 : 0) != 0);
        ArrayList orderedFds = Lists.newArrayList(this.fileDescs_);
        if (!this.filesAreSorted_) {
            Collections.sort(orderedFds);
        }
        Preconditions.checkState((this.partitions_.size() == 1 ? 1 : 0) != 0);
        FeFsPartition part = (FeFsPartition)this.partitions_.get(0);
        long totalBytes = 0L;
        for (HdfsPartition.FileDescriptor fd2 : orderedFds) {
            totalBytes += fd2.getFileLength();
        }
        int numFilesRemaining = orderedFds.size();
        double fracPercentBytes = (double)percentBytes / 100.0;
        long targetBytes = Math.round((double)totalBytes * fracPercentBytes);
        targetBytes = Math.max(targetBytes, minSampleBytes);
        Random rnd = new Random(randomSeed);
        ArrayList sampleFiles = Lists.newArrayList();
        for (long selectedBytes = 0L; selectedBytes < targetBytes && numFilesRemaining > 0; selectedBytes += fd.getFileLength(), --numFilesRemaining) {
            int selectedIdx = rnd.nextInt(numFilesRemaining);
            fd = (HdfsPartition.FileDescriptor)orderedFds.get(selectedIdx);
            sampleFiles.add(fd);
            orderedFds.set(selectedIdx, orderedFds.get(numFilesRemaining - 1));
        }
        HashMap<Long, List<HdfsPartition.FileDescriptor>> result = new HashMap<Long, List<HdfsPartition.FileDescriptor>>();
        result.put(part.getId(), sampleFiles);
        return result;
    }

    @Override
    protected void toThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        super.toThrift(msg, serialCtx);
        Preconditions.checkNotNull((Object)msg.hdfs_scan_node);
        if (this.deleteFileScanNodeId != null) {
            msg.hdfs_scan_node.setDeleteFileScanNodeId(this.deleteFileScanNodeId.asInt());
        }
    }

    @Override
    protected String getDerivedExplainString(String indentPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(indentPrefix + "Iceberg snapshot id: " + String.valueOf(this.snapshotId_) + "\n");
        if (!this.skippedConjuncts_.isEmpty()) {
            output.append(indentPrefix + String.format("skipped Iceberg predicates: %s\n", Expr.getExplainString(this.skippedConjuncts_, detailLevel)));
        }
        return output.toString();
    }
}

