/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TIcebergMetadataScanNode;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.thrift.TTableName;

public class IcebergMetadataScanNode
extends ScanNode {
    protected final String metadataTableName_;

    protected IcebergMetadataScanNode(PlanNodeId id, List<Expr> conjuncts, TableRef tblRef) {
        super(id, tblRef.getDesc(), "SCAN ICEBERG METADATA");
        this.conjuncts_ = conjuncts;
        this.metadataTableName_ = ((IcebergMetadataTable)tblRef.getTable()).getMetadataTableName();
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        this.scanRangeSpecs_ = new TScanRangeSpec();
        this.assignConjuncts(analyzer);
        this.conjuncts_ = IcebergMetadataScanNode.orderConjunctsByCost(this.conjuncts_);
        analyzer.materializeSlots(this.conjuncts_);
        this.computeMemLayout(analyzer);
        this.computeStats(analyzer);
        this.numInstances_ = 1;
        this.numNodes_ = 1;
    }

    @Override
    protected String getDisplayLabelDetail() {
        Preconditions.checkNotNull((Object)this.desc_.getPath());
        if (this.desc_.hasExplicitAlias()) {
            return this.desc_.getPath().toString() + " " + this.desc_.getAlias();
        }
        return this.desc_.getPath().toString();
    }

    @Override
    protected String getNodeExplainString(String rootPrefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s [%s]\n", rootPrefix, this.getDisplayLabel(), this.getDisplayLabelDetail()));
        return output.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.iceberg_scan_metadata_node = new TIcebergMetadataScanNode();
        msg.node_type = TPlanNodeType.ICEBERG_METADATA_SCAN_NODE;
        msg.iceberg_scan_metadata_node.table_name = new TTableName(this.desc_.getTableName().getDb(), this.desc_.getTableName().getTbl());
        msg.iceberg_scan_metadata_node.metadata_table_name = this.metadataTableName_;
        msg.iceberg_scan_metadata_node.tuple_id = this.desc_.getId().asInt();
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }
}

