/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.IcebergScanNode;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.thrift.TEqJoinCondition;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TIcebergDeleteNode;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergDeleteNode
extends JoinNode {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergDeleteNode.class);

    public IcebergDeleteNode(PlanNode outer, PlanNode inner, List<BinaryPredicate> eqJoinConjuncts) {
        super(outer, inner, true, JoinNode.DistributionMode.NONE, JoinOperator.ICEBERG_DELETE_JOIN, eqJoinConjuncts, Collections.emptyList(), "ICEBERG DELETE");
        Preconditions.checkNotNull(eqJoinConjuncts);
        Preconditions.checkState((this.joinOp_ == JoinOperator.ICEBERG_DELETE_JOIN ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
        Preconditions.checkState((boolean)this.runtimeFilters_.isEmpty());
    }

    @Override
    public boolean isBlockingJoinNode() {
        return true;
    }

    @Override
    public List<BinaryPredicate> getEqJoinConjuncts() {
        return this.eqJoinConjuncts_;
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        ArrayList<BinaryPredicate> newEqJoinConjuncts = new ArrayList<BinaryPredicate>();
        ExprSubstitutionMap combinedChildSmap = this.getCombinedChildSmap();
        for (Expr c : this.eqJoinConjuncts_) {
            BinaryPredicate eqPred = (BinaryPredicate)c.substitute(combinedChildSmap, analyzer, false);
            Type t0 = ((Expr)eqPred.getChild(0)).getType();
            Type t1 = ((Expr)eqPred.getChild(1)).getType();
            Preconditions.checkState((boolean)t0.matchesType(t1));
            BinaryPredicate newEqPred = new BinaryPredicate(eqPred.getOp(), (Expr)eqPred.getChild(0), (Expr)eqPred.getChild(1));
            newEqPred.analyze(analyzer);
            newEqJoinConjuncts.add(newEqPred);
        }
        this.eqJoinConjuncts_ = newEqJoinConjuncts;
        this.orderJoinConjunctsByCost();
        this.computeStats(analyzer);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        long leftCardWithSelectivity = ((PlanNode)this.getChild((int)0)).cardinality_;
        long rightCard = ((PlanNode)this.getChild((int)1)).cardinality_;
        Preconditions.checkState((leftCardWithSelectivity > 0L ? 1 : 0) != 0);
        Preconditions.checkState((rightCard > 0L ? 1 : 0) != 0);
        double leftSelectivity = ((PlanNode)this.getChild(0)).computeSelectivity();
        long rightCardWithSelectivity = (long)(leftSelectivity * (double)rightCard);
        this.cardinality_ = Math.max(1L, leftCardWithSelectivity - rightCardWithSelectivity);
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("eqJoinConjuncts_", (Object)this.eqJoinConjunctsDebugString()).addValue((Object)super.debugString()).toString();
    }

    private String eqJoinConjunctsDebugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (Expr entry : this.eqJoinConjuncts_) {
            helper.add("lhs", entry.getChild(0)).add("rhs", entry.getChild(1));
        }
        return helper.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.ICEBERG_DELETE_NODE;
        msg.join_node = this.joinNodeToThrift();
        msg.join_node.iceberg_delete_node = new TIcebergDeleteNode();
        msg.join_node.iceberg_delete_node.setEq_join_conjuncts(this.getThriftEquiJoinConjuncts());
    }

    public List<TEqJoinCondition> getThriftEquiJoinConjuncts() {
        ArrayList<TEqJoinCondition> equiJoinConjuncts = new ArrayList<TEqJoinCondition>(this.eqJoinConjuncts_.size());
        for (BinaryPredicate bp : this.eqJoinConjuncts_) {
            TEqJoinCondition eqJoinCondition = new TEqJoinCondition(((Expr)bp.getChild(0)).treeToThrift(), ((Expr)bp.getChild(1)).treeToThrift(), bp.getOp() == BinaryPredicate.Operator.NOT_DISTINCT);
            equiJoinConjuncts.add(eqJoinCondition);
        }
        return equiJoinConjuncts;
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s [%s]\n", prefix, this.getDisplayLabel(), this.getDisplayLabelDetail()));
        if (!(detailLevel.ordinal() <= TExplainLevel.MINIMAL.ordinal() || this.isDeleteRowsJoin_ && detailLevel.ordinal() < TExplainLevel.EXTENDED.ordinal())) {
            output.append(detailPrefix + "equality predicates: ");
            for (int i = 0; i < this.eqJoinConjuncts_.size(); ++i) {
                Expr eqConjunct = (Expr)this.eqJoinConjuncts_.get(i);
                output.append(eqConjunct.toSql());
                if (i + 1 == this.eqJoinConjuncts_.size()) continue;
                output.append(", ");
            }
            output.append("\n");
        }
        return output.toString();
    }

    @Override
    public Pair<ResourceProfile, ResourceProfile> computeJoinResourceProfile(TQueryOptions queryOptions) {
        Preconditions.checkState((((PlanNode)this.getChild(1)).getCardinality() != -1L ? 1 : 0) != 0);
        Preconditions.checkState((((PlanNode)this.getChild(1)).getAvgRowSize() != -1.0f ? 1 : 0) != 0);
        Preconditions.checkState((this.fragment_.getNumNodes() > 0 ? 1 : 0) != 0);
        long rhsCard = ((PlanNode)this.getChild(1)).getCardinality();
        long rhsNdv = 1L;
        for (Expr eqJoinPredicate : this.eqJoinConjuncts_) {
            long rhsPdNdv = IcebergDeleteNode.getNdv((Expr)eqJoinPredicate.getChild(1));
            if ((rhsPdNdv = Math.min(rhsPdNdv, rhsCard)) == -1L) continue;
            rhsNdv = PlanNode.checkedMultiply(rhsNdv, rhsPdNdv);
        }
        int numberOfDataFilesWithDelete = ((IcebergScanNode)this.getChild(0)).getFileDescriptorsWithLimit(null, false, -1L).size();
        double avgFilePathLen = ((PlanNode)this.getChild(1)).getAvgRowSize();
        long filePathsSize = (long)Math.ceil((double)numberOfDataFilesWithDelete * avgFilePathLen);
        int BYTES_PER_POSITION = 2;
        int PER_ROARING_BITMAP_OVERHEAD = 512;
        long roaringBitmapOverhead = 512 * numberOfDataFilesWithDelete;
        long roaringBitmapSize = (long)Math.ceil(2L * rhsCard) + roaringBitmapOverhead;
        long totalBuildDataBytes = filePathsSize + roaringBitmapSize;
        int numBuildInstances = this.fragment_.getNumNodes();
        long perBuildInstanceMemEstimate = totalBuildDataBytes / (long)numBuildInstances;
        ResourceProfile probeProfile = new ResourceProfileBuilder().setMemEstimateBytes(0L).build();
        ResourceProfile buildProfile = new ResourceProfileBuilder().setMemEstimateBytes(perBuildInstanceMemEstimate).setMinMemReservationBytes(perBuildInstanceMemEstimate).build();
        return Pair.create(probeProfile, buildProfile);
    }

    @Override
    public Pair<ProcessingCost, ProcessingCost> computeJoinProcessingCost() {
        float eqJoinPredicateEvalCost = ExprUtil.computeExprsTotalCost(this.eqJoinConjuncts_);
        ProcessingCost probeProcessingCost = ProcessingCost.basicCost(this.getDisplayLabel() + " Probe side (eqJoinConjuncts_)", this.getProbeCardinalityForCosting(), eqJoinPredicateEvalCost);
        long buildCardinality = Math.max(0L, ((PlanNode)this.getChild(1)).getCardinality());
        ProcessingCost buildProcessingCost = ProcessingCost.basicCost(this.getDisplayLabel() + " Build side", buildCardinality, eqJoinPredicateEvalCost);
        return Pair.create(probeProcessingCost, buildProcessingCost);
    }
}

