/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.TableSink;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TIcebergDeleteSink;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TTableSink;
import org.apache.impala.thrift.TTableSinkType;

public class IcebergBufferedDeleteSink
extends TableSink {
    private final int deleteTableId_;
    protected final List<Expr> partitionKeyExprs_;

    public IcebergBufferedDeleteSink(FeIcebergTable targetTable, List<Expr> partitionKeyExprs, List<Expr> outputExprs) {
        this(targetTable, partitionKeyExprs, outputExprs, 0);
    }

    public IcebergBufferedDeleteSink(FeIcebergTable targetTable, List<Expr> partitionKeyExprs, List<Expr> outputExprs, int deleteTableId) {
        super(targetTable, TableSink.Op.DELETE, outputExprs);
        this.partitionKeyExprs_ = partitionKeyExprs;
        this.deleteTableId_ = deleteTableId;
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }

    @Override
    public void computeResourceProfile(TQueryOptions queryOptions) {
        long perInstanceMemEstimate;
        PlanNode inputNode = this.fragment_.getPlanRoot();
        int numInstances = this.fragment_.getNumInstances();
        long perPartitionMemReq = 0x20000000L;
        long bufferedData = 0x1000000L;
        if (inputNode.getCardinality() == -1L || inputNode.getAvgRowSize() == -1.0f) {
            perInstanceMemEstimate = 0x21000000L;
        } else {
            long perInstanceInputCardinality = Math.max(1L, inputNode.getCardinality() / (long)numInstances);
            perInstanceMemEstimate = (long)Math.ceil((float)perInstanceInputCardinality * inputNode.getAvgRowSize());
        }
        this.resourceProfile_ = ResourceProfile.noReservation(perInstanceMemEstimate);
    }

    @Override
    public void appendSinkExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel, StringBuilder output) {
        output.append(String.format("%sBUFFERED DELETE FROM ICEBERG [%s]\n", prefix, this.targetTable_.getFullName()));
        if (explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(detailPrefix + "output exprs: ").append(Expr.getExplainString(this.outputExprs_, explainLevel) + "\n");
            if (!this.partitionKeyExprs_.isEmpty()) {
                output.append(detailPrefix + "partition keys: ").append(Expr.getExplainString(this.partitionKeyExprs_, explainLevel) + "\n");
            }
        }
    }

    @Override
    protected String getLabel() {
        return "ICEBERG BUFFERED DELETER";
    }

    @Override
    protected void toThriftImpl(TDataSink tsink) {
        TIcebergDeleteSink icebergDeleteSink = new TIcebergDeleteSink();
        icebergDeleteSink.setPartition_key_exprs(Expr.treesToThrift(this.partitionKeyExprs_));
        TTableSink tTableSink = new TTableSink(0, TTableSinkType.HDFS, this.sinkOp_.toThrift());
        tTableSink.iceberg_delete_sink = icebergDeleteSink;
        tTableSink.setTarget_table_id(this.deleteTableId_);
        tsink.table_sink = tTableSink;
        tsink.output_exprs = Expr.treesToThrift(this.outputExprs_);
    }

    @Override
    protected TDataSinkType getSinkType() {
        return TDataSinkType.TABLE_SINK;
    }

    @Override
    public void collectExprs(List<Expr> exprs) {
        exprs.addAll(this.partitionKeyExprs_);
        exprs.addAll(this.outputExprs_);
    }

    @Override
    public void computeRowConsumptionAndProductionToCost() {
        super.computeRowConsumptionAndProductionToCost();
        this.fragment_.setFixedInstanceCount(this.fragment_.getNumInstances());
    }
}

