/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.IsNotEmptyPredicate;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TableSampleClause;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsCompression;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.NotImplementedException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.fb.FbFileBlock;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.Planner;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TFileSplitGeneratorSpec;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.THdfsFileSplit;
import org.apache.impala.thrift.THdfsScanNode;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TOverlapPredicateDesc;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TReplicaPreference;
import org.apache.impala.thrift.TRuntimeFilterType;
import org.apache.impala.thrift.TScanRange;
import org.apache.impala.thrift.TScanRangeLocation;
import org.apache.impala.thrift.TScanRangeLocationList;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.BitUtil;
import org.apache.impala.util.ExecutorMembershipSnapshot;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsScanNode
extends ScanNode {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsScanNode.class);
    private static final Configuration CONF = new Configuration();
    private static final long MAX_IO_BUFFERS_PER_THREAD = 10L;
    private static final int MAX_THREAD_TOKENS_PER_CORE = 3;
    private static final long MIN_MEMORY_ESTIMATE = 0x100000L;
    private static final long DEFAULT_COLUMN_SCAN_RANGE_RESERVATION = 0x400000L;
    private static final long PARQUET_FOOTER_SIZE = 102400L;
    private static final long ORC_FOOTER_SIZE = 16384L;
    private static double ESTIMATED_COMPRESSION_FACTOR_UNCOMPRESSED = 1.0;
    private static double ESTIMATED_COMPRESSION_FACTOR_LEGACY = 3.58;
    private static double ESTIMATED_COMPRESSION_FACTOR_COLUMNAR = 4.97;
    private static long PARTITION_KEY_SCAN_INPUT_CARDINALITY_ADJUSTMENT_FACTOR = 100L;
    private static Set<HdfsFileFormat> VALID_LEGACY_FORMATS = ImmutableSet.builder().add((Object)HdfsFileFormat.RC_FILE).add((Object)HdfsFileFormat.TEXT).add((Object)HdfsFileFormat.SEQUENCE_FILE).add((Object)HdfsFileFormat.AVRO).add((Object)HdfsFileFormat.JSON).build();
    private static Set<HdfsFileFormat> VALID_COLUMNAR_FORMATS = ImmutableSet.builder().add((Object)HdfsFileFormat.PARQUET).add((Object)HdfsFileFormat.HUDI_PARQUET).add((Object)HdfsFileFormat.ORC).add((Object)HdfsFileFormat.ICEBERG).build();
    private static final double COST_COEFFICIENT_COLUMNAR_BYTES_MATERIALIZED = 0.0144;
    private static final double COST_COEFFICIENT_NONCOLUMNAR_BYTES_SCANNED = 0.0354;
    private static final double COST_COEFFICIENT_COLUMNAR_PREDICATE_EVAL = 0.0281;
    private static final double COST_COEFFICIENT_NONCOLUMNAR_PREDICATE_EVAL = 0.0549;
    private double DEFAULT_ROW_WIDTH_ESTIMATE = 1.0;
    private final FeFsTable tbl_;
    protected final List<FeFsPartition> partitions_;
    protected List<FeFsPartition> sampledPartitions_ = null;
    private final TableSampleClause sampleParams_;
    private final TReplicaPreference replicaPreference_;
    private final boolean randomReplica_;
    private Map<FileSystemUtil.FsType, Long> numPartitionsPerFs_ = new TreeMap<FileSystemUtil.FsType, Long>();
    private Map<FileSystemUtil.FsType, Long> totalFilesPerFs_ = new TreeMap<FileSystemUtil.FsType, Long>();
    private Map<FileSystemUtil.FsType, Long> totalBytesPerFs_ = new TreeMap<FileSystemUtil.FsType, Long>();
    private Map<FileSystemUtil.FsType, Long> totalFilesPerFsEC_ = new TreeMap<FileSystemUtil.FsType, Long>();
    private Map<FileSystemUtil.FsType, Long> totalBytesPerFsEC_ = new TreeMap<FileSystemUtil.FsType, Long>();
    protected Set<HdfsFileFormat> fileFormats_ = new HashSet<HdfsFileFormat>();
    private boolean allParquet_ = false;
    private boolean allColumnarFormat_ = false;
    private long largestScanRangeBytes_ = 0L;
    private long partitionNumRows_ = -1L;
    private long extrapolatedNumRows_ = -1L;
    private long generatedScanRangeCount_ = 0L;
    private long maxScanRangeNumRows_ = -1L;
    private boolean useMtScanNode_;
    private final boolean isPartitionKeyScan_;
    private final Map<TupleDescriptor, List<Expr>> collectionConjuncts_ = new LinkedHashMap<TupleDescriptor, List<Expr>>();
    private final Set<TupleDescriptor> notEmptyCollections_ = new HashSet<TupleDescriptor>();
    private final Map<SlotDescriptor, List<Integer>> dictionaryFilterConjuncts_ = new LinkedHashMap<SlotDescriptor, List<Integer>>();
    private int numPartitionsWithNumRows_ = 0;
    private boolean hasCorruptTableStats_;
    private int skipHeaderLineCount_ = 0;
    private int numScanRangesNoDiskIds_ = 0;
    private int numFilesNoDiskIds_ = 0;
    private int numPartitionsNoDiskIds_ = 0;
    private final List<Expr> statsConjuncts_ = new ArrayList<Expr>();
    private final Map<TupleDescriptor, List<Expr>> statsOriginalConjuncts_ = new LinkedHashMap<TupleDescriptor, List<Expr>>();
    private TupleDescriptor statsTuple_;
    private ArrayList<TOverlapPredicateDesc> overlapPredicateDescs_ = new ArrayList();
    private int overlap_first_slot_idx_ = -1;
    protected SlotDescriptor countStarSlot_ = null;
    Map<Long, List<HdfsPartition.FileDescriptor>> sampledFiles_ = null;
    private final List<Expr> partitionConjuncts_;
    private boolean isFullAcidTable_ = false;

    public HdfsScanNode(PlanNodeId id, TupleDescriptor desc, List<Expr> conjuncts, List<? extends FeFsPartition> partitions, TableRef hdfsTblRef, MultiAggregateInfo aggInfo, List<Expr> partConjuncts, boolean isPartitionKeyScan) {
        super(id, desc, HdfsScanNode.createDisplayName(hdfsTblRef.getTable()));
        this.tbl_ = (FeFsTable)desc.getTable();
        this.conjuncts_ = conjuncts;
        this.partitions_ = new ArrayList<FeFsPartition>(partitions);
        this.partitionConjuncts_ = partConjuncts;
        this.sampleParams_ = hdfsTblRef.getSampleParams();
        this.replicaPreference_ = hdfsTblRef.getReplicaPreference();
        this.randomReplica_ = hdfsTblRef.getRandomReplica();
        this.tableNumRowsHint_ = hdfsTblRef.getTableNumRowsHint();
        FeFsTable hdfsTable = (FeFsTable)hdfsTblRef.getTable();
        Preconditions.checkState((this.tbl_ == hdfsTable ? 1 : 0) != 0);
        this.isFullAcidTable_ = AcidUtils.isFullAcidTable(hdfsTable.getMetaStoreTable().getParameters());
        StringBuilder error = new StringBuilder();
        this.aggInfo_ = aggInfo;
        this.skipHeaderLineCount_ = this.tbl_.parseSkipHeaderLineCount(error);
        if (error.length() > 0) {
            throw new IllegalStateException(error.toString());
        }
        this.isPartitionKeyScan_ = isPartitionKeyScan;
    }

    private static String createDisplayName(FeTable table) {
        Preconditions.checkState((boolean)(table instanceof FeFsTable));
        return "SCAN " + (Object)((Object)((FeFsTable)table).getFsType());
    }

    @Override
    protected String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (FeFsPartition partition : this.partitions_) {
            helper.add("Partition " + partition.getId() + ":", (Object)partition.toString());
        }
        return helper.addValue((Object)super.debugString()).toString();
    }

    private boolean hasParquet(Set<HdfsFileFormat> fileFormats) {
        return fileFormats.contains((Object)HdfsFileFormat.PARQUET) || fileFormats.contains((Object)HdfsFileFormat.HUDI_PARQUET);
    }

    private boolean hasOrc(Set<HdfsFileFormat> fileFormats) {
        return fileFormats.contains((Object)HdfsFileFormat.ORC);
    }

    protected boolean canApplyCountStarOptimization(Analyzer analyzer, Set<HdfsFileFormat> fileFormats) {
        if (fileFormats.size() != 1) {
            return false;
        }
        if (this.isFullAcidTable_) {
            return false;
        }
        if (!this.hasParquet(fileFormats) && !this.hasOrc(fileFormats)) {
            return false;
        }
        return this.canApplyCountStarOptimization(analyzer);
    }

    private List<FeFsPartition> getSampledOrRawPartitions() {
        return this.sampledPartitions_ == null ? this.partitions_ : this.sampledPartitions_;
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        this.conjuncts_ = HdfsScanNode.orderConjunctsByCost(this.conjuncts_);
        this.checkSamplingAndCountStar(analyzer);
        this.checkForSupportedFileFormats();
        this.assignCollectionConjuncts(analyzer);
        this.computeScanRangeLocations(analyzer);
        if (this.hasParquet(this.fileFormats_)) {
            if (analyzer.getQueryOptions().parquet_read_statistics) {
                this.computeStatsTupleAndConjuncts(analyzer);
            }
            if (analyzer.getQueryOptions().parquet_dictionary_filtering) {
                this.computeDictionaryFilterConjuncts(analyzer);
            }
        }
        if (this.hasOrc(this.fileFormats_) && analyzer.getQueryOptions().orc_read_statistics) {
            this.computeStatsTupleAndConjuncts(analyzer);
        }
        this.computeMemLayout(analyzer);
        this.computeStats(analyzer);
        this.assignedConjuncts_ = analyzer.getAssignedConjuncts();
    }

    private void checkSamplingAndCountStar(Analyzer analyzer) {
        if (this.sampleParams_ != null) {
            long percentBytes = this.sampleParams_.getPercentBytes();
            long randomSeed = this.sampleParams_.hasRandomSeed() ? this.sampleParams_.getRandomSeed() : System.currentTimeMillis();
            this.sampledFiles_ = this.getFilesSample(percentBytes, 0L, randomSeed);
        }
        if (this.sampledFiles_ != null) {
            this.sampledPartitions_ = new ArrayList<FeFsPartition>();
            for (FeFsPartition partition : this.partitions_) {
                Preconditions.checkState((partition.getId() >= 0L ? 1 : 0) != 0);
                if (this.sampledFiles_.get(partition.getId()) == null) continue;
                this.sampledPartitions_.add(partition);
            }
        }
        for (FeFsPartition partition : this.getSampledOrRawPartitions()) {
            if (partition.getFileFormat() == HdfsFileFormat.ICEBERG) continue;
            this.fileFormats_.add(partition.getFileFormat());
        }
        if (this.canApplyCountStarOptimization(analyzer, this.fileFormats_)) {
            Preconditions.checkState((this.desc_.getPath().destTable() != null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.collectionConjuncts_.isEmpty());
            this.countStarSlot_ = this.applyCountStarOptimization(analyzer);
        }
    }

    @Override
    protected void checkForSupportedFileFormats() throws NotImplementedException {
        boolean bl;
        Preconditions.checkNotNull((Object)this.desc_);
        Preconditions.checkNotNull((Object)this.desc_.getTable());
        for (FeFsPartition feFsPartition : this.partitions_) {
            if (!feFsPartition.getFileFormat().equals((Object)HdfsFileFormat.JSON) || BackendConfig.INSTANCE.isJsonScannerEnabled()) continue;
            throw new NotImplementedException("JSON scans are disabled by --enable_json_scanner flag.");
        }
        Column firstComplexTypedCol = null;
        for (Column col : this.desc_.getTable().getColumns()) {
            if (!col.getType().isComplexType()) continue;
            firstComplexTypedCol = col;
            break;
        }
        if (firstComplexTypedCol == null) {
            return;
        }
        boolean bl2 = false;
        for (SlotDescriptor slotDesc : this.desc_.getSlots()) {
            if (!slotDesc.isMaterialized() || !slotDesc.getType().isComplexType() && slotDesc.getColumn() != null) continue;
            bl = true;
            break;
        }
        for (FeFsPartition part : this.partitions_) {
            HdfsFileFormat format = part.getFileFormat();
            if (format.isComplexTypesSupported() || format.canSkipComplexTypes() && !bl) continue;
            String errSuffix = String.format("Complex types are supported for these file formats: %s", Joiner.on((String)", ").join(HdfsFileFormat.complexTypesFormats()));
            if (this.desc_.getTable().getNumClusteringCols() == 0) {
                throw new NotImplementedException(String.format("Scan of table '%s' in format '%s' is not supported because the table has a column '%s' with a complex type '%s'.\n%s.", new Object[]{this.desc_.getAlias(), format, firstComplexTypedCol.getName(), firstComplexTypedCol.getType().toSql(), errSuffix}));
            }
            throw new NotImplementedException(String.format("Scan of partition '%s' in format '%s' of table '%s' is not supported because the table has a column '%s' with a complex type '%s'.\n%s.", new Object[]{part.getPartitionName(), format, this.desc_.getAlias(), firstComplexTypedCol.getName(), firstComplexTypedCol.getType().toSql(), errSuffix}));
        }
    }

    private void assignCollectionConjuncts(Analyzer analyzer) {
        this.collectionConjuncts_.clear();
        this.addNotEmptyCollections(this.conjuncts_);
        this.assignCollectionConjuncts(this.desc_, analyzer);
    }

    private void buildBinaryStatsPredicate(Analyzer analyzer, SlotRef inputSlot, BinaryPredicate inputPred, BinaryPredicate.Operator op) {
        Expr constExpr = ((Expr)inputPred.getChild(1)).clone();
        Preconditions.checkState((boolean)constExpr.isConstant());
        SlotDescriptor slotDesc = analyzer.getDescTbl().copySlotDescriptor(this.statsTuple_, inputSlot.getDesc());
        SlotRef slot = new SlotRef(slotDesc);
        BinaryPredicate statsPred = new BinaryPredicate(op, slot, constExpr);
        statsPred.analyzeNoThrow(analyzer);
        this.statsConjuncts_.add(statsPred);
    }

    private void buildInListStatsPredicate(Analyzer analyzer, SlotRef inputSlot, InPredicate inputPred) {
        Preconditions.checkState((!inputPred.isNotIn() ? 1 : 0) != 0);
        List children = inputPred.getChildren();
        Preconditions.checkState((inputSlot == ((Expr)children.get(0)).unwrapSlotRef(true) ? 1 : 0) != 0);
        ArrayList inList = Lists.newArrayListWithCapacity((int)(children.size() - 1));
        for (int i = 1; i < children.size(); ++i) {
            Expr child = (Expr)children.get(i);
            if (!Expr.IS_LITERAL.apply((Object)child)) {
                return;
            }
            if (this.isUnsupportedStatsType(child.getType())) {
                return;
            }
            inList.add(child);
        }
        SlotDescriptor slotDesc = analyzer.getDescTbl().copySlotDescriptor(this.statsTuple_, inputSlot.getDesc());
        SlotRef slot = new SlotRef(slotDesc);
        InPredicate inPred = new InPredicate((Expr)slot, inList, inputPred.isNotIn());
        inPred.analyzeNoThrow(analyzer);
        this.statsConjuncts_.add(inPred);
    }

    private boolean isUnsupportedStatsType(Type type) {
        return this.hasOrc(this.fileFormats_) && (type.getPrimitiveType() == PrimitiveType.CHAR || type.getPrimitiveType() == PrimitiveType.VARCHAR || type.getPrimitiveType() == PrimitiveType.TIMESTAMP);
    }

    private void tryComputeBinaryStatsPredicate(Analyzer analyzer, BinaryPredicate binaryPred) {
        SlotRef slotRef = ((Expr)binaryPred.getChild(0)).unwrapSlotRef(true);
        if (slotRef == null) {
            return;
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        Preconditions.checkState((boolean)slotDesc.isScanSlot());
        if (slotDesc.isArrayPosRef()) {
            return;
        }
        Expr constExpr = (Expr)binaryPred.getChild(1);
        if (!constExpr.isConstant()) {
            return;
        }
        if (Expr.IS_NULL_VALUE.apply((Object)constExpr)) {
            return;
        }
        if (slotDesc.isVirtualColumn()) {
            return;
        }
        if (this.isUnsupportedStatsType(slotDesc.getType())) {
            return;
        }
        if (this.isUnsupportedStatsType(constExpr.getType())) {
            return;
        }
        if (BinaryPredicate.IS_RANGE_PREDICATE.apply((Object)binaryPred)) {
            this.addStatsOriginalConjunct(slotDesc.getParent(), binaryPred);
            this.buildBinaryStatsPredicate(analyzer, slotRef, binaryPred, binaryPred.getOp());
        } else if (BinaryPredicate.IS_EQ_PREDICATE.apply((Object)binaryPred)) {
            this.addStatsOriginalConjunct(slotDesc.getParent(), binaryPred);
            if (this.hasParquet(this.fileFormats_)) {
                this.buildBinaryStatsPredicate(analyzer, slotRef, binaryPred, BinaryPredicate.Operator.LE);
                this.buildBinaryStatsPredicate(analyzer, slotRef, binaryPred, BinaryPredicate.Operator.GE);
            }
            if (this.hasOrc(this.fileFormats_)) {
                this.buildBinaryStatsPredicate(analyzer, slotRef, binaryPred, binaryPred.getOp());
            }
        }
    }

    private void tryComputeInListStatsPredicate(Analyzer analyzer, InPredicate inPred) {
        SlotRef slotRef = inPred.getBoundSlot();
        if (slotRef == null) {
            return;
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        Preconditions.checkState((boolean)slotDesc.isScanSlot());
        if (slotDesc.isArrayPosRef()) {
            return;
        }
        if (inPred.isNotIn()) {
            return;
        }
        if (this.hasOrc(this.fileFormats_)) {
            if (this.isUnsupportedStatsType(slotDesc.getType())) {
                return;
            }
            this.addStatsOriginalConjunct(slotDesc.getParent(), inPred);
            this.buildInListStatsPredicate(analyzer, slotRef, inPred);
        }
        if (!this.hasParquet(this.fileFormats_)) {
            return;
        }
        List children = inPred.getChildren();
        Expr min = null;
        LiteralExpr max = null;
        for (int i = 1; i < children.size(); ++i) {
            Expr child = (Expr)children.get(i);
            if (!Expr.IS_LITERAL.apply((Object)child)) {
                return;
            }
            LiteralExpr literalChild = (LiteralExpr)child;
            if (Expr.IS_NULL_LITERAL.apply((Object)literalChild)) {
                return;
            }
            if (min == null || literalChild.compareTo((LiteralExpr)min) < 0) {
                min = literalChild;
            }
            if (max != null && literalChild.compareTo(max) <= 0) continue;
            max = literalChild;
        }
        Preconditions.checkState((min != null ? 1 : 0) != 0);
        Preconditions.checkState((max != null ? 1 : 0) != 0);
        BinaryPredicate minBound = new BinaryPredicate(BinaryPredicate.Operator.GE, ((Expr)children.get(0)).clone(), min.clone());
        BinaryPredicate maxBound = new BinaryPredicate(BinaryPredicate.Operator.LE, ((Expr)children.get(0)).clone(), max.clone());
        this.addStatsOriginalConjunct(slotDesc.getParent(), inPred);
        this.buildBinaryStatsPredicate(analyzer, slotRef, minBound, minBound.getOp());
        this.buildBinaryStatsPredicate(analyzer, slotRef, maxBound, maxBound.getOp());
    }

    private void tryComputeIsNullStatsPredicate(Analyzer analyzer, IsNullPredicate isNullPred) {
        if (!this.hasOrc(this.fileFormats_)) {
            return;
        }
        SlotRef slotRef = isNullPred.getBoundSlot();
        if (slotRef == null) {
            return;
        }
        Preconditions.checkState((boolean)slotRef.getDesc().isScanSlot());
        if (slotRef.getDesc().isArrayPosRef()) {
            return;
        }
        this.addStatsOriginalConjunct(slotRef.getDesc().getParent(), isNullPred);
        SlotDescriptor slotDesc = analyzer.getDescTbl().copySlotDescriptor(this.statsTuple_, slotRef.getDesc());
        SlotRef slot = new SlotRef(slotDesc);
        IsNullPredicate statsPred = new IsNullPredicate(slot, isNullPred.isNotNull());
        statsPred.analyzeNoThrow(analyzer);
        this.statsConjuncts_.add(statsPred);
    }

    private void addStatsOriginalConjunct(TupleDescriptor tupleDesc, Expr expr) {
        List exprs = this.statsOriginalConjuncts_.computeIfAbsent(tupleDesc, k -> new ArrayList());
        exprs.add(expr);
    }

    private void tryComputeStatsPredicate(Analyzer analyzer, Expr pred) {
        if (pred instanceof BinaryPredicate) {
            this.tryComputeBinaryStatsPredicate(analyzer, (BinaryPredicate)pred);
        } else if (pred instanceof InPredicate) {
            this.tryComputeInListStatsPredicate(analyzer, (InPredicate)pred);
        } else if (pred instanceof IsNullPredicate) {
            this.tryComputeIsNullStatsPredicate(analyzer, (IsNullPredicate)pred);
        }
    }

    private void addNotEmptyCollections(List<Expr> conjuncts) {
        for (Expr expr : conjuncts) {
            if (!(expr instanceof IsNotEmptyPredicate)) continue;
            SlotRef ref = (SlotRef)((IsNotEmptyPredicate)expr).getChild(0);
            Preconditions.checkState((boolean)ref.getDesc().getType().isComplexType());
            Preconditions.checkState((ref.getDesc().getItemTupleDesc() != null ? 1 : 0) != 0);
            this.notEmptyCollections_.add(ref.getDesc().getItemTupleDesc());
        }
    }

    private void computeStatsTupleAndConjuncts(Analyzer analyzer) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.desc_.getPath());
        if (this.statsTuple_ != null) {
            return;
        }
        String tupleName = this.desc_.getPath().toString() + " statistics";
        DescriptorTable descTbl = analyzer.getDescTbl();
        this.statsTuple_ = descTbl.createTupleDescriptor(tupleName);
        this.statsTuple_.setPath(this.desc_.getPath());
        for (Expr expr : this.conjuncts_) {
            this.tryComputeStatsPredicate(analyzer, expr);
        }
        for (Map.Entry entry : this.collectionConjuncts_.entrySet()) {
            if (!this.notEmptyCollections_.contains(entry.getKey())) continue;
            for (Expr pred : (List)entry.getValue()) {
                this.tryComputeStatsPredicate(analyzer, pred);
            }
        }
        this.statsTuple_.computeMemLayout();
    }

    public void initOverlapPredicate(Analyzer analyzer) {
        if (!this.allParquet_) {
            return;
        }
        Preconditions.checkNotNull((Object)this.statsTuple_);
        this.statsTuple_.resetHasMemoryLayout();
        this.overlap_first_slot_idx_ = this.statsTuple_.getSlots().size();
    }

    private boolean checkTypeForOverlapPredicate(Type slotType, Type joinType) {
        if (slotType.isBoolean() && joinType.isBoolean()) {
            return true;
        }
        if (slotType.isIntegerType() && joinType.isIntegerType()) {
            return true;
        }
        if (slotType.isScalarType(PrimitiveType.STRING) && joinType.isScalarType(PrimitiveType.STRING)) {
            return true;
        }
        if (slotType.isTimestamp() && joinType.isTimestamp()) {
            return true;
        }
        if (slotType.isDate() && joinType.isDate()) {
            return true;
        }
        if (slotType.isFloatingPointType() && joinType.isFloatingPointType()) {
            return true;
        }
        if (slotType.isDecimal() && joinType.isDecimal()) {
            ScalarType slotScalarType = (ScalarType)slotType;
            ScalarType hashScalarType = (ScalarType)joinType;
            return slotScalarType.decimalPrecision() == hashScalarType.decimalPrecision() && slotScalarType.decimalScale() == hashScalarType.decimalScale();
        }
        return false;
    }

    private boolean allowMinMaxFilter(FeTable table, Column column, TQueryOptions queryOptions, boolean isBoundByPartitionColumns) {
        if (column == null || table == null || !(table instanceof FeFsTable)) {
            return false;
        }
        FeFsTable feFsTable = (FeFsTable)table;
        boolean minmaxOnPartitionColumns = queryOptions.isMinmax_filter_partition_columns();
        boolean minmaxOnSortedColumns = queryOptions.isMinmax_filter_sorted_columns();
        TSortingOrder sortOrder = feFsTable.getSortOrderForSortByColumn();
        if (sortOrder != null) {
            if (sortOrder == TSortingOrder.LEXICAL) {
                return feFsTable.isLeadingSortByColumn(column.getName()) && minmaxOnSortedColumns;
            }
            Preconditions.checkState((sortOrder == TSortingOrder.ZORDER ? 1 : 0) != 0);
            return feFsTable.isSortByColumn(column.getName()) && minmaxOnSortedColumns;
        }
        if (isBoundByPartitionColumns) {
            return minmaxOnPartitionColumns;
        }
        return queryOptions.getMinmax_filter_threshold() > 0.0;
    }

    public Boolean tryToComputeOverlapPredicate(Analyzer analyzer, RuntimeFilterGenerator.RuntimeFilter filter, Expr targetExpr, boolean isBoundByPartitionColumns) {
        if (filter.getType() != TRuntimeFilterType.MIN_MAX) {
            return false;
        }
        if (!this.allParquet_) {
            return false;
        }
        SlotRef slotRefInScan = targetExpr.unwrapSlotRef(true);
        if (slotRefInScan == null) {
            return false;
        }
        List<SlotDescriptor> slotDescs = this.statsTuple_.getSlots();
        for (int i = 0; i < this.overlap_first_slot_idx_; ++i) {
            if (slotDescs.get(i).getPath() != slotRefInScan.getDesc().getPath()) continue;
            return false;
        }
        Column column = slotRefInScan.getDesc().getColumn();
        FeTable table = slotRefInScan.getDesc().getParent().getTable();
        if (!this.allowMinMaxFilter(table, column, analyzer.getQueryOptions(), isBoundByPartitionColumns)) {
            return false;
        }
        Expr srcExpr = filter.getSrcExpr();
        if (!targetExpr.isImplicitCast() ? !this.checkTypeForOverlapPredicate(slotRefInScan.getType(), srcExpr.getType()) : !this.checkTypeForOverlapPredicate(slotRefInScan.getType(), targetExpr.getType()) || !this.checkTypeForOverlapPredicate(targetExpr.getType(), srcExpr.getType())) {
            return false;
        }
        int firstSlotIdx = this.statsTuple_.getSlots().size();
        SlotDescriptor slotDescDataMin = analyzer.getDescTbl().copySlotDescriptor(this.statsTuple_, slotRefInScan.getDesc());
        SlotDescriptor slotDescDataMax = analyzer.getDescTbl().copySlotDescriptor(this.statsTuple_, slotRefInScan.getDesc());
        this.overlapPredicateDescs_.add(new TOverlapPredicateDesc(filter.getFilterId().asInt(), firstSlotIdx));
        return true;
    }

    public void finalizeOverlapPredicate() {
        if (!this.allParquet_) {
            return;
        }
        this.statsTuple_.computeMemLayout();
    }

    private void assignCollectionConjuncts(TupleDescriptor tupleDesc, Analyzer analyzer) {
        for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
            if (!slotDesc.getType().isCollectionType()) continue;
            Preconditions.checkNotNull((Object)slotDesc.getItemTupleDesc());
            TupleDescriptor itemTupleDesc = slotDesc.getItemTupleDesc();
            TupleId itemTid = itemTupleDesc.getId();
            if (analyzer.getNumZippingUnnests() > 1 && analyzer.getZippingUnnestTupleIds().contains(itemTid)) continue;
            List<Expr> collectionConjuncts = analyzer.getUnassignedConjuncts(Lists.newArrayList((Object[])new TupleId[]{itemTid}));
            List<Expr> bindingPredicates = analyzer.getBoundPredicates(itemTid);
            for (Expr boundPred : bindingPredicates) {
                if (collectionConjuncts.contains(boundPred)) continue;
                collectionConjuncts.add(boundPred);
            }
            analyzer.createEquivConjuncts(itemTid, collectionConjuncts);
            for (Expr conjunct : collectionConjuncts) {
                if (analyzer.evalAfterJoin(conjunct)) continue;
                analyzer.markConjunctAssigned(conjunct);
            }
            if (analyzer.getQueryCtx().client_request.getQuery_options().enable_expr_rewrites) {
                Expr.optimizeConjuncts(collectionConjuncts, analyzer);
            }
            if (!collectionConjuncts.isEmpty()) {
                analyzer.materializeSlots(collectionConjuncts);
                this.collectionConjuncts_.put(itemTupleDesc, collectionConjuncts);
                this.addNotEmptyCollections(collectionConjuncts);
            }
            this.assignCollectionConjuncts(itemTupleDesc, analyzer);
        }
    }

    private void addDictionaryFilter(Analyzer analyzer, Expr conjunct, int conjunctIdx) {
        ArrayList<TupleId> tupleIds = new ArrayList<TupleId>();
        ArrayList<SlotId> slotIds = new ArrayList<SlotId>();
        conjunct.getIds(tupleIds, slotIds);
        if (slotIds.size() != 1) {
            return;
        }
        SlotDescriptor firstSlotDesc = analyzer.getSlotDesc((SlotId)slotIds.get(0));
        if (firstSlotDesc.getType().isCollectionType()) {
            return;
        }
        if (firstSlotDesc.isVirtualColumn()) {
            return;
        }
        for (SlotId slotId : slotIds) {
            SlotDescriptor slotDesc = analyzer.getSlotDesc(slotId);
            if (!this.IsMemberOfStructInSelectList(slotDesc)) continue;
            return;
        }
        if (conjunct.contains(Expr.IS_NONDETERMINISTIC_BUILTIN_FN_PREDICATE)) {
            return;
        }
        try {
            if (analyzer.isTrueWithNullSlots(conjunct)) {
                return;
            }
        }
        catch (InternalException e) {
            LOG.warn("Skipping dictionary filter because backend evaluation failed: " + conjunct.toSql(), (Throwable)e);
            return;
        }
        SlotId slotId = (SlotId)slotIds.get(0);
        SlotDescriptor slotKey = analyzer.getSlotDesc(slotId);
        List<Integer> slotList = this.dictionaryFilterConjuncts_.get(slotKey);
        if (slotList == null) {
            slotList = new ArrayList<Integer>();
            this.dictionaryFilterConjuncts_.put(slotKey, slotList);
        }
        slotList.add(conjunctIdx);
    }

    private boolean IsMemberOfStructInSelectList(SlotDescriptor slotDesc) {
        SlotDescriptor parentStructSlot = slotDesc.getParent().getParentSlotDesc();
        if (slotDesc.getType().isScalarType() && parentStructSlot == null) {
            return false;
        }
        if (slotDesc.getType().isStructType()) {
            for (SlotDescriptor scannedSlots : this.desc_.getSlots()) {
                if (scannedSlots.getId() != slotDesc.getId()) continue;
                return true;
            }
        }
        if (parentStructSlot != null) {
            return this.IsMemberOfStructInSelectList(parentStructSlot);
        }
        return false;
    }

    private void computeDictionaryFilterConjuncts(Analyzer analyzer) {
        for (int conjunctIdx = 0; conjunctIdx < this.conjuncts_.size(); ++conjunctIdx) {
            this.addDictionaryFilter(analyzer, (Expr)this.conjuncts_.get(conjunctIdx), conjunctIdx);
        }
        for (Map.Entry<TupleDescriptor, List<Expr>> entry : this.collectionConjuncts_.entrySet()) {
            if (!this.notEmptyCollections_.contains(entry.getKey())) continue;
            List<Expr> conjuncts = entry.getValue();
            for (int conjunctIdx = 0; conjunctIdx < conjuncts.size(); ++conjunctIdx) {
                this.addDictionaryFilter(analyzer, conjuncts.get(conjunctIdx), conjunctIdx);
            }
        }
    }

    protected void computeScanRangeLocations(Analyzer analyzer) throws ImpalaRuntimeException {
        long testLimit;
        long scanRangeBytesLimit = analyzer.getQueryCtx().client_request.getQuery_options().getMax_scan_range_length();
        if (RuntimeEnv.INSTANCE.hasTableScanRangeLimit() && this.desc_.getTableName() != null && (testLimit = RuntimeEnv.INSTANCE.getTableScanRangeLimit(this.desc_.getTableName().getDb(), this.desc_.getTableName().getTbl())) > 0L && (scanRangeBytesLimit == 0L || scanRangeBytesLimit > testLimit)) {
            scanRangeBytesLimit = testLimit;
        }
        this.scanRangeSpecs_ = new TScanRangeSpec();
        this.generatedScanRangeCount_ = 0L;
        this.largestScanRangeBytes_ = 0L;
        this.maxScanRangeNumRows_ = -1L;
        this.numScanRangesNoDiskIds_ = 0;
        this.numFilesNoDiskIds_ = 0;
        this.numPartitionsNoDiskIds_ = 0;
        this.numPartitionsPerFs_ = new TreeMap<FileSystemUtil.FsType, Long>();
        this.totalFilesPerFs_ = new TreeMap<FileSystemUtil.FsType, Long>();
        this.totalBytesPerFs_ = new TreeMap<FileSystemUtil.FsType, Long>();
        this.totalFilesPerFsEC_ = new TreeMap<FileSystemUtil.FsType, Long>();
        this.totalBytesPerFsEC_ = new TreeMap<FileSystemUtil.FsType, Long>();
        Preconditions.checkState((this.sampleParams_ == null == (this.sampledPartitions_ == null) ? 1 : 0) != 0);
        int partitionsSize = this.getSampledOrRawPartitions().size();
        boolean allParquet = partitionsSize > 0;
        boolean allColumnarFormat = partitionsSize > 0;
        long simpleLimitNumRows = 0L;
        boolean isSimpleLimit = this.sampleParams_ == null && analyzer.getQueryCtx().client_request.getQuery_options().isOptimize_simple_limit() && analyzer.getSimpleLimitStatus() != null && (Boolean)analyzer.getSimpleLimitStatus().first != false;
        String lastFsScheme = null;
        String lastFsAuthority = null;
        FileSystem lastFileSytem = null;
        for (FeFsPartition partition : this.getSampledOrRawPartitions()) {
            FileSystem partitionFs;
            String partitionLocation = partition.getLocation();
            Path partitionPath = new Path(partitionLocation);
            String fsScheme = partitionPath.toUri().getScheme();
            String fsAuthority = partitionPath.toUri().getAuthority();
            FileSystemUtil.FsType fsType = FileSystemUtil.FsType.getFsType(fsScheme);
            if (lastFileSytem != null && Objects.equals(lastFsScheme, fsScheme) && Objects.equals(lastFsAuthority, fsAuthority)) {
                partitionFs = lastFileSytem;
            } else {
                try {
                    partitionFs = partitionPath.getFileSystem(CONF);
                }
                catch (IOException e) {
                    throw new ImpalaRuntimeException("Error determining partition fs type", e);
                }
                lastFsScheme = fsScheme;
                lastFsAuthority = fsAuthority;
                lastFileSytem = partitionFs;
            }
            boolean fsHasBlocks = FileSystemUtil.supportsStorageIds(partitionFs);
            List<HdfsPartition.FileDescriptor> fileDescs = this.getFileDescriptorsWithLimit(partition, fsHasBlocks, isSimpleLimit ? (Long)analyzer.getSimpleLimitStatus().second - simpleLimitNumRows : -1L);
            simpleLimitNumRows += (long)fileDescs.size();
            if (this.sampledFiles_ != null) {
                fileDescs = this.sampledFiles_.get(partition.getId());
            }
            long partitionNumRows = partition.getNumRows();
            analyzer.getDescTbl().addReferencedPartition(this.tbl_, partition.getId());
            if (!partition.getFileFormat().isParquetBased()) {
                allParquet = false;
            }
            boolean bl = allColumnarFormat = allColumnarFormat && VALID_COLUMNAR_FORMATS.contains((Object)partition.getFileFormat());
            if (!fsHasBlocks) {
                long defaultBlockSize = partition.getFileFormat().isParquetBased() ? analyzer.getQueryOptions().parquet_object_store_split_size : partitionFs.getDefaultBlockSize(partitionPath);
                long maxBlockSize = Math.max(defaultBlockSize, 0x100000L);
                scanRangeBytesLimit = scanRangeBytesLimit > 0L ? Math.min(scanRangeBytesLimit, maxBlockSize) : maxBlockSize;
            }
            long partitionBytes = HdfsPartition.FileDescriptor.computeTotalFileLength(fileDescs);
            long partitionMaxScanRangeBytes = 0L;
            boolean partitionMissingDiskIds = false;
            this.totalBytesPerFs_.merge(fsType, partitionBytes, Long::sum);
            this.totalFilesPerFs_.merge(fsType, Long.valueOf(fileDescs.size()), Long::sum);
            this.numPartitionsPerFs_.merge(fsType, 1L, Long::sum);
            for (HdfsPartition.FileDescriptor fileDesc : fileDescs) {
                boolean isFooterOnly;
                if (!analyzer.getQueryOptions().isAllow_erasure_coded_files() && fileDesc.getIsEc()) {
                    throw new ImpalaRuntimeException(String.format("Scanning of HDFS erasure-coded file (%s) is not supported", fileDesc.getAbsolutePath(partitionLocation)));
                }
                if (fileDesc.getIsEc()) {
                    this.totalFilesPerFsEC_.merge(fsType, 1L, Long::sum);
                    this.totalBytesPerFsEC_.merge(fsType, fileDesc.getFileLength(), Long::sum);
                }
                boolean bl2 = isFooterOnly = this.countStarSlot_ != null || this.isPartitionKeyScan_ && (partition.getFileFormat().isParquetBased() || partition.getFileFormat() == HdfsFileFormat.ORC);
                if (!fsHasBlocks) {
                    Preconditions.checkState((fileDesc.getNumFileBlocks() == 0 ? 1 : 0) != 0);
                    this.generateScanRangeSpecs(partition, partitionLocation, fileDesc, scanRangeBytesLimit, isFooterOnly);
                    continue;
                }
                if (fileDesc.getNumFileBlocks() == 0) continue;
                Pair<Boolean, Long> result = this.transformBlocksToScanRanges(partition, partitionLocation, fsType, fileDesc, fsHasBlocks, scanRangeBytesLimit, analyzer, isFooterOnly);
                partitionMaxScanRangeBytes = Math.max(partitionMaxScanRangeBytes, (Long)result.second);
                if (!((Boolean)result.first).booleanValue()) continue;
                partitionMissingDiskIds = true;
            }
            if (partitionMissingDiskIds) {
                ++this.numPartitionsNoDiskIds_;
            }
            if (partitionMaxScanRangeBytes > 0L && partitionNumRows >= 0L) {
                this.updateMaxScanRangeNumRows(partitionNumRows, partitionBytes, partitionMaxScanRangeBytes);
            }
            if (!isSimpleLimit || simpleLimitNumRows != (Long)analyzer.getSimpleLimitStatus().second) continue;
            break;
        }
        this.allParquet_ = allParquet;
        this.allColumnarFormat_ = allColumnarFormat;
        if (this.totalFilesPerFs_.isEmpty() || HdfsScanNode.sumValues(this.totalFilesPerFs_) == 0L) {
            this.maxScanRangeNumRows_ = 0L;
        } else {
            long tableNumRows = this.tbl_.getNumRows();
            if (tableNumRows >= 0L) {
                this.updateMaxScanRangeNumRows(tableNumRows, HdfsScanNode.sumValues(this.totalBytesPerFs_), this.largestScanRangeBytes_);
            }
        }
    }

    protected List<HdfsPartition.FileDescriptor> getFileDescriptorsWithLimit(FeFsPartition partition, boolean fsHasBlocks, long limit) {
        List<HdfsPartition.FileDescriptor> fileDescs;
        if (limit != -1L) {
            int fileCount = 0;
            fileDescs = new ArrayList<HdfsPartition.FileDescriptor>();
            for (HdfsPartition.FileDescriptor fd : partition.getFileDescriptors()) {
                if (fsHasBlocks && fd.getNumFileBlocks() == 0 || !fsHasBlocks && fd.getFileLength() <= 0L) continue;
                fileDescs.add(fd);
                if ((long)(++fileCount) != limit) continue;
                break;
            }
        } else {
            fileDescs = partition.getFileDescriptors();
        }
        return fileDescs;
    }

    protected Map<Long, List<HdfsPartition.FileDescriptor>> getFilesSample(long percentBytes, long minSampleBytes, long randomSeed) {
        return FeFsTable.Utils.getFilesSample(this.tbl_, this.partitions_, percentBytes, minSampleBytes, randomSeed);
    }

    private void updateMaxScanRangeNumRows(long totalRows, long totalBytes, long maxScanRangeBytes) {
        long estimate;
        Preconditions.checkState((totalRows >= 0L ? 1 : 0) != 0);
        Preconditions.checkState((totalBytes >= 0L ? 1 : 0) != 0);
        Preconditions.checkState((maxScanRangeBytes >= 0L ? 1 : 0) != 0);
        if (maxScanRangeBytes == 0L || totalBytes == 0L || totalRows == 0L) {
            estimate = 0L;
        } else {
            double divisor = (double)totalBytes / (double)maxScanRangeBytes;
            estimate = (long)((double)totalRows / divisor);
        }
        this.maxScanRangeNumRows_ = Math.max(this.maxScanRangeNumRows_, estimate);
    }

    private void generateScanRangeSpecs(FeFsPartition partition, String partitionLocation, HdfsPartition.FileDescriptor fileDesc, long maxBlockSize, boolean isFooterOnly) {
        Preconditions.checkArgument((fileDesc.getNumFileBlocks() == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxBlockSize > 0L ? 1 : 0) != 0);
        if (fileDesc.getFileLength() <= 0L) {
            return;
        }
        boolean splittable = partition.getFileFormat().isSplittable(HdfsCompression.fromFileName(fileDesc.getPath()));
        int partitionHash = partitionLocation.hashCode();
        TFileSplitGeneratorSpec splitSpec = new TFileSplitGeneratorSpec(fileDesc.toThrift(), maxBlockSize, splittable, partition.getId(), partitionHash, isFooterOnly &= splittable);
        this.scanRangeSpecs_.addToSplit_specs(splitSpec);
        long scanRangeBytes = Math.min(maxBlockSize, fileDesc.getFileLength());
        if (splittable && !this.isPartitionKeyScan_) {
            this.generatedScanRangeCount_ = (long)((double)this.generatedScanRangeCount_ + Math.ceil((double)fileDesc.getFileLength() / (double)maxBlockSize));
        } else {
            ++this.generatedScanRangeCount_;
            scanRangeBytes = fileDesc.getFileLength();
        }
        this.largestScanRangeBytes_ = Math.max(this.largestScanRangeBytes_, scanRangeBytes);
    }

    private Pair<Boolean, Long> transformBlocksToScanRanges(FeFsPartition partition, String partitionLocation, FileSystemUtil.FsType fsType, HdfsPartition.FileDescriptor fileDesc, boolean fsHasBlocks, long scanRangeBytesLimit, Analyzer analyzer, boolean isFooterOnly) {
        Preconditions.checkArgument((fileDesc.getNumFileBlocks() > 0 ? 1 : 0) != 0);
        boolean fileDescMissingDiskIds = false;
        long fileMaxScanRangeBytes = 0L;
        int i = 0;
        if (isFooterOnly) {
            i = fileDesc.getNumFileBlocks() - 1;
        }
        while (i < fileDesc.getNumFileBlocks()) {
            FbFileBlock block = fileDesc.getFbFileBlock(i);
            int replicaHostCount = HdfsPartition.FileBlock.getNumReplicaHosts(block);
            if (replicaHostCount != 0) {
                ArrayList<TScanRangeLocation> locations = new ArrayList<TScanRangeLocation>();
                for (int j = 0; j < replicaHostCount; ++j) {
                    TScanRangeLocation location = new TScanRangeLocation();
                    int replicaHostIdx = HdfsPartition.FileBlock.getReplicaHostIdx(block, j);
                    TNetworkAddress networkAddress = partition.getHostIndex().getEntry(replicaHostIdx);
                    Preconditions.checkNotNull((Object)networkAddress);
                    Integer globalHostIdx = analyzer.getHostIndex().getOrAddIndex(networkAddress);
                    location.setHost_idx(globalHostIdx);
                    if (fsHasBlocks && !fileDesc.getIsEc() && HdfsPartition.FileBlock.getDiskId(block, j) == -1) {
                        if (fsType != FileSystemUtil.FsType.OZONE) {
                            ++this.numScanRangesNoDiskIds_;
                        }
                        fileDescMissingDiskIds = true;
                    }
                    location.setVolume_id(HdfsPartition.FileBlock.getDiskId(block, j));
                    location.setIs_cached(HdfsPartition.FileBlock.isReplicaCached(block, j));
                    locations.add(location);
                }
                long currentOffset = HdfsPartition.FileBlock.getOffset(block);
                long remainingLength = HdfsPartition.FileBlock.getLength(block);
                while (remainingLength > 0L) {
                    long currentLength = remainingLength;
                    if (scanRangeBytesLimit > 0L && remainingLength > scanRangeBytesLimit) {
                        currentLength = scanRangeBytesLimit;
                        if (isFooterOnly) {
                            currentOffset += remainingLength - currentLength;
                            remainingLength = currentLength;
                        }
                    }
                    TScanRange scanRange = new TScanRange();
                    THdfsFileSplit hdfsFileSplit = new THdfsFileSplit(fileDesc.getRelativePath(), currentOffset, currentLength, partition.getId(), fileDesc.getFileLength(), fileDesc.getFileCompression().toThrift(), fileDesc.getModificationTime(), partitionLocation.hashCode());
                    hdfsFileSplit.setAbsolute_path(fileDesc.getAbsolutePath());
                    hdfsFileSplit.setIs_encrypted(fileDesc.getIsEncrypted());
                    hdfsFileSplit.setIs_erasure_coded(fileDesc.getIsEc());
                    scanRange.setHdfs_file_split(hdfsFileSplit);
                    if (fileDesc.getFbFileMetadata() != null) {
                        scanRange.setFile_metadata(fileDesc.getFbFileMetadata().getByteBuffer());
                    }
                    TScanRangeLocationList scanRangeLocations = new TScanRangeLocationList();
                    scanRangeLocations.scan_range = scanRange;
                    scanRangeLocations.locations = locations;
                    this.scanRangeSpecs_.addToConcrete_ranges(scanRangeLocations);
                    this.largestScanRangeBytes_ = Math.max(this.largestScanRangeBytes_, currentLength);
                    fileMaxScanRangeBytes = Math.max(fileMaxScanRangeBytes, currentLength);
                    remainingLength -= currentLength;
                    currentOffset += currentLength;
                }
                if (this.isPartitionKeyScan_) break;
            }
            ++i;
        }
        if (fileDescMissingDiskIds) {
            ++this.numFilesNoDiskIds_;
            if (LOG.isTraceEnabled()) {
                LOG.trace("File blocks mapping to unknown disk ids. Dir: " + partitionLocation + " File:" + fileDesc.toString());
            }
        }
        return new Pair<Boolean, Long>(fileDescMissingDiskIds, fileMaxScanRangeBytes);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_);
        super.computeStats(analyzer);
        this.computeCardinalities(analyzer);
        this.computeNumNodes(analyzer, this.cardinality_);
    }

    protected void computeCardinalities(Analyzer analyzer) {
        this.extrapolatedNumRows_ = FeFsTable.Utils.getExtrapolatedNumRows(this.tbl_, HdfsScanNode.sumValues(this.totalBytesPerFs_));
        long statsNumRows = this.getStatsNumRows(analyzer.getQueryOptions());
        if (this.extrapolatedNumRows_ != -1L) {
            this.cardinality_ = this.extrapolatedNumRows_;
        } else {
            this.cardinality_ = statsNumRows;
            if (this.sampleParams_ != null && this.cardinality_ != -1L) {
                double fracPercBytes = (double)this.sampleParams_.getPercentBytes() / 100.0;
                this.cardinality_ = Math.round((double)this.cardinality_ * fracPercBytes);
                this.cardinality_ = Math.max(this.cardinality_, 1L);
            }
        }
        if (HdfsScanNode.sumValues(this.totalBytesPerFs_) == 0L) {
            this.inputCardinality_ = 0L;
            this.cardinality_ = 0L;
            return;
        }
        if (this.cardinality_ != -1L) {
            for (Type t : this.desc_.getPath().getMatchedTypes()) {
                if (!t.isCollectionType()) continue;
                this.cardinality_ *= 10L;
            }
        }
        this.inputCardinality_ = this.cardinality_;
        if (this.cardinality_ < -1L) {
            this.hasCorruptTableStats_ = true;
            this.cardinality_ = -1L;
        }
        if (this.cardinality_ > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("cardinality_=" + Long.toString(this.cardinality_) + " sel=" + Double.toString(this.computeSelectivity()));
            }
            this.cardinality_ = this.applyConjunctsSelectivity(this.cardinality_);
        }
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        if (this.isPartitionKeyScan_) {
            long numRanges = this.getNumScanRanges();
            this.cardinality_ = this.cardinality_ < 0L ? numRanges : Math.min(this.cardinality_, numRanges);
            long numRangesAdjusted = MathUtil.saturatingMultiply(numRanges, PARTITION_KEY_SCAN_INPUT_CARDINALITY_ADJUSTMENT_FACTOR);
            long l = this.inputCardinality_ = this.inputCardinality_ < 0L ? numRangesAdjusted : Math.min(this.inputCardinality_, numRangesAdjusted);
        }
        if (this.countStarSlot_ != null) {
            long totalFiles;
            this.inputCardinality_ = totalFiles = HdfsScanNode.sumValues(this.totalFilesPerFs_);
            this.cardinality_ = totalFiles;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("HdfsScan: cardinality_=" + Long.toString(this.cardinality_));
        }
    }

    private long getStatsNumRows(TQueryOptions queryOptions) {
        this.numPartitionsWithNumRows_ = 0;
        this.partitionNumRows_ = -1L;
        this.hasCorruptTableStats_ = false;
        ArrayList<FeFsPartition> partitionsWithCorruptOrMissingStats = new ArrayList<FeFsPartition>();
        for (FeFsPartition p : this.partitions_) {
            long partNumRows = p.getNumRows();
            if (partNumRows < -1L || partNumRows == 0L && p.getSize() > 0L) {
                this.hasCorruptTableStats_ = true;
                partitionsWithCorruptOrMissingStats.add(p);
                continue;
            }
            if (partNumRows == -1L) {
                partitionsWithCorruptOrMissingStats.add(p);
                continue;
            }
            if (partNumRows <= -1L) continue;
            if (this.partitionNumRows_ == -1L) {
                this.partitionNumRows_ = 0L;
            }
            this.partitionNumRows_ = HdfsScanNode.checkedAdd(this.partitionNumRows_, partNumRows);
            ++this.numPartitionsWithNumRows_;
        }
        if (partitionsWithCorruptOrMissingStats.size() == 0 && this.numPartitionsWithNumRows_ > 0) {
            return this.partitionNumRows_;
        }
        long numRows = this.tbl_.getNumRows();
        if (!queryOptions.disable_hdfs_num_rows_estimate && (numRows == -1L || this.hasCorruptTableStats_) && this.tableNumRowsHint_ == -1L) {
            long estimatedTableSize = this.computeEstimatedTableSize(partitionsWithCorruptOrMissingStats);
            double sumAvgRowSizes = 0.0;
            for (Column col : this.tbl_.getColumns()) {
                Type currentType = col.getType();
                if (!(currentType instanceof ScalarType)) continue;
                if (col.getStats().hasAvgSize()) {
                    sumAvgRowSizes += col.getStats().getAvgSerializedSize();
                    continue;
                }
                sumAvgRowSizes += (double)col.getType().getSlotSize();
            }
            long estNumRows = 0L;
            estNumRows = sumAvgRowSizes == 0.0 ? Math.round((double)estimatedTableSize / this.DEFAULT_ROW_WIDTH_ESTIMATE) : Math.round((double)estimatedTableSize / sumAvgRowSizes);
            this.partitionNumRows_ = this.partitionNumRows_ > 0L ? this.partitionNumRows_ + estNumRows : estNumRows;
            numRows = this.partitionNumRows_;
        }
        if (numRows < -1L || numRows == 0L && this.tbl_.getTotalHdfsBytes() > 0L) {
            this.hasCorruptTableStats_ = true;
        }
        return numRows >= 0L && !this.hasCorruptTableStats_ || this.tableNumRowsHint_ == -1L ? numRows : this.tableNumRowsHint_;
    }

    private long computeEstimatedTableSize(List<FeFsPartition> partitions) {
        long estimatedTableSize = 0L;
        for (FeFsPartition p : partitions) {
            HdfsFileFormat format = p.getFileFormat();
            long estimatedPartitionSize = 0L;
            if (format == HdfsFileFormat.TEXT || format == HdfsFileFormat.JSON) {
                for (HdfsPartition.FileDescriptor desc : p.getFileDescriptors()) {
                    HdfsCompression compression = HdfsCompression.fromFileName(desc.getPath());
                    if (HdfsCompression.SUFFIX_MAP.containsValue((Object)compression)) {
                        estimatedPartitionSize += Math.round((double)desc.getFileLength() * ESTIMATED_COMPRESSION_FACTOR_LEGACY);
                        continue;
                    }
                    estimatedPartitionSize += Math.round((double)desc.getFileLength() * ESTIMATED_COMPRESSION_FACTOR_UNCOMPRESSED);
                }
            } else if (VALID_LEGACY_FORMATS.contains((Object)format)) {
                estimatedPartitionSize += Math.round((double)p.getSize() * ESTIMATED_COMPRESSION_FACTOR_LEGACY);
            } else {
                Preconditions.checkState((boolean)VALID_COLUMNAR_FORMATS.contains((Object)format), (String)"Unknown HDFS compressed format: %s", (Object)((Object)format), (Object)this);
                estimatedPartitionSize += Math.round((double)p.getSize() * ESTIMATED_COMPRESSION_FACTOR_COLUMNAR);
            }
            estimatedTableSize += estimatedPartitionSize;
        }
        return estimatedTableSize;
    }

    protected void computeNumNodes(Analyzer analyzer, long cardinality) {
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_);
        ExecutorMembershipSnapshot cluster = ExecutorMembershipSnapshot.getCluster();
        int maxInstancesPerNode = this.getMaxInstancesPerNode(analyzer);
        int maxPossibleInstances = analyzer.numExecutorsForPlanning() * maxInstancesPerNode;
        int totalNodes = 0;
        int totalInstances = 0;
        int numLocalRanges = 0;
        int numRemoteRanges = 0;
        HashMap<TNetworkAddress, Integer> localRangeCounts = new HashMap<TNetworkAddress, Integer>();
        int totalLocalParallelism = 0;
        if (this.scanRangeSpecs_.isSetConcrete_ranges()) {
            if (analyzer.getQueryOptions().planner_testcase_mode) {
                HashSet dummyHostIndex = Sets.newHashSet();
                for (TScanRangeLocationList range : this.scanRangeSpecs_.concrete_ranges) {
                    for (TScanRangeLocation loc : range.locations) {
                        dummyHostIndex.add(loc.getHost_idx());
                        ++numLocalRanges;
                    }
                }
                totalNodes = Math.min(this.scanRangeSpecs_.concrete_ranges.size(), analyzer.getQueryOptions().getReplica_preference().equals((Object)TReplicaPreference.REMOTE) ? analyzer.numExecutorsForPlanning() : dummyHostIndex.size());
                totalInstances = Math.min(this.scanRangeSpecs_.concrete_ranges.size(), totalNodes * maxInstancesPerNode);
                LOG.info(String.format("Planner running in DEBUG mode. ScanNode: %s, TotalNodes %d, TotalInstances %d Local Ranges %d", this.tbl_.getFullName(), totalNodes, totalInstances, numLocalRanges));
            } else {
                for (TScanRangeLocationList range : this.scanRangeSpecs_.concrete_ranges) {
                    int numRemoteNodes;
                    int numLocalNodes;
                    boolean anyLocal = false;
                    if (range.isSetLocations()) {
                        for (TScanRangeLocation loc : range.locations) {
                            TNetworkAddress dataNode = analyzer.getHostIndex().getEntry(loc.getHost_idx());
                            if (!cluster.contains(dataNode)) continue;
                            anyLocal = true;
                            int count = localRangeCounts.getOrDefault(dataNode, 0);
                            if (count >= maxInstancesPerNode) continue;
                            ++totalLocalParallelism;
                            localRangeCounts.put(dataNode, count + 1);
                        }
                    }
                    if (anyLocal) {
                        ++numLocalRanges;
                    } else {
                        ++numRemoteRanges;
                    }
                    if ((totalInstances = this.computeNumInstances(numLocalRanges, numRemoteRanges, totalNodes = Math.min((numLocalNodes = Math.min(numLocalRanges, localRangeCounts.size())) + (numRemoteNodes = Math.min(numRemoteRanges, analyzer.numExecutorsForPlanning())), analyzer.numExecutorsForPlanning()), maxInstancesPerNode, totalLocalParallelism)) != maxPossibleInstances) continue;
                    break;
                }
            }
        }
        if (totalInstances < maxPossibleInstances && this.scanRangeSpecs_.isSetSplit_specs()) {
            Preconditions.checkState((this.generatedScanRangeCount_ >= (long)this.scanRangeSpecs_.getSplit_specsSize() ? 1 : 0) != 0);
            numRemoteRanges = (int)((long)numRemoteRanges + this.generatedScanRangeCount_);
            int numLocalNodes = Math.min(numLocalRanges, localRangeCounts.size());
            totalNodes = Math.min(numLocalNodes + numRemoteRanges, analyzer.numExecutorsForPlanning());
            totalInstances = this.computeNumInstances(numLocalRanges, numRemoteRanges, totalNodes, maxInstancesPerNode, totalLocalParallelism);
        }
        this.numNodes_ = cardinality == 0L || totalNodes == 0 ? 1 : totalNodes;
        int n = this.numInstances_ = cardinality == 0L || totalInstances == 0 ? 1 : totalInstances;
        if (LOG.isTraceEnabled()) {
            LOG.trace("computeNumNodes totalRanges=" + this.getEffectiveNumScanRanges() + " localRanges=" + numLocalRanges + " remoteRanges=" + numRemoteRanges + " localRangeCounts.size=" + localRangeCounts.size() + " totalLocalParallelism=" + totalLocalParallelism + " executorNodes=" + analyzer.numExecutorsForPlanning() + "  numNodes=" + this.numNodes_ + " numInstances=" + this.numInstances_);
        }
    }

    private int computeNumInstances(int numLocalRanges, int numRemoteRanges, int numNodes, int maxInstancesPerNode, int totalLocalParallelism) {
        int numLocalInstances = Math.min(numLocalRanges, totalLocalParallelism);
        return Math.min(numLocalInstances + numRemoteRanges, numNodes * maxInstancesPerNode);
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        Preconditions.checkState((boolean)false, (Object)"Unexpected use of old toThrift() signature.");
    }

    @Override
    protected void toThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        msg.hdfs_scan_node = new THdfsScanNode(serialCtx.translateTupleId(this.desc_.getId()).asInt(), new HashSet<THdfsFileFormat>());
        serialCtx.registerTable(this.desc_.getTable());
        if (this.replicaPreference_ != null) {
            msg.hdfs_scan_node.setReplica_preference(this.replicaPreference_);
        }
        msg.hdfs_scan_node.setRandom_replica(this.randomReplica_);
        msg.node_type = TPlanNodeType.HDFS_SCAN_NODE;
        if (!this.collectionConjuncts_.isEmpty()) {
            LinkedHashMap<Integer, List<TExpr>> tcollectionConjuncts = new LinkedHashMap<Integer, List<TExpr>>();
            for (Map.Entry<TupleDescriptor, List<Expr>> entry : this.collectionConjuncts_.entrySet()) {
                tcollectionConjuncts.put(serialCtx.translateTupleId(entry.getKey().getId()).asInt(), Expr.treesToThrift(entry.getValue(), serialCtx));
            }
            msg.hdfs_scan_node.setCollection_conjuncts(tcollectionConjuncts);
        }
        if (this.skipHeaderLineCount_ > 0) {
            msg.hdfs_scan_node.setSkip_header_line_count(this.skipHeaderLineCount_);
        }
        msg.hdfs_scan_node.setUse_mt_scan_node(this.useMtScanNode_);
        Preconditions.checkState((this.optimizedAggSmap_ == null == (this.countStarSlot_ == null) ? 1 : 0) != 0);
        if (this.countStarSlot_ != null) {
            msg.hdfs_scan_node.setCount_star_slot_offset(this.countStarSlot_.getByteOffset());
        }
        if (!serialCtx.isTupleCache()) {
            if (!this.statsConjuncts_.isEmpty()) {
                for (Expr expr : this.statsConjuncts_) {
                    msg.hdfs_scan_node.addToStats_conjuncts(expr.treeToThrift());
                }
            }
            if (this.statsTuple_ != null) {
                msg.hdfs_scan_node.setStats_tuple_id(this.statsTuple_.getId().asInt());
            }
            LinkedHashMap<Integer, List<Integer>> dictMap = new LinkedHashMap<Integer, List<Integer>>();
            for (Map.Entry<SlotDescriptor, List<Integer>> entry : this.dictionaryFilterConjuncts_.entrySet()) {
                dictMap.put(entry.getKey().getId().asInt(), entry.getValue());
            }
            msg.hdfs_scan_node.setDictionary_filter_conjuncts(dictMap);
        }
        msg.hdfs_scan_node.setIs_partition_key_scan(this.isPartitionKeyScan_);
        for (HdfsFileFormat hdfsFileFormat : this.fileFormats_) {
            msg.hdfs_scan_node.addToFile_formats(hdfsFileFormat.toThrift());
        }
        if (!this.overlapPredicateDescs_.isEmpty()) {
            for (TOverlapPredicateDesc tOverlapPredicateDesc : this.overlapPredicateDescs_) {
                msg.hdfs_scan_node.addToOverlap_predicate_descs(tOverlapPredicateDesc);
            }
        }
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        FeFsTable table = (FeFsTable)this.desc_.getTable();
        output.append(String.format("%s%s [%s", prefix, this.getDisplayLabel(), this.getDisplayLabelDetail()));
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal() && this.fragment_.isPartitioned()) {
            output.append(", " + this.fragment_.getDataPartition().getExplainString());
        }
        output.append("]\n");
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
            String derivedExplain;
            if (this.partitionConjuncts_ != null && !this.partitionConjuncts_.isEmpty()) {
                output.append(detailPrefix).append(String.format("partition predicates: %s\n", Expr.getExplainString(this.partitionConjuncts_, detailLevel)));
            }
            String partMetaTemplate = "partitions=%d/%d files=%d size=%s\n";
            String erasureCodeTemplate = "erasure coded: files=%d size=%s\n";
            if (!this.numPartitionsPerFs_.isEmpty()) {
                for (Map.Entry<FileSystemUtil.FsType, Long> entry : this.numPartitionsPerFs_.entrySet()) {
                    FileSystemUtil.FsType fsType = entry.getKey();
                    output.append(detailPrefix);
                    output.append((Object)fsType).append(" ");
                    output.append(String.format(partMetaTemplate, entry.getValue(), table.getPartitions().size(), this.totalFilesPerFs_.get((Object)fsType), PrintUtils.printBytes(this.totalBytesPerFs_.get((Object)fsType))));
                    if (!this.totalFilesPerFsEC_.containsKey((Object)fsType)) continue;
                    long totalNumECFiles = this.totalFilesPerFsEC_.get((Object)fsType);
                    long totalECSize = this.totalBytesPerFsEC_.get((Object)fsType);
                    output.append(String.format("%s", detailPrefix)).append(String.format(erasureCodeTemplate, totalNumECFiles, PrintUtils.printBytes(totalECSize)));
                }
            } else if (this.tbl_.getNumClusteringCols() == 0) {
                output.append(detailPrefix);
                output.append((Object)table.getFsType()).append(" ");
                output.append(String.format(partMetaTemplate, 1, table.getPartitions().size(), 0, PrintUtils.printBytes(0L)));
            } else {
                output.append(detailPrefix);
                output.append(String.format(partMetaTemplate, 0, table.getPartitions().size(), 0, PrintUtils.printBytes(0L)));
            }
            if (!this.conjuncts_.isEmpty()) {
                output.append(detailPrefix).append(String.format("predicates: %s\n", Expr.getExplainString(this.conjuncts_, detailLevel)));
            }
            if (!this.collectionConjuncts_.isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.collectionConjuncts_.entrySet()) {
                    String alias = ((TupleDescriptor)entry.getKey()).getAlias();
                    output.append(detailPrefix).append(String.format("predicates on %s: %s\n", alias, Expr.getExplainString((List)entry.getValue(), detailLevel)));
                }
            }
            if (!this.runtimeFilters_.isEmpty()) {
                output.append(detailPrefix + "runtime filters: ");
                output.append(this.getRuntimeFilterExplainString(false, detailLevel));
            }
            if (this.isPartitionKeyScan_) {
                output.append(detailPrefix + "partition key scan\n");
            }
            if (!(derivedExplain = this.getDerivedExplainString(detailPrefix, detailLevel)).isEmpty()) {
                output.append(derivedExplain);
            }
        }
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(this.getStatsExplainString(detailPrefix)).append("\n");
            String extrapRows = FeFsTable.Utils.isStatsExtrapolationEnabled(this.tbl_) ? PrintUtils.printEstCardinality(this.extrapolatedNumRows_) : "disabled";
            output.append(detailPrefix).append("extrapolated-rows=").append(extrapRows).append(" max-scan-range-rows=").append(PrintUtils.printEstCardinality(this.maxScanRangeNumRows_));
            if (this.filteredCardinality_ > -1L && this.scanRangeSelectivity_ < 1.0) {
                output.append(String.format(" est-scan-range=%d(filtered from %d)", this.estScanRangeAfterRuntimeFilter(), this.getEffectiveNumScanRanges()));
            }
            output.append("\n");
            if (this.numScanRangesNoDiskIds_ > 0) {
                output.append(detailPrefix).append(String.format("missing disk ids: partitions=%s/%s files=%s/%s scan ranges %s/%s\n", this.numPartitionsNoDiskIds_, HdfsScanNode.sumValues(this.numPartitionsPerFs_), this.numFilesNoDiskIds_, HdfsScanNode.sumValues(this.totalFilesPerFs_), this.numScanRangesNoDiskIds_, this.getEffectiveNumScanRanges()));
            }
            output.append(this.getMinMaxOriginalConjunctsExplainString(detailPrefix, detailLevel));
            output.append(this.getDictionaryConjunctsExplainString(detailPrefix, detailLevel));
        }
        if (detailLevel.ordinal() >= TExplainLevel.VERBOSE.ordinal()) {
            List formats = this.fileFormats_.stream().map(Object::toString).collect(Collectors.toList());
            Collections.sort(formats);
            output.append(detailPrefix).append("file formats: ").append(formats.toString()).append("\n");
        }
        return output.toString();
    }

    protected String getDerivedExplainString(String indentPrefix, TExplainLevel detailLevel) {
        return "";
    }

    private String getMinMaxOriginalConjunctsExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<TupleDescriptor, List<Expr>> entry : this.statsOriginalConjuncts_.entrySet()) {
            String fileFormatStr;
            TupleDescriptor tupleDesc = entry.getKey();
            List<Expr> exprs = entry.getValue();
            if (this.hasParquet(this.fileFormats_) && this.hasOrc(this.fileFormats_)) {
                fileFormatStr = "parquet/orc";
            } else {
                String string = fileFormatStr = this.hasParquet(this.fileFormats_) ? "parquet" : "orc";
            }
            if (tupleDesc == this.getTupleDesc()) {
                output.append(prefix).append(String.format("%s statistics predicates: %s\n", fileFormatStr, Expr.getExplainString(exprs, detailLevel)));
                continue;
            }
            output.append(prefix).append(String.format("%s statistics predicates on %s: %s\n", fileFormatStr, tupleDesc.getAlias(), Expr.getExplainString(exprs, detailLevel)));
        }
        return output.toString();
    }

    private String getDictionaryConjunctsExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        LinkedHashMap perTupleConjuncts = new LinkedHashMap();
        for (Map.Entry<SlotDescriptor, List<Integer>> entry : this.dictionaryFilterConjuncts_.entrySet()) {
            SlotDescriptor slotDescriptor = entry.getKey();
            TupleDescriptor tupleDescriptor = slotDescriptor.getParent();
            ArrayList indexes = (ArrayList)perTupleConjuncts.get(tupleDescriptor);
            if (indexes == null) {
                indexes = new ArrayList();
                perTupleConjuncts.put(tupleDescriptor, indexes);
            }
            indexes.addAll(entry.getValue());
        }
        for (Map.Entry<SlotDescriptor, List<Integer>> entry : perTupleConjuncts.entrySet()) {
            List<Expr> conjuncts;
            List<Integer> totalIdxList = entry.getValue();
            Collections.sort(totalIdxList);
            TupleDescriptor tupleDescriptor = (TupleDescriptor)((Object)entry.getKey());
            String tupleName = "";
            if (tupleDescriptor == this.getTupleDesc()) {
                conjuncts = this.conjuncts_;
            } else {
                conjuncts = this.collectionConjuncts_.get(tupleDescriptor);
                tupleName = " on " + tupleDescriptor.getAlias();
            }
            Preconditions.checkNotNull((Object)conjuncts);
            ArrayList<Expr> exprList = new ArrayList<Expr>();
            for (Integer idx : totalIdxList) {
                Preconditions.checkState((idx < conjuncts.size() ? 1 : 0) != 0);
                exprList.add(conjuncts.get(idx));
            }
            output.append(String.format("%sparquet dictionary predicates%s: %s\n", prefix, tupleName, Expr.getExplainString(exprList, detailLevel)));
        }
        return output.toString();
    }

    @Override
    protected String getTableStatsExplainString(String prefix) {
        StringBuilder output = new StringBuilder();
        TTableStats tblStats = this.desc_.getTable().getTTableStats();
        String totalBytes = PrintUtils.printBytes(tblStats.total_file_bytes);
        if (tblStats.total_file_bytes == -1L) {
            totalBytes = "unavailable";
        }
        output.append(String.format("%stable: rows=%s size=%s", prefix, PrintUtils.printEstCardinality(tblStats.num_rows), totalBytes));
        if (this.tbl_.getNumClusteringCols() > 0) {
            output.append("\n");
            output.append(String.format("%spartitions: %s/%s rows=%s", prefix, this.numPartitionsWithNumRows_, this.partitions_.size(), PrintUtils.printEstCardinality(this.partitionNumRows_)));
        }
        return output.toString();
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_);
        this.processingCost_ = this.computeScanProcessingCost(queryOptions);
    }

    @Override
    protected ProcessingCost computeScanProcessingCost(TQueryOptions queryOptions) {
        long inputCardinality = this.getFilteredInputCardinality();
        long estBytes = 0L;
        double bytesCostCoefficient = 0.0;
        double predicateCostCoefficient = 0.0;
        if (inputCardinality >= 0L) {
            if (this.allColumnarFormat_) {
                float avgRowDataSize = this.getAvgRowSizeWithoutPad();
                estBytes = (long)Math.ceil((double)avgRowDataSize * (double)inputCardinality);
                bytesCostCoefficient = 0.0144;
                predicateCostCoefficient = 0.0281;
            } else {
                estBytes = HdfsScanNode.sumValues(this.totalBytesPerFs_);
                bytesCostCoefficient = 0.0354;
                predicateCostCoefficient = 0.0549;
            }
            double totalCost = (double)estBytes * bytesCostCoefficient + (double)(inputCardinality * (long)this.getConjuncts().size()) * predicateCostCoefficient;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Scan CPU cost estimate: " + totalCost + ", All Columnar: " + this.allColumnarFormat_ + ", Input Cardinality: " + inputCardinality + ", Bytes: " + estBytes + ", Pred Count: " + this.getConjuncts().size());
            }
            return ProcessingCost.basicCost(this.getDisplayLabel(), totalCost);
        }
        return super.computeScanProcessingCost(queryOptions);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        long perHostUpperBound;
        long perInstanceMemEstimate;
        this.useMtScanNode_ = Planner.useMTFragment(queryOptions);
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_, (Object)"Cost estimation requires scan ranges.");
        long scanRangeSize = this.getEffectiveNumScanRanges();
        if (scanRangeSize == 0L) {
            this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
            return;
        }
        Preconditions.checkState((0 < this.numNodes_ ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.numNodes_ <= scanRangeSize ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.desc_);
        Preconditions.checkState((boolean)(this.desc_.getTable() instanceof FeFsTable));
        List<Long> columnReservations = null;
        if (this.hasParquet(this.fileFormats_) || this.hasOrc(this.fileFormats_)) {
            boolean orcAsyncRead = this.hasOrc(this.fileFormats_) && queryOptions.orc_async_read;
            columnReservations = this.computeMinColumnMemReservations(orcAsyncRead);
        }
        int perHostScanRanges = 0;
        for (HdfsFileFormat format : this.fileFormats_) {
            int partitionScanRange = 0;
            if (format.isParquetBased() || format == HdfsFileFormat.ORC) {
                Preconditions.checkNotNull(columnReservations);
                partitionScanRange = columnReservations.size();
            } else {
                partitionScanRange = this.estimatePerHostScanRanges(scanRangeSize);
            }
            if (partitionScanRange <= perHostScanRanges) continue;
            perHostScanRanges = partitionScanRange;
        }
        int requiredThreads = this.useMtScanNode_ ? 0 : 1;
        int maxScannerThreads = this.computeMaxNumberOfScannerThreads(queryOptions, perHostScanRanges);
        long avgScanRangeBytes = (long)Math.ceil((double)HdfsScanNode.sumValues(this.totalBytesPerFs_) / (double)scanRangeSize);
        long maxIoBufferSize = BitUtil.roundUpToPowerOf2(BackendConfig.INSTANCE.getReadSize());
        long perThreadIoBuffers = Math.min((long)Math.ceil((double)avgScanRangeBytes / (double)maxIoBufferSize), 10L) + 1L;
        if (queryOptions.compute_processing_cost) {
            Preconditions.checkState((maxScannerThreads == 1 ? 1 : 0) != 0);
            perThreadIoBuffers = 2L;
        }
        if ((perInstanceMemEstimate = HdfsScanNode.checkedMultiply(HdfsScanNode.checkedMultiply(maxScannerThreads, perThreadIoBuffers), maxIoBufferSize)) > (perHostUpperBound = HdfsScanNode.getPerHostMemUpperBound())) {
            LOG.warn(String.format("Per-instance mem cost %s exceeded per-host upper bound %s.", PrintUtils.printBytes(perInstanceMemEstimate), PrintUtils.printBytes(perHostUpperBound)));
            perInstanceMemEstimate = perHostUpperBound;
        }
        perInstanceMemEstimate = Math.max(perInstanceMemEstimate, 0x100000L);
        this.nodeResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(perInstanceMemEstimate).setMinMemReservationBytes(this.computeMinMemReservation(columnReservations, queryOptions)).setThreadReservation(requiredThreads).build();
    }

    private long computeMinMemReservation(List<Long> columnReservations, TQueryOptions queryOptions) {
        Preconditions.checkState((this.largestScanRangeBytes_ >= 0L ? 1 : 0) != 0);
        long maxIoBufferSize = BitUtil.roundUpToPowerOf2(BackendConfig.INSTANCE.getReadSize());
        long reservationBytes = 0L;
        for (HdfsFileFormat format : this.fileFormats_) {
            long formatReservationBytes = 0L;
            if (format.isParquetBased() || format == HdfsFileFormat.ORC && queryOptions.orc_async_read) {
                for (long columnReservation : columnReservations) {
                    formatReservationBytes += columnReservation;
                }
                long footerSize = format == HdfsFileFormat.ORC ? 16384L : 102400L;
                formatReservationBytes = Math.max(footerSize, formatReservationBytes);
            } else {
                formatReservationBytes = maxIoBufferSize;
            }
            reservationBytes = Math.max(reservationBytes, formatReservationBytes);
        }
        reservationBytes = HdfsScanNode.roundUpToIoBuffer(reservationBytes, maxIoBufferSize);
        int iomgrScanRangesPerSplit = columnReservations != null ? Math.max(1, columnReservations.size()) : 1;
        long maxReservationBytes = HdfsScanNode.roundUpToIoBuffer(this.largestScanRangeBytes_, maxIoBufferSize);
        return Math.max((long)iomgrScanRangesPerSplit * BackendConfig.INSTANCE.getMinBufferSize(), Math.min(reservationBytes, maxReservationBytes));
    }

    private List<Long> computeMinColumnMemReservations(boolean orcAsyncRead) {
        ArrayList<Long> columnByteSizes = new ArrayList<Long>();
        FeFsTable table = (FeFsTable)this.desc_.getTable();
        boolean havePosSlot = false;
        for (SlotDescriptor slot : this.desc_.getSlots()) {
            if (!slot.isMaterialized() || slot == this.countStarSlot_ || slot.getColumn() != null && slot.getColumn().getPosition() < table.getNumClusteringCols()) continue;
            Type type = slot.getType();
            if (slot.isArrayPosRef()) {
                havePosSlot = true;
                continue;
            }
            if (type.isScalarType()) {
                Column column = slot.getColumn();
                long estReservation = column == null ? 0x400000L : this.computeMinScalarColumnMemReservation(column);
                if (orcAsyncRead) {
                    int estNumStream = 2;
                    if (type.isTimestamp() || type.isStringType() || type.isDecimal()) {
                        ++estNumStream;
                        if (type.isStringType()) {
                            ++estNumStream;
                        }
                    }
                    long reservationPerStream = estReservation / (long)estNumStream;
                    for (int i = 0; i < estNumStream; ++i) {
                        columnByteSizes.add(reservationPerStream);
                    }
                    continue;
                }
                columnByteSizes.add(estReservation);
                continue;
            }
            this.appendMinColumnMemReservationsForComplexType(slot, columnByteSizes, orcAsyncRead);
        }
        if (columnByteSizes.isEmpty() && (havePosSlot || orcAsyncRead && this.desc_.getSlots().isEmpty())) {
            this.appendDefaultColumnReservation(columnByteSizes, orcAsyncRead);
        }
        return columnByteSizes;
    }

    private void appendMinColumnMemReservationsForComplexType(SlotDescriptor complexSlot, List<Long> columnMemReservations, boolean orcAsyncRead) {
        Preconditions.checkState((boolean)complexSlot.getType().isComplexType());
        boolean addedColumn = false;
        for (SlotDescriptor nestedSlot : complexSlot.getItemTupleDesc().getSlots()) {
            if (!nestedSlot.isMaterialized() || nestedSlot.isArrayPosRef()) continue;
            if (nestedSlot.getType().isScalarType()) {
                this.appendDefaultColumnReservation(columnMemReservations, orcAsyncRead);
                addedColumn = true;
                continue;
            }
            if (!nestedSlot.getType().isComplexType()) continue;
            this.appendMinColumnMemReservationsForComplexType(nestedSlot, columnMemReservations, orcAsyncRead);
        }
        if (!addedColumn) {
            this.appendDefaultColumnReservation(columnMemReservations, orcAsyncRead);
        }
    }

    private void appendDefaultColumnReservation(List<Long> columnMemReservations, boolean orcAsyncRead) {
        if (orcAsyncRead) {
            int estNumStream = 4;
            Long reservationPerStream = 0x400000L / (long)estNumStream;
            for (int i = 0; i < estNumStream; ++i) {
                columnMemReservations.add(reservationPerStream);
            }
        } else {
            columnMemReservations.add(0x400000L);
        }
    }

    private long computeMinScalarColumnMemReservation(Column column) {
        Preconditions.checkNotNull((Object)column);
        long reservationBytes = 0x400000L;
        ColumnStats stats = column.getStats();
        if (stats.hasAvgSize() && this.maxScanRangeNumRows_ != -1L) {
            reservationBytes = (long)Math.min((double)reservationBytes, stats.getAvgSize() * (double)this.maxScanRangeNumRows_);
            if (stats.hasNumDistinctValues()) {
                long dictBytes = (long)(stats.getAvgSize() * (double)stats.getNumDistinctValues());
                long bitsPerVal = BitUtil.log2Ceiling(stats.getNumDistinctValues());
                long encodedDataBytes = bitsPerVal * this.maxScanRangeNumRows_ / 8L;
                reservationBytes = Math.min(reservationBytes, dictBytes + encodedDataBytes);
            }
        }
        return reservationBytes;
    }

    private static long roundUpToIoBuffer(long bytes, long maxIoBufferSize) {
        return bytes < maxIoBufferSize ? BitUtil.roundUpToPowerOf2(bytes) : BitUtil.roundUpToPowerOf2Factor(bytes, maxIoBufferSize);
    }

    public static long getPerHostMemUpperBound() {
        return (long)RuntimeEnv.INSTANCE.getNumCores() * 3L * 10L * BackendConfig.INSTANCE.getReadSize();
    }

    @Override
    public boolean isTableMissingTableStats() {
        if (this.extrapolatedNumRows_ >= 0L) {
            return false;
        }
        if (this.tbl_.getNumClusteringCols() > 0 && this.numPartitionsWithNumRows_ != this.partitions_.size()) {
            return true;
        }
        return super.isTableMissingTableStats();
    }

    @Override
    public boolean hasCorruptTableStats() {
        return this.hasCorruptTableStats_;
    }

    public boolean hasMissingDiskIds() {
        return this.numScanRangesNoDiskIds_ > 0;
    }

    protected Map<TupleDescriptor, List<Expr>> getCollectionConjuncts() {
        return this.collectionConjuncts_;
    }

    protected Set<HdfsFileFormat> getFileFormats() {
        return this.fileFormats_;
    }

    private static long sumValues(Map<?, Long> input) {
        return input.values().stream().mapToLong(Long::longValue).sum();
    }

    public long getNumScanRanges() {
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_);
        return this.scanRangeSpecs_.getConcrete_rangesSize() + this.scanRangeSpecs_.getSplit_specsSize();
    }

    @Override
    public long getEffectiveNumScanRanges() {
        Preconditions.checkNotNull((Object)this.scanRangeSpecs_);
        Preconditions.checkState((this.generatedScanRangeCount_ >= (long)this.scanRangeSpecs_.getSplit_specsSize() ? 1 : 0) != 0);
        return (long)this.scanRangeSpecs_.getConcrete_rangesSize() + this.generatedScanRangeCount_;
    }

    public void arrangeRuntimefiltersForParquet() {
        if (this.allParquet_) {
            Collections.sort(this.runtimeFilters_, new Comparator<RuntimeFilterGenerator.RuntimeFilter>(){

                @Override
                public int compare(RuntimeFilterGenerator.RuntimeFilter a, RuntimeFilterGenerator.RuntimeFilter b) {
                    if (a.getType() == b.getType()) {
                        return 0;
                    }
                    if (a.getType() == TRuntimeFilterType.MIN_MAX && b.getType() == TRuntimeFilterType.BLOOM) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
    }

    protected boolean isAllColumnarScanner() {
        return this.allColumnarFormat_;
    }

    @Override
    public boolean isTupleCachingImplemented() {
        return true;
    }
}

