/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BetweenPredicate;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TableSampleClause;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.HdfsPartitionFilter;
import org.apache.impala.rewrite.BetweenToCompoundRule;
import org.apache.impala.rewrite.ExprRewriteRule;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.rewrite.FoldConstantsRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsPartitionPruner {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsPartitionPruner.class);
    private static final int PARTITION_PRUNING_BATCH_SIZE = 1024;
    private final FeFsTable tbl_;
    private final List<SlotId> partitionSlots_;
    private final ExprRewriter exprRewriter_ = new ExprRewriter(new ArrayList<ExprRewriteRule>(Arrays.asList(BetweenToCompoundRule.INSTANCE, FoldConstantsRule.INSTANCE)));

    public HdfsPartitionPruner(TupleDescriptor tupleDesc) {
        Preconditions.checkState((boolean)(tupleDesc.getTable() instanceof FeFsTable));
        this.tbl_ = (FeFsTable)tupleDesc.getTable();
        this.partitionSlots_ = tupleDesc.getPartitionSlots();
    }

    public Pair<List<? extends FeFsPartition>, List<Expr>> prunePartitions(Analyzer analyzer, List<Expr> conjuncts, boolean allowEmpty, TableRef hdfsTblRef) throws ImpalaException {
        ArrayList<HdfsPartitionFilter> partitionFilters = new ArrayList<HdfsPartitionFilter>();
        ArrayList<Expr> simpleFilterConjuncts = new ArrayList<Expr>();
        ArrayList<Object> partitionConjuncts = new ArrayList<Object>();
        Iterator<Expr> it = conjuncts.iterator();
        while (it.hasNext()) {
            Expr conjunct = it.next();
            if (!conjunct.isBoundBySlotIds(this.partitionSlots_) || conjunct.contains(Expr.IS_NONDETERMINISTIC_BUILTIN_FN_PREDICATE)) continue;
            Expr clonedConjunct = this.exprRewriter_.rewrite(conjunct.clone(), analyzer);
            if (this.canEvalUsingPartitionMd(clonedConjunct, analyzer)) {
                simpleFilterConjuncts.add(Expr.pushNegationToOperands(clonedConjunct));
            } else {
                partitionFilters.add(new HdfsPartitionFilter(clonedConjunct, this.tbl_, analyzer));
            }
            partitionConjuncts.add(clonedConjunct);
            it.remove();
        }
        HashSet matchingPartitionIds = null;
        for (Expr filter : simpleFilterConjuncts) {
            HashSet matchingIds = this.evalSlotBindingFilter(filter);
            if (matchingPartitionIds == null) {
                matchingPartitionIds = matchingIds;
                continue;
            }
            matchingPartitionIds.retainAll(matchingIds);
        }
        if (simpleFilterConjuncts.size() == 0) {
            Preconditions.checkState((matchingPartitionIds == null ? 1 : 0) != 0);
            matchingPartitionIds = Sets.newHashSet(this.tbl_.getPartitionIds());
        }
        this.evalPartitionFiltersInBe(partitionFilters, matchingPartitionIds, analyzer);
        List<Object> results = this.tbl_.loadPartitions(matchingPartitionIds);
        if (!allowEmpty) {
            results = Lists.newArrayList((Iterable)Iterables.filter(results, (Predicate)new Predicate<FeFsPartition>(){

                public boolean apply(FeFsPartition partition) {
                    return partition.hasFileDescriptors();
                }
            }));
        }
        if (hdfsTblRef != null) {
            results = this.pruneForSimpleLimit(hdfsTblRef, analyzer, results);
        }
        return new Pair<List<? extends FeFsPartition>, List<Expr>>(results, partitionConjuncts);
    }

    private List<? extends FeFsPartition> pruneForSimpleLimit(TableRef tblRef, Analyzer analyzer, List<? extends FeFsPartition> partitions) {
        if ((tblRef.getSampleParams() == null || tblRef.hasConvertLimitToSampleHint()) && analyzer.getQueryCtx().client_request.getQuery_options().isOptimize_simple_limit() && analyzer.getSimpleLimitStatus() != null && ((Boolean)analyzer.getSimpleLimitStatus().first).booleanValue()) {
            long limitValue = (Long)analyzer.getSimpleLimitStatus().second;
            if (tblRef.hasConvertLimitToSampleHint()) {
                tblRef.setTableSampleClause(new TableSampleClause(tblRef.getConvertLimitToSampleHintPercent(), 1L));
            } else {
                ArrayList<FeFsPartition> prunedPartitions = new ArrayList<FeFsPartition>();
                long numRows = 0L;
                for (FeFsPartition feFsPartition : partitions) {
                    prunedPartitions.add(feFsPartition);
                    if ((numRows += (long)feFsPartition.getNumFileDescriptors()) < limitValue) continue;
                    break;
                }
                return prunedPartitions;
            }
        }
        return partitions;
    }

    private boolean canEvalUsingPartitionMd(Expr expr, Analyzer analyzer) {
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((!(expr instanceof BetweenPredicate) ? 1 : 0) != 0);
        if (expr instanceof BinaryPredicate) {
            try {
                expr = analyzer.getConstantFolder().rewrite(expr, analyzer);
                Preconditions.checkState((boolean)(expr instanceof BinaryPredicate));
            }
            catch (AnalysisException e) {
                LOG.error("Error evaluating constant expressions in the BE: " + e.getMessage());
                return false;
            }
            BinaryPredicate bp = (BinaryPredicate)expr;
            if (((Expr)bp.getChild(0)).isImplicitCast()) {
                return false;
            }
            SlotRef slot = bp.getBoundSlot();
            if (slot == null) {
                return false;
            }
            Expr bindingExpr = bp.getSlotBinding(slot.getSlotId());
            return bindingExpr != null && Expr.IS_LITERAL.apply((Object)bindingExpr);
        }
        if (expr instanceof CompoundPredicate) {
            boolean res = this.canEvalUsingPartitionMd((Expr)expr.getChild(0), analyzer);
            if (expr.getChild(1) != null) {
                res &= this.canEvalUsingPartitionMd((Expr)expr.getChild(1), analyzer);
            }
            return res;
        }
        if (expr instanceof IsNullPredicate) {
            IsNullPredicate nullPredicate = (IsNullPredicate)expr;
            return nullPredicate.getBoundSlot() != null;
        }
        if (expr instanceof InPredicate) {
            try {
                analyzer.getConstantFolder().rewrite(expr, analyzer);
            }
            catch (AnalysisException e) {
                LOG.error("Error evaluating constant expressions in the BE: " + e.getMessage());
                return false;
            }
            SlotRef slot = ((InPredicate)expr).getBoundSlot();
            if (slot == null) {
                return false;
            }
            for (int i = 1; i < expr.getChildren().size(); ++i) {
                if (Expr.IS_LITERAL.apply(expr.getChild(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<Long> evalBinaryPredicate(Expr expr) {
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((boolean)(expr instanceof BinaryPredicate));
        boolean isSlotOnLeft = true;
        if (Expr.IS_LITERAL.apply(expr.getChild(0))) {
            isSlotOnLeft = false;
        }
        BinaryPredicate bp = (BinaryPredicate)expr;
        SlotRef slot = bp.getBoundSlot();
        Preconditions.checkNotNull((Object)slot);
        Expr bindingExpr = bp.getSlotBinding(slot.getSlotId());
        Preconditions.checkNotNull((Object)bindingExpr);
        Preconditions.checkState((boolean)Expr.IS_LITERAL.apply((Object)bindingExpr));
        LiteralExpr literal = (LiteralExpr)bindingExpr;
        BinaryPredicate.Operator op = bp.getOp();
        if (Expr.IS_NULL_LITERAL.apply((Object)literal) && op != BinaryPredicate.Operator.NOT_DISTINCT && op != BinaryPredicate.Operator.DISTINCT_FROM) {
            return new HashSet<Long>();
        }
        int partitionPos = slot.getDesc().getColumn().getPosition();
        TreeMap<LiteralExpr, Set<Long>> partitionValueMap = this.tbl_.getPartitionValueMap(partitionPos);
        if (partitionValueMap.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> matchingIds = new HashSet<Long>();
        if (op == BinaryPredicate.Operator.NOT_DISTINCT) {
            if (Expr.IS_NULL_LITERAL.apply((Object)literal)) {
                Set<Long> ids = this.tbl_.getNullPartitionIds(partitionPos);
                if (ids != null) {
                    matchingIds.addAll(ids);
                }
                return matchingIds;
            }
            op = BinaryPredicate.Operator.EQ;
        }
        if (op == BinaryPredicate.Operator.EQ) {
            Set<Long> ids = partitionValueMap.get(literal);
            if (ids != null) {
                matchingIds.addAll(ids);
            }
            return matchingIds;
        }
        if (op == BinaryPredicate.Operator.DISTINCT_FROM) {
            matchingIds.addAll(this.tbl_.getPartitionIds());
            if (Expr.IS_NULL_LITERAL.apply((Object)literal)) {
                Set<Long> nullIds = this.tbl_.getNullPartitionIds(partitionPos);
                matchingIds.removeAll(nullIds);
            } else {
                Set<Long> ids = partitionValueMap.get(literal);
                if (ids != null) {
                    matchingIds.removeAll(ids);
                }
            }
            return matchingIds;
        }
        if (op == BinaryPredicate.Operator.NE) {
            matchingIds.addAll(this.tbl_.getPartitionIds());
            Set<Long> nullIds = this.tbl_.getNullPartitionIds(partitionPos);
            matchingIds.removeAll(nullIds);
            Set<Long> ids = partitionValueMap.get(literal);
            if (ids != null) {
                matchingIds.removeAll(ids);
            }
            return matchingIds;
        }
        NavigableMap<LiteralExpr, Set<Long>> rangeValueMap = null;
        LiteralExpr firstKey = partitionValueMap.firstKey();
        LiteralExpr lastKey = partitionValueMap.lastKey();
        boolean upperInclusive = false;
        boolean lowerInclusive = false;
        LiteralExpr upperBoundKey = null;
        LiteralExpr lowerBoundKey = null;
        if ((op == BinaryPredicate.Operator.LE || op == BinaryPredicate.Operator.LT) && isSlotOnLeft || (op == BinaryPredicate.Operator.GE || op == BinaryPredicate.Operator.GT) && !isSlotOnLeft) {
            if (literal.compareTo(firstKey) < 0) {
                return new HashSet<Long>();
            }
            if (op == BinaryPredicate.Operator.LE || op == BinaryPredicate.Operator.GE) {
                upperInclusive = true;
            }
            if (literal.compareTo(lastKey) <= 0) {
                upperBoundKey = literal;
            } else {
                upperBoundKey = lastKey;
                upperInclusive = true;
            }
            lowerBoundKey = firstKey;
            lowerInclusive = true;
        } else {
            if (literal.compareTo(lastKey) > 0) {
                return new HashSet<Long>();
            }
            if (op == BinaryPredicate.Operator.GE || op == BinaryPredicate.Operator.LE) {
                lowerInclusive = true;
            }
            if (literal.compareTo(firstKey) >= 0) {
                lowerBoundKey = literal;
            } else {
                lowerBoundKey = firstKey;
                lowerInclusive = true;
            }
            upperBoundKey = lastKey;
            upperInclusive = true;
        }
        rangeValueMap = partitionValueMap.subMap(lowerBoundKey, lowerInclusive, upperBoundKey, upperInclusive);
        for (Set idSet : rangeValueMap.values()) {
            if (idSet == null) continue;
            matchingIds.addAll(idSet);
        }
        return matchingIds;
    }

    private Set<Long> evalInPredicate(Expr expr) {
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((boolean)(expr instanceof InPredicate));
        InPredicate inPredicate = (InPredicate)expr;
        HashSet<Long> matchingIds = new HashSet<Long>();
        SlotRef slot = inPredicate.getBoundSlot();
        Preconditions.checkNotNull((Object)slot);
        int partitionPos = slot.getDesc().getColumn().getPosition();
        TreeMap<LiteralExpr, Set<Long>> partitionValueMap = this.tbl_.getPartitionValueMap(partitionPos);
        if (inPredicate.isNotIn()) {
            ArrayList nullLiterals = new ArrayList();
            inPredicate.collectAll(Predicates.instanceOf(NullLiteral.class), nullLiterals);
            if (!nullLiterals.isEmpty()) {
                return matchingIds;
            }
            matchingIds.addAll(this.tbl_.getPartitionIds());
            Set<Long> nullIds = this.tbl_.getNullPartitionIds(partitionPos);
            matchingIds.removeAll(nullIds);
        }
        for (int i = 1; i < inPredicate.getChildren().size(); ++i) {
            LiteralExpr literal = (LiteralExpr)inPredicate.getChild(i);
            Set<Long> idSet = partitionValueMap.get(literal);
            if (idSet == null) continue;
            if (inPredicate.isNotIn()) {
                matchingIds.removeAll(idSet);
                continue;
            }
            matchingIds.addAll(idSet);
        }
        return matchingIds;
    }

    private Set<Long> evalIsNullPredicate(Expr expr) {
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((boolean)(expr instanceof IsNullPredicate));
        HashSet<Long> matchingIds = new HashSet<Long>();
        IsNullPredicate nullPredicate = (IsNullPredicate)expr;
        SlotRef slot = nullPredicate.getBoundSlot();
        Preconditions.checkNotNull((Object)slot);
        int partitionPos = slot.getDesc().getColumn().getPosition();
        Set<Long> nullPartitionIds = this.tbl_.getNullPartitionIds(partitionPos);
        if (nullPredicate.isNotNull()) {
            matchingIds.addAll(this.tbl_.getPartitionIds());
            matchingIds.removeAll(nullPartitionIds);
        } else {
            matchingIds.addAll(nullPartitionIds);
        }
        return matchingIds;
    }

    private Set<Long> evalSlotBindingFilter(Expr expr) {
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((!(expr instanceof BetweenPredicate) ? 1 : 0) != 0);
        if (expr instanceof BinaryPredicate) {
            return this.evalBinaryPredicate(expr);
        }
        if (expr instanceof CompoundPredicate) {
            Set<Long> leftChildIds = this.evalSlotBindingFilter((Expr)expr.getChild(0));
            CompoundPredicate cp = (CompoundPredicate)expr;
            Preconditions.checkState((cp.getOp() != CompoundPredicate.Operator.NOT ? 1 : 0) != 0);
            if (cp.getOp() == CompoundPredicate.Operator.AND) {
                Set<Long> rightChildIds = this.evalSlotBindingFilter((Expr)expr.getChild(1));
                leftChildIds.retainAll(rightChildIds);
            } else if (cp.getOp() == CompoundPredicate.Operator.OR) {
                Set<Long> rightChildIds = this.evalSlotBindingFilter((Expr)expr.getChild(1));
                leftChildIds.addAll(rightChildIds);
            }
            return leftChildIds;
        }
        if (expr instanceof InPredicate) {
            return this.evalInPredicate(expr);
        }
        if (expr instanceof IsNullPredicate) {
            return this.evalIsNullPredicate(expr);
        }
        return null;
    }

    private void evalPartitionFiltersInBe(List<HdfsPartitionFilter> filters, Set<Long> matchingPartitionIds, Analyzer analyzer) throws ImpalaException {
        Map<Long, ? extends PrunablePartition> partitionMap = this.tbl_.getPartitionMap();
        HashSet<Long> matchingIds = new HashSet<Long>();
        ArrayList<PrunablePartition> partitionBatch = new ArrayList<PrunablePartition>();
        for (HdfsPartitionFilter filter : filters) {
            for (Long id : matchingPartitionIds) {
                PrunablePartition p = partitionMap.get(id);
                Preconditions.checkState((p.getPartitionValues().size() == this.tbl_.getNumClusteringCols() ? 1 : 0) != 0);
                partitionBatch.add(partitionMap.get(id));
                if (partitionBatch.size() != 1024) continue;
                matchingIds.addAll(filter.getMatchingPartitionIds(partitionBatch, analyzer));
                partitionBatch.clear();
            }
            if (!partitionBatch.isEmpty()) {
                matchingIds.addAll(filter.getMatchingPartitionIds(partitionBatch, analyzer));
                partitionBatch.clear();
            }
            matchingPartitionIds.retainAll(matchingIds);
            matchingIds.clear();
        }
    }
}

