/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.NotImplementedException;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TResultRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsPartitionFilter {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsPartitionFilter.class);
    private final Expr predicate_;
    private final List<SlotRef> lhsSlotRefs_ = new ArrayList<SlotRef>();
    private final List<Integer> refdKeys_ = new ArrayList<Integer>();

    public HdfsPartitionFilter(Expr predicate, FeFsTable tbl, Analyzer analyzer) {
        SlotDescriptor slotDesc;
        this.predicate_ = predicate;
        ArrayList<SlotId> refdSlots = new ArrayList<SlotId>();
        predicate.getIds(null, refdSlots);
        HashMap<Column, SlotDescriptor> slotDescsByCol = new HashMap<Column, SlotDescriptor>();
        for (SlotId refdSlot : refdSlots) {
            slotDesc = analyzer.getDescTbl().getSlotDesc(refdSlot);
            slotDescsByCol.put(slotDesc.getColumn(), slotDesc);
        }
        for (int i = 0; i < tbl.getNumClusteringCols(); ++i) {
            Column col = tbl.getColumns().get(i);
            slotDesc = (SlotDescriptor)slotDescsByCol.get(col);
            if (slotDesc == null) continue;
            this.lhsSlotRefs_.add(new SlotRef(slotDesc));
            this.refdKeys_.add(i);
        }
        Preconditions.checkState((this.lhsSlotRefs_.size() == this.refdKeys_.size() ? 1 : 0) != 0);
    }

    public Set<Long> getMatchingPartitionIds(List<PrunablePartition> partitions, Analyzer analyzer) throws ImpalaException {
        HashSet<Long> result = new HashSet<Long>();
        ArrayList<Expr> predicates = new ArrayList<Expr>(partitions.size());
        long[] partitionIds = new long[partitions.size()];
        int indx = 0;
        for (PrunablePartition p : partitions) {
            predicates.add(this.buildPartitionPredicate(p, analyzer));
            partitionIds[indx++] = p.getId();
        }
        TResultRow results = FeSupport.EvalPredicateBatch(predicates, analyzer.getQueryCtx());
        Preconditions.checkState((results.getColValsSize() == partitions.size() ? 1 : 0) != 0);
        indx = 0;
        for (TColumnValue val : results.getColVals()) {
            if (val.isBool_val()) {
                result.add(partitionIds[indx]);
            }
            ++indx;
        }
        return result;
    }

    private Expr buildPartitionPredicate(PrunablePartition p, Analyzer analyzer) throws ImpalaException {
        ExprSubstitutionMap sMap = new ExprSubstitutionMap();
        for (int i = 0; i < this.refdKeys_.size(); ++i) {
            sMap.put(this.lhsSlotRefs_.get(i), p.getPartitionValues().get(this.refdKeys_.get(i)));
        }
        Expr literalPredicate = this.predicate_.substitute(sMap, analyzer, false);
        if (LOG.isTraceEnabled()) {
            LOG.trace("buildPartitionPredicate: " + literalPredicate.toSql() + " " + literalPredicate.debugString());
        }
        if (!literalPredicate.isConstant()) {
            throw new NotImplementedException("Unsupported non-deterministic predicate: " + this.predicate_.toSql());
        }
        return literalPredicate;
    }
}

