/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.Planner;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.thrift.TEqJoinCondition;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.THashJoinNode;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.BitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashJoinNode
extends JoinNode {
    private static final Logger LOG = LoggerFactory.getLogger(HashJoinNode.class);
    private static final double COST_COEFFICIENT_PROBE_INPUT = 0.2565;
    private static final double COST_COEFFICIENT_HASH_JOIN_OUTPUT = 0.1812;
    private static final double COST_COEFFICIENT_BUILD_INPUT = 1.0;

    public HashJoinNode(PlanNode outer, PlanNode inner, boolean isStraightJoin, JoinNode.DistributionMode distrMode, JoinOperator joinOp, List<BinaryPredicate> eqJoinConjuncts, List<Expr> otherJoinConjuncts) {
        super(outer, inner, isStraightJoin, distrMode, joinOp, eqJoinConjuncts, otherJoinConjuncts, "HASH JOIN");
        Preconditions.checkNotNull(eqJoinConjuncts);
        Preconditions.checkState((this.joinOp_ != JoinOperator.CROSS_JOIN ? 1 : 0) != 0);
        Preconditions.checkState((this.joinOp_ != JoinOperator.ICEBERG_DELETE_JOIN ? 1 : 0) != 0);
    }

    @Override
    public boolean isBlockingJoinNode() {
        return true;
    }

    @Override
    public List<BinaryPredicate> getEqJoinConjuncts() {
        return this.eqJoinConjuncts_;
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        ArrayList<BinaryPredicate> newEqJoinConjuncts = new ArrayList<BinaryPredicate>();
        ExprSubstitutionMap combinedChildSmap = this.getCombinedChildSmap();
        for (Expr c : this.eqJoinConjuncts_) {
            Type t1;
            BinaryPredicate eqPred = (BinaryPredicate)c.substitute(combinedChildSmap, analyzer, false);
            Type t0 = ((Expr)eqPred.getChild(0)).getType();
            if (!t0.matchesType(t1 = ((Expr)eqPred.getChild(1)).getType())) {
                boolean bothString;
                boolean bothDecimal = t0.isDecimal() && t1.isDecimal();
                boolean bl = bothString = t0.isStringType() && t1.isStringType();
                if (!bothDecimal && !bothString) {
                    throw new InternalException("Cannot compare " + t0.toSql() + " to " + t1.toSql() + " in join predicate.");
                }
                Type compatibleType = Type.getAssignmentCompatibleType(t0, t1, analyzer.getRegularCompatibilityLevel());
                if (compatibleType.isInvalid()) {
                    throw new InternalException(String.format("Unable create a hash join with equi-join predicate %s because the operands cannot be cast without loss of precision. Operand types: %s = %s.", eqPred.toSql(), t0.toSql(), t1.toSql()));
                }
                Preconditions.checkState((compatibleType.isDecimal() || compatibleType.isStringType() ? 1 : 0) != 0);
                try {
                    if (!t0.equals(compatibleType)) {
                        eqPred.setChild(0, ((Expr)eqPred.getChild(0)).castTo(compatibleType));
                    }
                    if (!t1.equals(compatibleType)) {
                        eqPred.setChild(1, ((Expr)eqPred.getChild(1)).castTo(compatibleType));
                    }
                }
                catch (AnalysisException e) {
                    throw new InternalException("Should not happen", e);
                }
            }
            Preconditions.checkState((boolean)((Expr)eqPred.getChild(0)).getType().matchesType(((Expr)eqPred.getChild(1)).getType()));
            BinaryPredicate newEqPred = new BinaryPredicate(eqPred.getOp(), (Expr)eqPred.getChild(0), (Expr)eqPred.getChild(1));
            newEqPred.analyze(analyzer);
            newEqJoinConjuncts.add(newEqPred);
        }
        this.eqJoinConjuncts_ = newEqJoinConjuncts;
        this.orderJoinConjunctsByCost();
        this.computeStats(analyzer);
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("eqJoinConjuncts_", (Object)this.eqJoinConjunctsDebugString()).addValue((Object)super.debugString()).toString();
    }

    private String eqJoinConjunctsDebugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (Expr entry : this.eqJoinConjuncts_) {
            helper.add("lhs", entry.getChild(0)).add("rhs", entry.getChild(1));
        }
        return helper.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.HASH_JOIN_NODE;
        msg.join_node = this.joinNodeToThrift();
        msg.join_node.hash_join_node = new THashJoinNode();
        msg.join_node.hash_join_node.setEq_join_conjuncts(this.getThriftEquiJoinConjuncts());
        for (Expr e : this.otherJoinConjuncts_) {
            msg.join_node.hash_join_node.addToOther_join_conjuncts(e.treeToThrift());
        }
        msg.join_node.hash_join_node.setHash_seed(this.getFragment().getHashSeed());
    }

    public List<TEqJoinCondition> getThriftEquiJoinConjuncts() {
        ArrayList<TEqJoinCondition> equiJoinConjuncts = new ArrayList<TEqJoinCondition>(this.eqJoinConjuncts_.size());
        for (Expr entry : this.eqJoinConjuncts_) {
            BinaryPredicate bp = (BinaryPredicate)entry;
            TEqJoinCondition eqJoinCondition = new TEqJoinCondition(((Expr)bp.getChild(0)).treeToThrift(), ((Expr)bp.getChild(1)).treeToThrift(), bp.getOp() == BinaryPredicate.Operator.NOT_DISTINCT);
            equiJoinConjuncts.add(eqJoinCondition);
        }
        return equiJoinConjuncts;
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s [%s]\n", prefix, this.getDisplayLabel(), this.getDisplayLabelDetail()));
        if (detailLevel.ordinal() > TExplainLevel.STANDARD.ordinal() && this.joinTableId_.isValid()) {
            output.append(detailPrefix + "hash-table-id=" + this.joinTableId_.toString() + "\n");
        }
        if (detailLevel.ordinal() > TExplainLevel.MINIMAL.ordinal()) {
            if (!this.isDeleteRowsJoin_ || detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
                output.append(detailPrefix + "hash predicates: ");
                for (int i = 0; i < this.eqJoinConjuncts_.size(); ++i) {
                    Expr eqConjunct = (Expr)this.eqJoinConjuncts_.get(i);
                    output.append(eqConjunct.toSql());
                    if (i + 1 == this.eqJoinConjuncts_.size()) continue;
                    output.append(", ");
                }
                output.append("\n");
            }
            if ((this.joinOp_.isInnerJoin() || this.joinOp_.isOuterJoin()) && detailLevel.ordinal() > TExplainLevel.STANDARD.ordinal()) {
                output.append(detailPrefix + "fk/pk conjuncts: ");
                if (this.fkPkEqJoinConjuncts_ == null) {
                    output.append("none");
                } else if (this.fkPkEqJoinConjuncts_.isEmpty()) {
                    output.append("assumed fk/pk");
                } else {
                    output.append(Joiner.on((String)", ").join((Iterable)this.fkPkEqJoinConjuncts_));
                }
                output.append("\n");
            }
            if (!this.otherJoinConjuncts_.isEmpty()) {
                output.append(detailPrefix + "other join predicates: ").append(Expr.getExplainString(this.otherJoinConjuncts_, detailLevel) + "\n");
            }
            if (!this.conjuncts_.isEmpty()) {
                output.append(detailPrefix + "other predicates: ").append(Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
            }
            if (!this.runtimeFilters_.isEmpty()) {
                output.append(detailPrefix + "runtime filters: ");
                output.append(this.getRuntimeFilterExplainString(true, detailLevel));
            }
        }
        return output.toString();
    }

    @Override
    public Pair<ResourceProfile, ResourceProfile> computeJoinResourceProfile(TQueryOptions queryOptions) {
        long perBuildInstanceDataBytes;
        long perBuildInstanceMemEstimate;
        int numInstances = this.fragment_.getNumInstances();
        if (((PlanNode)this.getChild(1)).getCardinality() == -1L || ((PlanNode)this.getChild(1)).getAvgRowSize() == -1.0f || numInstances <= 0) {
            perBuildInstanceMemEstimate = 0x80000000L;
            perBuildInstanceDataBytes = -1L;
        } else {
            long rhsCard = ((PlanNode)this.getChild(1)).getCardinality();
            long rhsNdv = 1L;
            for (Expr eqJoinPredicate : this.eqJoinConjuncts_) {
                long rhsPdNdv = HashJoinNode.getNdv((Expr)eqJoinPredicate.getChild(1));
                if ((rhsPdNdv = Math.min(rhsPdNdv, rhsCard)) == -1L) continue;
                rhsNdv = PlanNode.checkedMultiply(rhsNdv, rhsPdNdv);
            }
            perBuildInstanceDataBytes = (long)Math.ceil((double)((float)rhsCard * ((PlanNode)this.getChild(1)).getAvgRowSize()) + (double)BitUtil.roundUpToPowerOf2((long)Math.ceil(3L * rhsCard / 2L)) * 12.0);
            if (rhsNdv > 1L && rhsNdv < rhsCard) {
                perBuildInstanceDataBytes = (long)((double)perBuildInstanceDataBytes + (double)(rhsCard - rhsNdv) * 16.0);
            }
            if (this.distrMode_ == JoinNode.DistributionMode.PARTITIONED) {
                perBuildInstanceDataBytes /= (long)numInstances;
            }
            perBuildInstanceMemEstimate = perBuildInstanceDataBytes;
        }
        int PARTITION_FANOUT = 16;
        long minBuildBuffers = 17 + (this.joinOp_ == JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN ? 1 : 0);
        long bufferSize = queryOptions.getDefault_spillable_buffer_size();
        if (perBuildInstanceDataBytes != -1L) {
            long bytesPerBuffer = perBuildInstanceDataBytes / 16L;
            bufferSize = Math.min(bufferSize, Math.max(queryOptions.getMin_spillable_buffer_size(), BitUtil.roundUpToPowerOf2(bytesPerBuffer)));
        }
        long maxRowBufferSize = HashJoinNode.computeMaxSpillableBufferSize(bufferSize, queryOptions.getMax_row_size());
        long perInstanceBuildMinMemReservation = bufferSize * (minBuildBuffers - 2L) + maxRowBufferSize * 2L;
        if (Planner.useMTFragment(queryOptions) && this.canShareBuild()) {
            int numInstancePerHost = queryOptions.compute_processing_cost ? this.fragment_.getNumInstancesPerHost(queryOptions) : queryOptions.getMt_dop();
            perInstanceBuildMinMemReservation *= (long)numInstancePerHost;
        }
        long perInstanceProbeMinMemReservation = 0L;
        if (this.joinOp_ == JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN) {
            perInstanceProbeMinMemReservation = this.hasSeparateBuild() ? maxRowBufferSize + bufferSize : bufferSize * 2L;
        }
        ResourceProfile probeProfile = new ResourceProfileBuilder().setMemEstimateBytes(0L).setMinMemReservationBytes(perInstanceProbeMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(maxRowBufferSize).build();
        ResourceProfile buildProfile = new ResourceProfileBuilder().setMemEstimateBytes(perBuildInstanceMemEstimate).setMinMemReservationBytes(perInstanceBuildMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(maxRowBufferSize).build();
        return Pair.create(probeProfile, buildProfile);
    }

    @Override
    public Pair<ProcessingCost, ProcessingCost> computeJoinProcessingCost() {
        long outputCardinality = Math.max(0L, this.getCardinality());
        double totalProbeCost = (double)this.getProbeCardinalityForCosting() * 0.2565 + (double)outputCardinality * 0.1812;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Probe CPU cost estimate: " + totalProbeCost + ", Input Card: " + this.getProbeCardinalityForCosting() + ", Output Card: " + outputCardinality);
        }
        ProcessingCost probeProcessingCost = ProcessingCost.basicCost(this.getDisplayLabel(), totalProbeCost);
        long buildCardinality = Math.max(0L, ((PlanNode)this.getChild(1)).getFilteredCardinality());
        double totalBuildCost = (double)buildCardinality * 1.0;
        ProcessingCost buildProcessingCost = ProcessingCost.basicCost(this.getDisplayLabel() + " Build side", totalBuildCost);
        return Pair.create(probeProcessingCost, buildProcessingCost);
    }
}

