/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.TableSink;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TTableSink;
import org.apache.impala.thrift.TTableSinkType;

public class HBaseTableSink
extends TableSink {
    public HBaseTableSink(FeTable targetTable, List<Expr> outputExprs) {
        super(targetTable, TableSink.Op.INSERT, outputExprs);
    }

    @Override
    public void appendSinkExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel, StringBuilder output) {
        output.append(prefix + "WRITE TO HBASE table=" + this.targetTable_.getFullName() + "\n");
        if (explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(detailPrefix + "output exprs: ").append(Expr.getExplainString(this.outputExprs_, explainLevel) + "\n");
        }
    }

    @Override
    protected String getLabel() {
        return "HBASE WRITER";
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }

    @Override
    public void computeResourceProfile(TQueryOptions queryOptions) {
        this.resourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    protected void toThriftImpl(TDataSink tsink) {
        TTableSink tTableSink;
        tsink.table_sink = tTableSink = new TTableSink(0, TTableSinkType.HBASE, this.sinkOp_.toThrift());
        tsink.output_exprs = Expr.treesToThrift(this.outputExprs_);
    }

    @Override
    protected TDataSinkType getSinkType() {
        return TDataSinkType.TABLE_SINK;
    }

    @Override
    public void collectExprs(List<Expr> exprs) {
        exprs.addAll(this.outputExprs_);
    }
}

