/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HBaseColumn;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.planner.ValueRange;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.THBaseFilter;
import org.apache.impala.thrift.THBaseKeyRange;
import org.apache.impala.thrift.THBaseScanNode;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TScanRange;
import org.apache.impala.thrift.TScanRangeLocation;
import org.apache.impala.thrift.TScanRangeLocationList;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.util.BitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseScanNode
extends ScanNode {
    private static final int MAX_HBASE_FETCH_BATCH_SIZE = 524288000;
    private static final int DEFAULT_SUGGESTED_CACHING = 1024;
    private static final int DEFAULT_STRING_COL_BYTES = 32768;
    private static final int DEFAULT_MAX_ESTIMATE_BYTES = 0x8000000;
    private static final int DEFAULT_MIN_ESTIMATE_BYTES = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseScanNode.class);
    private final TupleDescriptor desc_;
    private List<ValueRange> keyRanges_ = new ArrayList<ValueRange>();
    private List<Expr> keyConjuncts_ = new ArrayList<Expr>();
    private byte[] startKey_ = HConstants.EMPTY_START_ROW;
    private byte[] stopKey_ = HConstants.EMPTY_END_ROW;
    private boolean isEmpty_ = false;
    private final List<THBaseFilter> filters_ = new ArrayList<THBaseFilter>();
    private int suggestedCaching_ = 1024;

    public HBaseScanNode(PlanNodeId id, TupleDescriptor desc) {
        super(id, desc, "SCAN HBASE");
        this.desc_ = desc;
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        FeTable table = this.desc_.getTable();
        List<Column> columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            HBaseColumn col = (HBaseColumn)columns.get(i);
            if (!col.isKeyColumn()) continue;
            SlotDescriptor slotDesc = analyzer.getColumnSlot(this.desc_, col);
            if (slotDesc == null || !slotDesc.getType().isStringType()) {
                this.keyRanges_.add(null);
                continue;
            }
            this.keyRanges_.add(this.createHBaseValueRange(slotDesc));
        }
        this.checkForSupportedFileFormats();
        this.assignConjuncts(analyzer);
        this.conjuncts_ = HBaseScanNode.orderConjunctsByCost(this.conjuncts_);
        this.setStartStopKey(analyzer);
        this.createHBaseFilters(analyzer);
        analyzer.materializeSlots(this.conjuncts_);
        this.computeMemLayout(analyzer);
        this.computeScanRangeLocations(analyzer);
        Preconditions.checkState((!this.scanRangeSpecs_.isSetSplit_specs() ? 1 : 0) != 0);
        this.keyRanges_ = Collections.unmodifiableList(this.keyRanges_);
        this.keyConjuncts_ = Collections.unmodifiableList(this.keyConjuncts_);
        this.computeStats(analyzer);
    }

    private ValueRange createHBaseValueRange(SlotDescriptor d) {
        ListIterator i = this.conjuncts_.listIterator();
        ValueRange result = null;
        while (i.hasNext()) {
            Expr slotBinding;
            BinaryPredicate comp;
            Expr e = (Expr)i.next();
            if (!(e instanceof BinaryPredicate) || (comp = (BinaryPredicate)e).getOp() == BinaryPredicate.Operator.NE || comp.getOp() == BinaryPredicate.Operator.DISTINCT_FROM || comp.getOp() == BinaryPredicate.Operator.NOT_DISTINCT || (slotBinding = comp.getSlotBinding(d.getId())) == null || !slotBinding.isConstant() || !slotBinding.getType().equals(Type.STRING)) continue;
            if (comp.getOp() == BinaryPredicate.Operator.EQ) {
                i.remove();
                this.keyConjuncts_.add(e);
                return ValueRange.createEqRange(slotBinding);
            }
            if (result == null) {
                result = new ValueRange();
            }
            if (comp.getOp() == BinaryPredicate.Operator.GT || comp.getOp() == BinaryPredicate.Operator.GE) {
                if (result.getLowerBound() != null) continue;
                result.setLowerBound(slotBinding);
                result.setLowerBoundInclusive(comp.getOp() == BinaryPredicate.Operator.GE);
                i.remove();
                this.keyConjuncts_.add(e);
                continue;
            }
            if (result.getUpperBound() != null) continue;
            result.setUpperBound(slotBinding);
            result.setUpperBoundInclusive(comp.getOp() == BinaryPredicate.Operator.LE);
            i.remove();
            this.keyConjuncts_.add(e);
        }
        return result;
    }

    private void setStartStopKey(Analyzer analyzer) throws ImpalaException {
        Preconditions.checkNotNull(this.keyRanges_);
        Preconditions.checkState((this.keyRanges_.size() == 1 ? 1 : 0) != 0);
        ValueRange rowRange = this.keyRanges_.get(0);
        if (rowRange != null) {
            StringLiteral litVal;
            LiteralExpr val;
            if (rowRange.getLowerBound() != null) {
                Preconditions.checkState((boolean)rowRange.getLowerBound().isConstant());
                Preconditions.checkState((boolean)rowRange.getLowerBound().getType().equals(Type.STRING));
                val = LiteralExpr.createBounded(rowRange.getLowerBound(), analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
                if (val instanceof StringLiteral) {
                    litVal = (StringLiteral)val;
                    this.startKey_ = this.convertToBytes(litVal.getUnescapedValue(), !rowRange.getLowerBoundInclusive());
                } else {
                    this.isEmpty_ = true;
                    return;
                }
            }
            if (rowRange.getUpperBound() != null) {
                Preconditions.checkState((boolean)rowRange.getUpperBound().isConstant());
                Preconditions.checkState((boolean)rowRange.getUpperBound().getType().equals(Type.STRING));
                val = LiteralExpr.createBounded(rowRange.getUpperBound(), analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
                if (val instanceof StringLiteral) {
                    litVal = (StringLiteral)val;
                    this.stopKey_ = this.convertToBytes(litVal.getUnescapedValue(), rowRange.getUpperBoundInclusive());
                } else {
                    this.isEmpty_ = true;
                    return;
                }
            }
        }
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])this.stopKey_, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])this.startKey_, (byte[])this.stopKey_) > 0 && !endKeyIsEndOfTable) {
            this.isEmpty_ = true;
        }
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        FeHBaseTable tbl = (FeHBaseTable)this.desc_.getTable();
        if (LOG.isTraceEnabled()) {
            LOG.trace("computing stats for HbaseScan on " + tbl.getHBaseTableName());
        }
        ValueRange rowRange = this.keyRanges_.get(0);
        if (this.isEmpty_) {
            this.cardinality_ = 0L;
        } else if (rowRange != null && rowRange.isEqRange()) {
            this.cardinality_ = 1L;
        } else if (this.inputCardinality_ >= 0L) {
            Preconditions.checkState((this.numNodes_ > 0 ? 1 : 0) != 0);
            Preconditions.checkState((this.numInstances_ > 0 ? 1 : 0) != 0);
            Preconditions.checkState((this.cardinality_ >= 0L ? 1 : 0) != 0);
            this.cardinality_ = this.inputCardinality_;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Reuse last stats: inputCardinality_=" + this.inputCardinality_);
            }
        } else {
            Pair<Long, Long> estimate = analyzer.getQueryOptions().isDisable_hbase_num_rows_estimate() ? new Pair<Long, Long>(-1L, -1L) : tbl.getEstimatedRowStats(this.startKey_, this.stopKey_);
            long rowsFromHms = tbl.getTTableStats().getNum_rows();
            if ((Long)estimate.first == -1L) {
                this.cardinality_ = rowsFromHms;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fallback to use table stats in HMS: num_rows=" + this.cardinality_);
                }
                if (this.cardinality_ > 0L && this.keyConjuncts_ != null) {
                    this.cardinality_ = this.applySelectivity(this.cardinality_, HBaseScanNode.computeCombinedSelectivity(this.keyConjuncts_));
                }
            } else {
                long l = this.cardinality_ = rowsFromHms >= 0L ? Long.min((Long)estimate.first, rowsFromHms) : (Long)estimate.first;
                if ((Long)estimate.second > 0L) {
                    this.suggestedCaching_ = (int)Math.max(524288000L / (Long)estimate.second, 1L);
                }
            }
        }
        this.inputCardinality_ = this.cardinality_;
        this.cardinality_ = this.cardinality_ > 0L ? this.applyConjunctsSelectivity(this.cardinality_) : Math.max(-1L, this.cardinality_);
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        if (LOG.isTraceEnabled()) {
            LOG.trace("computeStats HbaseScan: cardinality=" + this.cardinality_);
        }
        int numExecutors = analyzer.numExecutorsForPlanning();
        this.numNodes_ = Math.max(1, Math.min(this.scanRangeSpecs_.getConcrete_rangesSize(), numExecutors));
        int maxInstances = this.numNodes_ * this.getMaxInstancesPerNode(analyzer);
        this.numInstances_ = Math.max(1, Math.min(this.scanRangeSpecs_.getConcrete_rangesSize(), maxInstances));
        if (LOG.isTraceEnabled()) {
            LOG.trace("computeStats HbaseScan: #nodes=" + this.numNodes_ + " #instances=" + this.numInstances_);
        }
    }

    @Override
    protected String debugString() {
        FeHBaseTable tbl = (FeHBaseTable)this.desc_.getTable();
        return MoreObjects.toStringHelper((Object)this).add("tid", this.desc_.getId().asInt()).add("hiveTblName", (Object)tbl.getFullName()).add("hbaseTblName", (Object)tbl.getHBaseTableName()).add("startKey", (Object)ByteBuffer.wrap(this.startKey_).toString()).add("stopKey", (Object)ByteBuffer.wrap(this.stopKey_).toString()).add("isEmpty", this.isEmpty_).addValue((Object)super.debugString()).toString();
    }

    private void createHBaseFilters(Analyzer analyzer) {
        for (Expr e : this.conjuncts_) {
            BinaryPredicate bp;
            CompareFilter.CompareOp hbaseOp;
            if (!(e instanceof BinaryPredicate) || (hbaseOp = HBaseScanNode.impalaOpToHBaseOp((bp = (BinaryPredicate)e).getOp())) == null) continue;
            for (SlotDescriptor slot : this.desc_.getSlots()) {
                Expr bindingExpr;
                if (slot.getType().getPrimitiveType() != PrimitiveType.STRING || (bindingExpr = bp.getSlotBinding(slot.getId())) == null || !(bindingExpr instanceof StringLiteral)) continue;
                StringLiteral literal = (StringLiteral)bindingExpr;
                HBaseColumn col = (HBaseColumn)slot.getColumn();
                THBaseFilter thbf = new THBaseFilter(col.getColumnFamily(), (byte)hbaseOp.ordinal(), literal.getUnescapedValue());
                thbf.setQualifier(col.getColumnQualifier());
                this.filters_.add(thbf);
                analyzer.materializeSlots(Lists.newArrayList((Object[])new Expr[]{e}));
            }
        }
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.HBASE_SCAN_NODE;
        FeHBaseTable tbl = (FeHBaseTable)this.desc_.getTable();
        msg.hbase_scan_node = new THBaseScanNode(this.desc_.getId().asInt(), tbl.getHBaseTableName());
        if (!this.filters_.isEmpty()) {
            msg.hbase_scan_node.setFilters(this.filters_);
        }
        msg.hbase_scan_node.setSuggested_max_caching(this.suggestedCaching_);
    }

    private void computeScanRangeLocations(Analyzer analyzer) {
        List<HRegionLocation> regionsLoc;
        this.scanRangeSpecs_ = new TScanRangeSpec();
        if (this.isEmpty_) {
            return;
        }
        FeHBaseTable tbl = (FeHBaseTable)this.desc_.getTable();
        try {
            regionsLoc = FeHBaseTable.Util.getRegionsInRange(tbl, this.startKey_, this.stopKey_);
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't retrieve HBase table (" + tbl.getHBaseTableName() + ") info:\n" + e.getMessage(), e);
        }
        HashMap<String, ArrayList> locationMap = new HashMap<String, ArrayList>();
        for (HRegionLocation hRegionLocation : regionsLoc) {
            String locHostPort = hRegionLocation.getHostnamePort();
            if (locationMap.containsKey(locHostPort)) {
                ((List)locationMap.get(locHostPort)).add(hRegionLocation);
                continue;
            }
            locationMap.put(locHostPort, Lists.newArrayList((Object[])new HRegionLocation[]{hRegionLocation}));
        }
        for (Map.Entry entry : locationMap.entrySet()) {
            THBaseKeyRange keyRange = null;
            byte[] prevEndKey = null;
            for (HRegionLocation regionLoc : (List)entry.getValue()) {
                byte[] curRegStartKey = regionLoc.getRegionInfo().getStartKey();
                byte[] curRegEndKey = regionLoc.getRegionInfo().getEndKey();
                if (prevEndKey != null && Bytes.compareTo(prevEndKey, (byte[])curRegStartKey) == 0) {
                    this.setKeyRangeEnd(keyRange, curRegEndKey);
                } else {
                    keyRange = new THBaseKeyRange();
                    this.setKeyRangeStart(keyRange, curRegStartKey);
                    this.setKeyRangeEnd(keyRange, curRegEndKey);
                    TScanRangeLocationList scanRangeLocation = new TScanRangeLocationList();
                    TNetworkAddress networkAddress = HBaseScanNode.addressToTNetworkAddress((String)entry.getKey());
                    scanRangeLocation.addToLocations(new TScanRangeLocation(analyzer.getHostIndex().getOrAddIndex(networkAddress)));
                    TScanRange scanRange = new TScanRange();
                    scanRange.setHbase_key_range(keyRange);
                    scanRangeLocation.setScan_range(scanRange);
                    this.scanRangeSpecs_.addToConcrete_ranges(scanRangeLocation);
                }
                prevEndKey = curRegEndKey;
            }
        }
    }

    private void setKeyRangeStart(THBaseKeyRange keyRange, byte[] rangeStartKey) {
        keyRange.unsetStartKey();
        if (!Bytes.equals((byte[])rangeStartKey, (byte[])HConstants.EMPTY_START_ROW) || !Bytes.equals((byte[])this.startKey_, (byte[])HConstants.EMPTY_START_ROW)) {
            byte[] partStart = Bytes.compareTo((byte[])rangeStartKey, (byte[])this.startKey_) < 0 ? this.startKey_ : rangeStartKey;
            keyRange.setStartKey(Bytes.toString((byte[])partStart));
        }
    }

    private void setKeyRangeEnd(THBaseKeyRange keyRange, byte[] rangeEndKey) {
        keyRange.unsetStopKey();
        if (!Bytes.equals((byte[])rangeEndKey, (byte[])HConstants.EMPTY_END_ROW) || !Bytes.equals((byte[])this.stopKey_, (byte[])HConstants.EMPTY_END_ROW)) {
            if (Bytes.equals((byte[])this.stopKey_, (byte[])HConstants.EMPTY_END_ROW)) {
                keyRange.setStopKey(Bytes.toString((byte[])rangeEndKey));
            } else if (Bytes.equals((byte[])rangeEndKey, (byte[])HConstants.EMPTY_END_ROW)) {
                keyRange.setStopKey(Bytes.toString((byte[])this.stopKey_));
            } else {
                byte[] partEnd = Bytes.compareTo((byte[])rangeEndKey, (byte[])this.stopKey_) < 0 ? rangeEndKey : this.stopKey_;
                keyRange.setStopKey(Bytes.toString((byte[])partEnd));
            }
        }
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        FeHBaseTable table = (FeHBaseTable)this.desc_.getTable();
        StringBuilder output = new StringBuilder();
        if (this.isEmpty_) {
            output.append(prefix + "empty scan node\n");
            return output.toString();
        }
        String aliasStr = "";
        if (!table.getFullName().equalsIgnoreCase(this.desc_.getAlias()) && !table.getName().equalsIgnoreCase(this.desc_.getAlias())) {
            aliasStr = " " + this.desc_.getAlias();
        }
        output.append(String.format("%s%s:%s [%s%s]\n", prefix, this.id_.toString(), this.displayName_, table.getFullName(), aliasStr));
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
            if (!this.keyConjuncts_.isEmpty()) {
                output.append(detailPrefix + "key predicates: " + Expr.getExplainString(this.keyConjuncts_, detailLevel) + "\n");
            }
            if (!Bytes.equals((byte[])this.startKey_, (byte[])HConstants.EMPTY_START_ROW)) {
                output.append(detailPrefix + "start key: " + HBaseScanNode.printKey(this.startKey_) + "\n");
            }
            if (!Bytes.equals((byte[])this.stopKey_, (byte[])HConstants.EMPTY_END_ROW)) {
                output.append(detailPrefix + "stop key: " + HBaseScanNode.printKey(this.stopKey_) + "\n");
            }
            if (!this.filters_.isEmpty()) {
                output.append(detailPrefix + "hbase filters:");
                if (this.filters_.size() == 1) {
                    THBaseFilter filter = this.filters_.get(0);
                    output.append(" " + filter.family + ":" + filter.qualifier + " " + CompareFilter.CompareOp.values()[filter.op_ordinal].toString() + " '" + filter.filter_constant + "'");
                } else {
                    for (int i = 0; i < this.filters_.size(); ++i) {
                        THBaseFilter filter = this.filters_.get(i);
                        output.append("\n" + detailPrefix + filter.family + ":" + filter.qualifier + " " + CompareFilter.CompareOp.values()[filter.op_ordinal].toString() + " '" + filter.filter_constant + "'");
                    }
                }
                output.append('\n');
            }
            if (!this.conjuncts_.isEmpty()) {
                output.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
            }
        }
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(this.getStatsExplainString(detailPrefix));
            output.append("\n");
        }
        return output.toString();
    }

    private byte[] convertToBytes(String rowKey, boolean nextKey) {
        byte[] keyBytes = Bytes.toBytes((String)rowKey);
        if (!nextKey) {
            return keyBytes;
        }
        return Arrays.copyOf(keyBytes, keyBytes.length + 1);
    }

    public static String printKey(byte[] key) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < key.length; ++i) {
            if (!Character.isISOControl(key[i])) {
                result.append((char)key[i]);
                continue;
            }
            result.append("\\");
            result.append(Integer.toOctalString(key[i]));
        }
        return result.toString();
    }

    private static CompareFilter.CompareOp impalaOpToHBaseOp(BinaryPredicate.Operator impalaOp) {
        switch (impalaOp) {
            case EQ: {
                return CompareFilter.CompareOp.EQUAL;
            }
            case NE: {
                return CompareFilter.CompareOp.NOT_EQUAL;
            }
            case GT: {
                return CompareFilter.CompareOp.GREATER;
            }
            case GE: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case LT: {
                return CompareFilter.CompareOp.LESS;
            }
            case LE: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException("HBase: Unsupported Impala compare operator: " + (Object)((Object)impalaOp));
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeScanProcessingCost(queryOptions);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        FeHBaseTable tbl = (FeHBaseTable)this.desc_.getTable();
        HBaseColumn keyCol = (HBaseColumn)tbl.getColumns().get(0);
        ArrayList<HBaseColumn> colsToFetchFromHBase = new ArrayList<HBaseColumn>();
        for (SlotDescriptor slot : this.desc_.getSlots()) {
            HBaseColumn col = (HBaseColumn)tbl.getColumn(slot.getLabel());
            if (col.getColumnFamily().equals(":key")) continue;
            colsToFetchFromHBase.add(col);
        }
        colsToFetchFromHBase.add(keyCol);
        long mem_estimate = HBaseScanNode.memoryEstimateForFetchingColumns(colsToFetchFromHBase);
        mem_estimate = Math.max(mem_estimate, 4096L);
        this.nodeResourceProfile_ = ResourceProfile.noReservation(mem_estimate);
    }

    protected static long memoryEstimateForFetchingColumns(List<HBaseColumn> columns) {
        long maxRowSize = 0L;
        boolean isMissingStats = false;
        for (HBaseColumn col : columns) {
            long colMaxSize = col.getStats().getMaxSize();
            if (col.getType().isStringType()) {
                if (colMaxSize == -1L) {
                    colMaxSize = 32768L;
                    isMissingStats = true;
                }
                colMaxSize = BitUtil.roundUpToPowerOf2(colMaxSize);
            }
            Preconditions.checkState((colMaxSize != -1L ? 1 : 0) != 0);
            maxRowSize += colMaxSize;
            if (col.getColumnFamily().equals(":key")) continue;
            maxRowSize += (long)(col.getColumnFamily().length() + col.getColumnQualifier().length());
        }
        long mem_estimate = BitUtil.roundUpToPowerOf2(maxRowSize) * 2L;
        if (isMissingStats) {
            mem_estimate = Math.min(mem_estimate, 0x8000000L);
        }
        return mem_estimate;
    }

    @Override
    public boolean hasStorageLayerConjuncts() {
        return !this.filters_.isEmpty();
    }
}

