/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.Stack;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.BroadcastProcessingCost;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.DataStreamSink;
import org.apache.impala.planner.IcebergDeleteNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExchangeNode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSortInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(ExchangeNode.class);
    private static final double PER_TUPLE_SERIALIZATION_OVERHEAD = 4.0;
    private static final double PER_TUPLE_DESERIALIZED_OVERHEAD = 8.0;
    private static final int MIN_ESTIMATE_BYTES = 16384;
    private static final double COST_COEFFICIENT_MERGING_XCHG_RCVR_ROWS = 0.2369;
    private static final double COST_COEFFICIENT_MERGING_XCHG_RCVR_BYTES = 0.002;
    private static final double COST_COEFFICIENT_BCAST_XCHG_RCVR_ROWS = 0.1329;
    private static final double COST_COEFFICIENT_PART_XCHG_RCVR_ROWS = 0.0743;
    private static final double COST_COEFFICIENT_PART_XCHG_RCVR_BYTES = 0.0046;
    private SortInfo mergeInfo_;
    private long offset_ = 0L;

    protected boolean isMergingExchange() {
        return this.mergeInfo_ != null;
    }

    protected boolean isBroadcastExchange() {
        Preconditions.checkState((!this.children_.isEmpty() ? 1 : 0) != 0);
        if (this.isDirectedExchange()) {
            return false;
        }
        DataSink sink = ((PlanNode)this.getChild(0)).getFragment().getSink();
        if (sink == null) {
            return false;
        }
        Preconditions.checkState((boolean)(sink instanceof DataStreamSink));
        DataStreamSink streamSink = (DataStreamSink)sink;
        return !streamSink.getOutputPartition().isPartitioned() && this.fragment_.isPartitioned();
    }

    protected boolean isDirectedExchange() {
        if (this.fragment_.getSink().getSinkType() == TDataSinkType.ICEBERG_DELETE_BUILDER) {
            return true;
        }
        return this.isChildOfIcebergDeleteNode(this.fragment_.getPlanRoot());
    }

    protected boolean isChildOfIcebergDeleteNode(PlanNode currNode) {
        if (currNode instanceof IcebergDeleteNode) {
            Preconditions.checkState((currNode.getChildCount() == 2 ? 1 : 0) != 0);
            if (currNode.getChild(1) == this) {
                return true;
            }
        }
        for (PlanNode child : currNode.getChildren()) {
            if (!this.isChildOfIcebergDeleteNode(child)) continue;
            return true;
        }
        return false;
    }

    public ExchangeNode(PlanNodeId id, PlanNode input) {
        super(id, "EXCHANGE");
        this.children_.add(input);
        if (input.getFragment().isPartitioned() && (!(input instanceof AggregationNode) || input.isBlockingNode())) {
            this.limit_ = input.limit_;
        }
        this.computeTupleIds();
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tupleIds_.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.tblRefIds_.addAll(((PlanNode)this.getChild(0)).getTblRefIds());
        this.nullableTupleIds_.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        Preconditions.checkState((this.children_.size() == 1 ? 1 : 0) != 0);
        this.cardinality_ = this.capCardinalityAtLimit(((PlanNode)this.children_.get(0)).getCardinality());
        if (this.cardinality_ > -1L) {
            this.cardinality_ = Math.max(0L, this.cardinality_ - this.offset_);
        }
        this.hasHardEstimates_ = ((PlanNode)this.children_.get((int)0)).hasHardEstimates_;
    }

    public void setMergeInfo(SortInfo info, long offset) {
        this.mergeInfo_ = info;
        this.offset_ = offset;
        this.displayName_ = "MERGING-EXCHANGE";
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s [%s]\n", prefix, this.getDisplayLabel(), this.getDisplayLabelDetail()));
        if (this.offset_ > 0L) {
            output.append(detailPrefix + "offset: ").append(this.offset_).append("\n");
        }
        if (this.isMergingExchange() && detailLevel.ordinal() > TExplainLevel.MINIMAL.ordinal()) {
            output.append(detailPrefix + "order by: ");
            output.append(this.getSortingOrderExplainString(this.mergeInfo_.getSortExprs(), this.mergeInfo_.getIsAscOrder(), this.mergeInfo_.getNullsFirstParams(), this.mergeInfo_.getSortingOrder(), this.mergeInfo_.getNumLexicalKeysInZOrder()));
        }
        return output.toString();
    }

    @Override
    protected boolean displayCardinality(TExplainLevel detailLevel) {
        return detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal();
    }

    @Override
    protected String getDisplayLabelDetail() {
        Preconditions.checkState((!this.children_.isEmpty() ? 1 : 0) != 0);
        DataSink sink = ((PlanNode)this.getChild(0)).getFragment().getSink();
        if (sink == null) {
            return "";
        }
        if (this.isDirectedExchange()) {
            return "DIRECTED";
        }
        if (this.isBroadcastExchange()) {
            return "BROADCAST";
        }
        Preconditions.checkState((boolean)(sink instanceof DataStreamSink));
        DataStreamSink streamSink = (DataStreamSink)sink;
        return streamSink.getOutputPartition().getExplainString();
    }

    public static double getAvgSerializedRowSize(PlanNode exchInput) {
        return (double)exchInput.getAvgRowSize() + (double)exchInput.getTupleIds().size() * 4.0;
    }

    public double getAvgDeserializedRowSize() {
        return (double)this.getAvgRowSize() + (double)this.getTupleIds().size() * 8.0;
    }

    public int getNumSenders() {
        Preconditions.checkState((!this.children_.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((PlanNode)this.children_.get(0)).getFragment());
        return ((PlanNode)this.children_.get(0)).getFragment().getNumInstances();
    }

    public int getNumReceivers() {
        DataSink sink = this.fragment_.getSink();
        if (sink == null) {
            return 1;
        }
        return sink.getFragment().getNumInstances();
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        String exchType;
        long inputCardinality = Math.max(0L, ((PlanNode)this.getChild(0)).getFilteredCardinality());
        long inputSize = (long)(this.getAvgDeserializedRowSize() * (double)inputCardinality);
        double totalCost = 0.0;
        if (this.isMergingExchange()) {
            exchType = "MERGING";
            totalCost = (double)inputCardinality * 0.2369 + (double)inputSize * 0.002;
        } else if (this.isBroadcastExchange()) {
            exchType = "BROADCAST";
            totalCost = (double)inputCardinality * 0.1329;
        } else {
            exchType = this.isDirectedExchange() ? "DIRECTED" : "PARTITIONED";
            totalCost = (double)inputCardinality * 0.0743 + (double)inputSize * 0.0046;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Total CPU cost estimate: " + totalCost + ", ExchangeType: " + exchType + ", Input Card: " + inputCardinality + ", Input Size: " + inputSize);
        }
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), totalCost);
        if (this.isBroadcastExchange()) {
            this.processingCost_ = ProcessingCost.broadcastCost(this.processingCost_, () -> this.fragment_.hasAdjustedInstanceCount() ? this.fragment_.getAdjustedInstanceCount() : this.getNumReceivers());
        }
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        int numSenders = this.getNumSenders();
        long estimatedTotalQueueByteSize = this.estimateTotalQueueByteSize(numSenders);
        long estimatedDeferredRPCQueueSize = this.estimateDeferredRPCQueueSize(queryOptions, numSenders);
        long estimatedMem = Math.max(ExchangeNode.checkedAdd(estimatedTotalQueueByteSize, estimatedDeferredRPCQueueSize), 16384L);
        this.nodeResourceProfile_ = ResourceProfile.noReservation(estimatedMem);
    }

    private long estimateDeferredRPCQueueSize(TQueryOptions queryOptions, int numSenders) {
        long rowBatchSize = ExchangeNode.getRowBatchSize(queryOptions);
        if (this.getCardinality() > 0L) {
            rowBatchSize = Math.min(rowBatchSize, this.getCardinality());
        }
        long avgRowBatchByteSize = Math.min((long)Math.ceil((double)rowBatchSize * ExchangeNode.getAvgSerializedRowSize(this)), 0x800000L);
        long deferredBatchQueueSize = avgRowBatchByteSize * (long)numSenders;
        return deferredBatchQueueSize;
    }

    private long estimateTotalQueueByteSize(int numSenders) {
        int numQueues = this.isMergingExchange() ? numSenders : 1;
        long maxQueueByteSize = BackendConfig.INSTANCE.getBackendCfg().exchg_node_buffer_size_bytes;
        long estimatedTotalQueueByteSize = (long)numQueues * maxQueueByteSize;
        if (this.hasValidStats()) {
            long totalBytesToReceive = (long)Math.ceil(this.getAvgRowSize() * (float)this.getCardinality());
            long bytesToReceivePerExchNode = this.isBroadcastExchange() ? totalBytesToReceive : totalBytesToReceive / (long)this.getNumNodes();
            estimatedTotalQueueByteSize = Math.min(bytesToReceivePerExchNode, estimatedTotalQueueByteSize);
        }
        return estimatedTotalQueueByteSize;
    }

    @Override
    public PlanNode.ExecPhaseResourceProfiles computeTreeResourceProfiles(TQueryOptions queryOptions) {
        return new PlanNode.ExecPhaseResourceProfiles(this.nodeResourceProfile_, this.nodeResourceProfile_);
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        if (this.processingCost_.isValid() && this.processingCost_ instanceof BroadcastProcessingCost) {
            Preconditions.checkState((this.getNumReceivers() == this.processingCost_.getNumInstancesExpected() ? 1 : 0) != 0);
        }
        msg.node_type = TPlanNodeType.EXCHANGE_NODE;
        msg.exchange_node = new TExchangeNode();
        for (TupleId tid : this.tupleIds_) {
            msg.exchange_node.addToInput_row_tuples(tid.asInt());
        }
        if (this.isMergingExchange()) {
            TSortInfo sortInfo = new TSortInfo(Expr.treesToThrift(this.mergeInfo_.getSortExprs()), this.mergeInfo_.getIsAscOrder(), this.mergeInfo_.getNullsFirst(), this.mergeInfo_.getSortingOrder());
            msg.exchange_node.setSort_info(sortInfo);
            msg.exchange_node.setOffset(this.offset_);
        }
    }

    @Override
    protected void reduceCardinalityByRuntimeFilter(Stack<PlanNode> nodeStack, double reductionScale) {
        if (!nodeStack.isEmpty()) {
            nodeStack.add(this);
        }
        ((PlanNode)this.getChild(0)).reduceCardinalityByRuntimeFilter(nodeStack, reductionScale);
    }
}

