/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;

public class EmptySetNode
extends PlanNode {
    public EmptySetNode(PlanNodeId id, List<TupleId> tupleIds) {
        super(id, tupleIds, "EMPTYSET");
        Preconditions.checkArgument((tupleIds.size() > 0 ? 1 : 0) != 0);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        this.avgRowSize_ = 0.0f;
        this.rowPadSize_ = 0.0f;
        this.cardinality_ = 0L;
        this.numNodes_ = 1;
        this.numInstances_ = 1;
    }

    @Override
    public void init(Analyzer analyzer) {
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
        for (TupleId id : this.tupleIds_) {
            analyzer.getTupleDesc(id).setIsMaterialized(true);
        }
        this.computeMemLayout(analyzer);
        this.computeStats(analyzer);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.zero();
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        return String.format("%s%s:%s\n", prefix, this.id_.toString(), this.displayName_);
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.EMPTY_SET_NODE;
    }

    @Override
    protected boolean displayCardinality(TExplainLevel detailLevel) {
        return false;
    }
}

