/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.AnalyticEvalNode;
import org.apache.impala.planner.CardinalityCheckNode;
import org.apache.impala.planner.DataPartition;
import org.apache.impala.planner.EmptySetNode;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.IcebergDeleteNode;
import org.apache.impala.planner.IcebergMetadataScanNode;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.planner.SelectNode;
import org.apache.impala.planner.SortNode;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.thrift.TPartitionType;
import org.apache.impala.thrift.TVirtualColumnType;
import org.apache.impala.util.KuduUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedPlanner.class);
    private final PlannerContext ctx_;

    public DistributedPlanner(PlannerContext ctx) {
        this.ctx_ = ctx;
    }

    public List<PlanFragment> createPlanFragments(PlanNode singleNodePlan) throws ImpalaException {
        Preconditions.checkState((!this.ctx_.isSingleNodeExec() ? 1 : 0) != 0);
        QueryStmt queryStmt = this.ctx_.getQueryStmt();
        ArrayList<PlanFragment> fragments = new ArrayList<PlanFragment>();
        boolean isPartitioned = false;
        if (this.ctx_.hasTableSink() && !singleNodePlan.hasLimit()) {
            Preconditions.checkState((!queryStmt.hasOffset() ? 1 : 0) != 0);
            isPartitioned = true;
        }
        this.createPlanFragments(singleNodePlan, isPartitioned, fragments);
        return fragments;
    }

    public PlanFragment createPlanFragments(PlanNode root, boolean isPartitioned, List<PlanFragment> fragments) throws ImpalaException {
        ArrayList<PlanFragment> childFragments = new ArrayList<PlanFragment>();
        for (PlanNode child : root.getChildren()) {
            boolean childIsPartitioned = child.allowPartitioned();
            if (root instanceof SubplanNode && child == root.getChild(1)) continue;
            childFragments.add(this.createPlanFragments(child, childIsPartitioned, fragments));
        }
        PlanFragment result = null;
        if (root instanceof ScanNode) {
            if (root instanceof IcebergMetadataScanNode) {
                result = this.createIcebergMetadataScanFragment(root);
                fragments.add(result);
            } else {
                result = this.createScanFragment(root);
                fragments.add(result);
            }
        } else if (root instanceof HashJoinNode) {
            Preconditions.checkState((childFragments.size() == 2 ? 1 : 0) != 0);
            result = this.createHashJoinFragment((HashJoinNode)root, (PlanFragment)childFragments.get(1), (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof NestedLoopJoinNode) {
            Preconditions.checkState((childFragments.size() == 2 ? 1 : 0) != 0);
            result = this.createNestedLoopJoinFragment((NestedLoopJoinNode)root, (PlanFragment)childFragments.get(1), (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof SubplanNode) {
            Preconditions.checkState((childFragments.size() == 1 ? 1 : 0) != 0);
            result = this.createSubplanNodeFragment((SubplanNode)root, (PlanFragment)childFragments.get(0));
        } else if (root instanceof SelectNode) {
            result = this.createSelectNodeFragment((SelectNode)root, childFragments);
        } else if (root instanceof UnionNode) {
            result = this.createUnionNodeFragment((UnionNode)root, childFragments, fragments);
        } else if (root instanceof AggregationNode) {
            result = this.createAggregationFragment((AggregationNode)root, (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof SortNode) {
            result = ((SortNode)root).isAnalyticSort() ? this.createAnalyticFragment(root, (PlanFragment)childFragments.get(0), fragments) : this.createOrderByFragment((SortNode)root, (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof AnalyticEvalNode) {
            result = this.createAnalyticFragment(root, (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof EmptySetNode) {
            result = new PlanFragment(this.ctx_.getNextFragmentId(), root, DataPartition.UNPARTITIONED);
        } else if (root instanceof CardinalityCheckNode) {
            result = this.createCardinalityCheckNodeFragment((CardinalityCheckNode)root, childFragments);
        } else if (root instanceof IcebergDeleteNode) {
            Preconditions.checkState((childFragments.size() == 2 ? 1 : 0) != 0);
            result = this.createIcebergDeleteFragment((IcebergDeleteNode)root, (PlanFragment)childFragments.get(0), (PlanFragment)childFragments.get(1));
        } else {
            throw new InternalException("Cannot create plan fragment for this node type: " + root.getExplainString(this.ctx_.getQueryOptions()));
        }
        fragments.remove(result);
        fragments.add(result);
        if (!isPartitioned && result.isPartitioned()) {
            result = this.createMergeFragment(result);
            fragments.add(result);
        }
        return result;
    }

    private long getNumDistinctValues(List<Expr> exprs) {
        Preconditions.checkNotNull(exprs);
        return exprs.isEmpty() ? 1L : Expr.getNumDistinctValues(exprs);
    }

    public PlanFragment createInsertFragment(PlanFragment inputFragment, DmlStatementBase dmlStmt, Analyzer analyzer, List<PlanFragment> fragments) throws ImpalaException {
        return this.createDmlFragment(inputFragment, dmlStmt, analyzer, fragments);
    }

    public PlanFragment createDmlFragment(PlanFragment inputFragment, DmlStatementBase dmlStmt, Analyzer analyzer, List<PlanFragment> fragments) throws ImpalaException {
        boolean enforce_hdfs_writer_limit;
        boolean isComputeCost = analyzer.getQueryOptions().isCompute_processing_cost();
        boolean bl = enforce_hdfs_writer_limit = dmlStmt.getTargetTable() instanceof FeFsTable && (analyzer.getQueryOptions().getMax_fs_writers() > 0 || isComputeCost);
        if (dmlStmt.hasNoShuffleHint() && !enforce_hdfs_writer_limit) {
            return inputFragment;
        }
        ArrayList partitionExprs = Lists.newArrayList(dmlStmt.getPartitionKeyExprs());
        Expr.removeConstants(partitionExprs);
        DataPartition inputPartition = inputFragment.getDataPartition();
        if (!partitionExprs.isEmpty() && analyzer.setsHaveValueTransfer(inputPartition.getPartitionExprs(), partitionExprs, true) && !(dmlStmt.getTargetTable() instanceof FeKuduTable) && !enforce_hdfs_writer_limit) {
            return inputFragment;
        }
        int maxHdfsWriters = analyzer.getQueryOptions().getMax_fs_writers();
        ArrayList hdfsScanNodes = Lists.newArrayList();
        inputFragment.collectPlanNodes((Predicate<? super PlanNode>)Predicates.instanceOf(HdfsScanNode.class), hdfsScanNodes);
        ArrayList unionNodes = Lists.newArrayList();
        inputFragment.collectPlanNodes((Predicate<? super PlanNode>)Predicates.instanceOf(UnionNode.class), unionNodes);
        boolean hasHdfsScanORUnion = !hdfsScanNodes.isEmpty() || !unionNodes.isEmpty();
        int expectedNumInputInstance = inputFragment.getNumInstances();
        if (enforce_hdfs_writer_limit && isComputeCost) {
            int costBasedMaxWriter = IntMath.saturatedMultiply((int)inputFragment.getNumNodes(), (int)analyzer.getMinParallelismPerNode());
            PlanNode root = inputFragment.getPlanRoot();
            if (root.getCardinality() > -1L && root.getAvgRowSize() > -1.0f) {
                int totalNumPartitions = (int)Math.min(Integer.MAX_VALUE, Math.max(1L, this.getNumDistinctValues(partitionExprs)));
                int minNumWriter = Math.min(totalNumPartitions, inputFragment.getNumNodes());
                int maxNumWriter = Math.min(totalNumPartitions, IntMath.saturatedMultiply((int)inputFragment.getNumNodes(), (int)analyzer.getMaxParallelismPerNode()));
                costBasedMaxWriter = (int)Math.round(Math.ceil(root.getAvgRowSize() / 2.6843546E8f * (float)root.getCardinality()));
                costBasedMaxWriter = Math.min(maxNumWriter, Math.max(minNumWriter, costBasedMaxWriter));
            }
            maxHdfsWriters = maxHdfsWriters > 0 ? Math.min(maxHdfsWriters, costBasedMaxWriter) : costBasedMaxWriter;
            Preconditions.checkState((maxHdfsWriters > 0 ? 1 : 0) != 0);
            dmlStmt.setMaxTableSinks(maxHdfsWriters);
            if (!hdfsScanNodes.isEmpty() && fragments.size() == 1) {
                int maxScanThread = 1;
                for (HdfsScanNode scanNode : hdfsScanNodes) {
                    ProcessingCost scanCost = scanNode.computeScanProcessingCost(analyzer.getQueryOptions());
                    maxScanThread = Math.max(maxScanThread, scanCost.getNumInstanceMax(inputFragment.getNumNodes()));
                }
                expectedNumInputInstance = maxScanThread;
            }
        }
        if (!dmlStmt.hasShuffleHint()) {
            if (dmlStmt.getTargetTable() instanceof FeKuduTable) {
                if (partitionExprs.isEmpty()) {
                    return inputFragment;
                }
            } else if (!enforce_hdfs_writer_limit || !hasHdfsScanORUnion || expectedNumInputInstance <= maxHdfsWriters) {
                long numPartitions;
                Preconditions.checkState((expectedNumInputInstance <= inputFragment.getNumInstances() ? 1 : 0) != 0);
                int input_instances = expectedNumInputInstance;
                if (enforce_hdfs_writer_limit && !hasHdfsScanORUnion) {
                    Preconditions.checkState((maxHdfsWriters > 0 ? 1 : 0) != 0);
                    input_instances = Math.min(input_instances, maxHdfsWriters);
                }
                if (Expr.isSubset(inputPartition.getPartitionExprs(), partitionExprs) && (numPartitions = this.getNumDistinctValues(inputPartition.getPartitionExprs())) >= (long)input_instances) {
                    return inputFragment;
                }
                numPartitions = this.getNumDistinctValues(partitionExprs);
                Preconditions.checkState((expectedNumInputInstance != -1 ? 1 : 0) != 0);
                if (numPartitions > 0L && numPartitions <= (long)input_instances) {
                    return inputFragment;
                }
            }
        }
        ExchangeNode exchNode = new ExchangeNode(this.ctx_.getNextNodeId(), inputFragment.getPlanRoot());
        exchNode.init(analyzer);
        Preconditions.checkState((boolean)exchNode.hasValidStats());
        DataPartition partition = partitionExprs.isEmpty() ? (enforce_hdfs_writer_limit && inputFragment.getDataPartition().getType() == TPartitionType.RANDOM ? DataPartition.RANDOM : DataPartition.UNPARTITIONED) : (dmlStmt instanceof InsertStmt && dmlStmt.getTargetTable() instanceof FeKuduTable ? DataPartition.kuduPartitioned(KuduUtil.createPartitionExpr((InsertStmt)dmlStmt, this.ctx_.getRootAnalyzer())) : DataPartition.hashPartitioned(partitionExprs));
        PlanFragment fragment = new PlanFragment(this.ctx_.getNextFragmentId(), exchNode, partition);
        inputFragment.setDestination(exchNode);
        inputFragment.setOutputPartition(partition);
        fragments.add(fragment);
        return fragment;
    }

    private PlanFragment createMergeFragment(PlanFragment inputFragment) throws ImpalaException {
        Preconditions.checkState((boolean)inputFragment.isPartitioned());
        ExchangeNode mergePlan = new ExchangeNode(this.ctx_.getNextNodeId(), inputFragment.getPlanRoot());
        mergePlan.init(this.ctx_.getRootAnalyzer());
        Preconditions.checkState((boolean)mergePlan.hasValidStats());
        PlanFragment fragment = new PlanFragment(this.ctx_.getNextFragmentId(), mergePlan, DataPartition.UNPARTITIONED);
        inputFragment.setDestination(mergePlan);
        return fragment;
    }

    private PlanFragment createScanFragment(PlanNode node) {
        return new PlanFragment(this.ctx_.getNextFragmentId(), node, DataPartition.RANDOM);
    }

    private PlanFragment createIcebergMetadataScanFragment(PlanNode node) {
        return new PlanFragment(this.ctx_.getNextFragmentId(), node, DataPartition.UNPARTITIONED, true);
    }

    private PlanFragment createSubplanNodeFragment(SubplanNode node, PlanFragment childFragment) {
        node.setChild(0, childFragment.getPlanRoot());
        childFragment.setPlanRoot(node);
        return childFragment;
    }

    private PlanFragment createNestedLoopJoinFragment(NestedLoopJoinNode node, PlanFragment rightChildFragment, PlanFragment leftChildFragment, List<PlanFragment> fragments) throws ImpalaException {
        node.setDistributionMode(JoinNode.DistributionMode.BROADCAST);
        node.setChild(0, leftChildFragment.getPlanRoot());
        this.connectChildFragment(node, 1, leftChildFragment, rightChildFragment);
        leftChildFragment.setPlanRoot(node);
        return leftChildFragment;
    }

    private PlanFragment createPartitionedHashJoinFragment(HashJoinNode node, Analyzer analyzer, boolean lhsHasCompatPartition, boolean rhsHasCompatPartition, PlanFragment leftChildFragment, PlanFragment rightChildFragment, List<Expr> lhsJoinExprs, List<Expr> rhsJoinExprs, List<PlanFragment> fragments) throws ImpalaException {
        DataPartition outputPartition;
        Preconditions.checkState((node.getDistributionMode() == JoinNode.DistributionMode.PARTITIONED ? 1 : 0) != 0);
        if (lhsHasCompatPartition && rhsHasCompatPartition && this.isCompatPartition(leftChildFragment.getDataPartition(), rightChildFragment.getDataPartition(), lhsJoinExprs, rhsJoinExprs, analyzer)) {
            node.setChild(0, leftChildFragment.getPlanRoot());
            node.setChild(1, rightChildFragment.getPlanRoot());
            leftChildFragment.setFragmentInPlanTree((PlanNode)node.getChild(1));
            for (PlanFragment rhsInput : rightChildFragment.getChildren()) {
                leftChildFragment.getChildren().add(rhsInput);
            }
            fragments.remove(rightChildFragment);
            leftChildFragment.setPlanRoot(node);
            return leftChildFragment;
        }
        DataPartition rhsJoinPartition = null;
        if (lhsHasCompatPartition && (rhsJoinPartition = this.getCompatPartition(lhsJoinExprs, leftChildFragment.getDataPartition(), rhsJoinExprs, analyzer)) != null) {
            node.setChild(0, leftChildFragment.getPlanRoot());
            this.connectChildFragment(node, 1, leftChildFragment, rightChildFragment);
            rightChildFragment.setOutputPartition(rhsJoinPartition);
            leftChildFragment.setPlanRoot(node);
            return leftChildFragment;
        }
        DataPartition lhsJoinPartition = null;
        if (rhsHasCompatPartition && (lhsJoinPartition = this.getCompatPartition(rhsJoinExprs, rightChildFragment.getDataPartition(), lhsJoinExprs, analyzer)) != null) {
            node.setChild(1, rightChildFragment.getPlanRoot());
            this.connectChildFragment(node, 0, rightChildFragment, leftChildFragment);
            leftChildFragment.setOutputPartition(lhsJoinPartition);
            rightChildFragment.setPlanRoot(node);
            return rightChildFragment;
        }
        Preconditions.checkState((lhsJoinPartition == null ? 1 : 0) != 0);
        Preconditions.checkState((rhsJoinPartition == null ? 1 : 0) != 0);
        lhsJoinPartition = DataPartition.hashPartitioned(Expr.cloneList(lhsJoinExprs));
        rhsJoinPartition = DataPartition.hashPartitioned(Expr.cloneList(rhsJoinExprs));
        ExchangeNode lhsExchange = new ExchangeNode(this.ctx_.getNextNodeId(), leftChildFragment.getPlanRoot());
        lhsExchange.computeStats(this.ctx_.getRootAnalyzer());
        node.setChild(0, lhsExchange);
        ExchangeNode rhsExchange = new ExchangeNode(this.ctx_.getNextNodeId(), rightChildFragment.getPlanRoot());
        rhsExchange.computeStats(this.ctx_.getRootAnalyzer());
        node.setChild(1, rhsExchange);
        switch (node.getJoinOp()) {
            case FULL_OUTER_JOIN: {
                outputPartition = DataPartition.RANDOM;
                break;
            }
            case RIGHT_ANTI_JOIN: 
            case RIGHT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: {
                outputPartition = rhsJoinPartition;
                break;
            }
            default: {
                outputPartition = lhsJoinPartition;
            }
        }
        PlanFragment joinFragment = new PlanFragment(this.ctx_.getNextFragmentId(), node, outputPartition);
        leftChildFragment.setDestination(lhsExchange);
        leftChildFragment.setOutputPartition(lhsJoinPartition);
        rightChildFragment.setDestination(rhsExchange);
        rightChildFragment.setOutputPartition(rhsJoinPartition);
        return joinFragment;
    }

    private PlanFragment createHashJoinFragment(HashJoinNode node, PlanFragment rightChildFragment, PlanFragment leftChildFragment, List<PlanFragment> fragments) throws ImpalaException {
        boolean bl;
        Analyzer analyzer = this.ctx_.getRootAnalyzer();
        PlanNode rhsTree = rightChildFragment.getPlanRoot();
        long rhsDataSize = -1L;
        long broadcastCost = -1L;
        int mt_dop = this.ctx_.getQueryOptions().mt_dop;
        int leftChildNodes = leftChildFragment.getNumNodes();
        if (rhsTree.getCardinality() != -1L) {
            rhsDataSize = Math.round((double)rhsTree.getCardinality() * ExchangeNode.getAvgSerializedRowSize(rhsTree));
            if (leftChildNodes != -1) {
                long dataPayload;
                long hashTblBuildCost = dataPayload = rhsDataSize * (long)leftChildNodes;
                if (mt_dop > 1 && this.ctx_.getQueryOptions().use_dop_for_costing) {
                    PlanNode planNode = leftChildFragment.getPlanRoot();
                    int actual_dop = planNode.getNumInstances() / planNode.getNumNodes();
                    hashTblBuildCost *= (long)(this.ctx_.getQueryOptions().broadcast_to_partition_factor * Math.max(1.0, Math.sqrt(actual_dop)));
                }
                broadcastCost = dataPayload + hashTblBuildCost;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("broadcast: cost=" + Long.toString(broadcastCost));
            LOG.trace("card=" + Long.toString(rhsTree.getCardinality()) + " row_size=" + Float.toString(rhsTree.getAvgRowSize()) + " #nodes=" + Integer.toString(leftChildNodes));
        }
        PlanNode lhsTree = leftChildFragment.getPlanRoot();
        ArrayList<Expr> lhsJoinExprs = new ArrayList<Expr>();
        ArrayList<Expr> rhsJoinExprs = new ArrayList<Expr>();
        for (Expr expr : node.getEqJoinConjuncts()) {
            lhsJoinExprs.add(((Expr)expr.getChild(0)).clone());
            rhsJoinExprs.add(((Expr)expr.getChild(1)).clone());
        }
        boolean lhsHasCompatPartition = false;
        boolean bl2 = false;
        long partitionCost = -1L;
        if (lhsTree.getCardinality() != -1L && rhsTree.getCardinality() != -1L) {
            lhsHasCompatPartition = analyzer.setsHaveValueTransfer(leftChildFragment.getDataPartition().getPartitionExprs(), lhsJoinExprs, false);
            bl = analyzer.setsHaveValueTransfer(rightChildFragment.getDataPartition().getPartitionExprs(), rhsJoinExprs, false);
            Preconditions.checkState((rhsDataSize != -1L ? 1 : 0) != 0);
            double lhsNetworkCost = lhsHasCompatPartition ? 0.0 : (double)Math.round((double)lhsTree.getCardinality() * ExchangeNode.getAvgSerializedRowSize(lhsTree));
            double rhsNetworkCost = bl ? 0.0 : (double)rhsDataSize;
            partitionCost = Math.round(lhsNetworkCost + rhsNetworkCost + (double)rhsDataSize);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("partition: cost=" + Long.toString(partitionCost));
            LOG.trace("lhs card=" + Long.toString(lhsTree.getCardinality()) + " row_size=" + Float.toString(lhsTree.getAvgRowSize()));
            LOG.trace("rhs card=" + Long.toString(rhsTree.getCardinality()) + " row_size=" + Float.toString(rhsTree.getAvgRowSize()));
            LOG.trace(rhsTree.getExplainString(this.ctx_.getQueryOptions()));
        }
        JoinNode.DistributionMode distrMode = this.computeJoinDistributionMode(node, broadcastCost, partitionCost, rhsDataSize);
        node.setDistributionMode(distrMode);
        PlanFragment hjFragment = null;
        if (distrMode == JoinNode.DistributionMode.BROADCAST) {
            node.setChild(0, leftChildFragment.getPlanRoot());
            this.connectChildFragment(node, 1, leftChildFragment, rightChildFragment);
            leftChildFragment.setPlanRoot(node);
            hjFragment = leftChildFragment;
        } else {
            hjFragment = this.createPartitionedHashJoinFragment(node, analyzer, lhsHasCompatPartition, bl, leftChildFragment, rightChildFragment, lhsJoinExprs, rhsJoinExprs, fragments);
        }
        return hjFragment;
    }

    private PlanFragment createIcebergDeleteFragment(IcebergDeleteNode node, PlanFragment leftChildFragment, PlanFragment rightChildFragment) throws ImpalaException {
        Preconditions.checkState((node.getEqJoinConjuncts().size() == 2 ? 1 : 0) != 0);
        BinaryPredicate filePathEq = node.getEqJoinConjuncts().get(1);
        Preconditions.checkState((((SlotRef)filePathEq.getChild(0)).getDesc().getVirtualColumnType() == TVirtualColumnType.INPUT_FILE_NAME ? 1 : 0) != 0);
        node.setDistributionMode(JoinNode.DistributionMode.DIRECTED);
        node.setChild(0, leftChildFragment.getPlanRoot());
        rightChildFragment.setOutputPartition(DataPartition.DIRECTED);
        this.connectChildFragment(node, 1, leftChildFragment, rightChildFragment);
        leftChildFragment.setPlanRoot(node);
        return leftChildFragment;
    }

    private JoinNode.DistributionMode computeJoinDistributionMode(JoinNode node, long broadcastCost, long partitionCost, long rhsDataSize) {
        JoinOperator op = node.getJoinOp();
        if (op == JoinOperator.RIGHT_OUTER_JOIN || op == JoinOperator.RIGHT_SEMI_JOIN || op == JoinOperator.RIGHT_ANTI_JOIN || op == JoinOperator.FULL_OUTER_JOIN) {
            return JoinNode.DistributionMode.PARTITIONED;
        }
        if (op == JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN) {
            return JoinNode.DistributionMode.BROADCAST;
        }
        if (node.getDistributionModeHint() != JoinNode.DistributionMode.NONE) {
            return node.getDistributionModeHint();
        }
        if (broadcastCost == -1L || partitionCost == -1L || broadcastCost == partitionCost) {
            return JoinNode.DistributionMode.fromThrift(this.ctx_.getQueryOptions().getDefault_join_distribution_mode());
        }
        long htSize = Math.round((double)rhsDataSize * 1.1);
        long memLimit = this.ctx_.getQueryOptions().mem_limit;
        long broadcast_bytes_limit = this.ctx_.getQueryOptions().getBroadcast_bytes_limit();
        if (!(broadcastCost > partitionCost || memLimit != 0L && htSize > memLimit || broadcast_bytes_limit != 0L && htSize > broadcast_bytes_limit)) {
            return JoinNode.DistributionMode.BROADCAST;
        }
        return JoinNode.DistributionMode.PARTITIONED;
    }

    private boolean isCompatPartition(DataPartition lhsPartition, DataPartition rhsPartition, List<Expr> lhsJoinExprs, List<Expr> rhsJoinExprs, Analyzer analyzer) {
        List<Expr> lhsPartExprs = lhsPartition.getPartitionExprs();
        List<Expr> rhsPartExprs = rhsPartition.getPartitionExprs();
        if (lhsPartExprs.size() != rhsPartExprs.size()) {
            return false;
        }
        Preconditions.checkState((lhsJoinExprs.size() == rhsJoinExprs.size() ? 1 : 0) != 0);
        if (lhsJoinExprs.size() == lhsPartExprs.size() && lhsJoinExprs.equals(lhsPartExprs) && rhsJoinExprs.equals(rhsPartExprs)) {
            return true;
        }
        for (int i = 0; i < lhsPartExprs.size(); ++i) {
            if (analyzer.exprsHaveValueTransfer(lhsPartExprs.get(i), rhsPartExprs.get(i), true)) continue;
            return false;
        }
        return true;
    }

    private DataPartition getCompatPartition(List<Expr> srcJoinExprs, DataPartition srcPartition, List<Expr> joinExprs, Analyzer analyzer) {
        Preconditions.checkState((boolean)srcPartition.isHashPartitioned());
        List<Expr> srcPartExprs = srcPartition.getPartitionExprs();
        ArrayList<Expr> resultPartExprs = new ArrayList<Expr>();
        block0: for (Expr srcPartExpr : srcPartExprs) {
            for (int j = 0; j < srcJoinExprs.size(); ++j) {
                if (!analyzer.exprsHaveValueTransfer(srcPartExpr, srcJoinExprs.get(j), false)) continue;
                resultPartExprs.add(joinExprs.get(j).clone());
                continue block0;
            }
        }
        if (resultPartExprs.size() != srcPartExprs.size()) {
            return null;
        }
        return DataPartition.hashPartitioned(resultPartExprs);
    }

    private PlanFragment createUnionNodeFragment(UnionNode unionNode, List<PlanFragment> childFragments, List<PlanFragment> fragments) throws ImpalaException {
        Preconditions.checkState((unionNode.getChildren().size() == childFragments.size() ? 1 : 0) != 0);
        if (unionNode.getChildren().isEmpty()) {
            return new PlanFragment(this.ctx_.getNextFragmentId(), unionNode, DataPartition.UNPARTITIONED);
        }
        Preconditions.checkState((!childFragments.isEmpty() ? 1 : 0) != 0);
        int numUnpartitionedChildFragments = 0;
        for (int i = 0; i < childFragments.size(); ++i) {
            if (childFragments.get(i).isPartitioned()) continue;
            ++numUnpartitionedChildFragments;
        }
        unionNode.clearChildren();
        if (numUnpartitionedChildFragments == childFragments.size()) {
            PlanFragment unionFragment = new PlanFragment(this.ctx_.getNextFragmentId(), unionNode, DataPartition.UNPARTITIONED);
            for (int i = 0; i < childFragments.size(); ++i) {
                unionNode.addChild(childFragments.get(i).getPlanRoot());
                unionFragment.setFragmentInPlanTree((PlanNode)unionNode.getChild(i));
                unionFragment.addChildren(childFragments.get(i).getChildren());
            }
            unionNode.init(this.ctx_.getRootAnalyzer());
            fragments.removeAll(childFragments);
            return unionFragment;
        }
        PlanFragment unionFragment = new PlanFragment(this.ctx_.getNextFragmentId(), unionNode, DataPartition.RANDOM);
        for (int i = 0; i < childFragments.size(); ++i) {
            PlanFragment childFragment = childFragments.get(i);
            if (childFragment.isPartitioned()) {
                unionNode.addChild(childFragment.getPlanRoot());
                unionFragment.setFragmentInPlanTree((PlanNode)unionNode.getChild(i));
                unionFragment.addChildren(childFragment.getChildren());
                fragments.remove(childFragment);
                continue;
            }
            unionNode.addChild(null);
            this.connectChildFragment(unionNode, i, unionFragment, childFragment);
            childFragment.setOutputPartition(DataPartition.RANDOM);
        }
        unionNode.init(this.ctx_.getRootAnalyzer());
        return unionFragment;
    }

    private PlanFragment createSelectNodeFragment(SelectNode selectNode, List<PlanFragment> childFragments) {
        Preconditions.checkState((selectNode.getChildren().size() == childFragments.size() ? 1 : 0) != 0);
        PlanFragment childFragment = childFragments.get(0);
        selectNode.setChild(0, childFragment.getPlanRoot());
        childFragment.setPlanRoot(selectNode);
        return childFragment;
    }

    private PlanFragment createCardinalityCheckNodeFragment(CardinalityCheckNode cardinalityCheckNode, List<PlanFragment> childFragments) throws ImpalaException {
        PlanFragment childFragment = childFragments.get(0);
        if (childFragment.getOutputPartition().isPartitioned()) {
            childFragment = this.createMergeFragment(childFragment);
        }
        cardinalityCheckNode.setChild(0, childFragment.getPlanRoot());
        childFragment.setPlanRoot(cardinalityCheckNode);
        return childFragment;
    }

    private void connectChildFragment(PlanNode node, int childIdx, PlanFragment parentFragment, PlanFragment childFragment) throws ImpalaException {
        ExchangeNode exchangeNode = new ExchangeNode(this.ctx_.getNextNodeId(), childFragment.getPlanRoot());
        exchangeNode.init(this.ctx_.getRootAnalyzer());
        exchangeNode.setFragment(parentFragment);
        node.setChild(childIdx, exchangeNode);
        childFragment.setDestination(exchangeNode);
    }

    private PlanFragment createParentFragment(PlanFragment childFragment, DataPartition parentPartition) throws ImpalaException {
        return this.createParentFragment(childFragment, parentPartition, false);
    }

    private PlanFragment createParentFragment(PlanFragment childFragment, DataPartition parentPartition, boolean unsetLimit) throws ImpalaException {
        ExchangeNode exchangeNode = new ExchangeNode(this.ctx_.getNextNodeId(), childFragment.getPlanRoot());
        exchangeNode.init(this.ctx_.getRootAnalyzer());
        if (unsetLimit) {
            exchangeNode.unsetLimit();
        }
        PlanFragment parentFragment = new PlanFragment(this.ctx_.getNextFragmentId(), exchangeNode, parentPartition);
        childFragment.setDestination(exchangeNode);
        childFragment.setOutputPartition(parentPartition);
        return parentFragment;
    }

    private PlanFragment createAggregationFragment(AggregationNode node, PlanFragment childFragment, List<PlanFragment> fragments) throws ImpalaException {
        boolean isDistinct;
        if (!childFragment.isPartitioned() || node.getAggPhase() == MultiAggregateInfo.AggPhase.TRANSPOSE) {
            childFragment.addPlanRoot(node);
            return childFragment;
        }
        if (node.isDistinctAgg()) {
            childFragment.addPlanRoot(node);
            return childFragment;
        }
        boolean bl = isDistinct = node.getChild(0) instanceof AggregationNode && ((AggregationNode)node.getChild(0)).isDistinctAgg();
        if (isDistinct) {
            return this.createPhase2DistinctAggregationFragment(node, childFragment, fragments);
        }
        return this.createMergeAggregationFragment(node, childFragment);
    }

    private PlanFragment createMergeAggregationFragment(AggregationNode node, PlanFragment childFragment) throws ImpalaException {
        Preconditions.checkArgument((boolean)childFragment.isPartitioned());
        List<Expr> partitionExprs = node.getMergePartitionExprs(this.ctx_.getRootAnalyzer());
        boolean hasGrouping = !partitionExprs.isEmpty();
        DataPartition parentPartition = null;
        if (hasGrouping) {
            boolean childHasCompatPartition;
            boolean bl = childHasCompatPartition = node.isSingleClassAgg() && this.ctx_.getRootAnalyzer().setsHaveValueTransfer(partitionExprs, childFragment.getDataPartition().getPartitionExprs(), true);
            if (childHasCompatPartition) {
                childFragment.addPlanRoot(node);
                return childFragment;
            }
            parentPartition = DataPartition.hashPartitioned(partitionExprs);
        } else {
            parentPartition = DataPartition.UNPARTITIONED;
        }
        childFragment.addPlanRoot(node);
        node.setIntermediateTuple();
        node.setIsPreagg(this.ctx_);
        long limit = node.getLimit();
        if (node.getMultiAggInfo().hasAggregateExprs() || !node.getConjuncts().isEmpty()) {
            node.unsetLimit();
        }
        node.unsetNeedsFinalize();
        PlanFragment mergeFragment = this.createParentFragment(childFragment, parentPartition);
        AggregationNode mergeAggNode = new AggregationNode(this.ctx_.getNextNodeId(), mergeFragment.getPlanRoot(), node.getMultiAggInfo(), MultiAggregateInfo.AggPhase.FIRST_MERGE);
        mergeAggNode.init(this.ctx_.getRootAnalyzer());
        mergeAggNode.setLimit(limit);
        mergeAggNode.setIsNonCorrelatedScalarSubquery(node.isNonCorrelatedScalarSubquery());
        if (!hasGrouping) {
            mergeFragment.getPlanRoot().setDisableCodegen(true);
            mergeAggNode.setDisableCodegen(true);
        }
        node.transferConjuncts(mergeAggNode);
        node.computeStats(this.ctx_.getRootAnalyzer());
        mergeFragment.getPlanRoot().computeStats(this.ctx_.getRootAnalyzer());
        mergeAggNode.computeStats(this.ctx_.getRootAnalyzer());
        mergeFragment.addPlanRoot(mergeAggNode);
        return mergeFragment;
    }

    private PlanFragment createPhase2DistinctAggregationFragment(AggregationNode phase2AggNode, PlanFragment childFragment, List<PlanFragment> fragments) throws ImpalaException {
        DataPartition phase2MergePartition;
        PlanFragment firstMergeFragment;
        boolean childHasCompatPartition;
        Preconditions.checkState((phase2AggNode.getChild(0) == childFragment.getPlanRoot() ? 1 : 0) != 0);
        boolean shuffleDistinctExprs = this.ctx_.getQueryOptions().shuffle_distinct_exprs;
        boolean hasGrouping = phase2AggNode.hasGrouping();
        AggregationNode phase1AggNode = (AggregationNode)phase2AggNode.getChild(0);
        List<Expr> phase1PartitionExprs = phase1AggNode.getMergePartitionExprs(this.ctx_.getRootAnalyzer());
        boolean bl = childHasCompatPartition = phase1AggNode.isSingleClassAgg() && this.ctx_.getRootAnalyzer().setsHaveValueTransfer(phase1PartitionExprs, childFragment.getDataPartition().getPartitionExprs(), true);
        if (childHasCompatPartition) {
            childFragment.addPlanRoot(phase2AggNode);
            firstMergeFragment = childFragment;
        } else {
            phase1AggNode.setIntermediateTuple();
            phase1AggNode.setIsPreagg(this.ctx_);
            DataPartition phase1MergePartition = DataPartition.hashPartitioned(phase1PartitionExprs);
            firstMergeFragment = this.createParentFragment(childFragment, phase1MergePartition);
            AggregationNode phase1MergeAggNode = new AggregationNode(this.ctx_.getNextNodeId(), phase1AggNode, phase1AggNode.getMultiAggInfo(), MultiAggregateInfo.AggPhase.FIRST_MERGE);
            phase1MergeAggNode.init(this.ctx_.getRootAnalyzer());
            phase1MergeAggNode.unsetNeedsFinalize();
            phase1MergeAggNode.setIntermediateTuple();
            firstMergeFragment.addPlanRoot(phase1MergeAggNode);
            firstMergeFragment.addPlanRoot(phase2AggNode);
            if (shuffleDistinctExprs || !hasGrouping) {
                fragments.add(firstMergeFragment);
            }
        }
        if (!shuffleDistinctExprs && hasGrouping) {
            return firstMergeFragment;
        }
        phase2AggNode.unsetNeedsFinalize();
        phase2AggNode.setIntermediateTuple();
        long limit = phase2AggNode.getLimit();
        phase2AggNode.unsetLimit();
        List<Expr> phase2PartitionExprs = phase2AggNode.getMergePartitionExprs(this.ctx_.getRootAnalyzer());
        if (phase2PartitionExprs.isEmpty()) {
            phase2MergePartition = DataPartition.UNPARTITIONED;
        } else {
            phase2AggNode.setIsPreagg(this.ctx_);
            phase2MergePartition = DataPartition.hashPartitioned(phase2PartitionExprs);
        }
        PlanFragment secondMergeFragment = this.createParentFragment(firstMergeFragment, phase2MergePartition);
        AggregationNode phase2MergeAggNode = new AggregationNode(this.ctx_.getNextNodeId(), phase2AggNode, phase2AggNode.getMultiAggInfo(), MultiAggregateInfo.AggPhase.SECOND_MERGE);
        phase2MergeAggNode.init(this.ctx_.getRootAnalyzer());
        phase2MergeAggNode.setLimit(limit);
        phase2AggNode.transferConjuncts(phase2MergeAggNode);
        secondMergeFragment.addPlanRoot(phase2MergeAggNode);
        return secondMergeFragment;
    }

    private PlanFragment createAnalyticFragment(PlanNode node, PlanFragment childFragment, List<PlanFragment> fragments) throws ImpalaException {
        Preconditions.checkState((node instanceof SortNode || node instanceof AnalyticEvalNode ? 1 : 0) != 0);
        if (node instanceof AnalyticEvalNode) {
            AnalyticEvalNode analyticNode = (AnalyticEvalNode)node;
            if (analyticNode.requiresUnpartitionedEval()) {
                PlanFragment fragment = childFragment;
                if (childFragment.isPartitioned()) {
                    fragment = this.createParentFragment(childFragment, DataPartition.UNPARTITIONED);
                }
                fragment.addPlanRoot(analyticNode);
                return fragment;
            }
            childFragment.addPlanRoot(analyticNode);
            return childFragment;
        }
        SortNode sortNode = (SortNode)node;
        Preconditions.checkState((boolean)sortNode.isAnalyticSort());
        PlanFragment analyticFragment = childFragment;
        boolean addedLowerTopN = false;
        SortNode lowerTopN = null;
        AnalyticEvalNode analyticNode = sortNode.getAnalyticEvalNode();
        if (sortNode.getInputPartition() != null) {
            sortNode.getInputPartition().substitute(childFragment.getPlanRoot().getOutputSmap(), this.ctx_.getRootAnalyzer());
            DataPartition sortPartition = sortNode.getInputPartition();
            boolean hasNullableTupleIds = childFragment.getPlanRoot().getNullableTupleIds().size() > 0;
            boolean hasCompatiblePartition = false;
            hasCompatiblePartition = hasNullableTupleIds ? childFragment.getDataPartition().equals(sortPartition) : this.ctx_.getRootAnalyzer().setsHaveValueTransfer(childFragment.getDataPartition().getPartitionExprs(), sortPartition.getPartitionExprs(), true);
            if (!hasCompatiblePartition) {
                if (sortNode.isTypeTopN() || sortNode.isPartitionedTopN()) {
                    lowerTopN = sortNode;
                    childFragment.addPlanRoot(lowerTopN);
                    sortPartition.substitute(sortNode.getSortInfo().getOutputSmap(), this.ctx_.getRootAnalyzer());
                    addedLowerTopN = true;
                    analyticFragment = this.createParentFragment(childFragment, sortPartition, true);
                } else {
                    analyticFragment = this.createParentFragment(childFragment, sortPartition);
                }
            }
        }
        if (addedLowerTopN) {
            SortNode upperTopN = lowerTopN.isTypeTopN() ? SortNode.createTopNSortNode(this.ctx_.getQueryOptions(), this.ctx_.getNextNodeId(), childFragment.getPlanRoot(), lowerTopN.getSortInfo(), sortNode.getOffset(), lowerTopN.getSortLimit(), lowerTopN.isIncludeTies()) : SortNode.createPartitionedTopNSortNode(this.ctx_.getNextNodeId(), childFragment.getPlanRoot(), lowerTopN.getSortInfo(), lowerTopN.getNumPartitionExprs(), lowerTopN.getPerPartitionLimit(), lowerTopN.isIncludeTies());
            upperTopN.setIsAnalyticSort(true);
            upperTopN.init(this.ctx_.getRootAnalyzer());
            analyticNode.setChild(0, upperTopN);
            analyticFragment.addPlanRoot(upperTopN);
        } else {
            analyticFragment.addPlanRoot(sortNode);
        }
        return analyticFragment;
    }

    private PlanFragment createOrderByFragment(SortNode node, PlanFragment childFragment, List<PlanFragment> fragments) throws ImpalaException {
        node.setChild(0, childFragment.getPlanRoot());
        childFragment.addPlanRoot(node);
        if (!childFragment.isPartitioned()) {
            return childFragment;
        }
        PlanFragment mergeFragment = this.createParentFragment(childFragment, DataPartition.UNPARTITIONED);
        ExchangeNode exchNode = (ExchangeNode)mergeFragment.getPlanRoot();
        SortNode childSortNode = (SortNode)childFragment.getPlanRoot();
        if (node.isIncludeTies()) {
            Preconditions.checkState((node.getOffset() == 0L ? 1 : 0) != 0, (Object)"Tie handling with offset not supported");
            if (node.isPartitionedTopN()) {
                SortNode parentSortNode = SortNode.createPartitionedTopNSortNode(this.ctx_.getNextNodeId(), exchNode, childSortNode.getSortInfo(), childSortNode.getNumPartitionExprs(), childSortNode.getPerPartitionLimit(), childSortNode.isIncludeTies());
                parentSortNode.init(this.ctx_.getRootAnalyzer());
                mergeFragment.addPlanRoot(parentSortNode);
            } else {
                Preconditions.checkState((boolean)node.isTypeTopN(), (Object)"only top-n handles ties");
                SortNode parentSortNode = SortNode.createTopNSortNode(this.ctx_.getQueryOptions(), this.ctx_.getNextNodeId(), exchNode, childSortNode.getSortInfo(), 0L, node.getSortLimit(), childSortNode.isIncludeTies());
                parentSortNode.init(this.ctx_.getRootAnalyzer());
                mergeFragment.addPlanRoot(parentSortNode);
            }
        } else {
            boolean hasLimit = node.hasLimit();
            long limit = node.getLimit();
            long offset = node.getOffset();
            exchNode.unsetLimit();
            if (hasLimit) {
                exchNode.setLimit(limit);
            }
            exchNode.setMergeInfo(node.getSortInfo(), offset);
            Preconditions.checkState((node == childSortNode ? 1 : 0) != 0);
            if (hasLimit) {
                childSortNode.unsetLimit();
                childSortNode.setLimit(PlanNode.checkedAdd(limit, offset));
            }
            childSortNode.setOffset(0L);
        }
        childSortNode.computeStats(this.ctx_.getRootAnalyzer());
        exchNode.computeStats(this.ctx_.getRootAnalyzer());
        return mergeFragment;
    }
}

