/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TimestampLiteral;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.extdatasource.ExternalDataSourceExecutor;
import org.apache.impala.extdatasource.thrift.TBinaryPredicate;
import org.apache.impala.extdatasource.thrift.TColumnDesc;
import org.apache.impala.extdatasource.thrift.TComparisonOp;
import org.apache.impala.extdatasource.thrift.TPrepareParams;
import org.apache.impala.extdatasource.thrift.TPrepareResult;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TDataSourceScanNode;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TScanRange;
import org.apache.impala.thrift.TScanRangeLocation;
import org.apache.impala.thrift.TScanRangeLocationList;
import org.apache.impala.thrift.TScanRangeSpec;
import org.apache.impala.thrift.TStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceScanNode
extends ScanNode {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceScanNode.class);
    private final TupleDescriptor desc_;
    private final FeDataSourceTable table_;
    private List<List<TBinaryPredicate>> acceptedPredicates_;
    private List<Expr> acceptedConjuncts_;
    private long numRowsEstimate_;

    public DataSourceScanNode(PlanNodeId id, TupleDescriptor desc, List<Expr> conjuncts) {
        super(id, desc, "SCAN DATA SOURCE");
        this.desc_ = desc;
        this.table_ = (FeDataSourceTable)this.desc_.getTable();
        this.conjuncts_ = conjuncts;
        this.acceptedPredicates_ = null;
        this.acceptedConjuncts_ = null;
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        this.checkForSupportedFileFormats();
        this.prepareDataSource();
        this.conjuncts_ = DataSourceScanNode.orderConjunctsByCost(this.conjuncts_);
        this.computeStats(analyzer);
        analyzer.materializeSlots(this.conjuncts_);
        this.computeMemLayout(analyzer);
        this.computeScanRangeLocations(analyzer);
    }

    public static TColumnValue literalToColumnValue(LiteralExpr expr) {
        switch (expr.getType().getPrimitiveType()) {
            case BOOLEAN: {
                return new TColumnValue().setBool_val(((BoolLiteral)expr).getValue());
            }
            case TINYINT: {
                return new TColumnValue().setByte_val((byte)((NumericLiteral)expr).getLongValue());
            }
            case SMALLINT: {
                return new TColumnValue().setShort_val((short)((NumericLiteral)expr).getLongValue());
            }
            case INT: {
                return new TColumnValue().setInt_val((int)((NumericLiteral)expr).getLongValue());
            }
            case BIGINT: {
                return new TColumnValue().setLong_val(((NumericLiteral)expr).getLongValue());
            }
            case FLOAT: 
            case DOUBLE: {
                return new TColumnValue().setDouble_val(((NumericLiteral)expr).getDoubleValue());
            }
            case STRING: {
                return new TColumnValue().setString_val(((StringLiteral)expr).getUnescapedValue());
            }
            case DATE: {
                return new TColumnValue().setDate_val(((DateLiteral)expr).getValue());
            }
            case TIMESTAMP: {
                return new TColumnValue().setString_val(((TimestampLiteral)expr).getStringValue());
            }
            case DECIMAL: {
                return new TColumnValue().setString_val(((NumericLiteral)expr).getValue().toString());
            }
            case DATETIME: {
                return null;
            }
        }
        Preconditions.checkState((boolean)false);
        return null;
    }

    private void prepareDataSource() throws InternalException {
        TStatus prepareStatus;
        TPrepareResult prepareResult;
        ArrayList<List<TBinaryPredicate>> offeredPredicates = new ArrayList<List<TBinaryPredicate>>();
        ArrayList<Integer> conjunctsIdx = new ArrayList<Integer>();
        for (int i = 0; i < this.conjuncts_.size(); ++i) {
            Expr conjunct = (Expr)this.conjuncts_.get(i);
            List<TBinaryPredicate> disjuncts = this.getDisjuncts(conjunct);
            if (disjuncts == null) continue;
            offeredPredicates.add(disjuncts);
            conjunctsIdx.add(i);
        }
        String className = this.table_.getDataSource().getClass_name();
        String apiVersion = this.table_.getDataSource().getApi_version();
        String dsLocation = this.table_.getDataSource().getHdfs_location();
        String localPath = null;
        if (!Strings.isNullOrEmpty((String)dsLocation)) {
            LOG.trace("Get the instance from URLClassLoader");
            try {
                localPath = FileSystemUtil.copyFileFromUriToLocal(dsLocation);
            }
            catch (IOException e) {
                throw new InternalException(String.format("Unable to fetch data source jar from location '%s'.", dsLocation));
            }
            Preconditions.checkNotNull((Object)localPath);
        } else {
            LOG.trace("Get the instance of the data source class in current ClassLoader");
        }
        try {
            ExternalDataSourceExecutor executor = new ExternalDataSourceExecutor(localPath, className, apiVersion, this.table_.getInitString());
            TPrepareParams prepareParams = new TPrepareParams();
            prepareParams.setInit_string(this.table_.getInitString());
            prepareParams.setPredicates(offeredPredicates);
            prepareParams.setTable_name(this.table_.getName());
            prepareResult = executor.prepare(prepareParams);
            prepareStatus = prepareResult.getStatus();
        }
        catch (Exception e) {
            throw new InternalException(String.format("Error calling prepare() on data source %s", DataSource.debugString(this.table_.getDataSource())), e);
        }
        finally {
            if (!Strings.isNullOrEmpty((String)localPath)) {
                Path localJarPath = new Path("file://" + localPath);
                FileSystemUtil.deleteIfExists(localJarPath);
            }
        }
        if (prepareStatus.getStatus_code() != TErrorCode.OK) {
            throw new InternalException(String.format("Data source %s returned an error from prepare(): %s", DataSource.debugString(this.table_.getDataSource()), Joiner.on((String)"\n").join(prepareStatus.getError_msgs())));
        }
        this.numRowsEstimate_ = prepareResult.getNum_rows_estimate();
        this.acceptedPredicates_ = new ArrayList<List<TBinaryPredicate>>();
        List<Integer> acceptedPredicatesIdx = prepareResult.isSetAccepted_conjuncts() ? prepareResult.getAccepted_conjuncts() : ImmutableList.of();
        Iterator iterator = acceptedPredicatesIdx.iterator();
        while (iterator.hasNext()) {
            Integer acceptedIdx = (Integer)iterator.next();
            this.acceptedPredicates_.add((List<TBinaryPredicate>)offeredPredicates.get(acceptedIdx));
        }
        this.removeAcceptedConjuncts(acceptedPredicatesIdx, conjunctsIdx);
    }

    private List<TBinaryPredicate> getDisjuncts(Expr conjunct) {
        ArrayList<TBinaryPredicate> disjuncts = new ArrayList<TBinaryPredicate>();
        if (this.getDisjunctsHelper(conjunct, disjuncts)) {
            return disjuncts;
        }
        return null;
    }

    private boolean getDisjunctsHelper(Expr conjunct, List<TBinaryPredicate> predicates) {
        if (conjunct instanceof BinaryPredicate) {
            TColumnValue val;
            if (conjunct.getChildren().size() != 2) {
                return false;
            }
            Expr colExpr = null;
            SlotRef slotRef = null;
            LiteralExpr literalExpr = null;
            TComparisonOp op = null;
            if (((Expr)conjunct.getChild(0)).unwrapSlotRef(true) instanceof SlotRef && conjunct.getChild(1) instanceof LiteralExpr) {
                colExpr = (Expr)conjunct.getChild(0);
                slotRef = colExpr.unwrapSlotRef(true);
                literalExpr = (LiteralExpr)conjunct.getChild(1);
                op = ((BinaryPredicate)conjunct).getOp().getThriftOp();
            } else if (((Expr)conjunct.getChild(1)).unwrapSlotRef(true) instanceof SlotRef && conjunct.getChild(0) instanceof LiteralExpr) {
                colExpr = (Expr)conjunct.getChild(1);
                slotRef = colExpr.unwrapSlotRef(true);
                literalExpr = (LiteralExpr)conjunct.getChild(0);
                op = ((BinaryPredicate)conjunct).getOp().converse().getThriftOp();
            } else {
                return false;
            }
            if (colExpr instanceof CastExpr) {
                CastExpr castExpr = (CastExpr)colExpr;
                Preconditions.checkNotNull((Object)castExpr.getType());
                if (castExpr.getType().isDateOrTimeType() || castExpr.getCompatibility().isUnsafe()) {
                    return false;
                }
            }
            if ((val = DataSourceScanNode.literalToColumnValue(literalExpr)) == null) {
                return false;
            }
            String colName = Joiner.on((String)".").join(slotRef.getResolvedPath().getRawPath());
            TColumnDesc col = new TColumnDesc().setName(colName).setType(slotRef.getType().toThrift());
            predicates.add(new TBinaryPredicate().setCol(col).setOp(op).setValue(val));
            return true;
        }
        if (conjunct instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)conjunct;
            if (compoundPredicate.getOp() != CompoundPredicate.Operator.OR) {
                return false;
            }
            if (!this.getDisjunctsHelper((Expr)conjunct.getChild(0), predicates)) {
                return false;
            }
            return this.getDisjunctsHelper((Expr)conjunct.getChild(1), predicates);
        }
        return false;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.inputCardinality_ = this.numRowsEstimate_;
        this.cardinality_ = this.numRowsEstimate_;
        this.cardinality_ = this.applyConjunctsSelectivity(this.cardinality_);
        this.cardinality_ = Math.max(1L, this.cardinality_);
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        if (LOG.isTraceEnabled()) {
            LOG.trace("computeStats DataSourceScan: cardinality=" + Long.toString(this.cardinality_));
        }
        this.numInstances_ = this.numNodes_ = this.table_.getNumNodes();
        if (LOG.isTraceEnabled()) {
            LOG.trace("computeStats DataSourceScan: #nodes=" + Integer.toString(this.numNodes_));
        }
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("tid", this.desc_.getId().asInt()).add("tblName", (Object)this.table_.getFullName()).add("dataSource", (Object)DataSource.debugString(this.table_.getDataSource())).add("initString", (Object)this.table_.getInitString()).addValue((Object)super.debugString()).toString();
    }

    private void removeAcceptedConjuncts(List<Integer> acceptedPredicatesIdx, List<Integer> conjunctsIdx) {
        this.acceptedConjuncts_ = new ArrayList<Expr>();
        for (int i = acceptedPredicatesIdx.size() - 1; i >= 0; --i) {
            int acceptedPredIdx = acceptedPredicatesIdx.get(i);
            int conjunctIdx = conjunctsIdx.get(acceptedPredIdx);
            this.acceptedConjuncts_.add((Expr)this.conjuncts_.remove(conjunctIdx));
        }
        this.acceptedConjuncts_ = Lists.reverse(this.acceptedConjuncts_);
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        Preconditions.checkNotNull(this.acceptedPredicates_);
        msg.node_type = TPlanNodeType.DATA_SOURCE_NODE;
        msg.data_source_node = new TDataSourceScanNode(this.desc_.getId().asInt(), this.table_.getDataSource(), this.table_.getInitString(), this.acceptedPredicates_);
    }

    private void computeScanRangeLocations(Analyzer analyzer) {
        TNetworkAddress networkAddress = DataSourceScanNode.addressToTNetworkAddress("localhost:12345");
        Integer hostIndex = analyzer.getHostIndex().getOrAddIndex(networkAddress);
        this.scanRangeSpecs_ = new TScanRangeSpec();
        this.scanRangeSpecs_.addToConcrete_ranges(new TScanRangeLocationList(new TScanRange(), Lists.newArrayList((Object[])new TScanRangeLocation[]{new TScanRangeLocation(hostIndex)})));
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0x40000000L);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        String aliasStr = "";
        if (!this.table_.getFullName().equalsIgnoreCase(this.desc_.getAlias()) && !this.table_.getName().equalsIgnoreCase(this.desc_.getAlias())) {
            aliasStr = " " + this.desc_.getAlias();
        }
        output.append(String.format("%s%s:%s [%s%s]\n", prefix, this.id_.toString(), this.displayName_, this.table_.getFullName(), aliasStr));
        if (this.acceptedConjuncts_ != null && !this.acceptedConjuncts_.isEmpty()) {
            output.append(detailPrefix + "data source predicates: " + Expr.getExplainString(this.acceptedConjuncts_, detailLevel) + "\n");
        }
        if (this.conjuncts_ != null && !this.conjuncts_.isEmpty()) {
            output.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
        }
        if (detailLevel == TExplainLevel.VERBOSE) {
            output.append(this.getStatsExplainString(prefix));
            output.append("\n");
        }
        return output.toString();
    }

    @Override
    public boolean hasStorageLayerConjuncts() {
        return !this.acceptedConjuncts_.isEmpty();
    }
}

