/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExecStats;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TQueryOptions;

public abstract class DataSink {
    protected PlanFragment fragment_;
    protected ResourceProfile resourceProfile_ = ResourceProfile.invalid();
    protected ProcessingCost processingCost_ = ProcessingCost.invalid();

    public final String getExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel) {
        StringBuilder output = new StringBuilder();
        this.appendSinkExplainString(prefix, detailPrefix, queryOptions, explainLevel, output);
        if (explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(detailPrefix);
            output.append(this.resourceProfile_.getExplainString());
            if (queryOptions.isCompute_processing_cost()) {
                output.append(" cost=");
                if (this.processingCost_.isValid()) {
                    output.append(this.processingCost_.getTotalCost());
                    if (explainLevel.ordinal() >= TExplainLevel.VERBOSE.ordinal()) {
                        output.append("\n");
                        output.append(this.processingCost_.getExplainString(detailPrefix, false));
                    }
                } else {
                    output.append("<invalid>");
                }
            }
            output.append("\n");
        }
        return output.toString();
    }

    protected abstract void appendSinkExplainString(String var1, String var2, TQueryOptions var3, TExplainLevel var4, StringBuilder var5);

    protected abstract String getLabel();

    public List<RuntimeFilterGenerator.RuntimeFilter> getRuntimeFilters() {
        return Collections.emptyList();
    }

    protected final TDataSink toThrift() {
        TDataSink tsink = new TDataSink(this.getSinkType());
        tsink.setLabel(this.fragment_.getId() + ":" + this.getLabel());
        TExecStats estimatedStats = new TExecStats();
        estimatedStats.setMemory_used(this.resourceProfile_.getMemEstimateBytes());
        tsink.setEstimated_stats(estimatedStats);
        Preconditions.checkState((boolean)this.resourceProfile_.isValid());
        tsink.resource_profile = this.resourceProfile_.toThrift();
        this.toThriftImpl(tsink);
        return tsink;
    }

    protected abstract void toThriftImpl(TDataSink var1);

    protected abstract TDataSinkType getSinkType();

    public void setFragment(PlanFragment fragment) {
        this.fragment_ = fragment;
    }

    public PlanFragment getFragment() {
        return this.fragment_;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile_;
    }

    public ProcessingCost getProcessingCost() {
        return this.processingCost_;
    }

    public abstract void computeProcessingCost(TQueryOptions var1);

    public abstract void computeResourceProfile(TQueryOptions var1);

    public void computeRowConsumptionAndProductionToCost() {
        Preconditions.checkState((boolean)this.processingCost_.isValid(), (String)"Processing cost of DataSink %s:%s is invalid! %s", (Object)this.fragment_.getId(), (Object)this.getLabel(), (Object)this.processingCost_);
        long inputOutputCardinality = Math.max(0L, this.fragment_.getPlanRoot().getCardinality());
        this.processingCost_.setNumRowToConsume(inputOutputCardinality);
        this.processingCost_.setNumRowToProduce(inputOutputCardinality);
    }

    public abstract void collectExprs(List<Expr> var1);
}

