/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.thrift.TDataPartition;
import org.apache.impala.thrift.TPartitionType;

public class DataPartition {
    private final TPartitionType type_;
    private List<Expr> partitionExprs_;
    public static final DataPartition UNPARTITIONED = new DataPartition(TPartitionType.UNPARTITIONED);
    public static final DataPartition RANDOM = new DataPartition(TPartitionType.RANDOM);
    public static final DataPartition DIRECTED = new DataPartition(TPartitionType.DIRECTED);

    private DataPartition(TPartitionType type, List<Expr> exprs) {
        Preconditions.checkNotNull(exprs);
        Preconditions.checkState((!exprs.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((type == TPartitionType.HASH_PARTITIONED || type == TPartitionType.RANGE_PARTITIONED || type == TPartitionType.KUDU ? 1 : 0) != 0);
        this.type_ = type;
        this.partitionExprs_ = exprs;
    }

    private DataPartition(TPartitionType type) {
        Preconditions.checkState((type == TPartitionType.UNPARTITIONED || type == TPartitionType.RANDOM || type == TPartitionType.DIRECTED ? 1 : 0) != 0);
        this.type_ = type;
        this.partitionExprs_ = new ArrayList<Expr>();
    }

    public static DataPartition hashPartitioned(List<Expr> exprs) {
        return new DataPartition(TPartitionType.HASH_PARTITIONED, exprs);
    }

    public static DataPartition kuduPartitioned(Expr expr) {
        return new DataPartition(TPartitionType.KUDU, Lists.newArrayList((Object[])new Expr[]{expr}));
    }

    public boolean isPartitioned() {
        return this.type_ != TPartitionType.UNPARTITIONED;
    }

    public boolean isHashPartitioned() {
        return this.type_ == TPartitionType.HASH_PARTITIONED;
    }

    public TPartitionType getType() {
        return this.type_;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs_;
    }

    public void substitute(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.partitionExprs_ = Expr.substituteList(this.partitionExprs_, smap, analyzer, false);
    }

    public TDataPartition toThrift() {
        TDataPartition result = new TDataPartition(this.type_);
        if (this.partitionExprs_ != null) {
            result.setPartition_exprs(Expr.treesToThrift(this.partitionExprs_));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataPartition other = (DataPartition)obj;
        if (this.type_ != other.type_) {
            return false;
        }
        return Expr.equalLists(this.partitionExprs_, other.partitionExprs_);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type_, this.partitionExprs_});
    }

    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("type_", (Object)this.type_).addValue((Object)Expr.debugString(this.partitionExprs_)).toString();
    }

    public String getExplainString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getPartitionShortName(this.type_));
        if (!this.partitionExprs_.isEmpty()) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Expr expr : this.partitionExprs_) {
                strings.add(expr.toSql());
            }
            str.append("(" + Joiner.on((String)",").join(strings) + ")");
        }
        return str.toString();
    }

    private String getPartitionShortName(TPartitionType partition) {
        switch (partition) {
            case RANDOM: {
                return "RANDOM";
            }
            case HASH_PARTITIONED: {
                return "HASH";
            }
            case RANGE_PARTITIONED: {
                return "RANGE";
            }
            case UNPARTITIONED: {
                return "UNPARTITIONED";
            }
            case KUDU: {
                return "KUDU";
            }
        }
        return "";
    }
}

