/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.impala.common.Id;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanFragmentId;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlanRootSink;

public class CoreCount {
    private final ImmutableList<Id> ids_;
    private final ImmutableList<Integer> counts_;
    private final ImmutableSet<PlanFragmentId> uniqueFragmentIds_;
    private final boolean hasPlanRootSink_;
    private final int total_;

    public CoreCount(PlanFragment fragment, int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"Core count must be a non-negative number");
        this.ids_ = ImmutableList.of((Object)fragment.getId());
        this.counts_ = ImmutableList.of((Object)count);
        this.uniqueFragmentIds_ = ImmutableSet.of((Object)fragment.getId());
        this.hasPlanRootSink_ = fragment.getSink() instanceof PlanRootSink;
        this.total_ = this.counts_.stream().mapToInt(v -> v).sum();
    }

    public CoreCount(PlanNode node, int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"Core count must be a non-negative number");
        this.ids_ = ImmutableList.of((Object)node.getId());
        this.counts_ = ImmutableList.of((Object)count);
        PlanFragment fragment = node.getFragment();
        this.uniqueFragmentIds_ = ImmutableSet.of((Object)fragment.getId());
        this.hasPlanRootSink_ = false;
        this.total_ = this.counts_.stream().mapToInt(v -> v).sum();
    }

    private CoreCount(ImmutableList<Id> ids, ImmutableList<Integer> counts, ImmutableSet<PlanFragmentId> uniqueFragments, boolean hasPlanRootSink) {
        Preconditions.checkArgument((ids.size() == counts.size() ? 1 : 0) != 0, (Object)"ids and counts must have same size!");
        this.ids_ = ids;
        this.counts_ = counts;
        this.uniqueFragmentIds_ = uniqueFragments;
        this.hasPlanRootSink_ = hasPlanRootSink;
        this.total_ = this.counts_.stream().mapToInt(v -> v).sum();
    }

    public int total() {
        return this.total_;
    }

    public boolean hasCoordinator() {
        return this.hasPlanRootSink_;
    }

    public int totalWithoutCoordinator() {
        return this.total_ - (this.hasPlanRootSink_ ? 1 : 0);
    }

    public ImmutableSet<PlanFragmentId> getUniqueFragmentIds() {
        return this.uniqueFragmentIds_;
    }

    public String toString() {
        if (this.ids_.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{total=");
        sb.append(this.total());
        sb.append(" trace=");
        sb.append(IntStream.range(0, this.ids_.size()).mapToObj(i -> (this.ids_.get(i) instanceof PlanNodeId ? "N" : "") + this.ids_.get(i) + ":" + this.counts_.get(i)).collect(Collectors.joining("+")));
        sb.append("}");
        return sb.toString();
    }

    protected static CoreCount sum(List<CoreCount> cores) {
        ImmutableList.Builder idBuilder = new ImmutableList.Builder();
        ImmutableList.Builder countBuilder = new ImmutableList.Builder();
        ImmutableSet.Builder fragmentIdBuilder = new ImmutableSet.Builder();
        boolean hasPlanRootSink = false;
        for (CoreCount coreRequirement : cores) {
            idBuilder.addAll(coreRequirement.ids_);
            countBuilder.addAll(coreRequirement.counts_);
            fragmentIdBuilder.addAll(coreRequirement.uniqueFragmentIds_);
            hasPlanRootSink |= coreRequirement.hasPlanRootSink_;
        }
        return new CoreCount((ImmutableList<Id>)idBuilder.build(), (ImmutableList<Integer>)countBuilder.build(), (ImmutableSet<PlanFragmentId>)fragmentIdBuilder.build(), hasPlanRootSink);
    }

    protected static CoreCount sum(CoreCount core1, CoreCount core2) {
        return CoreCount.sum((List<CoreCount>)ImmutableList.of((Object)core1, (Object)core2));
    }

    protected static CoreCount max(CoreCount core1, CoreCount core2) {
        if (core1.totalWithoutCoordinator() < core2.totalWithoutCoordinator()) {
            return core2;
        }
        return core1;
    }
}

