/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.util.MathUtil;

public class BroadcastProcessingCost
extends ProcessingCost {
    private final ProcessingCost childProcessingCost_;

    protected BroadcastProcessingCost(ProcessingCost cost, Supplier<Integer> countSupplier) {
        Preconditions.checkArgument((boolean)cost.isValid(), (String)"BroadcastProcessingCost: cost is invalid! %s", (Object)cost);
        this.childProcessingCost_ = cost;
        this.setNumInstanceExpected(countSupplier);
    }

    @Override
    public long getTotalCost() {
        return MathUtil.saturatingMultiply(this.childProcessingCost_.getTotalCost(), this.getNumInstancesExpected());
    }

    @Override
    public boolean isValid() {
        return this.getNumInstancesExpected() > 0;
    }

    @Override
    public ProcessingCost clone() {
        return new BroadcastProcessingCost(this.childProcessingCost_, this.numInstanceSupplier_);
    }

    @Override
    public String getExplainString(String detailPrefix, boolean fullExplain) {
        StringBuilder sb = new StringBuilder();
        sb.append(detailPrefix);
        sb.append("BroadcastCost(");
        sb.append(this.getNumInstancesExpected());
        sb.append("): ");
        sb.append(this.getDetails());
        if (fullExplain) {
            sb.append("\n");
            sb.append(this.childProcessingCost_.getExplainString(detailPrefix + "  ", true));
        }
        return sb.toString();
    }
}

