/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.planner.ProcessingCost;

public class BaseProcessingCost
extends ProcessingCost {
    private final long cardinality_;
    private final float exprsCost_;
    private final float materializationCost_;
    private final double totalCost_;

    public BaseProcessingCost(long cardinality, float exprsCost, float materializationCost) {
        this.cardinality_ = cardinality;
        this.exprsCost_ = exprsCost;
        this.materializationCost_ = materializationCost;
        this.totalCost_ = Math.ceil((float)Math.max(this.cardinality_, 0L) * (this.exprsCost_ + this.materializationCost_));
    }

    public BaseProcessingCost(double totalCost) {
        Preconditions.checkArgument((!Double.isNaN(totalCost) ? 1 : 0) != 0, (Object)"totalCost must not be a NaN!");
        Preconditions.checkArgument((boolean)Double.isFinite(totalCost), (Object)"totalCost must be a finite double!");
        Preconditions.checkArgument((totalCost >= 0.0 ? 1 : 0) != 0, (Object)"totalCost must not be a negative!");
        this.cardinality_ = 0L;
        this.exprsCost_ = 0.0f;
        this.materializationCost_ = 0.0f;
        this.totalCost_ = totalCost;
    }

    @Override
    public long getTotalCost() {
        return (long)this.totalCost_;
    }

    @Override
    public boolean isValid() {
        return this.totalCost_ >= 0.0;
    }

    @Override
    public ProcessingCost clone() {
        if (this.cardinality_ != 0L) {
            return new BaseProcessingCost(this.cardinality_, this.exprsCost_, this.materializationCost_);
        }
        return new BaseProcessingCost(this.totalCost_);
    }

    @Override
    public String getDetails() {
        StringBuilder output = new StringBuilder();
        output.append(super.getDetails());
        output.append(" raw-cost=").append(this.totalCost_);
        if (this.cardinality_ != 0L) {
            output.append(" cardinality=").append(this.cardinality_);
        }
        return output.toString();
    }
}

