/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.impala.analysis.AggregateInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.CaseWhenClause;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.ValidTupleIdExpr;
import org.apache.impala.common.InternalException;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.thrift.TAggregationNode;
import org.apache.impala.thrift.TAggregator;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.BitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationNode.class);
    private static final long DEFAULT_PER_INSTANCE_MEM = 0x8000000L;
    private static final double DEFAULT_SKEW_FACTOR = 1.5;
    private final MultiAggregateInfo multiAggInfo_;
    private final MultiAggregateInfo.AggPhase aggPhase_;
    private final List<AggregateInfo> aggInfos_;
    private boolean useIntermediateTuple_ = false;
    private boolean needsFinalize_ = false;
    private boolean useStreamingPreagg_ = false;
    private List<ResourceProfile> resourceProfiles_;
    protected static final long MIN_PLAIN_AGG_MEM = 16384L;
    protected boolean isNonCorrelatedScalarSubquery_ = false;
    private long aggInputCardinality_ = -1L;
    private List<Long> aggClassNumGroups_;

    public AggregationNode(PlanNodeId id, PlanNode input, MultiAggregateInfo multiAggInfo, MultiAggregateInfo.AggPhase aggPhase) {
        super(id, "AGGREGATE");
        this.children_.add(input);
        this.multiAggInfo_ = multiAggInfo;
        this.aggInfos_ = this.multiAggInfo_.getMaterializedAggInfos(aggPhase);
        this.aggPhase_ = aggPhase;
        this.needsFinalize_ = true;
        this.computeTupleIds();
    }

    private AggregationNode(PlanNodeId id, AggregationNode src) {
        super(id, src, "AGGREGATE");
        this.multiAggInfo_ = src.multiAggInfo_;
        this.aggPhase_ = src.aggPhase_;
        this.aggInfos_ = src.aggInfos_;
        this.needsFinalize_ = src.needsFinalize_;
        this.useIntermediateTuple_ = src.useIntermediateTuple_;
        this.isNonCorrelatedScalarSubquery_ = src.isNonCorrelatedScalarSubquery_;
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        for (AggregateInfo aggInfo : this.aggInfos_) {
            TupleId aggClassTupleId = null;
            aggClassTupleId = this.useIntermediateTuple_ ? aggInfo.getIntermediateTupleId() : aggInfo.getOutputTupleId();
            this.tupleIds_.add(aggClassTupleId);
            this.tblRefIds_.add(aggClassTupleId);
            if (this.aggInfos_.size() <= 1) continue;
            this.nullableTupleIds_.add(aggClassTupleId);
        }
    }

    public void setIsPreagg(PlannerContext ctx) {
        if (ctx.getQueryOptions().disable_streaming_preaggregations) {
            this.useStreamingPreagg_ = false;
            return;
        }
        for (AggregateInfo aggInfo : this.aggInfos_) {
            if (aggInfo.getGroupingExprs().size() <= 0) continue;
            this.useStreamingPreagg_ = true;
            return;
        }
    }

    public void unsetNeedsFinalize() {
        Preconditions.checkState((boolean)this.needsFinalize_);
        this.needsFinalize_ = false;
    }

    public void setIntermediateTuple() {
        this.useIntermediateTuple_ = true;
        this.computeTupleIds();
    }

    public MultiAggregateInfo getMultiAggInfo() {
        return this.multiAggInfo_;
    }

    public MultiAggregateInfo.AggPhase getAggPhase() {
        return this.aggPhase_;
    }

    public boolean hasGrouping() {
        return this.multiAggInfo_.hasGrouping();
    }

    public boolean isSingleClassAgg() {
        return this.aggInfos_.size() == 1;
    }

    public boolean isDistinctAgg() {
        for (AggregateInfo aggInfo : this.aggInfos_) {
            if (!aggInfo.isDistinctAgg()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlockingNode() {
        return !this.useStreamingPreagg_;
    }

    @Override
    public void init(Analyzer analyzer) throws InternalException {
        Preconditions.checkState((this.tupleIds_.size() == this.aggInfos_.size() ? 1 : 0) != 0);
        if (this.aggPhase_ == this.multiAggInfo_.getConjunctAssignmentPhase()) {
            this.conjuncts_.clear();
            this.conjuncts_.addAll(this.multiAggInfo_.collectConjuncts(analyzer, true));
            this.conjuncts_ = AggregationNode.orderConjunctsByCost(this.conjuncts_);
        }
        for (AggregateInfo aggInfo : this.aggInfos_) {
            aggInfo.getOutputTupleDesc().computeMemLayout();
            aggInfo.getIntermediateTupleDesc().computeMemLayout();
        }
        this.computeStats(analyzer);
        this.outputSmap_ = this.getCombinedChildSmap();
        if (this.aggPhase_ == MultiAggregateInfo.AggPhase.FIRST) {
            this.multiAggInfo_.substitute(this.outputSmap_, analyzer);
        }
        for (AggregateInfo aggInfo : this.aggInfos_) {
            aggInfo.substitute(this.outputSmap_, analyzer);
            aggInfo.checkConsistency();
        }
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = 0L;
        this.aggInputCardinality_ = this.getAggInputCardinality();
        Preconditions.checkState((this.aggInputCardinality_ >= -1L ? 1 : 0) != 0, (Object)this.aggInputCardinality_);
        boolean unknownEstimate = false;
        this.aggClassNumGroups_ = Lists.newArrayList();
        for (AggregateInfo aggInfo : this.aggInfos_) {
            long numGroups = this.estimateNumGroups(aggInfo);
            Preconditions.checkState((numGroups >= -1L ? 1 : 0) != 0, (Object)numGroups);
            this.aggClassNumGroups_.add(numGroups);
            if (numGroups == -1L) {
                unknownEstimate = true;
                continue;
            }
            this.cardinality_ = AggregationNode.checkedAdd(this.cardinality_, numGroups);
        }
        if (unknownEstimate) {
            this.cardinality_ = -1L;
        }
        if (this.cardinality_ > 0L) {
            this.cardinality_ = this.applyConjunctsSelectivity(this.cardinality_);
        }
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
    }

    private long estimateNumGroups(AggregateInfo aggInfo) {
        List<Expr> groupingExprs = aggInfo.getGroupingExprs();
        long numGroups = AggregationNode.estimateNumGroups(groupingExprs, this.aggInputCardinality_);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Node " + this.id_ + " numGroups= " + numGroups + " aggInputCardinality=" + this.aggInputCardinality_ + " for agg class " + aggInfo.debugString());
        }
        return numGroups;
    }

    public static long estimateNumGroups(List<Expr> groupingExprs, long aggInputCardinality) {
        if (groupingExprs.isEmpty()) {
            return 1L;
        }
        long numGroups = Expr.getNumDistinctValues(groupingExprs);
        if (numGroups == -1L) {
            return aggInputCardinality;
        }
        if (aggInputCardinality >= 0L) {
            numGroups = Math.min(aggInputCardinality, numGroups);
        }
        return numGroups;
    }

    private long getAggInputCardinality() {
        long inputCardinality = ((PlanNode)this.getChild(0)).getCardinality();
        if (this.multiAggInfo_.getIsGroupingSet() && this.aggPhase_ == MultiAggregateInfo.AggPhase.TRANSPOSE) {
            return inputCardinality;
        }
        AggregationNode firstAgg = this;
        while (firstAgg.getAggPhase() != MultiAggregateInfo.AggPhase.FIRST) {
            firstAgg = this.getPrevAggNode(firstAgg);
        }
        return Math.min(inputCardinality, ((PlanNode)firstAgg.getChild(0)).getCardinality());
    }

    private AggregationNode getPrevAggNode(AggregationNode aggNode) {
        Preconditions.checkArgument((aggNode.getAggPhase() != MultiAggregateInfo.AggPhase.FIRST ? 1 : 0) != 0);
        PlanNode child = (PlanNode)aggNode.getChild(0);
        if (child instanceof ExchangeNode) {
            child = (PlanNode)child.getChild(0);
        }
        Preconditions.checkState((boolean)(child instanceof AggregationNode));
        return (AggregationNode)child;
    }

    @Nullable
    private AggregationNode getPrevAggInputNode() {
        AggregationNode prevAgg = null;
        if (this.aggPhase_ != MultiAggregateInfo.AggPhase.FIRST && this.aggPhase_ != MultiAggregateInfo.AggPhase.TRANSPOSE) {
            prevAgg = this.getPrevAggNode(this);
            Preconditions.checkState((this.aggInfos_.size() == prevAgg.aggInfos_.size() ? 1 : 0) != 0);
            Preconditions.checkState((this.aggInfos_.size() == prevAgg.aggClassNumGroups_.size() ? 1 : 0) != 0);
        }
        return prevAgg;
    }

    public List<Expr> getMergePartitionExprs(Analyzer analyzer) {
        Preconditions.checkState((!this.tupleIds_.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!this.aggPhase_.isMerge() && !this.aggPhase_.isTranspose() ? 1 : 0) != 0);
        boolean shuffleDistinctExprs = analyzer.getQueryOptions().shuffle_distinct_exprs;
        if (this.aggInfos_.size() == 1) {
            AggregateInfo aggInfo = this.aggInfos_.get(0);
            List<Expr> groupingExprs = null;
            if (this.aggPhase_.isFirstPhase() && this.hasGrouping() && !shuffleDistinctExprs) {
                groupingExprs = this.multiAggInfo_.getSubstGroupingExprs();
            } else {
                groupingExprs = aggInfo.getPartitionExprs();
                if (groupingExprs == null) {
                    groupingExprs = aggInfo.getGroupingExprs();
                }
            }
            return Expr.substituteList(groupingExprs, aggInfo.getIntermediateSmap(), analyzer, false);
        }
        int maxNumExprs = 0;
        for (AggregateInfo aggInfo : this.aggInfos_) {
            if (aggInfo.getGroupingExprs() == null) continue;
            maxNumExprs = Math.max(maxNumExprs, aggInfo.getGroupingExprs().size());
        }
        if (maxNumExprs == 0) {
            return Collections.emptyList();
        }
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (int i = 0; i < maxNumExprs; ++i) {
            ArrayList<CaseWhenClause> caseWhenClauses = new ArrayList<CaseWhenClause>();
            for (AggregateInfo aggInfo : this.aggInfos_) {
                Expr thenExpr;
                TupleId tid = aggInfo.isDistinctAgg() ? aggInfo.getOutputTupleId() : aggInfo.getIntermediateTupleId();
                List<Expr> groupingExprs = aggInfo.getGroupingExprs();
                if (this.aggPhase_.isFirstPhase() && this.hasGrouping() && !shuffleDistinctExprs) {
                    groupingExprs = this.multiAggInfo_.getSubstGroupingExprs();
                }
                NumericLiteral whenExpr = NumericLiteral.create(tid.asInt());
                if (groupingExprs == null || i >= groupingExprs.size()) {
                    thenExpr = NumericLiteral.create(0L);
                } else {
                    thenExpr = new FunctionCallExpr("murmur_hash", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{groupingExprs.get(i).clone()}));
                    thenExpr.analyzeNoThrow(analyzer);
                    thenExpr = thenExpr.substitute(aggInfo.getIntermediateSmap(), analyzer, true);
                }
                caseWhenClauses.add(new CaseWhenClause(whenExpr, thenExpr));
            }
            CaseExpr caseExpr = new CaseExpr(new ValidTupleIdExpr(this.tupleIds_), caseWhenClauses, null);
            caseExpr.analyzeNoThrow(analyzer);
            result.add(caseExpr);
        }
        return result;
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.agg_node = new TAggregationNode();
        msg.node_type = TPlanNodeType.AGGREGATION_NODE;
        boolean replicateInput = this.aggPhase_ == MultiAggregateInfo.AggPhase.FIRST && this.aggInfos_.size() > 1;
        msg.agg_node.setReplicate_input(replicateInput);
        msg.agg_node.setEstimated_input_cardinality(((PlanNode)this.getChild(0)).getCardinality());
        msg.agg_node.setFast_limit_check(this.canCompleteEarly());
        for (int i = 0; i < this.aggInfos_.size(); ++i) {
            AggregateInfo aggInfo = this.aggInfos_.get(i);
            ArrayList<TExpr> aggregateFunctions = new ArrayList<TExpr>();
            for (FunctionCallExpr e : aggInfo.getMaterializedAggregateExprs()) {
                aggregateFunctions.add(e.treeToThrift());
            }
            TAggregator taggregator = new TAggregator(aggregateFunctions, aggInfo.getIntermediateTupleId().asInt(), aggInfo.getOutputTupleId().asInt(), this.needsFinalize_, this.useStreamingPreagg_, this.resourceProfiles_.get(i).toThrift());
            List<Expr> groupingExprs = aggInfo.getGroupingExprs();
            if (!groupingExprs.isEmpty()) {
                taggregator.setGrouping_exprs(Expr.treesToThrift(groupingExprs));
            }
            msg.agg_node.addToAggregators(taggregator);
        }
    }

    @Override
    protected String getDisplayLabelDetail() {
        if (this.useStreamingPreagg_) {
            return "STREAMING";
        }
        if (this.needsFinalize_) {
            return "FINALIZE";
        }
        return null;
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        String nameDetail = this.getDisplayLabelDetail();
        output.append(String.format("%s%s", prefix, this.getDisplayLabel()));
        if (nameDetail != null) {
            output.append(" [" + nameDetail + "]");
        }
        output.append("\n");
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
            if (this.aggInfos_.size() == 1) {
                output.append((CharSequence)this.getAggInfoExplainString(detailPrefix, this.aggInfos_.get(0), detailLevel));
            } else {
                for (int i = 0; i < this.aggInfos_.size(); ++i) {
                    AggregateInfo aggInfo = this.aggInfos_.get(i);
                    output.append(String.format("%sClass %d\n", detailPrefix, i));
                    output.append((CharSequence)this.getAggInfoExplainString(detailPrefix + "  ", aggInfo, detailLevel));
                }
            }
            if (!this.conjuncts_.isEmpty()) {
                output.append(detailPrefix).append("having: ").append(Expr.getExplainString(this.conjuncts_, detailLevel)).append("\n");
            }
        }
        return output.toString();
    }

    private StringBuilder getAggInfoExplainString(String prefix, AggregateInfo aggInfo, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        List<FunctionCallExpr> aggExprs = aggInfo.getMaterializedAggregateExprs();
        List<Expr> groupingExprs = aggInfo.getGroupingExprs();
        if (!aggExprs.isEmpty()) {
            output.append(prefix).append("output: ").append(Expr.getExplainString(aggExprs, detailLevel)).append("\n");
        }
        if (!groupingExprs.isEmpty()) {
            output.append(prefix).append("group by: ").append(Expr.getExplainString(groupingExprs, detailLevel)).append("\n");
        }
        return output;
    }

    private long getAggClassNumGroup(@Nullable AggregationNode prevAgg, AggregateInfo aggInfo) {
        if (prevAgg == null) {
            return this.aggInputCardinality_;
        }
        int aggIdx = this.aggInfos_.indexOf(aggInfo);
        long aggClassNumGroup = prevAgg.aggClassNumGroups_.get(aggIdx);
        if (aggClassNumGroup <= -1L) {
            return this.aggInputCardinality_;
        }
        return Math.min(this.aggInputCardinality_, aggClassNumGroup);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.zero();
        AggregationNode prevAgg = this.getPrevAggInputNode();
        for (AggregateInfo aggInfo : this.aggInfos_) {
            long inputCardinality = Math.max(0L, this.getAggClassNumGroup(prevAgg, aggInfo));
            long perInstanceNdv = this.fragment_.getPerInstanceNdvForCpuCosting(inputCardinality, aggInfo.getGroupingExprs());
            long intermediateOutputCardinality = Math.max(0L, Math.min(inputCardinality, perInstanceNdv * (long)this.fragment_.getNumInstancesForCosting()));
            long aggClassNumGroup = Math.max(0L, this.getAggClassNumGroup(prevAgg, aggInfo));
            ProcessingCost aggCost = aggInfo.computeProcessingCost(this.getDisplayLabel(), aggClassNumGroup, intermediateOutputCardinality);
            this.processingCost_ = ProcessingCost.sumCost(this.processingCost_, aggCost);
        }
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.resourceProfiles_ = Lists.newArrayListWithCapacity((int)this.aggInfos_.size());
        this.resourceProfiles_.clear();
        AggregationNode prevAgg = this.getPrevAggInputNode();
        for (AggregateInfo aggInfo : this.aggInfos_) {
            this.resourceProfiles_.add(this.computeAggClassResourceProfile(queryOptions, aggInfo, this.getAggClassNumGroup(prevAgg, aggInfo)));
        }
        if (this.aggInfos_.size() == 1) {
            this.nodeResourceProfile_ = this.resourceProfiles_.get(0);
        } else {
            this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
            for (ResourceProfile aggProfile : this.resourceProfiles_) {
                this.nodeResourceProfile_ = this.nodeResourceProfile_.sum(aggProfile);
            }
        }
    }

    private long estimatePerInstanceDataBytes(long perInstanceCardinality, long inputCardinality) {
        Preconditions.checkArgument((perInstanceCardinality > -1L ? 1 : 0) != 0);
        if (inputCardinality != -1L) {
            long numInstances = this.fragment_.getNumInstances();
            long perInstanceInputCardinality = numInstances > 1L ? (this.useStreamingPreagg_ ? (long)Math.ceil((double)inputCardinality / (double)numInstances * 1.5) : (long)Math.ceil((double)inputCardinality / (double)numInstances)) : inputCardinality;
            perInstanceCardinality = this.useStreamingPreagg_ ? Math.min(perInstanceCardinality, perInstanceInputCardinality / 2L) : Math.min(perInstanceCardinality, perInstanceInputCardinality);
        }
        long perInstanceDataBytes = (long)Math.ceil((double)perInstanceCardinality * ((double)this.avgRowSize_ + 12.0));
        return perInstanceDataBytes;
    }

    private ResourceProfile computeAggClassResourceProfile(TQueryOptions queryOptions, AggregateInfo aggInfo, long inputCardinality) {
        long perInstanceMinMemReservation;
        long perInstanceMemEstimate;
        Preconditions.checkNotNull((Object)this.fragment_, (Object)"PlanNode must be placed into a fragment before calling this method.");
        long perInstanceCardinality = this.fragment_.getPerInstanceNdv(aggInfo.getGroupingExprs(), false);
        long perInstanceDataBytes = -1L;
        long largeAggMemThreshold = Long.MAX_VALUE;
        if (this.useStreamingPreagg_ && queryOptions.getPreagg_bytes_limit() > 0L) {
            largeAggMemThreshold = queryOptions.getPreagg_bytes_limit();
        } else if (queryOptions.getLarge_agg_mem_threshold() > 0L) {
            largeAggMemThreshold = queryOptions.getLarge_agg_mem_threshold();
        }
        if (perInstanceCardinality == -1L) {
            perInstanceMemEstimate = 0x8000000L;
        } else {
            perInstanceDataBytes = this.estimatePerInstanceDataBytes(perInstanceCardinality, inputCardinality);
            if (perInstanceDataBytes > largeAggMemThreshold) {
                long lowPerInstanceCardinality = this.fragment_.getPerInstanceNdv(aggInfo.getGroupingExprs(), true);
                Preconditions.checkState((lowPerInstanceCardinality > -1L ? 1 : 0) != 0);
                long lowPerInstanceDataBytes = Math.max(largeAggMemThreshold, this.estimatePerInstanceDataBytes(lowPerInstanceCardinality, inputCardinality));
                Preconditions.checkState((lowPerInstanceDataBytes <= perInstanceDataBytes ? 1 : 0) != 0);
                long nonLiteralExprCount = aggInfo.getGroupingExprs().stream().filter(e -> !(e instanceof LiteralExpr)).count();
                double corrFactor = queryOptions.getAgg_mem_correlation_factor();
                double memScale = Math.pow(1.0 - corrFactor, Math.max(0L, nonLiteralExprCount - 1L));
                long resolvedPerInstanceDataBytes = lowPerInstanceDataBytes + Math.round(memScale * (double)(perInstanceDataBytes - lowPerInstanceDataBytes));
                if (LOG.isTraceEnabled() && perInstanceDataBytes > resolvedPerInstanceDataBytes) {
                    LOG.trace("Node " + this.getDisplayLabel() + " reduce perInstanceDataBytes from " + perInstanceDataBytes + " to " + resolvedPerInstanceDataBytes);
                }
                perInstanceDataBytes = resolvedPerInstanceDataBytes;
            }
            perInstanceMemEstimate = aggInfo.getGroupingExprs().isEmpty() ? 16384L : Math.max(perInstanceDataBytes, 0xA00000L);
        }
        long bufferSize = queryOptions.getDefault_spillable_buffer_size();
        long maxRowBufferSize = AggregationNode.computeMaxSpillableBufferSize(bufferSize, queryOptions.getMax_row_size());
        if (aggInfo.getGroupingExprs().isEmpty()) {
            perInstanceMinMemReservation = 0L;
        } else {
            int PARTITION_FANOUT = 16;
            if (perInstanceDataBytes != -1L) {
                long bytesPerPartition = perInstanceDataBytes / 16L;
                bufferSize = Math.min(bufferSize, Math.max(queryOptions.getMin_spillable_buffer_size(), BitUtil.roundUpToPowerOf2(bytesPerPartition)));
                maxRowBufferSize = AggregationNode.computeMaxSpillableBufferSize(bufferSize, queryOptions.getMax_row_size());
            }
            if (this.useStreamingPreagg_) {
                perInstanceMinMemReservation = bufferSize * 16L + Math.max(0x100000L, bufferSize);
            } else {
                long minBuffers = 17 + (aggInfo.needsSerialize() ? 1 : 0);
                perInstanceMinMemReservation = bufferSize * (minBuffers - 2L) + maxRowBufferSize * 2L;
            }
        }
        ResourceProfileBuilder builder = new ResourceProfileBuilder().setMemEstimateBytes(perInstanceMemEstimate).setMinMemReservationBytes(perInstanceMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(maxRowBufferSize);
        if (this.useStreamingPreagg_ && queryOptions.getPreagg_bytes_limit() > 0L) {
            long maxReservationBytes = Math.max(perInstanceMinMemReservation, queryOptions.getPreagg_bytes_limit());
            builder.setMaxMemReservationBytes(maxReservationBytes);
            builder.setMemEstimateBytes(Math.min(perInstanceMemEstimate, maxReservationBytes));
        }
        return builder.build();
    }

    public void setIsNonCorrelatedScalarSubquery(boolean val) {
        this.isNonCorrelatedScalarSubquery_ = val;
    }

    public boolean isNonCorrelatedScalarSubquery() {
        return this.isNonCorrelatedScalarSubquery_;
    }

    public boolean canCompleteEarly() {
        return this.isSingleClassAgg() && this.hasLimit() && this.hasGrouping() && !this.multiAggInfo_.hasAggregateExprs() && this.getConjuncts().isEmpty();
    }
}

